'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = toutSuite;

var _synchronousPromise = require('synchronous-promise');

function isObject(obj) {
  return obj === Object(obj);
}

function fakeSetTimeout(f, d) {
  for (var _len = arguments.length, args = Array(_len > 2 ? _len - 2 : 0), _key = 2; _key < _len; _key++) {
    args[_key - 2] = arguments[_key];
  }

  f(...args);
}

function fakeSetImmediate(f) {
  for (var _len2 = arguments.length, args = Array(_len2 > 1 ? _len2 - 1 : 0), _key2 = 1; _key2 < _len2; _key2++) {
    args[_key2 - 1] = arguments[_key2];
  }

  f(...args);
}

function toutSuite(block) {
  let realPromise = global.Promise;
  let realSetImmediate = global.setImmediate;
  let realSetTimeout = global.setTimeout;
  let realNextTick = process.nextTick;

  global.Promise = _synchronousPromise.SynchronousPromise;
  global.setImmediate = fakeSetImmediate;
  global.setTimeout = fakeSetTimeout;
  process.nextTick = fakeSetImmediate;

  try {
    let ret = block();
    if (isObject(ret) && 'then' in ret) {
      let val;
      ret.then(x => val = x);

      return val;
    }
  } finally {
    global.Promise = realPromise;
    global.setImmediate = realSetImmediate;
    global.setTimeout = realSetTimeout;
    process.nextTick = realNextTick;
  }
}