# Sass.js

Sass parser in JavaScript. Have a look at the [Interactive Playground](http://sass.js.org/) to play around with compiling SCSS to CSS in your browser.

This is a convenience API for [emscripted](https://github.com/kripken/emscripten) [libsass](https://github.com/sass/libsass) (at [v3.5.5](https://github.com/sass/libsass/releases/tag/3.5.5)). If you're looking to run Sass in node, you're probably looking for [node-sass](https://github.com/sass/node-sass). Sass.js and node-sass should generate the same results.

A fair warning: minified the worker weighs 3.5MB, gzipped it's still 750KB. If you're on NodeJS, please use the (considerably faster) [node-sass](https://github.com/andrew/node-sass) instead.

You may also be interested in giving [Dart Sass](https://github.com/sass/dart-sass) a shot.


## Documentation

* [Getting started](./docs/getting-started.md)
* [API documentation](./docs/api.md)
* [Building Sass.js](./docs/build.md)
* [Changelog](./CHANGELOG.md)


## Who uses Sass.js

Sass.js is used in the following tools:

* [grunt-contrib-sassjs](https://github.com/amiramw/grunt-contrib-sassjs)
* [mobilexag/plugin-sass](https://github.com/mobilexag/plugin-sass) is a SystemJS plugin
* [kevcjones/plugin-scss](https://github.com/kevcjones/plugin-scss) is a SystemJS plugin
* [theefer/plugin-sass](https://github.com/theefer/plugin-sass) is a SystemJS plugin
* [stealjs/steal-sass](https://github.com/stealjs/steal-sass) is a StealJS plugin
* [nickheiner/sassjs-loader](https://github.com/NickHeiner/sassjs-loader) is a Webpack plugin
* [lein-sass](https://github.com/yogthos/lein-sass) is a minimum dependency Clojure library designed to compile SASS files using Sass.js running on Nashorn
* [qwebs](https://www.npmjs.com/package/qwebs) is a "back-end web server"
* [Crunch 2](http://getcrunch.co/)


## Authors

* [Christian Kruse](https://github.com/ckruse) - [@cjk101010](https://twitter.com/cjk101010)
* [Sebastian Golasch](https://github.com/asciidisco) - [@asciidisco](https://twitter.com/asciidisco)
* [Rodney Rehm](http://rodneyrehm.de/en/) - [@rodneyrehm](https://twitter.com/rodneyrehm)


## Credits

* the [sass group](https://github.com/sass), especially [team libsass](https://github.com/sass/libsass)
* team [emscripten](https://github.com/kripken/emscripten), especially [Alon Zakai](https://github.com/kripken)
* [Piotr Paczkowski](https://github.com/trzecieu/) for providing the [emscripten docker image](https://hub.docker.com/r/trzeci/emscripten/)


## License

Sass.js is - as [libsass](https://github.com/sass/libsass) and [emscripten](https://github.com/kripken/emscripten/) are - published under the [MIT License](http://opensource.org/licenses/mit-license).
