# Sass.js Changelog

## 0.10.13 (November 19th 2018) ##

* fixing `sass.configure.paths.js` to restore ES5 compatibility - [Issue #109](https://github.com/medialize/sass.js/pull/109)

## 0.10.12 (November 14th 2018) ##

* fixing `sass.configure.paths.js` for angular compiler - [Issue #105](https://github.com/medialize/sass.js/pull/105) [Issue #100](https://github.com/medialize/sass.js/issues/100)
* upgrading to [libsass 3.5.5](https://github.com/sass/libsass/releases/tag/3.5.5)
* upgrading to [emscripten 1.38.18](https://github.com/kripken/emscripten/releases/tag/1.38.18)

## 0.10.11 (September 22nd 2018) ##

* upgrading to [emscripten 1.38.12](https://github.com/kripken/emscripten/releases/tag/1.38.12) - ([Issue #85](https://github.com/medialize/sass.js/issues/85))
* fixing IE11 compatibility by adding `-s LEGACY_VM_SUPPORT=1` - ([Issue #96](https://github.com/medialize/sass.js/issues/96))

## 0.10.10 (July 7th 2018) ##

* upgrading to [libsass 3.5.4](https://github.com/sass/libsass/releases/tag/3.5.4)
* upgrading to [emscripten 1.37.35](https://github.com/kripken/emscripten/releases/tag/1.37.35)

## 0.10.9 (February 6th 2018) ##

* upgrading to [libsass 3.4.9](https://github.com/sass/libsass/releases/tag/3.4.9)
* upgrading to [emscripten 1.37.33](https://github.com/kripken/emscripten/releases/tag/1.37.33)

## 0.10.8 (January 21st 2018) ##

* upgrading to [libsass 3.4.8](https://github.com/sass/libsass/releases/tag/3.4.8)
* fixing `sass.node.js` to allow raw CSS imports - ([PR #94](https://github.com/medialize/sass.js/pull/94))

## 0.10.7 (November 14th 2017) ##

* upgrading to [libsass 3.4.7](https://github.com/sass/libsass/releases/tag/3.4.7)

## 0.10.6 (July 28th 2017) ##

* fixing `sass.node.js` to work on windows - ([Issue #86](https://github.com/medialize/sass.js/issues/86))

## 0.10.5 (June 25th 2017) ##

* upgrading to [libsass 3.4.5](https://github.com/sass/libsass/releases/tag/3.4.5)

## 0.10.4 (March 30th 2017) ##

* upgrading to [libsass 3.4.4](https://github.com/sass/libsass/releases/tag/3.4.4)

## 0.10.3 (January 8th 2017) ##

* upgrading to [libsass 3.4.3](https://github.com/sass/libsass/releases/tag/3.4.3)

## 0.10.2 (December 28th 2016) ##

* upgrading to [libsass 3.4.2](https://github.com/sass/libsass/releases/tag/3.4.2)
* upgrading to [emscripten 1.37.0](https://github.com/kripken/emscripten/releases/tag/1.37.0)

## 0.10.1 (December 19th 2016) ##

* upgrading to [libsass 3.4.1](https://github.com/sass/libsass/releases/tag/3.4.1)

## 0.10.0 (December 11th 2016) ##

* Deprecating the synchronous `Sass.lazyFiles()` - as this can be achieved asynchronously with an Importer Callback
* upgrading to [libsass 3.4.0](https://github.com/sass/libsass/releases/tag/3.4.0)
* fixing Importer to properly process UTF8 strings - ([Issue #72](https://github.com/medialize/sass.js/issues/72))
* adding `sass.node.js` for convenient compilation of SCSS and SASS files in Node - ([Issue #72](https://github.com/medialize/sass.js/issues/72))

## 0.9.13 (September 25th 2016) ##

* fixing Importer to allow passing empty strings - ([Issue #63](https://github.com/medialize/sass.js/issues/63))

## 0.9.12 (August 14th 2016) ##

* refactoring Importer to expose `Sass.findPathVariation()` and `Sass.getPathVariations()` in the Synchronous API - ([Issue #61](https://github.com/medialize/sass.js/issues/61))

## 0.9.11 (July 17th 2016) ##

* fixing Importer callback to handle nested imports when running asynchronously - ([Issue #59](https://github.com/medialize/sass.js/issues/59))
* upgrading to [emscripten 1.36.5](https://github.com/kripken/emscripten/releases/tag/1.36.5)

## 0.9.10 (April 20th 2016) ##

* upgrading to [libsass 3.3.6](https://github.com/sass/libsass/releases/tag/3.3.6)

## 0.9.9 (April 20th 2016) ##

* upgrading to [libsass 3.3.5](https://github.com/sass/libsass/releases/tag/3.3.5)

## 0.9.8 (April 7th 2016) ##

* upgrading to [libsass 3.3.4](https://github.com/sass/libsass/releases/tag/3.3.4)
* upgrading to [emscripten 1.36.1](https://github.com/kripken/emscripten/releases/tag/1.36.1)

## 0.9.7 (February 4th 2016) ##

* refactoring sass.js initialization when emscripten is ready

## 0.9.6 (February 1st 2016) ##

* adding option `importer` to provide data to [importer callbacks](https://github.com/medialize/sass.js/#importer-callback-function) - ([Issue #43](https://github.com/medialize/sass.js/issues/43))

## 0.9.5 (January 23rd 2016) ##

* upgrading to [libsass 3.3.3](https://github.com/sass/libsass/releases/tag/3.3.3)
* upgrading to [emscripten 1.35.22](https://github.com/kripken/emscripten/releases/tag/1.35.22)
* inline memory init file and drop `libsass.js.mem` - ([Issue #42](https://github.com/medialize/sass.js/issues/42))

## 0.9.4 (October 27th 2015) ##

* upgrading to [libsass 3.3.1](https://github.com/sass/libsass/releases/tag/3.3.1)
* upgrading to [emscripten 1.35.4](https://github.com/kripken/emscripten/releases/tag/1.35.4)

## 0.9.3 (October 24th 2015) ##

* upgrading to [libsass 3.3.0](https://github.com/sass/libsass/releases/tag/3.3.0)
* upgrading to [emscripten 1.35.2](https://github.com/kripken/emscripten/releases/tag/1.35.2)

## 0.9.2 (June 14th 2015) ##

* upgrading to [libsass 3.2.5](https://github.com/sass/libsass/releases/tag/3.2.5)

## 0.9.1 (May 30th 2015) ##

* fixing automatic path detection (for loading `sass.worker.js` and `libsass.js.mem`), to make `sass.sync.js` load `libsass.js.mem` relative to itself (Node and browser) - ([Issue #33](https://github.com/medialize/sass.js/issues/33))

## 0.9.0 (May 21st 2015) ##

**NOTE:** This release contains breaking changes!

* upgrading to [libsass 3.2.4](https://github.com/sass/libsass/releases/tag/3.2.4)
* fixing worker API to avoid throwing `DataCloneError` because `postMessage` can't handle `Error` instances
* improving worker API to find `sass.worker.js` itself when loaded through simple `<script>` element - ([Issue #32](https://github.com/medialize/sass.js/issues/32))
* improving worker API to allow multiple *parallel* workers to be initialized - **Breaking Change**
* improving `Sass.compile()` to queue multiple invocations for serialized execution rather than throwing an error
* adding `sass.destroy()` to terminate a worker and free its resources
* adding `Sass.setWorkerUrl()` to define the path of the worker before a Sass instance is created


## Breaking Changes

* The worker API used to be initialized with `Sass.initialize('path/to/sass.worker.js')`, but as of v0.9.0 requires proper instantiation: `var sass = new Sass('path/to/sass.worker.js')`.

## 0.8.2 (May 9th 2015) ##

* upgrading to [libsass 3.2.3](https://github.com/sass/libsass/releases/tag/3.2.3)
* fixing build to cope with `emcc --version` not naming a commit - ([Issue #30](https://github.com/medialize/sass.js/issues/30))
* fixing build to *not* minify distributables (very little gain, but breaks asm in Firefox) - ([Issue #29](https://github.com/medialize/sass.js/issues/29))
* fixing `.compile()` to wait until emscripten is ready - ([Issue #29](https://github.com/medialize/sass.js/issues/29))

## 0.8.1 (May 2nd 2015) ##

* upgrading to [libsass 3.2.2](https://github.com/sass/libsass/releases/tag/3.2.2)
* adding `Sass.compileFile()` to compile directly from file system
* fixing `Sass.options('defaults', callback)` to actually fire the callback
* improving `Sass.compile()` to accept options to temporarily set for that invocation, extending the signature to
  * `Sass.compile(source, callback)`
  * `Sass.compile(source, options, callback)`
* improving `Sass.writeFile()` to accept a map of files to write
* improving `Sass.readFile()` to accept an array of files to read
* improving `Sass.removeFile()` to accept an array of files to remove

## 0.8.0 (May 2nd 2015) ##

(failed and unpublished from npm, removed tag, see 0.8.1, I'm sorry)

## 0.7.2 (April 30th 2015) ##

* fixing option `precision` so that by default Sass.js won't overwrite libsass default precision (`5`)

## 0.7.1 (April 30th 2015) ##

* upgrading to [libsass 3.2.1](https://github.com/sass/libsass/releases/tag/3.2.1)

## 0.7.0 (April 27th 2015) ##

**NOTE:** This release contains several breaking changes!

* Upgrading build infrastructure
  * compile [libsass 3.2.0](https://github.com/sass/libsass/releases/tag/3.2.0)
  * allowing builds without forced download of libsass.git every time
  * providing emscripten debug mode
* improving `emscripten_wrapper.cpp` to use `sass_context.h` instead of the deprecated `sass_interface.h`
* renaming files to make more sense
* improving synchronous API to perfectly mirror the worker API
* adding `.options('defaults')` to reset options to Sass.js defaults
* adding `dist/libsass.js.mem`, optimized memory file created by emscripten
* adding `Sass.lazyFiles()` and `Sass.preloadFiles()`
* adding `Sass.clearFiles()` to wipe all files known to `Sass.listFiles()`
* adding `Sass.importer()` to intercept file loading requests from libsass
* adding configuration options
  * `precision` - Precision for outputting fractional numbers (`0` using libsass default)
  * `indentedSyntax` - Treat source string as SASS (as opposed to SCSS)
  * `indent` - String to be used for indentation (2 spaces)
  * `linefeed` - String to be used to for line feeds (`\n`)
  * `sourceMapRoot` - Pass-through as sourceRoot property
  * `sourceMapFile` - Path to source map file (enables generating source maps)
  * `sourceMapContents` - embed include contents in maps
  * `sourceMapEmbed` - embed sourceMappingUrl as data URI
  * `sourceMapOmitUrl` - Disable sourceMappingUrl in CSS output
  * `inputPath` - source map generation source (`stdin`)
  * `outputPath` - source map generation target

## Breaking Changes

* synchronous API (formerly `dist/sass.js` and `dist/sass.min.js`) is now *required* to be loaded from a directory called `dist` relative to `document.URL` (irrelevant for use in Node!)
* synchronous API now has the *exact same* signature as the worker API, meaning responses are not returned, but passed to callback functions instead.
* `Sass.compile()` used to return the compiled CSS as string, it now [returns an object](https://github.com/medialize/sass.js#compile-response-object)
* distribution files renamed or removed for clarity
  * `dist/worker.js` *removed*
  * `dist/sass.worker.js` *removed*
  * `dist/sass.min.js` *removed*
  * `dist/sass.worker.js` renamed to `dist/sass.js` (public API for the browser)
  * `dist/worker.min.js` renamed to `dist/sass.worker.js` (emscripted libsass for the web worker)
  * `dist/sass.js` renamed to `dist/sass.sync.js` (emscripted libsass synchronous API)
* source files renamed for clarity
  * `src/libsass.worker.js` renamed to `src/sass.worker.js` (contains the worker's `onmessage` handler)
  * `src/sass.js` renamed to `src/sass.api.js` (abstraction of libsass and emscription)
  * `src/sass.worker.js` renamed to `src/sass.js` (public API using `postMessage` to talk to worker internally)
* example files renamed for clarity
  * `sass.sync.html` *added*
  * `console.html` renamed to `sass.source.html`
  * `worker.html` renamed to `sass.worker.html`

## 0.6.3 (March 3rd 2015) ##

* fixing invalid source error handling ([#23](https://github.com/medialize/sass.js/issues/23))

## 0.6.2 (January 22nd 2015) ##

* fixing `Makefile.patch` for "memory file" to work with emscripten 1.29

## 0.6.1 (January 5th 2015) ##

* fixing `Makefile.patch` to work with libsass 3.1.0
* upgrading to [libsass 3.1.0](https://github.com/sass/libsass/releases/tag/3.1.0)

## 0.6.0 (December 23rd 2014) ##

* adding `grunt build:libsass` to make libsass.js ([#15](https://github.com/medialize/sass.js/issues/15))
* making absolute paths work via symlinks ([#19](https://github.com/medialize/sass.js/issues/19))

## 0.5.0 (August 31st 2014) ##

* upgrading to [libsass 2.1.0-beta](https://github.com/hcatlin/libsass/releases/tag/2.1.0-beta)

## 0.4.0 (June 6th 2014) ##

* upgrading to [libsass v2.0](https://github.com/hcatlin/libsass/releases/tag/v2.0) - Sending [#386](https://github.com/hcatlin/libsass/pull/386), [#387](https://github.com/hcatlin/libsass/pull/387), [#388](https://github.com/hcatlin/libsass/pull/388)

## 0.3.0 (April 5th 2014) ##

* upgrading to [libsass @1122ead...](https://github.com/hcatlin/libsass/commit/1122ead208a8d1c438daaca70041ef6dd2361fa0) (to be on par with [node-sass](https://github.com/andrew/node-sass) [v.0.8.3](https://github.com/andrew/node-sass/releases/tag/v0.8.3))

## 0.2.0 (January 16th 2014) ##

* using libsass at v1.0.1 (instead of building from master)
* adding `grunt build` to generate `dist` files
* adding mocha tests `grunt test`

## 0.1.0 (January 13th 2014) ##

* Initial Sass.js
