export declare type VersionRange = string;
export interface PackageJSON {
    dependencies: {
        [name: string]: VersionRange;
    };
    devDependencies: {
        [name: string]: VersionRange;
    };
    optionalDependencies: {
        [name: string]: VersionRange;
    };
}
export declare class Walker {
    private rootModule;
    private prodPaths;
    constructor(modulePath: string);
    private relativeModule(rootPath, moduleName);
    private loadPackageJSON(modulePath);
    private loadProductionDependenciesForModuleInModule(moduleName, modulePath, allowMissing?);
    private loadProductionDependenciesForModule(modulePath, allowMissing?);
    loadProductionDependencies(): Promise<Set<string>>;
    pruneModule(modulePath: string): Promise<void>;
    prune(): Promise<void>;
}
