'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

exports.isAbsolute = isAbsolute;
exports.isBuiltIn = isBuiltIn;
exports.isExternalModuleMain = isExternalModuleMain;
exports.isScopedMain = isScopedMain;
exports.default = resolveImportType;

var _cond = require('lodash/cond');

var _cond2 = _interopRequireDefault(_cond);

var _core = require('resolve/lib/core');

var _core2 = _interopRequireDefault(_core);

var _path = require('path');

var _resolve = require('eslint-module-utils/resolve');

var _resolve2 = _interopRequireDefault(_resolve);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function constant(value) {
  return () => value;
}

function baseModule(name) {
  if (isScoped(name)) {
    var _name$split = name.split('/'),
        _name$split2 = _slicedToArray(_name$split, 2);

    const scope = _name$split2[0],
          pkg = _name$split2[1];

    return `${scope}/${pkg}`;
  }

  var _name$split3 = name.split('/'),
      _name$split4 = _slicedToArray(_name$split3, 1);

  const pkg = _name$split4[0];

  return pkg;
}

function isAbsolute(name) {
  return name.indexOf('/') === 0;
}

// path is defined only when a resolver resolves to a non-standard path
function isBuiltIn(name, settings, path) {
  if (path) return false;
  const base = baseModule(name);
  const extras = settings && settings['import/core-modules'] || [];
  return _core2.default[base] || extras.indexOf(base) > -1;
}

function isExternalPath(path, name, settings) {
  const folders = settings && settings['import/external-module-folders'] || ['node_modules'];

  // extract the part before the first / (redux-saga/effects => redux-saga)
  const packageName = name.match(/([^/]+)/)[0];

  return !path || folders.some(folder => -1 < path.indexOf((0, _path.join)(folder, packageName)));
}

const externalModuleRegExp = /^\w/;
function isExternalModule(name, settings, path) {
  return externalModuleRegExp.test(name) && isExternalPath(path, name, settings);
}

const externalModuleMainRegExp = /^[\w]((?!\/).)*$/;
function isExternalModuleMain(name, settings, path) {
  return externalModuleMainRegExp.test(name) && isExternalPath(path, name, settings);
}

const scopedRegExp = /^@[^/]+\/[^/]+/;
function isScoped(name) {
  return scopedRegExp.test(name);
}

const scopedMainRegExp = /^@[^/]+\/?[^/]+$/;
function isScopedMain(name) {
  return scopedMainRegExp.test(name);
}

function isInternalModule(name, settings, path) {
  const matchesScopedOrExternalRegExp = scopedRegExp.test(name) || externalModuleRegExp.test(name);
  return matchesScopedOrExternalRegExp && !isExternalPath(path, name, settings);
}

function isRelativeToParent(name) {
  return (/^\.\.[\\/]/.test(name)
  );
}

const indexFiles = ['.', './', './index', './index.js'];
function isIndex(name) {
  return indexFiles.indexOf(name) !== -1;
}

function isRelativeToSibling(name) {
  return (/^\.[\\/]/.test(name)
  );
}

const typeTest = (0, _cond2.default)([[isAbsolute, constant('absolute')], [isBuiltIn, constant('builtin')], [isInternalModule, constant('internal')], [isExternalModule, constant('external')], [isScoped, constant('external')], [isRelativeToParent, constant('parent')], [isIndex, constant('index')], [isRelativeToSibling, constant('sibling')], [constant(true), constant('unknown')]]);

function resolveImportType(name, context) {
  return typeTest(name, context.settings, (0, _resolve2.default)(name, context));
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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