'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _compilerBase = require('../compiler-base');

const inputMimeTypes = ['text/jade'];
let jade = null;

/**
 * @access private
 */
class JadeCompiler extends _compilerBase.SimpleCompilerBase {
  constructor() {
    super();
    this.compilerOptions.sourceMap = true;
  }

  static getInputMimeTypes() {
    return inputMimeTypes;
  }

  compileSync(sourceCode, filePath) {
    jade = jade || require('jade');

    let code = jade.render(sourceCode, Object.assign({ filename: filePath, cache: false }, this.compilerOptions));

    return { code, mimeType: 'text/html' };
  }

  getCompilerVersion() {
    return require('jade/package.json').version;
  }
}
exports.default = JadeCompiler;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy9odG1sL2phZGUuanMiXSwibmFtZXMiOlsiaW5wdXRNaW1lVHlwZXMiLCJqYWRlIiwiSmFkZUNvbXBpbGVyIiwiY29uc3RydWN0b3IiLCJjb21waWxlck9wdGlvbnMiLCJzb3VyY2VNYXAiLCJnZXRJbnB1dE1pbWVUeXBlcyIsImNvbXBpbGVTeW5jIiwic291cmNlQ29kZSIsImZpbGVQYXRoIiwicmVxdWlyZSIsImNvZGUiLCJyZW5kZXIiLCJPYmplY3QiLCJhc3NpZ24iLCJmaWxlbmFtZSIsImNhY2hlIiwibWltZVR5cGUiLCJnZXRDb21waWxlclZlcnNpb24iLCJ2ZXJzaW9uIl0sIm1hcHBpbmdzIjoiOzs7Ozs7QUFBQTs7QUFFQSxNQUFNQSxpQkFBaUIsQ0FBQyxXQUFELENBQXZCO0FBQ0EsSUFBSUMsT0FBTyxJQUFYOztBQUVBOzs7QUFHZSxNQUFNQyxZQUFOLDBDQUE4QztBQUMzREMsZ0JBQWM7QUFDWjtBQUNBLFNBQUtDLGVBQUwsQ0FBcUJDLFNBQXJCLEdBQWlDLElBQWpDO0FBQ0Q7O0FBRUQsU0FBT0MsaUJBQVAsR0FBMkI7QUFDekIsV0FBT04sY0FBUDtBQUNEOztBQUVETyxjQUFZQyxVQUFaLEVBQXdCQyxRQUF4QixFQUFrQztBQUNoQ1IsV0FBT0EsUUFBUVMsUUFBUSxNQUFSLENBQWY7O0FBRUEsUUFBSUMsT0FBT1YsS0FBS1csTUFBTCxDQUNUSixVQURTLEVBRVRLLE9BQU9DLE1BQVAsQ0FBYyxFQUFFQyxVQUFVTixRQUFaLEVBQXNCTyxPQUFPLEtBQTdCLEVBQWQsRUFBb0QsS0FBS1osZUFBekQsQ0FGUyxDQUFYOztBQUlBLFdBQU8sRUFBRU8sSUFBRixFQUFRTSxVQUFVLFdBQWxCLEVBQVA7QUFDRDs7QUFFREMsdUJBQXFCO0FBQ25CLFdBQU9SLFFBQVEsbUJBQVIsRUFBNkJTLE9BQXBDO0FBQ0Q7QUF0QjBEO2tCQUF4Q2pCLFkiLCJmaWxlIjoiamFkZS5qcyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7U2ltcGxlQ29tcGlsZXJCYXNlfSBmcm9tICcuLi9jb21waWxlci1iYXNlJztcclxuXHJcbmNvbnN0IGlucHV0TWltZVR5cGVzID0gWyd0ZXh0L2phZGUnXTtcclxubGV0IGphZGUgPSBudWxsO1xyXG5cclxuLyoqXHJcbiAqIEBhY2Nlc3MgcHJpdmF0ZVxyXG4gKi8gXHJcbmV4cG9ydCBkZWZhdWx0IGNsYXNzIEphZGVDb21waWxlciBleHRlbmRzIFNpbXBsZUNvbXBpbGVyQmFzZSB7XHJcbiAgY29uc3RydWN0b3IoKSB7XHJcbiAgICBzdXBlcigpO1xyXG4gICAgdGhpcy5jb21waWxlck9wdGlvbnMuc291cmNlTWFwID0gdHJ1ZTtcclxuICB9XHJcblxyXG4gIHN0YXRpYyBnZXRJbnB1dE1pbWVUeXBlcygpIHtcclxuICAgIHJldHVybiBpbnB1dE1pbWVUeXBlcztcclxuICB9XHJcblxyXG4gIGNvbXBpbGVTeW5jKHNvdXJjZUNvZGUsIGZpbGVQYXRoKSB7XHJcbiAgICBqYWRlID0gamFkZSB8fCByZXF1aXJlKCdqYWRlJyk7XHJcblxyXG4gICAgbGV0IGNvZGUgPSBqYWRlLnJlbmRlcihcclxuICAgICAgc291cmNlQ29kZSxcclxuICAgICAgT2JqZWN0LmFzc2lnbih7IGZpbGVuYW1lOiBmaWxlUGF0aCwgY2FjaGU6IGZhbHNlIH0sIHRoaXMuY29tcGlsZXJPcHRpb25zKSk7XHJcblxyXG4gICAgcmV0dXJuIHsgY29kZSwgbWltZVR5cGU6ICd0ZXh0L2h0bWwnIH07XHJcbiAgfVxyXG4gIFxyXG4gIGdldENvbXBpbGVyVmVyc2lvbigpIHtcclxuICAgIHJldHVybiByZXF1aXJlKCdqYWRlL3BhY2thZ2UuanNvbicpLnZlcnNpb247XHJcbiAgfVxyXG59XHJcbiJdfQ==