'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = registerRequireExtension;

var _mimeTypes = require('@paulcbetts/mime-types');

var _mimeTypes2 = _interopRequireDefault(_mimeTypes);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

let HMR = false;

const d = require('debug')('electron-compile:require-hook');
let electron = null;

if (process.type === 'renderer') {
  window.__hot = [];
  electron = require('electron');
  HMR = electron.remote.getGlobal('__electron_compile_hmr_enabled__');

  if (HMR) {
    electron.ipcRenderer.on('__electron-compile__HMR', () => {
      d("Got HMR signal!");

      // Reset the module cache
      let cache = require('module')._cache;
      let toEject = Object.keys(cache).filter(x => x && !x.match(/[\\\/](node_modules|.*\.asar)[\\\/]/i));
      toEject.forEach(x => {
        d(`Removing node module entry for ${x}`);
        delete cache[x];
      });

      window.__hot.forEach(fn => fn());
    });
  }
}

/**
 * Initializes the node.js hook that allows us to intercept files loaded by
 * node.js and rewrite them. This method along with {@link initializeProtocolHook}
 * are the top-level methods that electron-compile actually uses to intercept
 * code that Electron loads.
 *
 * @param  {CompilerHost} compilerHost  The compiler host to use for compilation.
 */
function registerRequireExtension(compilerHost, isProduction) {
  if (HMR) {
    try {
      require('module').prototype.hot = {
        accept: cb => window.__hot.push(cb)
      };

      require.main.require('react-hot-loader/patch');
    } catch (e) {
      console.error(`Couldn't require react-hot-loader/patch, you need to add react-hot-loader@3 as a dependency! ${e.message}`);
    }
  }

  let mimeTypeList = isProduction ? Object.keys(compilerHost.mimeTypesToRegister) : Object.keys(compilerHost.compilersByMimeType);

  mimeTypeList.forEach(mimeType => {
    let ext = _mimeTypes2.default.extension(mimeType);

    require.extensions[`.${ext}`] = (module, filename) => {
      var _compilerHost$compile = compilerHost.compileSync(filename);

      let code = _compilerHost$compile.code;


      if (code === null) {
        console.error(`null code returned for "${filename}".  Please raise an issue on 'electron-compile' with the contents of this file.`);
      }

      module._compile(code, filename);
    };
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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