'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.enableLiveReload = enableLiveReload;

var _fileChangeCache = require('./file-change-cache');

var _fileChangeCache2 = _interopRequireDefault(_fileChangeCache);

var _pathwatcherRx = require('./pathwatcher-rx');

var _Observable = require('rxjs/Observable');

require('./custom-operators');

require('rxjs/add/observable/defer');

require('rxjs/add/observable/empty');

require('rxjs/add/observable/fromPromise');

require('rxjs/add/operator/catch');

require('rxjs/add/operator/filter');

require('rxjs/add/operator/mergeMap');

require('rxjs/add/operator/switchMap');

require('rxjs/add/operator/timeout');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function enableLiveReload() {
  let options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  let strategy = options.strategy;


  if (process.type !== 'browser' || !global.globalCompilerHost) throw new Error("Call this from the browser process, right after initializing electron-compile");

  switch (strategy) {
    case 'react-hmr':
      enableReactHMR();
      break;
    case 'naive':
    default:
      enableLiveReloadNaive();
  }
}

let BrowserWindow;
if (process.type === 'browser') {
  BrowserWindow = require('electron').BrowserWindow;
}

function reloadAllWindows() {
  let ret = BrowserWindow.getAllWindows().map(wnd => {
    if (!wnd.isVisible()) return Promise.resolve(true);

    return new Promise(res => {
      wnd.webContents.reloadIgnoringCache();
      wnd.once('ready-to-show', () => res(true));
    });
  });

  return Promise.all(ret);
}

function enableLiveReloadNaive() {
  let filesWeCareAbout = global.globalCompilerHost.listenToCompileEvents().filter(x => !_fileChangeCache2.default.isInNodeModules(x.filePath));

  let weShouldReload = filesWeCareAbout.mergeMap(x => (0, _pathwatcherRx.watchPath)(x.filePath).map(() => x)).guaranteedThrottle(1 * 1000);

  return weShouldReload.switchMap(() => _Observable.Observable.defer(() => _Observable.Observable.fromPromise(reloadAllWindows()).timeout(5 * 1000).catch(() => _Observable.Observable.empty()))).subscribe(() => console.log("Reloaded all windows!"));
}

function triggerHMRInRenderers() {
  BrowserWindow.getAllWindows().forEach(window => {
    window.webContents.send('__electron-compile__HMR');
  });

  return Promise.resolve(true);
}

function enableReactHMR() {
  global.__electron_compile_hmr_enabled__ = true;

  let filesWeCareAbout = global.globalCompilerHost.listenToCompileEvents().filter(x => !_fileChangeCache2.default.isInNodeModules(x.filePath));

  let weShouldReload = filesWeCareAbout.mergeMap(x => (0, _pathwatcherRx.watchPath)(x.filePath).map(() => x)).guaranteedThrottle(1 * 1000);

  return weShouldReload.switchMap(() => _Observable.Observable.defer(() => _Observable.Observable.fromPromise(triggerHMRInRenderers()).catch(() => _Observable.Observable.empty()))).subscribe(() => console.log("HMR sent to all windows!"));
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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