# babel-preset-es2016-node5

This module only support one feature of ES2016: async, you can use preset: es2015-node5, stage3 to get the same effect.

> Babel preset to make node@5 ES2016 compatible.

Node@5 has great [ES2015 support](https://nodejs.org/en/docs/es6/),
this module just adds missing features:
- destructing assignment
- rest & default parameters
- modules
- unicode and sticky regular expressions

And ES2016 support
- async function

## Install

```sh
$ npm install --save-dev babel-preset-es2016-node5
```

## Usage

### Via `.babelrc` (recommended)

**.babelrc**

```json
{
  "presets": ["es2016-node5"]
}
```

### Via CLI

```sh
$ babel script.js --preset es2016-node5
```

### Via Node API

```javascript
require('babel-core').transform('code', {
  presets: ['es2016-node5']
})
```

## License

[MIT](./LICENSE)
