module.exports = getPage

const HttpError = require('../../request/http-error')
const getPageLinks = require('./get-page-links')
const deprecate = require('../../deprecate')

function getPage (octokit, link, which, headers, callback) {
  if (typeof headers === 'function') {
    callback = headers
    headers = null
  }

  if (callback) {
    deprecate('callbacks will be removed in v16. Use async/await or Promises instead.')
  }

  const url = getPageLinks(link)[which]

  if (!url) {
    const urlError = new HttpError(`No ${which} page found`, 404)
    if (callback) {
      return callback(urlError)
    }
    return Promise.reject(urlError)
  }

  const requestOptions = {
    url,
    headers: applyAcceptHeader(link, headers)
  }

  const promise = octokit.request(requestOptions)

  if (callback) {
    promise.then(callback.bind(null, null), callback)
    return
  }

  return promise
}

function applyAcceptHeader (res, headers) {
  const previous = res.headers && res.headers['x-github-media-type']

  if (!previous || (headers && headers.accept)) {
    return headers
  }
  headers = headers || {}
  headers.accept = 'application/vnd.' + previous
    .replace('; param=', '.')
    .replace('; format=', '+')

  return headers
}
