module.exports = apiMethod

const clone = require('lodash/clone')
const defaultsDeep = require('lodash/defaultsDeep')
const mapKeys = require('lodash/mapKeys')

const deprecate = require('../../deprecate')
const validate = require('./validate')

function apiMethod (octokit, endpointDefaults, endpointParams, options, callback) {
  // Do not alter passed options (#786)
  options = clone(options) || {}

  // lowercase header names (#760)
  options.headers = mapKeys(options.headers, (value, key) => key.toLowerCase())

  if (endpointDefaults.deprecated) {
    deprecate(endpointDefaults.deprecated)
    delete endpointDefaults.deprecated
  }

  const endpointOptions = defaultsDeep(options, endpointDefaults)

  const promise = Promise.resolve(endpointOptions)
    .then(validate.bind(null, endpointParams))
    .then(octokit.request)

  if (callback) {
    deprecate('callbacks will be removed in v16. Use async/await or Promises instead.')
    promise.then(callback.bind(null, null), callback)
    return
  }

  return promise
}
