'use strict'

module.exports = apiPlugin

const get = require('lodash/get')
const pick = require('lodash/pick')

const method = require('./method')

const ENDPOINT_DEFAULTS = require('../../routes.json')

function apiPlugin (octokit) {
  Object.keys(ENDPOINT_DEFAULTS).forEach(namespaceName => {
    octokit[namespaceName] = {}

    Object.keys(ENDPOINT_DEFAULTS[namespaceName]).forEach(apiName => {
      let apiOptions = ENDPOINT_DEFAULTS[namespaceName][apiName]
      let deprecated

      if (apiOptions.alias) {
        deprecated = apiOptions.deprecated
        apiOptions = get(ENDPOINT_DEFAULTS, apiOptions.alias)
      }

      const endpointDefaults = pick(apiOptions, ['method', 'url', 'headers', 'request'])
      if (deprecated) {
        endpointDefaults.deprecated = deprecated
      }

      octokit[namespaceName][apiName] = method.bind(null, octokit, endpointDefaults, apiOptions.params)
    })
  })
}
