/**
 * This declaration file requires TypeScript 2.1 or above.
 */

import * as http from "http";

declare namespace Github {
  type json = any;
  type date = string;

  export interface Response<T> {
    /** This is the data you would see in https://developer.github.com/v3/ */
    data: T;

    /** Response status number */
    status: number;

    /** Response headers */
    headers: {
      "x-ratelimit-limit": string;
      "x-ratelimit-remaining": string;
      "x-ratelimit-reset": string;
      "x-github-request-id": string;
      "x-github-media-type": string;
      link: string;
      "last-modified": string;
      etag: string;
      status: string;
    };

    [Symbol.iterator](): Iterator<any>;
  }

  export type AnyResponse = Response<any>;

  export interface EmptyParams {}

  export interface Options {
    baseUrl?: string;
    timeout?: number;
    headers?: { [header: string]: any };
    agent?: http.Agent;

    /**
     * @deprecated in version 15.0.0
     */
    proxy?: string;
    /**
     * @deprecated in version 15.0.0
     */
    ca?: string;
    /**
     * @deprecated in version 15.0.0
     */
    rejectUnauthorized?: boolean;
    /**
     * @deprecated in version 15.0.0
     */
    family?: number;

    /**
     * @deprecated in version 15.2.0
     */
    host?: string;
    /**
     * @deprecated in version 15.2.0
     */
    pathPrefix?: string;
    /**
     * @deprecated in version 15.2.0
     */
    protocol?: string;
    /**
     * @deprecated in version 15.2.0
     */
    port?: number;
  }

  export interface AuthBasic {
    type: "basic";
    username: string;
    password: string;
  }

  export interface AuthOAuthToken {
    type: "oauth";
    token: string;
  }

  export interface AuthOAuthSecret {
    type: "oauth";
    key: string;
    secret: string;
  }

  export interface AuthUserToken {
    type: "token";
    token: string;
  }

  /* @deprecated Use "app" instead of "integration" */
  export interface DeprecatedAuthJWT {
    type: "integration";
    token: string;
  }

  export interface AuthJWT {
    type: "app";
    token: string;
  }

  export type Auth =
    | AuthBasic
    | AuthOAuthToken
    | AuthOAuthSecret
    | AuthUserToken
    | AuthJWT
    | DeprecatedAuthJWT;

  export type Link = { link: string } | { headers: { link: string } } | string;

  export interface Callback<T> {
    (error: Error | null, result: T): any;
  }

  type UsersUpdateAuthenticatedResponsePlan = {
    name: string;
    space: number;
    private_repos: number;
    collaborators: number;
  };
  type UsersUpdateAuthenticatedResponse = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
    name: string;
    company: string;
    blog: string;
    location: string;
    email: string;
    hireable: boolean;
    bio: string;
    public_repos: number;
    public_gists: number;
    followers: number;
    following: number;
    created_at: string;
    updated_at: string;
    total_private_repos: number;
    owned_private_repos: number;
    private_gists: number;
    disk_usage: number;
    collaborators: number;
    two_factor_authentication: boolean;
    plan: UsersUpdateAuthenticatedResponsePlan;
  };
  type UsersUnfollowResponse = {};
  type UsersUnblockResponse = {};
  type UsersTogglePrimaryEmailVisibilityResponseItem = {
    email: string;
    primary: boolean;
    verified: boolean;
    visibility: string;
  };
  type UsersListPublicKeysForUserResponseItem = { id: number; key: string };
  type UsersListPublicKeysResponseItem = {
    id: number;
    key: string;
    url: string;
    title: string;
    verified: boolean;
    created_at: string;
    read_only: boolean;
  };
  type UsersListPublicEmailsResponseItem = {
    email: string;
    verified: boolean;
    primary: boolean;
    visibility: string;
  };
  type UsersListGpgKeysForUserResponseItemSubkeysItem = {
    id: number;
    primary_key_id: number;
    key_id: string;
    public_key: string;
    emails: Array<any>;
    subkeys: Array<any>;
    can_sign: boolean;
    can_encrypt_comms: boolean;
    can_encrypt_storage: boolean;
    can_certify: boolean;
    created_at: string;
    expires_at: null;
  };
  type UsersListGpgKeysForUserResponseItemEmailsItem = {
    email: string;
    verified: boolean;
  };
  type UsersListGpgKeysForUserResponseItem = {
    id: number;
    primary_key_id: null;
    key_id: string;
    public_key: string;
    emails: Array<UsersListGpgKeysForUserResponseItemEmailsItem>;
    subkeys: Array<UsersListGpgKeysForUserResponseItemSubkeysItem>;
    can_sign: boolean;
    can_encrypt_comms: boolean;
    can_encrypt_storage: boolean;
    can_certify: boolean;
    created_at: string;
    expires_at: null;
  };
  type UsersListGpgKeysResponseItemSubkeysItem = {
    id: number;
    primary_key_id: number;
    key_id: string;
    public_key: string;
    emails: Array<any>;
    subkeys: Array<any>;
    can_sign: boolean;
    can_encrypt_comms: boolean;
    can_encrypt_storage: boolean;
    can_certify: boolean;
    created_at: string;
    expires_at: null;
  };
  type UsersListGpgKeysResponseItemEmailsItem = {
    email: string;
    verified: boolean;
  };
  type UsersListGpgKeysResponseItem = {
    id: number;
    primary_key_id: null;
    key_id: string;
    public_key: string;
    emails: Array<UsersListGpgKeysResponseItemEmailsItem>;
    subkeys: Array<UsersListGpgKeysResponseItemSubkeysItem>;
    can_sign: boolean;
    can_encrypt_comms: boolean;
    can_encrypt_storage: boolean;
    can_certify: boolean;
    created_at: string;
    expires_at: null;
  };
  type UsersListFollowingForUserResponseItem = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type UsersListFollowingForAuthenticatedUserResponseItem = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type UsersListFollowersForUserResponseItem = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type UsersListFollowersForAuthenticatedUserResponseItem = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type UsersListEmailsResponseItem = {
    email: string;
    verified: boolean;
    primary: boolean;
    visibility: string;
  };
  type UsersListBlockedResponseItem = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type UsersListResponseItem = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type UsersGetPublicKeyResponse = {
    id: number;
    key: string;
    url: string;
    title: string;
    verified: boolean;
    created_at: string;
    read_only: boolean;
  };
  type UsersGetGpgKeyResponseSubkeysItem = {
    id: number;
    primary_key_id: number;
    key_id: string;
    public_key: string;
    emails: Array<any>;
    subkeys: Array<any>;
    can_sign: boolean;
    can_encrypt_comms: boolean;
    can_encrypt_storage: boolean;
    can_certify: boolean;
    created_at: string;
    expires_at: null;
  };
  type UsersGetGpgKeyResponseEmailsItem = { email: string; verified: boolean };
  type UsersGetGpgKeyResponse = {
    id: number;
    primary_key_id: null;
    key_id: string;
    public_key: string;
    emails: Array<UsersGetGpgKeyResponseEmailsItem>;
    subkeys: Array<UsersGetGpgKeyResponseSubkeysItem>;
    can_sign: boolean;
    can_encrypt_comms: boolean;
    can_encrypt_storage: boolean;
    can_certify: boolean;
    created_at: string;
    expires_at: null;
  };
  type UsersGetByUsernameResponse = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
    name: string;
    company: string;
    blog: string;
    location: string;
    email: string;
    hireable: boolean;
    bio: string;
    public_repos: number;
    public_gists: number;
    followers: number;
    following: number;
    created_at: string;
    updated_at: string;
  };
  type UsersFollowResponse = {};
  type UsersDeletePublicKeyResponse = {};
  type UsersDeleteGpgKeyResponse = {};
  type UsersDeleteEmailsResponse = {};
  type UsersCreatePublicKeyResponse = {
    id: number;
    key: string;
    url: string;
    title: string;
    verified: boolean;
    created_at: string;
    read_only: boolean;
  };
  type UsersCreateGpgKeyResponseSubkeysItem = {
    id: number;
    primary_key_id: number;
    key_id: string;
    public_key: string;
    emails: Array<any>;
    subkeys: Array<any>;
    can_sign: boolean;
    can_encrypt_comms: boolean;
    can_encrypt_storage: boolean;
    can_certify: boolean;
    created_at: string;
    expires_at: null;
  };
  type UsersCreateGpgKeyResponseEmailsItem = {
    email: string;
    verified: boolean;
  };
  type UsersCreateGpgKeyResponse = {
    id: number;
    primary_key_id: null;
    key_id: string;
    public_key: string;
    emails: Array<UsersCreateGpgKeyResponseEmailsItem>;
    subkeys: Array<UsersCreateGpgKeyResponseSubkeysItem>;
    can_sign: boolean;
    can_encrypt_comms: boolean;
    can_encrypt_storage: boolean;
    can_certify: boolean;
    created_at: string;
    expires_at: null;
  };
  type UsersCheckBlockedResponse = {};
  type UsersBlockResponse = {};
  type UsersAddEmailsResponseItem = {
    email: string;
    primary: boolean;
    verified: boolean;
    visibility: string | null;
  };
  type TeamsUpdateDiscussionCommentResponseReactions = {
    url: string;
    total_count: number;
    "+1": number;
    "-1": number;
    laugh: number;
    confused: number;
    heart: number;
    hooray: number;
  };
  type TeamsUpdateDiscussionCommentResponseAuthor = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type TeamsUpdateDiscussionCommentResponse = {
    author: TeamsUpdateDiscussionCommentResponseAuthor;
    body: string;
    body_html: string;
    body_version: string;
    created_at: string;
    last_edited_at: string;
    discussion_url: string;
    html_url: string;
    node_id: string;
    number: number;
    updated_at: string;
    url: string;
    reactions: TeamsUpdateDiscussionCommentResponseReactions;
  };
  type TeamsUpdateDiscussionResponseReactions = {
    url: string;
    total_count: number;
    "+1": number;
    "-1": number;
    laugh: number;
    confused: number;
    heart: number;
    hooray: number;
  };
  type TeamsUpdateDiscussionResponseAuthor = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type TeamsUpdateDiscussionResponse = {
    author: TeamsUpdateDiscussionResponseAuthor;
    body: string;
    body_html: string;
    body_version: string;
    comments_count: number;
    comments_url: string;
    created_at: string;
    last_edited_at: string;
    html_url: string;
    node_id: string;
    number: number;
    pinned: boolean;
    private: boolean;
    team_url: string;
    title: string;
    updated_at: string;
    url: string;
    reactions: TeamsUpdateDiscussionResponseReactions;
  };
  type TeamsUpdateResponseOrganization = {
    login: string;
    id: number;
    node_id: string;
    url: string;
    repos_url: string;
    events_url: string;
    hooks_url: string;
    issues_url: string;
    members_url: string;
    public_members_url: string;
    avatar_url: string;
    description: string;
    name: string;
    company: string;
    blog: string;
    location: string;
    email: string;
    is_verified: boolean;
    has_organization_projects: boolean;
    has_repository_projects: boolean;
    public_repos: number;
    public_gists: number;
    followers: number;
    following: number;
    html_url: string;
    created_at: string;
    type: string;
  };
  type TeamsUpdateResponse = {
    id: number;
    node_id: string;
    url: string;
    name: string;
    slug: string;
    description: string;
    privacy: string;
    permission: string;
    members_url: string;
    repositories_url: string;
    parent: null;
    members_count: number;
    repos_count: number;
    created_at: string;
    updated_at: string;
    organization: TeamsUpdateResponseOrganization;
  };
  type TeamsReviewProjectResponsePermissions = {
    read: boolean;
    write: boolean;
    admin: boolean;
  };
  type TeamsReviewProjectResponseCreator = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type TeamsReviewProjectResponse = {
    owner_url: string;
    url: string;
    html_url: string;
    columns_url: string;
    id: number;
    node_id: string;
    name: string;
    body: string;
    number: number;
    state: string;
    creator: TeamsReviewProjectResponseCreator;
    created_at: string;
    updated_at: string;
    organization_permission: string;
    private: boolean;
    permissions: TeamsReviewProjectResponsePermissions;
  };
  type TeamsRemoveRepoResponse = {};
  type TeamsRemoveProjectResponse = {};
  type TeamsRemoveMembershipResponse = {};
  type TeamsRemoveMemberResponse = {};
  type TeamsListReposResponseItemLicense = {
    key: string;
    name: string;
    spdx_id: string;
    url: string;
    node_id: string;
  };
  type TeamsListReposResponseItemPermissions = {
    admin: boolean;
    push: boolean;
    pull: boolean;
  };
  type TeamsListReposResponseItemOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type TeamsListReposResponseItem = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: TeamsListReposResponseItemOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    clone_url: string;
    mirror_url: string;
    hooks_url: string;
    svn_url: string;
    homepage: string;
    language: null;
    forks_count: number;
    stargazers_count: number;
    watchers_count: number;
    size: number;
    default_branch: string;
    open_issues_count: number;
    topics: Array<string>;
    has_issues: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    has_pages: boolean;
    has_downloads: boolean;
    archived: boolean;
    pushed_at: string;
    created_at: string;
    updated_at: string;
    permissions: TeamsListReposResponseItemPermissions;
    subscribers_count: number;
    network_count: number;
    license: TeamsListReposResponseItemLicense;
  };
  type TeamsListProjectsResponseItemPermissions = {
    read: boolean;
    write: boolean;
    admin: boolean;
  };
  type TeamsListProjectsResponseItemCreator = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type TeamsListProjectsResponseItem = {
    owner_url: string;
    url: string;
    html_url: string;
    columns_url: string;
    id: number;
    node_id: string;
    name: string;
    body: string;
    number: number;
    state: string;
    creator: TeamsListProjectsResponseItemCreator;
    created_at: string;
    updated_at: string;
    organization_permission: string;
    private: boolean;
    permissions: TeamsListProjectsResponseItemPermissions;
  };
  type TeamsListPendingInvitationsResponseItemInviter = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type TeamsListPendingInvitationsResponseItem = {
    id: number;
    login: string;
    email: string;
    role: string;
    created_at: string;
    inviter: TeamsListPendingInvitationsResponseItemInviter;
    team_count: number;
    invitation_team_url: string;
  };
  type TeamsListMembersResponseItem = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type TeamsListForAuthenticatedUserResponseItemOrganization = {
    login: string;
    id: number;
    node_id: string;
    url: string;
    repos_url: string;
    events_url: string;
    hooks_url: string;
    issues_url: string;
    members_url: string;
    public_members_url: string;
    avatar_url: string;
    description: string;
    name: string;
    company: string;
    blog: string;
    location: string;
    email: string;
    is_verified: boolean;
    has_organization_projects: boolean;
    has_repository_projects: boolean;
    public_repos: number;
    public_gists: number;
    followers: number;
    following: number;
    html_url: string;
    created_at: string;
    type: string;
  };
  type TeamsListForAuthenticatedUserResponseItem = {
    id: number;
    node_id: string;
    url: string;
    name: string;
    slug: string;
    description: string;
    privacy: string;
    permission: string;
    members_url: string;
    repositories_url: string;
    parent: null;
    members_count: number;
    repos_count: number;
    created_at: string;
    updated_at: string;
    organization: TeamsListForAuthenticatedUserResponseItemOrganization;
  };
  type TeamsListDiscussionsResponseItemReactions = {
    url: string;
    total_count: number;
    "+1": number;
    "-1": number;
    laugh: number;
    confused: number;
    heart: number;
    hooray: number;
  };
  type TeamsListDiscussionsResponseItemAuthor = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type TeamsListDiscussionsResponseItem = {
    author: TeamsListDiscussionsResponseItemAuthor;
    body: string;
    body_html: string;
    body_version: string;
    comments_count: number;
    comments_url: string;
    created_at: string;
    last_edited_at: null;
    html_url: string;
    node_id: string;
    number: number;
    pinned: boolean;
    private: boolean;
    team_url: string;
    title: string;
    updated_at: string;
    url: string;
    reactions: TeamsListDiscussionsResponseItemReactions;
  };
  type TeamsListDiscussionCommentsResponseItemReactions = {
    url: string;
    total_count: number;
    "+1": number;
    "-1": number;
    laugh: number;
    confused: number;
    heart: number;
    hooray: number;
  };
  type TeamsListDiscussionCommentsResponseItemAuthor = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type TeamsListDiscussionCommentsResponseItem = {
    author: TeamsListDiscussionCommentsResponseItemAuthor;
    body: string;
    body_html: string;
    body_version: string;
    created_at: string;
    last_edited_at: null;
    discussion_url: string;
    html_url: string;
    node_id: string;
    number: number;
    updated_at: string;
    url: string;
    reactions: TeamsListDiscussionCommentsResponseItemReactions;
  };
  type TeamsListResponseItem = {
    id: number;
    node_id: string;
    url: string;
    name: string;
    slug: string;
    description: string;
    privacy: string;
    permission: string;
    members_url: string;
    repositories_url: string;
    parent: null;
  };
  type TeamsGetDiscussionCommentResponseReactions = {
    url: string;
    total_count: number;
    "+1": number;
    "-1": number;
    laugh: number;
    confused: number;
    heart: number;
    hooray: number;
  };
  type TeamsGetDiscussionCommentResponseAuthor = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type TeamsGetDiscussionCommentResponse = {
    author: TeamsGetDiscussionCommentResponseAuthor;
    body: string;
    body_html: string;
    body_version: string;
    created_at: string;
    last_edited_at: null;
    discussion_url: string;
    html_url: string;
    node_id: string;
    number: number;
    updated_at: string;
    url: string;
    reactions: TeamsGetDiscussionCommentResponseReactions;
  };
  type TeamsGetDiscussionResponseReactions = {
    url: string;
    total_count: number;
    "+1": number;
    "-1": number;
    laugh: number;
    confused: number;
    heart: number;
    hooray: number;
  };
  type TeamsGetDiscussionResponseAuthor = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type TeamsGetDiscussionResponse = {
    author: TeamsGetDiscussionResponseAuthor;
    body: string;
    body_html: string;
    body_version: string;
    comments_count: number;
    comments_url: string;
    created_at: string;
    last_edited_at: null;
    html_url: string;
    node_id: string;
    number: number;
    pinned: boolean;
    private: boolean;
    team_url: string;
    title: string;
    updated_at: string;
    url: string;
    reactions: TeamsGetDiscussionResponseReactions;
  };
  type TeamsGetResponseOrganization = {
    login: string;
    id: number;
    node_id: string;
    url: string;
    repos_url: string;
    events_url: string;
    hooks_url: string;
    issues_url: string;
    members_url: string;
    public_members_url: string;
    avatar_url: string;
    description: string;
    name: string;
    company: string;
    blog: string;
    location: string;
    email: string;
    is_verified: boolean;
    has_organization_projects: boolean;
    has_repository_projects: boolean;
    public_repos: number;
    public_gists: number;
    followers: number;
    following: number;
    html_url: string;
    created_at: string;
    type: string;
  };
  type TeamsGetResponse = {
    id: number;
    node_id: string;
    url: string;
    name: string;
    slug: string;
    description: string;
    privacy: string;
    permission: string;
    members_url: string;
    repositories_url: string;
    parent: null;
    members_count: number;
    repos_count: number;
    created_at: string;
    updated_at: string;
    organization: TeamsGetResponseOrganization;
  };
  type TeamsDeleteDiscussionCommentResponse = {};
  type TeamsDeleteDiscussionResponse = {};
  type TeamsDeleteResponse = {};
  type TeamsCreateDiscussionCommentResponseReactions = {
    url: string;
    total_count: number;
    "+1": number;
    "-1": number;
    laugh: number;
    confused: number;
    heart: number;
    hooray: number;
  };
  type TeamsCreateDiscussionCommentResponseAuthor = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type TeamsCreateDiscussionCommentResponse = {
    author: TeamsCreateDiscussionCommentResponseAuthor;
    body: string;
    body_html: string;
    body_version: string;
    created_at: string;
    last_edited_at: null;
    discussion_url: string;
    html_url: string;
    node_id: string;
    number: number;
    updated_at: string;
    url: string;
    reactions: TeamsCreateDiscussionCommentResponseReactions;
  };
  type TeamsCreateDiscussionResponseReactions = {
    url: string;
    total_count: number;
    "+1": number;
    "-1": number;
    laugh: number;
    confused: number;
    heart: number;
    hooray: number;
  };
  type TeamsCreateDiscussionResponseAuthor = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type TeamsCreateDiscussionResponse = {
    author: TeamsCreateDiscussionResponseAuthor;
    body: string;
    body_html: string;
    body_version: string;
    comments_count: number;
    comments_url: string;
    created_at: string;
    last_edited_at: null;
    html_url: string;
    node_id: string;
    number: number;
    pinned: boolean;
    private: boolean;
    team_url: string;
    title: string;
    updated_at: string;
    url: string;
    reactions: TeamsCreateDiscussionResponseReactions;
  };
  type TeamsCreateResponseOrganization = {
    login: string;
    id: number;
    node_id: string;
    url: string;
    repos_url: string;
    events_url: string;
    hooks_url: string;
    issues_url: string;
    members_url: string;
    public_members_url: string;
    avatar_url: string;
    description: string;
    name: string;
    company: string;
    blog: string;
    location: string;
    email: string;
    is_verified: boolean;
    has_organization_projects: boolean;
    has_repository_projects: boolean;
    public_repos: number;
    public_gists: number;
    followers: number;
    following: number;
    html_url: string;
    created_at: string;
    type: string;
  };
  type TeamsCreateResponse = {
    id: number;
    node_id: string;
    url: string;
    name: string;
    slug: string;
    description: string;
    privacy: string;
    permission: string;
    members_url: string;
    repositories_url: string;
    parent: null;
    members_count: number;
    repos_count: number;
    created_at: string;
    updated_at: string;
    organization: TeamsCreateResponseOrganization;
  };
  type TeamsAddOrUpdateRepoResponse = {};
  type TeamsAddOrUpdateProjectResponse = {};
  type TeamsAddMemberResponseErrorsItem = {
    code: string;
    field: string;
    resource: string;
  };
  type TeamsAddMemberResponse = {
    message?: string;
    errors?: Array<TeamsAddMemberResponseErrorsItem>;
  };
  type ReposUpdateReleaseAssetResponseUploader = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ReposUpdateReleaseAssetResponse = {
    url: string;
    browser_download_url: string;
    id: number;
    node_id: string;
    name: string;
    label: string;
    state: string;
    content_type: string;
    size: number;
    download_count: number;
    created_at: string;
    updated_at: string;
    uploader: ReposUpdateReleaseAssetResponseUploader;
  };
  type ReposUpdateReleaseResponseAssetsItemUploader = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ReposUpdateReleaseResponseAssetsItem = {
    url: string;
    browser_download_url: string;
    id: number;
    node_id: string;
    name: string;
    label: string;
    state: string;
    content_type: string;
    size: number;
    download_count: number;
    created_at: string;
    updated_at: string;
    uploader: ReposUpdateReleaseResponseAssetsItemUploader;
  };
  type ReposUpdateReleaseResponseAuthor = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ReposUpdateReleaseResponse = {
    url: string;
    html_url: string;
    assets_url: string;
    upload_url: string;
    tarball_url: string;
    zipball_url: string;
    id: number;
    node_id: string;
    tag_name: string;
    target_commitish: string;
    name: string;
    body: string;
    draft: boolean;
    prerelease: boolean;
    created_at: string;
    published_at: string;
    author: ReposUpdateReleaseResponseAuthor;
    assets: Array<ReposUpdateReleaseResponseAssetsItem>;
  };
  type ReposUpdateProtectedBranchRequiredStatusChecksResponse = {
    url: string;
    strict: boolean;
    contexts: Array<string>;
    contexts_url: string;
  };
  type ReposUpdateProtectedBranchPullRequestReviewEnforcementResponseDismissalRestrictionsTeamsItem = {
    id: number;
    node_id: string;
    url: string;
    name: string;
    slug: string;
    description: string;
    privacy: string;
    permission: string;
    members_url: string;
    repositories_url: string;
    parent: null;
  };
  type ReposUpdateProtectedBranchPullRequestReviewEnforcementResponseDismissalRestrictionsUsersItem = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ReposUpdateProtectedBranchPullRequestReviewEnforcementResponseDismissalRestrictions = {
    url: string;
    users_url: string;
    teams_url: string;
    users: Array<
      ReposUpdateProtectedBranchPullRequestReviewEnforcementResponseDismissalRestrictionsUsersItem
    >;
    teams: Array<
      ReposUpdateProtectedBranchPullRequestReviewEnforcementResponseDismissalRestrictionsTeamsItem
    >;
  };
  type ReposUpdateProtectedBranchPullRequestReviewEnforcementResponse = {
    url: string;
    dismissal_restrictions: ReposUpdateProtectedBranchPullRequestReviewEnforcementResponseDismissalRestrictions;
    dismiss_stale_reviews: boolean;
    require_code_owner_reviews: boolean;
    required_approving_review_count: number;
  };
  type ReposUpdateInvitationResponseInviter = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ReposUpdateInvitationResponseInvitee = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ReposUpdateInvitationResponseRepositoryOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ReposUpdateInvitationResponseRepository = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: ReposUpdateInvitationResponseRepositoryOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
  };
  type ReposUpdateInvitationResponse = {
    id: number;
    repository: ReposUpdateInvitationResponseRepository;
    invitee: ReposUpdateInvitationResponseInvitee;
    inviter: ReposUpdateInvitationResponseInviter;
    permissions: string;
    created_at: string;
    url: string;
    html_url: string;
  };
  type ReposUpdateInformationAboutPagesSiteResponse = {};
  type ReposUpdateHookResponseConfig = { url: string; content_type: string };
  type ReposUpdateHookResponse = {
    id: number;
    url: string;
    test_url: string;
    ping_url: string;
    name: string;
    events: Array<string>;
    active: boolean;
    config: ReposUpdateHookResponseConfig;
    updated_at: string;
    created_at: string;
  };
  type ReposUpdateFileResponseCommitVerification = {
    verified: boolean;
    reason: string;
    signature: null;
    payload: null;
  };
  type ReposUpdateFileResponseCommitParentsItem = {
    url: string;
    html_url: string;
    sha: string;
  };
  type ReposUpdateFileResponseCommitTree = { url: string; sha: string };
  type ReposUpdateFileResponseCommitCommitter = {
    date: string;
    name: string;
    email: string;
  };
  type ReposUpdateFileResponseCommitAuthor = {
    date: string;
    name: string;
    email: string;
  };
  type ReposUpdateFileResponseCommit = {
    sha: string;
    node_id: string;
    url: string;
    html_url: string;
    author: ReposUpdateFileResponseCommitAuthor;
    committer: ReposUpdateFileResponseCommitCommitter;
    message: string;
    tree: ReposUpdateFileResponseCommitTree;
    parents: Array<ReposUpdateFileResponseCommitParentsItem>;
    verification: ReposUpdateFileResponseCommitVerification;
  };
  type ReposUpdateFileResponseContentLinks = {
    self: string;
    git: string;
    html: string;
  };
  type ReposUpdateFileResponseContent = {
    name: string;
    path: string;
    sha: string;
    size: number;
    url: string;
    html_url: string;
    git_url: string;
    download_url: string;
    type: string;
    _links: ReposUpdateFileResponseContentLinks;
  };
  type ReposUpdateFileResponse = {
    content: ReposUpdateFileResponseContent;
    commit: ReposUpdateFileResponseCommit;
  };
  type ReposUpdateCommitCommentResponseUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ReposUpdateCommitCommentResponse = {
    html_url: string;
    url: string;
    id: number;
    node_id: string;
    body: string;
    path: string;
    position: number;
    line: number;
    commit_id: string;
    user: ReposUpdateCommitCommentResponseUser;
    created_at: string;
    updated_at: string;
  };
  type ReposUpdateBranchProtectionResponseRestrictionsTeamsItem = {
    id: number;
    node_id: string;
    url: string;
    name: string;
    slug: string;
    description: string;
    privacy: string;
    permission: string;
    members_url: string;
    repositories_url: string;
    parent: null;
  };
  type ReposUpdateBranchProtectionResponseRestrictionsUsersItem = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ReposUpdateBranchProtectionResponseRestrictions = {
    url: string;
    users_url: string;
    teams_url: string;
    users: Array<ReposUpdateBranchProtectionResponseRestrictionsUsersItem>;
    teams: Array<ReposUpdateBranchProtectionResponseRestrictionsTeamsItem>;
  };
  type ReposUpdateBranchProtectionResponseRequiredPullRequestReviewsDismissalRestrictionsTeamsItem = {
    id: number;
    node_id: string;
    url: string;
    name: string;
    slug: string;
    description: string;
    privacy: string;
    permission: string;
    members_url: string;
    repositories_url: string;
    parent: null;
  };
  type ReposUpdateBranchProtectionResponseRequiredPullRequestReviewsDismissalRestrictionsUsersItem = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ReposUpdateBranchProtectionResponseRequiredPullRequestReviewsDismissalRestrictions = {
    url: string;
    users_url: string;
    teams_url: string;
    users: Array<
      ReposUpdateBranchProtectionResponseRequiredPullRequestReviewsDismissalRestrictionsUsersItem
    >;
    teams: Array<
      ReposUpdateBranchProtectionResponseRequiredPullRequestReviewsDismissalRestrictionsTeamsItem
    >;
  };
  type ReposUpdateBranchProtectionResponseRequiredPullRequestReviews = {
    url: string;
    dismissal_restrictions: ReposUpdateBranchProtectionResponseRequiredPullRequestReviewsDismissalRestrictions;
    dismiss_stale_reviews: boolean;
    require_code_owner_reviews: boolean;
    required_approving_review_count: number;
  };
  type ReposUpdateBranchProtectionResponseEnforceAdmins = {
    url: string;
    enabled: boolean;
  };
  type ReposUpdateBranchProtectionResponseRequiredStatusChecks = {
    url: string;
    strict: boolean;
    contexts: Array<string>;
    contexts_url: string;
  };
  type ReposUpdateBranchProtectionResponse = {
    url: string;
    required_status_checks: ReposUpdateBranchProtectionResponseRequiredStatusChecks;
    enforce_admins: ReposUpdateBranchProtectionResponseEnforceAdmins;
    required_pull_request_reviews: ReposUpdateBranchProtectionResponseRequiredPullRequestReviews;
    restrictions: ReposUpdateBranchProtectionResponseRestrictions;
  };
  type ReposUpdateResponseSourcePermissions = {
    admin: boolean;
    push: boolean;
    pull: boolean;
  };
  type ReposUpdateResponseSourceOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ReposUpdateResponseSource = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: ReposUpdateResponseSourceOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    clone_url: string;
    mirror_url: string;
    hooks_url: string;
    svn_url: string;
    homepage: string;
    language: null;
    forks_count: number;
    stargazers_count: number;
    watchers_count: number;
    size: number;
    default_branch: string;
    open_issues_count: number;
    topics: Array<string>;
    has_issues: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    has_pages: boolean;
    has_downloads: boolean;
    archived: boolean;
    pushed_at: string;
    created_at: string;
    updated_at: string;
    permissions: ReposUpdateResponseSourcePermissions;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    allow_merge_commit: boolean;
    subscribers_count: number;
    network_count: number;
  };
  type ReposUpdateResponseParentPermissions = {
    admin: boolean;
    push: boolean;
    pull: boolean;
  };
  type ReposUpdateResponseParentOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ReposUpdateResponseParent = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: ReposUpdateResponseParentOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    clone_url: string;
    mirror_url: string;
    hooks_url: string;
    svn_url: string;
    homepage: string;
    language: null;
    forks_count: number;
    stargazers_count: number;
    watchers_count: number;
    size: number;
    default_branch: string;
    open_issues_count: number;
    topics: Array<string>;
    has_issues: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    has_pages: boolean;
    has_downloads: boolean;
    archived: boolean;
    pushed_at: string;
    created_at: string;
    updated_at: string;
    permissions: ReposUpdateResponseParentPermissions;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    allow_merge_commit: boolean;
    subscribers_count: number;
    network_count: number;
  };
  type ReposUpdateResponseOrganization = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ReposUpdateResponsePermissions = {
    admin: boolean;
    push: boolean;
    pull: boolean;
  };
  type ReposUpdateResponseOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ReposUpdateResponse = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: ReposUpdateResponseOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    clone_url: string;
    mirror_url: string;
    hooks_url: string;
    svn_url: string;
    homepage: string;
    language: null;
    forks_count: number;
    stargazers_count: number;
    watchers_count: number;
    size: number;
    default_branch: string;
    open_issues_count: number;
    topics: Array<string>;
    has_issues: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    has_pages: boolean;
    has_downloads: boolean;
    archived: boolean;
    pushed_at: string;
    created_at: string;
    updated_at: string;
    permissions: ReposUpdateResponsePermissions;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    allow_merge_commit: boolean;
    subscribers_count: number;
    network_count: number;
    organization: ReposUpdateResponseOrganization;
    parent: ReposUpdateResponseParent;
    source: ReposUpdateResponseSource;
  };
  type ReposTransferResponsePermissions = {
    admin: boolean;
    push: boolean;
    pull: boolean;
  };
  type ReposTransferResponseOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ReposTransferResponse = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: ReposTransferResponseOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    clone_url: string;
    mirror_url: string;
    hooks_url: string;
    svn_url: string;
    homepage: string;
    language: null;
    forks_count: number;
    stargazers_count: number;
    watchers_count: number;
    size: number;
    default_branch: string;
    open_issues_count: number;
    topics: Array<string>;
    has_issues: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    has_pages: boolean;
    has_downloads: boolean;
    archived: boolean;
    pushed_at: string;
    created_at: string;
    updated_at: string;
    permissions: ReposTransferResponsePermissions;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    allow_merge_commit: boolean;
    subscribers_count: number;
    network_count: number;
  };
  type ReposTestPushHookResponse = {};
  type ReposRetrieveCommunityProfileMetricsResponseFilesReadme = {
    url: string;
    html_url: string;
  };
  type ReposRetrieveCommunityProfileMetricsResponseFilesLicense = {
    name: string;
    key: string;
    spdx_id: string;
    url: string;
    html_url: string;
  };
  type ReposRetrieveCommunityProfileMetricsResponseFilesPullRequestTemplate = {
    url: string;
    html_url: string;
  };
  type ReposRetrieveCommunityProfileMetricsResponseFilesIssueTemplate = {
    url: string;
    html_url: string;
  };
  type ReposRetrieveCommunityProfileMetricsResponseFilesContributing = {
    url: string;
    html_url: string;
  };
  type ReposRetrieveCommunityProfileMetricsResponseFilesCodeOfConduct = {
    name: string;
    key: string;
    url: string;
    html_url: string;
  };
  type ReposRetrieveCommunityProfileMetricsResponseFiles = {
    code_of_conduct: ReposRetrieveCommunityProfileMetricsResponseFilesCodeOfConduct;
    contributing: ReposRetrieveCommunityProfileMetricsResponseFilesContributing;
    issue_template: ReposRetrieveCommunityProfileMetricsResponseFilesIssueTemplate;
    pull_request_template: ReposRetrieveCommunityProfileMetricsResponseFilesPullRequestTemplate;
    license: ReposRetrieveCommunityProfileMetricsResponseFilesLicense;
    readme: ReposRetrieveCommunityProfileMetricsResponseFilesReadme;
  };
  type ReposRetrieveCommunityProfileMetricsResponse = {
    health_percentage: number;
    description: string;
    documentation: boolean;
    files: ReposRetrieveCommunityProfileMetricsResponseFiles;
    updated_at: string;
  };
  type ReposRequestPageBuildResponse = { url: string; status: string };
  type ReposReplaceTopicsResponse = { names: Array<string> };
  type ReposReplaceProtectedBranchUserRestrictionsResponseItem = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ReposReplaceProtectedBranchTeamRestrictionsResponseItem = {
    id: number;
    node_id: string;
    url: string;
    name: string;
    slug: string;
    description: string;
    privacy: string;
    permission: string;
    members_url: string;
    repositories_url: string;
    parent: null;
  };
  type ReposRemoveProtectedBranchUserRestrictionsResponseItem = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ReposRemoveProtectedBranchTeamRestrictionsResponseItem = {
    id: number;
    node_id: string;
    url: string;
    name: string;
    slug: string;
    description: string;
    privacy: string;
    permission: string;
    members_url: string;
    repositories_url: string;
    parent: null;
  };
  type ReposRemoveDeployKeyResponse = {};
  type ReposRemoveCollaboratorResponse = {};
  type ReposRemoveBranchProtectionResponse = {};
  type ReposPingHookResponse = {};
  type ReposListTopicsResponse = { names: Array<string> };
  type ReposListTeamsResponseItem = {
    id: number;
    node_id: string;
    url: string;
    name: string;
    slug: string;
    description: string;
    privacy: string;
    permission: string;
    members_url: string;
    repositories_url: string;
    parent: null;
  };
  type ReposListTagsResponseItemCommit = { sha: string; url: string };
  type ReposListTagsResponseItem = {
    name: string;
    commit: ReposListTagsResponseItemCommit;
    zipball_url: string;
    tarball_url: string;
  };
  type ReposListStatusesForRefResponseItemCreator = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ReposListStatusesForRefResponseItem = {
    url: string;
    avatar_url: string;
    id: number;
    node_id: string;
    state: string;
    description: string;
    target_url: string;
    context: string;
    created_at: string;
    updated_at: string;
    creator: ReposListStatusesForRefResponseItemCreator;
  };
  type ReposListReleasesResponseItemAssetsItemUploader = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ReposListReleasesResponseItemAssetsItem = {
    url: string;
    browser_download_url: string;
    id: number;
    node_id: string;
    name: string;
    label: string;
    state: string;
    content_type: string;
    size: number;
    download_count: number;
    created_at: string;
    updated_at: string;
    uploader: ReposListReleasesResponseItemAssetsItemUploader;
  };
  type ReposListReleasesResponseItemAuthor = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ReposListReleasesResponseItem = {
    url: string;
    html_url: string;
    assets_url: string;
    upload_url: string;
    tarball_url: string;
    zipball_url: string;
    id: number;
    node_id: string;
    tag_name: string;
    target_commitish: string;
    name: string;
    body: string;
    draft: boolean;
    prerelease: boolean;
    created_at: string;
    published_at: string;
    author: ReposListReleasesResponseItemAuthor;
    assets: Array<ReposListReleasesResponseItemAssetsItem>;
  };
  type ReposListPublicResponseItemOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ReposListPublicResponseItem = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: ReposListPublicResponseItemOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
  };
  type ReposListLanguagesResponse = { C: number; Python: number };
  type ReposListInvitationsForAuthenticatedUserResponseItemInviter = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ReposListInvitationsForAuthenticatedUserResponseItemInvitee = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ReposListInvitationsForAuthenticatedUserResponseItemRepositoryOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ReposListInvitationsForAuthenticatedUserResponseItemRepository = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: ReposListInvitationsForAuthenticatedUserResponseItemRepositoryOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
  };
  type ReposListInvitationsForAuthenticatedUserResponseItem = {
    id: number;
    repository: ReposListInvitationsForAuthenticatedUserResponseItemRepository;
    invitee: ReposListInvitationsForAuthenticatedUserResponseItemInvitee;
    inviter: ReposListInvitationsForAuthenticatedUserResponseItemInviter;
    permissions: string;
    created_at: string;
    url: string;
    html_url: string;
  };
  type ReposListInvitationsResponseItemInviter = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ReposListInvitationsResponseItemInvitee = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ReposListInvitationsResponseItemRepositoryOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ReposListInvitationsResponseItemRepository = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: ReposListInvitationsResponseItemRepositoryOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
  };
  type ReposListInvitationsResponseItem = {
    id: number;
    repository: ReposListInvitationsResponseItemRepository;
    invitee: ReposListInvitationsResponseItemInvitee;
    inviter: ReposListInvitationsResponseItemInviter;
    permissions: string;
    created_at: string;
    url: string;
    html_url: string;
  };
  type ReposListHooksResponseItemConfig = { url: string; content_type: string };
  type ReposListHooksResponseItem = {
    id: number;
    url: string;
    test_url: string;
    ping_url: string;
    name: string;
    events: Array<string>;
    active: boolean;
    config: ReposListHooksResponseItemConfig;
    updated_at: string;
    created_at: string;
  };
  type ReposListForksResponseItemLicense = {
    key: string;
    name: string;
    spdx_id: string;
    url: string;
    node_id: string;
  };
  type ReposListForksResponseItemPermissions = {
    admin: boolean;
    push: boolean;
    pull: boolean;
  };
  type ReposListForksResponseItemOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ReposListForksResponseItem = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: ReposListForksResponseItemOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    clone_url: string;
    mirror_url: string;
    hooks_url: string;
    svn_url: string;
    homepage: string;
    language: null;
    forks_count: number;
    stargazers_count: number;
    watchers_count: number;
    size: number;
    default_branch: string;
    open_issues_count: number;
    topics: Array<string>;
    has_issues: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    has_pages: boolean;
    has_downloads: boolean;
    archived: boolean;
    pushed_at: string;
    created_at: string;
    updated_at: string;
    permissions: ReposListForksResponseItemPermissions;
    subscribers_count: number;
    network_count: number;
    license: ReposListForksResponseItemLicense;
  };
  type ReposListForOrgResponseItemLicense = {
    key: string;
    name: string;
    spdx_id: string;
    url: string;
    node_id: string;
  };
  type ReposListForOrgResponseItemPermissions = {
    admin: boolean;
    push: boolean;
    pull: boolean;
  };
  type ReposListForOrgResponseItemOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ReposListForOrgResponseItem = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: ReposListForOrgResponseItemOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    clone_url: string;
    mirror_url: string;
    hooks_url: string;
    svn_url: string;
    homepage: string;
    language: null;
    forks_count: number;
    stargazers_count: number;
    watchers_count: number;
    size: number;
    default_branch: string;
    open_issues_count: number;
    topics: Array<string>;
    has_issues: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    has_pages: boolean;
    has_downloads: boolean;
    archived: boolean;
    pushed_at: string;
    created_at: string;
    updated_at: string;
    permissions: ReposListForOrgResponseItemPermissions;
    subscribers_count: number;
    network_count: number;
    license: ReposListForOrgResponseItemLicense;
  };
  type ReposListDownloadsResponseItem = {
    url: string;
    html_url: string;
    id: number;
    name: string;
    description: string;
    size: number;
    download_count: number;
    content_type: string;
  };
  type ReposListDeploymentsResponseItemCreator = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ReposListDeploymentsResponseItemPayload = { deploy: string };
  type ReposListDeploymentsResponseItem = {
    url: string;
    id: number;
    node_id: string;
    sha: string;
    ref: string;
    task: string;
    payload: ReposListDeploymentsResponseItemPayload;
    original_environment: string;
    environment: string;
    description: string;
    creator: ReposListDeploymentsResponseItemCreator;
    created_at: string;
    updated_at: string;
    statuses_url: string;
    repository_url: string;
    transient_environment: boolean;
    production_environment: boolean;
  };
  type ReposListDeploymentStatusesResponseItemCreator = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ReposListDeploymentStatusesResponseItem = {
    url: string;
    id: number;
    node_id: string;
    state: string;
    creator: ReposListDeploymentStatusesResponseItemCreator;
    description: string;
    environment: string;
    target_url: string;
    created_at: string;
    updated_at: string;
    deployment_url: string;
    repository_url: string;
    environment_url: string;
    log_url: string;
  };
  type ReposListDeployKeysResponseItem = {
    id: number;
    key: string;
    url: string;
    title: string;
    verified: boolean;
    created_at: string;
    read_only: boolean;
  };
  type ReposListCommitsResponseItemParentsItem = { url: string; sha: string };
  type ReposListCommitsResponseItemCommitter = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ReposListCommitsResponseItemAuthor = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ReposListCommitsResponseItemCommitVerification = {
    verified: boolean;
    reason: string;
    signature: null;
    payload: null;
  };
  type ReposListCommitsResponseItemCommitTree = { url: string; sha: string };
  type ReposListCommitsResponseItemCommitCommitter = {
    name: string;
    email: string;
    date: string;
  };
  type ReposListCommitsResponseItemCommitAuthor = {
    name: string;
    email: string;
    date: string;
  };
  type ReposListCommitsResponseItemCommit = {
    url: string;
    author: ReposListCommitsResponseItemCommitAuthor;
    committer: ReposListCommitsResponseItemCommitCommitter;
    message: string;
    tree: ReposListCommitsResponseItemCommitTree;
    comment_count: number;
    verification: ReposListCommitsResponseItemCommitVerification;
  };
  type ReposListCommitsResponseItem = {
    url: string;
    sha: string;
    node_id: string;
    html_url: string;
    comments_url: string;
    commit: ReposListCommitsResponseItemCommit;
    author: ReposListCommitsResponseItemAuthor;
    committer: ReposListCommitsResponseItemCommitter;
    parents: Array<ReposListCommitsResponseItemParentsItem>;
  };
  type ReposListCommitCommentsResponseItemUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ReposListCommitCommentsResponseItem = {
    html_url: string;
    url: string;
    id: number;
    node_id: string;
    body: string;
    path: string;
    position: number;
    line: number;
    commit_id: string;
    user: ReposListCommitCommentsResponseItemUser;
    created_at: string;
    updated_at: string;
  };
  type ReposListCommentsForCommitResponseItemUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ReposListCommentsForCommitResponseItem = {
    html_url: string;
    url: string;
    id: number;
    node_id: string;
    body: string;
    path: string;
    position: number;
    line: number;
    commit_id: string;
    user: ReposListCommentsForCommitResponseItemUser;
    created_at: string;
    updated_at: string;
  };
  type ReposListCollaboratorsResponseItemPermissions = {
    pull: boolean;
    push: boolean;
    admin: boolean;
  };
  type ReposListCollaboratorsResponseItem = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
    permissions: ReposListCollaboratorsResponseItemPermissions;
  };
  type ReposListBranchesResponseItemCommit = { sha: string; url: string };
  type ReposListBranchesResponseItem = {
    name: string;
    commit: ReposListBranchesResponseItemCommit;
    protected: boolean;
    protection_url: string;
  };
  type ReposListAssetsForReleaseResponseItemUploader = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ReposListAssetsForReleaseResponseItem = {
    url: string;
    browser_download_url: string;
    id: number;
    node_id: string;
    name: string;
    label: string;
    state: string;
    content_type: string;
    size: number;
    download_count: number;
    created_at: string;
    updated_at: string;
    uploader: ReposListAssetsForReleaseResponseItemUploader;
  };
  type ReposGetViewsResponseViewsItem = {
    timestamp: string;
    count: number;
    uniques: number;
  };
  type ReposGetViewsResponse = {
    count: number;
    uniques: number;
    views: Array<ReposGetViewsResponseViewsItem>;
  };
  type ReposGetTopReferrersResponseItem = {
    referrer: string;
    count: number;
    uniques: number;
  };
  type ReposGetTopPathsResponseItem = {
    path: string;
    title: string;
    count: number;
    uniques: number;
  };
  type ReposGetReleaseByTagResponseAssetsItemUploader = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ReposGetReleaseByTagResponseAssetsItem = {
    url: string;
    browser_download_url: string;
    id: number;
    node_id: string;
    name: string;
    label: string;
    state: string;
    content_type: string;
    size: number;
    download_count: number;
    created_at: string;
    updated_at: string;
    uploader: ReposGetReleaseByTagResponseAssetsItemUploader;
  };
  type ReposGetReleaseByTagResponseAuthor = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ReposGetReleaseByTagResponse = {
    url: string;
    html_url: string;
    assets_url: string;
    upload_url: string;
    tarball_url: string;
    zipball_url: string;
    id: number;
    node_id: string;
    tag_name: string;
    target_commitish: string;
    name: string;
    body: string;
    draft: boolean;
    prerelease: boolean;
    created_at: string;
    published_at: string;
    author: ReposGetReleaseByTagResponseAuthor;
    assets: Array<ReposGetReleaseByTagResponseAssetsItem>;
  };
  type ReposGetReleaseAssetResponseUploader = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ReposGetReleaseAssetResponse = {
    url: string;
    browser_download_url: string;
    id: number;
    node_id: string;
    name: string;
    label: string;
    state: string;
    content_type: string;
    size: number;
    download_count: number;
    created_at: string;
    updated_at: string;
    uploader: ReposGetReleaseAssetResponseUploader;
  };
  type ReposGetReleaseResponseAssetsItemUploader = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ReposGetReleaseResponseAssetsItem = {
    url: string;
    browser_download_url: string;
    id: number;
    node_id: string;
    name: string;
    label: string;
    state: string;
    content_type: string;
    size: number;
    download_count: number;
    created_at: string;
    updated_at: string;
    uploader: ReposGetReleaseResponseAssetsItemUploader;
  };
  type ReposGetReleaseResponseAuthor = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ReposGetReleaseResponse = {
    url: string;
    html_url: string;
    assets_url: string;
    upload_url: string;
    tarball_url: string;
    zipball_url: string;
    id: number;
    node_id: string;
    tag_name: string;
    target_commitish: string;
    name: string;
    body: string;
    draft: boolean;
    prerelease: boolean;
    created_at: string;
    published_at: string;
    author: ReposGetReleaseResponseAuthor;
    assets: Array<ReposGetReleaseResponseAssetsItem>;
  };
  type ReposGetReadmeResponseLinks = {
    git: string;
    self: string;
    html: string;
  };
  type ReposGetReadmeResponse = {
    type: string;
    encoding: string;
    size: number;
    name: string;
    path: string;
    content: string;
    sha: string;
    url: string;
    git_url: string;
    html_url: string;
    download_url: string;
    _links: ReposGetReadmeResponseLinks;
  };
  type ReposGetProtectedBranchRequiredStatusChecksResponse = {
    url: string;
    strict: boolean;
    contexts: Array<string>;
    contexts_url: string;
  };
  type ReposGetProtectedBranchRequiredSignaturesResponse = {
    url: string;
    enabled: boolean;
  };
  type ReposGetParticipationStatsResponse = {
    all: Array<number>;
    owner: Array<number>;
  };
  type ReposGetPagesResponseSource = { branch: string; directory: string };
  type ReposGetPagesResponse = {
    url: string;
    status: string;
    cname: string;
    custom_404: boolean;
    html_url: string;
    source: ReposGetPagesResponseSource;
  };
  type ReposGetLatestReleaseResponseAssetsItemUploader = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ReposGetLatestReleaseResponseAssetsItem = {
    url: string;
    browser_download_url: string;
    id: number;
    node_id: string;
    name: string;
    label: string;
    state: string;
    content_type: string;
    size: number;
    download_count: number;
    created_at: string;
    updated_at: string;
    uploader: ReposGetLatestReleaseResponseAssetsItemUploader;
  };
  type ReposGetLatestReleaseResponseAuthor = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ReposGetLatestReleaseResponse = {
    url: string;
    html_url: string;
    assets_url: string;
    upload_url: string;
    tarball_url: string;
    zipball_url: string;
    id: number;
    node_id: string;
    tag_name: string;
    target_commitish: string;
    name: string;
    body: string;
    draft: boolean;
    prerelease: boolean;
    created_at: string;
    published_at: string;
    author: ReposGetLatestReleaseResponseAuthor;
    assets: Array<ReposGetLatestReleaseResponseAssetsItem>;
  };
  type ReposGetHookResponseConfig = { url: string; content_type: string };
  type ReposGetHookResponse = {
    id: number;
    url: string;
    test_url: string;
    ping_url: string;
    name: string;
    events: Array<string>;
    active: boolean;
    config: ReposGetHookResponseConfig;
    updated_at: string;
    created_at: string;
  };
  type ReposGetDownloadResponse = {
    url: string;
    html_url: string;
    id: number;
    name: string;
    description: string;
    size: number;
    download_count: number;
    content_type: string;
  };
  type ReposGetDeploymentStatusResponseCreator = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ReposGetDeploymentStatusResponse = {
    url: string;
    id: number;
    node_id: string;
    state: string;
    creator: ReposGetDeploymentStatusResponseCreator;
    description: string;
    environment: string;
    target_url: string;
    created_at: string;
    updated_at: string;
    deployment_url: string;
    repository_url: string;
    environment_url: string;
    log_url: string;
  };
  type ReposGetDeploymentResponseCreator = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ReposGetDeploymentResponsePayload = { deploy: string };
  type ReposGetDeploymentResponse = {
    url: string;
    id: number;
    node_id: string;
    sha: string;
    ref: string;
    task: string;
    payload: ReposGetDeploymentResponsePayload;
    original_environment: string;
    environment: string;
    description: string;
    creator: ReposGetDeploymentResponseCreator;
    created_at: string;
    updated_at: string;
    statuses_url: string;
    repository_url: string;
    transient_environment: boolean;
    production_environment: boolean;
  };
  type ReposGetDeployKeyResponse = {
    id: number;
    key: string;
    url: string;
    title: string;
    verified: boolean;
    created_at: string;
    read_only: boolean;
  };
  type ReposGetContributorsStatsResponseItemWeeksItem = {
    w: string;
    a: number;
    d: number;
    c: number;
  };
  type ReposGetContributorsStatsResponseItemAuthor = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ReposGetContributorsStatsResponseItem = {
    author: ReposGetContributorsStatsResponseItemAuthor;
    total: number;
    weeks: Array<ReposGetContributorsStatsResponseItemWeeksItem>;
  };
  type ReposGetCommitRefShaResponse = {};
  type ReposGetCommitCommentResponseUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ReposGetCommitCommentResponse = {
    html_url: string;
    url: string;
    id: number;
    node_id: string;
    body: string;
    path: string;
    position: number;
    line: number;
    commit_id: string;
    user: ReposGetCommitCommentResponseUser;
    created_at: string;
    updated_at: string;
  };
  type ReposGetCommitActivityStatsResponseItem = {
    days: Array<number>;
    total: number;
    week: number;
  };
  type ReposGetCommitResponseFilesItem = {
    filename: string;
    additions: number;
    deletions: number;
    changes: number;
    status: string;
    raw_url: string;
    blob_url: string;
    patch: string;
  };
  type ReposGetCommitResponseStats = {
    additions: number;
    deletions: number;
    total: number;
  };
  type ReposGetCommitResponseParentsItem = { url: string; sha: string };
  type ReposGetCommitResponseCommitter = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ReposGetCommitResponseAuthor = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ReposGetCommitResponseCommitVerification = {
    verified: boolean;
    reason: string;
    signature: null;
    payload: null;
  };
  type ReposGetCommitResponseCommitTree = { url: string; sha: string };
  type ReposGetCommitResponseCommitCommitter = {
    name: string;
    email: string;
    date: string;
  };
  type ReposGetCommitResponseCommitAuthor = {
    name: string;
    email: string;
    date: string;
  };
  type ReposGetCommitResponseCommit = {
    url: string;
    author: ReposGetCommitResponseCommitAuthor;
    committer: ReposGetCommitResponseCommitCommitter;
    message: string;
    tree: ReposGetCommitResponseCommitTree;
    comment_count: number;
    verification: ReposGetCommitResponseCommitVerification;
  };
  type ReposGetCommitResponse = {
    url: string;
    sha: string;
    node_id: string;
    html_url: string;
    comments_url: string;
    commit: ReposGetCommitResponseCommit;
    author: ReposGetCommitResponseAuthor;
    committer: ReposGetCommitResponseCommitter;
    parents: Array<ReposGetCommitResponseParentsItem>;
    stats: ReposGetCommitResponseStats;
    files: Array<ReposGetCommitResponseFilesItem>;
  };
  type ReposGetCombinedStatusForRefResponseRepositoryOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ReposGetCombinedStatusForRefResponseRepository = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: ReposGetCombinedStatusForRefResponseRepositoryOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
  };
  type ReposGetCombinedStatusForRefResponseStatusesItem = {
    url: string;
    avatar_url: string;
    id: number;
    node_id: string;
    state: string;
    description: string;
    target_url: string;
    context: string;
    created_at: string;
    updated_at: string;
  };
  type ReposGetCombinedStatusForRefResponse = {
    state: string;
    statuses: Array<ReposGetCombinedStatusForRefResponseStatusesItem>;
    sha: string;
    total_count: number;
    repository: ReposGetCombinedStatusForRefResponseRepository;
    commit_url: string;
    url: string;
  };
  type ReposGetClonesResponseClonesItem = {
    timestamp: string;
    count: number;
    uniques: number;
  };
  type ReposGetClonesResponse = {
    count: number;
    uniques: number;
    clones: Array<ReposGetClonesResponseClonesItem>;
  };
  type ReposGetBranchProtectionResponseRestrictionsTeamsItem = {
    id: number;
    node_id: string;
    url: string;
    name: string;
    slug: string;
    description: string;
    privacy: string;
    permission: string;
    members_url: string;
    repositories_url: string;
    parent: null;
  };
  type ReposGetBranchProtectionResponseRestrictionsUsersItem = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ReposGetBranchProtectionResponseRestrictions = {
    url: string;
    users_url: string;
    teams_url: string;
    users: Array<ReposGetBranchProtectionResponseRestrictionsUsersItem>;
    teams: Array<ReposGetBranchProtectionResponseRestrictionsTeamsItem>;
  };
  type ReposGetBranchProtectionResponseRequiredPullRequestReviewsDismissalRestrictionsTeamsItem = {
    id: number;
    node_id: string;
    url: string;
    name: string;
    slug: string;
    description: string;
    privacy: string;
    permission: string;
    members_url: string;
    repositories_url: string;
    parent: null;
  };
  type ReposGetBranchProtectionResponseRequiredPullRequestReviewsDismissalRestrictionsUsersItem = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ReposGetBranchProtectionResponseRequiredPullRequestReviewsDismissalRestrictions = {
    url: string;
    users_url: string;
    teams_url: string;
    users: Array<
      ReposGetBranchProtectionResponseRequiredPullRequestReviewsDismissalRestrictionsUsersItem
    >;
    teams: Array<
      ReposGetBranchProtectionResponseRequiredPullRequestReviewsDismissalRestrictionsTeamsItem
    >;
  };
  type ReposGetBranchProtectionResponseRequiredPullRequestReviews = {
    url: string;
    dismissal_restrictions: ReposGetBranchProtectionResponseRequiredPullRequestReviewsDismissalRestrictions;
    dismiss_stale_reviews: boolean;
    require_code_owner_reviews: boolean;
    required_approving_review_count: number;
  };
  type ReposGetBranchProtectionResponseEnforceAdmins = {
    url: string;
    enabled: boolean;
  };
  type ReposGetBranchProtectionResponseRequiredStatusChecks = {
    url: string;
    strict: boolean;
    contexts: Array<string>;
    contexts_url: string;
  };
  type ReposGetBranchProtectionResponse = {
    url: string;
    required_status_checks: ReposGetBranchProtectionResponseRequiredStatusChecks;
    enforce_admins: ReposGetBranchProtectionResponseEnforceAdmins;
    required_pull_request_reviews: ReposGetBranchProtectionResponseRequiredPullRequestReviews;
    restrictions: ReposGetBranchProtectionResponseRestrictions;
  };
  type ReposGetBranchResponseLinks = { html: string; self: string };
  type ReposGetBranchResponseCommitCommitter = {
    gravatar_id: string;
    avatar_url: string;
    url: string;
    id: number;
    login: string;
  };
  type ReposGetBranchResponseCommitParentsItem = { sha: string; url: string };
  type ReposGetBranchResponseCommitAuthor = {
    gravatar_id: string;
    avatar_url: string;
    url: string;
    id: number;
    login: string;
  };
  type ReposGetBranchResponseCommitCommitVerification = {
    verified: boolean;
    reason: string;
    signature: null;
    payload: null;
  };
  type ReposGetBranchResponseCommitCommitCommitter = {
    name: string;
    date: string;
    email: string;
  };
  type ReposGetBranchResponseCommitCommitTree = { sha: string; url: string };
  type ReposGetBranchResponseCommitCommitAuthor = {
    name: string;
    date: string;
    email: string;
  };
  type ReposGetBranchResponseCommitCommit = {
    author: ReposGetBranchResponseCommitCommitAuthor;
    url: string;
    message: string;
    tree: ReposGetBranchResponseCommitCommitTree;
    committer: ReposGetBranchResponseCommitCommitCommitter;
    verification: ReposGetBranchResponseCommitCommitVerification;
  };
  type ReposGetBranchResponseCommit = {
    sha: string;
    node_id: string;
    commit: ReposGetBranchResponseCommitCommit;
    author: ReposGetBranchResponseCommitAuthor;
    parents: Array<ReposGetBranchResponseCommitParentsItem>;
    url: string;
    committer: ReposGetBranchResponseCommitCommitter;
  };
  type ReposGetBranchResponse = {
    name: string;
    commit: ReposGetBranchResponseCommit;
    _links: ReposGetBranchResponseLinks;
    protected: boolean;
    protection_url: string;
  };
  type ReposGetArchiveLinkResponse = {};
  type ReposGetResponseSourcePermissions = {
    admin: boolean;
    push: boolean;
    pull: boolean;
  };
  type ReposGetResponseSourceOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ReposGetResponseSource = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: ReposGetResponseSourceOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    clone_url: string;
    mirror_url: string;
    hooks_url: string;
    svn_url: string;
    homepage: string;
    language: null;
    forks_count: number;
    stargazers_count: number;
    watchers_count: number;
    size: number;
    default_branch: string;
    open_issues_count: number;
    topics: Array<string>;
    has_issues: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    has_pages: boolean;
    has_downloads: boolean;
    archived: boolean;
    pushed_at: string;
    created_at: string;
    updated_at: string;
    permissions: ReposGetResponseSourcePermissions;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    allow_merge_commit: boolean;
    subscribers_count: number;
    network_count: number;
  };
  type ReposGetResponseParentPermissions = {
    admin: boolean;
    push: boolean;
    pull: boolean;
  };
  type ReposGetResponseParentOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ReposGetResponseParent = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: ReposGetResponseParentOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    clone_url: string;
    mirror_url: string;
    hooks_url: string;
    svn_url: string;
    homepage: string;
    language: null;
    forks_count: number;
    stargazers_count: number;
    watchers_count: number;
    size: number;
    default_branch: string;
    open_issues_count: number;
    topics: Array<string>;
    has_issues: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    has_pages: boolean;
    has_downloads: boolean;
    archived: boolean;
    pushed_at: string;
    created_at: string;
    updated_at: string;
    permissions: ReposGetResponseParentPermissions;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    allow_merge_commit: boolean;
    subscribers_count: number;
    network_count: number;
  };
  type ReposGetResponseOrganization = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ReposGetResponseLicense = {
    key: string;
    name: string;
    spdx_id: string;
    url: string;
    node_id: string;
  };
  type ReposGetResponsePermissions = {
    admin: boolean;
    push: boolean;
    pull: boolean;
  };
  type ReposGetResponseOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ReposGetResponse = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: ReposGetResponseOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    clone_url: string;
    mirror_url: string;
    hooks_url: string;
    svn_url: string;
    homepage: string;
    language: null;
    forks_count: number;
    stargazers_count: number;
    watchers_count: number;
    size: number;
    default_branch: string;
    open_issues_count: number;
    topics: Array<string>;
    has_issues: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    has_pages: boolean;
    has_downloads: boolean;
    archived: boolean;
    pushed_at: string;
    created_at: string;
    updated_at: string;
    permissions: ReposGetResponsePermissions;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    allow_merge_commit: boolean;
    subscribers_count: number;
    network_count: number;
    license: ReposGetResponseLicense;
    organization: ReposGetResponseOrganization;
    parent: ReposGetResponseParent;
    source: ReposGetResponseSource;
  };
  type ReposDeleteReleaseAssetResponse = {};
  type ReposDeleteReleaseResponse = {};
  type ReposDeleteInvitationResponse = {};
  type ReposDeleteHookResponse = {};
  type ReposDeleteFileResponseCommitVerification = {
    verified: boolean;
    reason: string;
    signature: null;
    payload: null;
  };
  type ReposDeleteFileResponseCommitParentsItem = {
    url: string;
    html_url: string;
    sha: string;
  };
  type ReposDeleteFileResponseCommitTree = { url: string; sha: string };
  type ReposDeleteFileResponseCommitCommitter = {
    date: string;
    name: string;
    email: string;
  };
  type ReposDeleteFileResponseCommitAuthor = {
    date: string;
    name: string;
    email: string;
  };
  type ReposDeleteFileResponseCommit = {
    sha: string;
    node_id: string;
    url: string;
    html_url: string;
    author: ReposDeleteFileResponseCommitAuthor;
    committer: ReposDeleteFileResponseCommitCommitter;
    message: string;
    tree: ReposDeleteFileResponseCommitTree;
    parents: Array<ReposDeleteFileResponseCommitParentsItem>;
    verification: ReposDeleteFileResponseCommitVerification;
  };
  type ReposDeleteFileResponse = {
    content: null;
    commit: ReposDeleteFileResponseCommit;
  };
  type ReposDeleteDownloadResponse = {};
  type ReposDeleteCommitCommentResponse = {};
  type ReposDeleteResponse = { message?: string; documentation_url?: string };
  type ReposDeclineInvitationResponse = {};
  type ReposCreateStatusResponseCreator = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ReposCreateStatusResponse = {
    url: string;
    avatar_url: string;
    id: number;
    node_id: string;
    state: string;
    description: string;
    target_url: string;
    context: string;
    created_at: string;
    updated_at: string;
    creator: ReposCreateStatusResponseCreator;
  };
  type ReposCreateReleaseResponseAuthor = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ReposCreateReleaseResponse = {
    url: string;
    html_url: string;
    assets_url: string;
    upload_url: string;
    tarball_url: string;
    zipball_url: string;
    id: number;
    node_id: string;
    tag_name: string;
    target_commitish: string;
    name: string;
    body: string;
    draft: boolean;
    prerelease: boolean;
    created_at: string;
    published_at: string;
    author: ReposCreateReleaseResponseAuthor;
    assets: Array<any>;
  };
  type ReposCreateInOrgResponsePermissions = {
    admin: boolean;
    push: boolean;
    pull: boolean;
  };
  type ReposCreateInOrgResponseOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ReposCreateInOrgResponse = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: ReposCreateInOrgResponseOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    clone_url: string;
    mirror_url: string;
    hooks_url: string;
    svn_url: string;
    homepage: string;
    language: null;
    forks_count: number;
    stargazers_count: number;
    watchers_count: number;
    size: number;
    default_branch: string;
    open_issues_count: number;
    topics: Array<string>;
    has_issues: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    has_pages: boolean;
    has_downloads: boolean;
    archived: boolean;
    pushed_at: string;
    created_at: string;
    updated_at: string;
    permissions: ReposCreateInOrgResponsePermissions;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    allow_merge_commit: boolean;
    subscribers_count: number;
    network_count: number;
  };
  type ReposCreateHookResponseConfig = { url: string; content_type: string };
  type ReposCreateHookResponse = {
    id: number;
    url: string;
    test_url: string;
    ping_url: string;
    name: string;
    events: Array<string>;
    active: boolean;
    config: ReposCreateHookResponseConfig;
    updated_at: string;
    created_at: string;
  };
  type ReposCreateForkResponsePermissions = {
    admin: boolean;
    push: boolean;
    pull: boolean;
  };
  type ReposCreateForkResponseOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ReposCreateForkResponse = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: ReposCreateForkResponseOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    clone_url: string;
    mirror_url: string;
    hooks_url: string;
    svn_url: string;
    homepage: string;
    language: null;
    forks_count: number;
    stargazers_count: number;
    watchers_count: number;
    size: number;
    default_branch: string;
    open_issues_count: number;
    topics: Array<string>;
    has_issues: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    has_pages: boolean;
    has_downloads: boolean;
    archived: boolean;
    pushed_at: string;
    created_at: string;
    updated_at: string;
    permissions: ReposCreateForkResponsePermissions;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    allow_merge_commit: boolean;
    subscribers_count: number;
    network_count: number;
  };
  type ReposCreateForAuthenticatedUserResponsePermissions = {
    admin: boolean;
    push: boolean;
    pull: boolean;
  };
  type ReposCreateForAuthenticatedUserResponseOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ReposCreateForAuthenticatedUserResponse = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: ReposCreateForAuthenticatedUserResponseOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    clone_url: string;
    mirror_url: string;
    hooks_url: string;
    svn_url: string;
    homepage: string;
    language: null;
    forks_count: number;
    stargazers_count: number;
    watchers_count: number;
    size: number;
    default_branch: string;
    open_issues_count: number;
    topics: Array<string>;
    has_issues: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    has_pages: boolean;
    has_downloads: boolean;
    archived: boolean;
    pushed_at: string;
    created_at: string;
    updated_at: string;
    permissions: ReposCreateForAuthenticatedUserResponsePermissions;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    allow_merge_commit: boolean;
    subscribers_count: number;
    network_count: number;
  };
  type ReposCreateFileResponseCommitVerification = {
    verified: boolean;
    reason: string;
    signature: null;
    payload: null;
  };
  type ReposCreateFileResponseCommitParentsItem = {
    url: string;
    html_url: string;
    sha: string;
  };
  type ReposCreateFileResponseCommitTree = { url: string; sha: string };
  type ReposCreateFileResponseCommitCommitter = {
    date: string;
    name: string;
    email: string;
  };
  type ReposCreateFileResponseCommitAuthor = {
    date: string;
    name: string;
    email: string;
  };
  type ReposCreateFileResponseCommit = {
    sha: string;
    node_id: string;
    url: string;
    html_url: string;
    author: ReposCreateFileResponseCommitAuthor;
    committer: ReposCreateFileResponseCommitCommitter;
    message: string;
    tree: ReposCreateFileResponseCommitTree;
    parents: Array<ReposCreateFileResponseCommitParentsItem>;
    verification: ReposCreateFileResponseCommitVerification;
  };
  type ReposCreateFileResponseContentLinks = {
    self: string;
    git: string;
    html: string;
  };
  type ReposCreateFileResponseContent = {
    name: string;
    path: string;
    sha: string;
    size: number;
    url: string;
    html_url: string;
    git_url: string;
    download_url: string;
    type: string;
    _links: ReposCreateFileResponseContentLinks;
  };
  type ReposCreateFileResponse = {
    content: ReposCreateFileResponseContent;
    commit: ReposCreateFileResponseCommit;
  };
  type ReposCreateDeploymentStatusResponseCreator = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ReposCreateDeploymentStatusResponse = {
    url: string;
    id: number;
    node_id: string;
    state: string;
    creator: ReposCreateDeploymentStatusResponseCreator;
    description: string;
    environment: string;
    target_url: string;
    created_at: string;
    updated_at: string;
    deployment_url: string;
    repository_url: string;
    environment_url: string;
    log_url: string;
  };
  type ReposCreateCommitCommentResponseUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ReposCreateCommitCommentResponse = {
    html_url: string;
    url: string;
    id: number;
    node_id: string;
    body: string;
    path: string;
    position: number;
    line: number;
    commit_id: string;
    user: ReposCreateCommitCommentResponseUser;
    created_at: string;
    updated_at: string;
  };
  type ReposAddProtectedBranchUserRestrictionsResponseItem = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ReposAddProtectedBranchTeamRestrictionsResponseItem = {
    id: number;
    node_id: string;
    url: string;
    name: string;
    slug: string;
    description: string;
    privacy: string;
    permission: string;
    members_url: string;
    repositories_url: string;
    parent: null;
  };
  type ReposAddProtectedBranchRequiredSignaturesResponse = {
    url: string;
    enabled: boolean;
  };
  type ReposAddProtectedBranchAdminEnforcementResponse = {
    url: string;
    enabled: boolean;
  };
  type ReposAddDeployKeyResponse = {
    id: number;
    key: string;
    url: string;
    title: string;
    verified: boolean;
    created_at: string;
    read_only: boolean;
  };
  type ReposAcceptInvitationResponse = {};
  type ReactionsListForTeamDiscussionCommentResponseItemUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ReactionsListForTeamDiscussionCommentResponseItem = {
    id: number;
    node_id: string;
    user: ReactionsListForTeamDiscussionCommentResponseItemUser;
    content: string;
    created_at: string;
  };
  type ReactionsListForTeamDiscussionResponseItemUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ReactionsListForTeamDiscussionResponseItem = {
    id: number;
    node_id: string;
    user: ReactionsListForTeamDiscussionResponseItemUser;
    content: string;
    created_at: string;
  };
  type ReactionsListForPullRequestReviewCommentResponseItemUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ReactionsListForPullRequestReviewCommentResponseItem = {
    id: number;
    node_id: string;
    user: ReactionsListForPullRequestReviewCommentResponseItemUser;
    content: string;
    created_at: string;
  };
  type ReactionsListForIssueCommentResponseItemUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ReactionsListForIssueCommentResponseItem = {
    id: number;
    node_id: string;
    user: ReactionsListForIssueCommentResponseItemUser;
    content: string;
    created_at: string;
  };
  type ReactionsListForIssueResponseItemUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ReactionsListForIssueResponseItem = {
    id: number;
    node_id: string;
    user: ReactionsListForIssueResponseItemUser;
    content: string;
    created_at: string;
  };
  type ReactionsListForCommitCommentResponseItemUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ReactionsListForCommitCommentResponseItem = {
    id: number;
    node_id: string;
    user: ReactionsListForCommitCommentResponseItemUser;
    content: string;
    created_at: string;
  };
  type ReactionsDeleteResponse = {};
  type ReactionsCreateForTeamDiscussionCommentResponseUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ReactionsCreateForTeamDiscussionCommentResponse = {
    id: number;
    node_id: string;
    user: ReactionsCreateForTeamDiscussionCommentResponseUser;
    content: string;
    created_at: string;
  };
  type ReactionsCreateForTeamDiscussionResponseUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ReactionsCreateForTeamDiscussionResponse = {
    id: number;
    node_id: string;
    user: ReactionsCreateForTeamDiscussionResponseUser;
    content: string;
    created_at: string;
  };
  type ReactionsCreateForPullRequestReviewCommentResponseUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ReactionsCreateForPullRequestReviewCommentResponse = {
    id: number;
    node_id: string;
    user: ReactionsCreateForPullRequestReviewCommentResponseUser;
    content: string;
    created_at: string;
  };
  type ReactionsCreateForIssueCommentResponseUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ReactionsCreateForIssueCommentResponse = {
    id: number;
    node_id: string;
    user: ReactionsCreateForIssueCommentResponseUser;
    content: string;
    created_at: string;
  };
  type ReactionsCreateForIssueResponseUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ReactionsCreateForIssueResponse = {
    id: number;
    node_id: string;
    user: ReactionsCreateForIssueResponseUser;
    content: string;
    created_at: string;
  };
  type ReactionsCreateForCommitCommentResponseUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ReactionsCreateForCommitCommentResponse = {
    id: number;
    node_id: string;
    user: ReactionsCreateForCommitCommentResponseUser;
    content: string;
    created_at: string;
  };
  type RateLimitGetResponseRate = {
    limit: number;
    remaining: number;
    reset: number;
  };
  type RateLimitGetResponseResourcesGraphql = {
    limit: number;
    remaining: number;
    reset: number;
  };
  type RateLimitGetResponseResourcesSearch = {
    limit: number;
    remaining: number;
    reset: number;
  };
  type RateLimitGetResponseResourcesCore = {
    limit: number;
    remaining: number;
    reset: number;
  };
  type RateLimitGetResponseResources = {
    core: RateLimitGetResponseResourcesCore;
    search: RateLimitGetResponseResourcesSearch;
    graphql: RateLimitGetResponseResourcesGraphql;
  };
  type RateLimitGetResponse = {
    resources: RateLimitGetResponseResources;
    rate: RateLimitGetResponseRate;
  };
  type PullRequestsUpdateCommentResponseLinksPullRequest = { href: string };
  type PullRequestsUpdateCommentResponseLinksHtml = { href: string };
  type PullRequestsUpdateCommentResponseLinksSelf = { href: string };
  type PullRequestsUpdateCommentResponseLinks = {
    self: PullRequestsUpdateCommentResponseLinksSelf;
    html: PullRequestsUpdateCommentResponseLinksHtml;
    pull_request: PullRequestsUpdateCommentResponseLinksPullRequest;
  };
  type PullRequestsUpdateCommentResponseUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type PullRequestsUpdateCommentResponse = {
    url: string;
    id: number;
    node_id: string;
    pull_request_review_id: number;
    diff_hunk: string;
    path: string;
    position: number;
    original_position: number;
    commit_id: string;
    original_commit_id: string;
    in_reply_to_id: number;
    user: PullRequestsUpdateCommentResponseUser;
    body: string;
    created_at: string;
    updated_at: string;
    html_url: string;
    pull_request_url: string;
    _links: PullRequestsUpdateCommentResponseLinks;
  };
  type PullRequestsUpdateResponseUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type PullRequestsUpdateResponseLinksStatuses = { href: string };
  type PullRequestsUpdateResponseLinksCommits = { href: string };
  type PullRequestsUpdateResponseLinksReviewComment = { href: string };
  type PullRequestsUpdateResponseLinksReviewComments = { href: string };
  type PullRequestsUpdateResponseLinksComments = { href: string };
  type PullRequestsUpdateResponseLinksIssue = { href: string };
  type PullRequestsUpdateResponseLinksHtml = { href: string };
  type PullRequestsUpdateResponseLinksSelf = { href: string };
  type PullRequestsUpdateResponseLinks = {
    self: PullRequestsUpdateResponseLinksSelf;
    html: PullRequestsUpdateResponseLinksHtml;
    issue: PullRequestsUpdateResponseLinksIssue;
    comments: PullRequestsUpdateResponseLinksComments;
    review_comments: PullRequestsUpdateResponseLinksReviewComments;
    review_comment: PullRequestsUpdateResponseLinksReviewComment;
    commits: PullRequestsUpdateResponseLinksCommits;
    statuses: PullRequestsUpdateResponseLinksStatuses;
  };
  type PullRequestsUpdateResponseBaseRepoPermissions = {
    admin: boolean;
    push: boolean;
    pull: boolean;
  };
  type PullRequestsUpdateResponseBaseRepoOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type PullRequestsUpdateResponseBaseRepo = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: PullRequestsUpdateResponseBaseRepoOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    clone_url: string;
    mirror_url: string;
    hooks_url: string;
    svn_url: string;
    homepage: string;
    language: null;
    forks_count: number;
    stargazers_count: number;
    watchers_count: number;
    size: number;
    default_branch: string;
    open_issues_count: number;
    topics: Array<string>;
    has_issues: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    has_pages: boolean;
    has_downloads: boolean;
    archived: boolean;
    pushed_at: string;
    created_at: string;
    updated_at: string;
    permissions: PullRequestsUpdateResponseBaseRepoPermissions;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    allow_merge_commit: boolean;
    subscribers_count: number;
    network_count: number;
  };
  type PullRequestsUpdateResponseBaseUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type PullRequestsUpdateResponseBase = {
    label: string;
    ref: string;
    sha: string;
    user: PullRequestsUpdateResponseBaseUser;
    repo: PullRequestsUpdateResponseBaseRepo;
  };
  type PullRequestsUpdateResponseHeadRepoPermissions = {
    admin: boolean;
    push: boolean;
    pull: boolean;
  };
  type PullRequestsUpdateResponseHeadRepoOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type PullRequestsUpdateResponseHeadRepo = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: PullRequestsUpdateResponseHeadRepoOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    clone_url: string;
    mirror_url: string;
    hooks_url: string;
    svn_url: string;
    homepage: string;
    language: null;
    forks_count: number;
    stargazers_count: number;
    watchers_count: number;
    size: number;
    default_branch: string;
    open_issues_count: number;
    topics: Array<string>;
    has_issues: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    has_pages: boolean;
    has_downloads: boolean;
    archived: boolean;
    pushed_at: string;
    created_at: string;
    updated_at: string;
    permissions: PullRequestsUpdateResponseHeadRepoPermissions;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    allow_merge_commit: boolean;
    subscribers_count: number;
    network_count: number;
  };
  type PullRequestsUpdateResponseHeadUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type PullRequestsUpdateResponseHead = {
    label: string;
    ref: string;
    sha: string;
    user: PullRequestsUpdateResponseHeadUser;
    repo: PullRequestsUpdateResponseHeadRepo;
  };
  type PullRequestsUpdateResponseMilestoneCreator = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type PullRequestsUpdateResponseMilestone = {
    url: string;
    html_url: string;
    labels_url: string;
    id: number;
    node_id: string;
    number: number;
    state: string;
    title: string;
    description: string;
    creator: PullRequestsUpdateResponseMilestoneCreator;
    open_issues: number;
    closed_issues: number;
    created_at: string;
    updated_at: string;
    closed_at: string;
    due_on: string;
  };
  type PullRequestsUpdateResponseLabelsItem = {
    id: number;
    node_id: string;
    url: string;
    name: string;
    description: string;
    color: string;
    default: boolean;
  };
  type PullRequestsUpdateResponseAssignee = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type PullRequestsUpdateResponse = {
    id: number;
    node_id: string;
    url: string;
    html_url: string;
    diff_url: string;
    patch_url: string;
    issue_url: string;
    commits_url: string;
    review_comments_url: string;
    review_comment_url: string;
    comments_url: string;
    statuses_url: string;
    number: number;
    state: string;
    title: string;
    body: string;
    assignee: PullRequestsUpdateResponseAssignee;
    labels: Array<PullRequestsUpdateResponseLabelsItem>;
    milestone: PullRequestsUpdateResponseMilestone;
    locked: boolean;
    active_lock_reason: string;
    created_at: string;
    updated_at: string;
    closed_at: string;
    merged_at: string;
    head: PullRequestsUpdateResponseHead;
    base: PullRequestsUpdateResponseBase;
    _links: PullRequestsUpdateResponseLinks;
    user: PullRequestsUpdateResponseUser;
  };
  type PullRequestsSubmitReviewResponseLinksPullRequest = { href: string };
  type PullRequestsSubmitReviewResponseLinksHtml = { href: string };
  type PullRequestsSubmitReviewResponseLinks = {
    html: PullRequestsSubmitReviewResponseLinksHtml;
    pull_request: PullRequestsSubmitReviewResponseLinksPullRequest;
  };
  type PullRequestsSubmitReviewResponseUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type PullRequestsSubmitReviewResponse = {
    id: number;
    node_id: string;
    user: PullRequestsSubmitReviewResponseUser;
    body: string;
    commit_id: string;
    state: string;
    html_url: string;
    pull_request_url: string;
    _links: PullRequestsSubmitReviewResponseLinks;
  };
  type PullRequestsListReviewsResponseItemLinksPullRequest = { href: string };
  type PullRequestsListReviewsResponseItemLinksHtml = { href: string };
  type PullRequestsListReviewsResponseItemLinks = {
    html: PullRequestsListReviewsResponseItemLinksHtml;
    pull_request: PullRequestsListReviewsResponseItemLinksPullRequest;
  };
  type PullRequestsListReviewsResponseItemUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type PullRequestsListReviewsResponseItem = {
    id: number;
    node_id: string;
    user: PullRequestsListReviewsResponseItemUser;
    body: string;
    commit_id: string;
    state: string;
    html_url: string;
    pull_request_url: string;
    _links: PullRequestsListReviewsResponseItemLinks;
  };
  type PullRequestsListReviewRequestsResponseTeamsItem = {
    id: number;
    node_id: string;
    url: string;
    name: string;
    slug: string;
    description: string;
    privacy: string;
    permission: string;
    members_url: string;
    repositories_url: string;
    parent: null;
  };
  type PullRequestsListReviewRequestsResponseUsersItem = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type PullRequestsListReviewRequestsResponse = {
    users: Array<PullRequestsListReviewRequestsResponseUsersItem>;
    teams: Array<PullRequestsListReviewRequestsResponseTeamsItem>;
  };
  type PullRequestsListFilesResponseItem = {
    sha: string;
    filename: string;
    status: string;
    additions: number;
    deletions: number;
    changes: number;
    blob_url: string;
    raw_url: string;
    contents_url: string;
    patch: string;
  };
  type PullRequestsListCommitsResponseItemParentsItem = {
    url: string;
    sha: string;
  };
  type PullRequestsListCommitsResponseItemCommitter = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type PullRequestsListCommitsResponseItemAuthor = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type PullRequestsListCommitsResponseItemCommitVerification = {
    verified: boolean;
    reason: string;
    signature: null;
    payload: null;
  };
  type PullRequestsListCommitsResponseItemCommitTree = {
    url: string;
    sha: string;
  };
  type PullRequestsListCommitsResponseItemCommitCommitter = {
    name: string;
    email: string;
    date: string;
  };
  type PullRequestsListCommitsResponseItemCommitAuthor = {
    name: string;
    email: string;
    date: string;
  };
  type PullRequestsListCommitsResponseItemCommit = {
    url: string;
    author: PullRequestsListCommitsResponseItemCommitAuthor;
    committer: PullRequestsListCommitsResponseItemCommitCommitter;
    message: string;
    tree: PullRequestsListCommitsResponseItemCommitTree;
    comment_count: number;
    verification: PullRequestsListCommitsResponseItemCommitVerification;
  };
  type PullRequestsListCommitsResponseItem = {
    url: string;
    sha: string;
    node_id: string;
    html_url: string;
    comments_url: string;
    commit: PullRequestsListCommitsResponseItemCommit;
    author: PullRequestsListCommitsResponseItemAuthor;
    committer: PullRequestsListCommitsResponseItemCommitter;
    parents: Array<PullRequestsListCommitsResponseItemParentsItem>;
  };
  type PullRequestsListCommentsForRepoResponseItemLinksPullRequest = {
    href: string;
  };
  type PullRequestsListCommentsForRepoResponseItemLinksHtml = { href: string };
  type PullRequestsListCommentsForRepoResponseItemLinksSelf = { href: string };
  type PullRequestsListCommentsForRepoResponseItemLinks = {
    self: PullRequestsListCommentsForRepoResponseItemLinksSelf;
    html: PullRequestsListCommentsForRepoResponseItemLinksHtml;
    pull_request: PullRequestsListCommentsForRepoResponseItemLinksPullRequest;
  };
  type PullRequestsListCommentsForRepoResponseItemUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type PullRequestsListCommentsForRepoResponseItem = {
    url: string;
    id: number;
    node_id: string;
    pull_request_review_id: number;
    diff_hunk: string;
    path: string;
    position: number;
    original_position: number;
    commit_id: string;
    original_commit_id: string;
    in_reply_to_id: number;
    user: PullRequestsListCommentsForRepoResponseItemUser;
    body: string;
    created_at: string;
    updated_at: string;
    html_url: string;
    pull_request_url: string;
    _links: PullRequestsListCommentsForRepoResponseItemLinks;
  };
  type PullRequestsListCommentsResponseItemLinksPullRequest = { href: string };
  type PullRequestsListCommentsResponseItemLinksHtml = { href: string };
  type PullRequestsListCommentsResponseItemLinksSelf = { href: string };
  type PullRequestsListCommentsResponseItemLinks = {
    self: PullRequestsListCommentsResponseItemLinksSelf;
    html: PullRequestsListCommentsResponseItemLinksHtml;
    pull_request: PullRequestsListCommentsResponseItemLinksPullRequest;
  };
  type PullRequestsListCommentsResponseItemUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type PullRequestsListCommentsResponseItem = {
    url: string;
    id: number;
    node_id: string;
    pull_request_review_id: number;
    diff_hunk: string;
    path: string;
    position: number;
    original_position: number;
    commit_id: string;
    original_commit_id: string;
    in_reply_to_id: number;
    user: PullRequestsListCommentsResponseItemUser;
    body: string;
    created_at: string;
    updated_at: string;
    html_url: string;
    pull_request_url: string;
    _links: PullRequestsListCommentsResponseItemLinks;
  };
  type PullRequestsListResponseItemUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type PullRequestsListResponseItemLinksStatuses = { href: string };
  type PullRequestsListResponseItemLinksCommits = { href: string };
  type PullRequestsListResponseItemLinksReviewComment = { href: string };
  type PullRequestsListResponseItemLinksReviewComments = { href: string };
  type PullRequestsListResponseItemLinksComments = { href: string };
  type PullRequestsListResponseItemLinksIssue = { href: string };
  type PullRequestsListResponseItemLinksHtml = { href: string };
  type PullRequestsListResponseItemLinksSelf = { href: string };
  type PullRequestsListResponseItemLinks = {
    self: PullRequestsListResponseItemLinksSelf;
    html: PullRequestsListResponseItemLinksHtml;
    issue: PullRequestsListResponseItemLinksIssue;
    comments: PullRequestsListResponseItemLinksComments;
    review_comments: PullRequestsListResponseItemLinksReviewComments;
    review_comment: PullRequestsListResponseItemLinksReviewComment;
    commits: PullRequestsListResponseItemLinksCommits;
    statuses: PullRequestsListResponseItemLinksStatuses;
  };
  type PullRequestsListResponseItemBaseRepoPermissions = {
    admin: boolean;
    push: boolean;
    pull: boolean;
  };
  type PullRequestsListResponseItemBaseRepoOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type PullRequestsListResponseItemBaseRepo = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: PullRequestsListResponseItemBaseRepoOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    clone_url: string;
    mirror_url: string;
    hooks_url: string;
    svn_url: string;
    homepage: string;
    language: null;
    forks_count: number;
    stargazers_count: number;
    watchers_count: number;
    size: number;
    default_branch: string;
    open_issues_count: number;
    topics: Array<string>;
    has_issues: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    has_pages: boolean;
    has_downloads: boolean;
    archived: boolean;
    pushed_at: string;
    created_at: string;
    updated_at: string;
    permissions: PullRequestsListResponseItemBaseRepoPermissions;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    allow_merge_commit: boolean;
    subscribers_count: number;
    network_count: number;
  };
  type PullRequestsListResponseItemBaseUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type PullRequestsListResponseItemBase = {
    label: string;
    ref: string;
    sha: string;
    user: PullRequestsListResponseItemBaseUser;
    repo: PullRequestsListResponseItemBaseRepo;
  };
  type PullRequestsListResponseItemHeadRepoPermissions = {
    admin: boolean;
    push: boolean;
    pull: boolean;
  };
  type PullRequestsListResponseItemHeadRepoOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type PullRequestsListResponseItemHeadRepo = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: PullRequestsListResponseItemHeadRepoOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    clone_url: string;
    mirror_url: string;
    hooks_url: string;
    svn_url: string;
    homepage: string;
    language: null;
    forks_count: number;
    stargazers_count: number;
    watchers_count: number;
    size: number;
    default_branch: string;
    open_issues_count: number;
    topics: Array<string>;
    has_issues: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    has_pages: boolean;
    has_downloads: boolean;
    archived: boolean;
    pushed_at: string;
    created_at: string;
    updated_at: string;
    permissions: PullRequestsListResponseItemHeadRepoPermissions;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    allow_merge_commit: boolean;
    subscribers_count: number;
    network_count: number;
  };
  type PullRequestsListResponseItemHeadUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type PullRequestsListResponseItemHead = {
    label: string;
    ref: string;
    sha: string;
    user: PullRequestsListResponseItemHeadUser;
    repo: PullRequestsListResponseItemHeadRepo;
  };
  type PullRequestsListResponseItemMilestoneCreator = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type PullRequestsListResponseItemMilestone = {
    url: string;
    html_url: string;
    labels_url: string;
    id: number;
    node_id: string;
    number: number;
    state: string;
    title: string;
    description: string;
    creator: PullRequestsListResponseItemMilestoneCreator;
    open_issues: number;
    closed_issues: number;
    created_at: string;
    updated_at: string;
    closed_at: string;
    due_on: string;
  };
  type PullRequestsListResponseItemLabelsItem = {
    id: number;
    node_id: string;
    url: string;
    name: string;
    description: string;
    color: string;
    default: boolean;
  };
  type PullRequestsListResponseItemAssignee = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type PullRequestsListResponseItem = {
    id: number;
    node_id: string;
    url: string;
    html_url: string;
    diff_url: string;
    patch_url: string;
    issue_url: string;
    commits_url: string;
    review_comments_url: string;
    review_comment_url: string;
    comments_url: string;
    statuses_url: string;
    number: number;
    state: string;
    title: string;
    body: string;
    assignee: PullRequestsListResponseItemAssignee;
    labels: Array<PullRequestsListResponseItemLabelsItem>;
    milestone: PullRequestsListResponseItemMilestone;
    locked: boolean;
    active_lock_reason: string;
    created_at: string;
    updated_at: string;
    closed_at: string;
    merged_at: string;
    head: PullRequestsListResponseItemHead;
    base: PullRequestsListResponseItemBase;
    _links: PullRequestsListResponseItemLinks;
    user: PullRequestsListResponseItemUser;
  };
  type PullRequestsGetReviewResponseLinksPullRequest = { href: string };
  type PullRequestsGetReviewResponseLinksHtml = { href: string };
  type PullRequestsGetReviewResponseLinks = {
    html: PullRequestsGetReviewResponseLinksHtml;
    pull_request: PullRequestsGetReviewResponseLinksPullRequest;
  };
  type PullRequestsGetReviewResponseUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type PullRequestsGetReviewResponse = {
    id: number;
    node_id: string;
    user: PullRequestsGetReviewResponseUser;
    body: string;
    commit_id: string;
    state: string;
    html_url: string;
    pull_request_url: string;
    _links: PullRequestsGetReviewResponseLinks;
  };
  type PullRequestsGetCommentsForReviewResponseItemLinksPullRequest = {
    href: string;
  };
  type PullRequestsGetCommentsForReviewResponseItemLinksHtml = { href: string };
  type PullRequestsGetCommentsForReviewResponseItemLinksSelf = { href: string };
  type PullRequestsGetCommentsForReviewResponseItemLinks = {
    self: PullRequestsGetCommentsForReviewResponseItemLinksSelf;
    html: PullRequestsGetCommentsForReviewResponseItemLinksHtml;
    pull_request: PullRequestsGetCommentsForReviewResponseItemLinksPullRequest;
  };
  type PullRequestsGetCommentsForReviewResponseItemUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type PullRequestsGetCommentsForReviewResponseItem = {
    url: string;
    id: number;
    node_id: string;
    pull_request_review_id: number;
    diff_hunk: string;
    path: string;
    position: number;
    original_position: number;
    commit_id: string;
    original_commit_id: string;
    in_reply_to_id: number;
    user: PullRequestsGetCommentsForReviewResponseItemUser;
    body: string;
    created_at: string;
    updated_at: string;
    html_url: string;
    pull_request_url: string;
    _links: PullRequestsGetCommentsForReviewResponseItemLinks;
  };
  type PullRequestsGetCommentResponseLinksPullRequest = { href: string };
  type PullRequestsGetCommentResponseLinksHtml = { href: string };
  type PullRequestsGetCommentResponseLinksSelf = { href: string };
  type PullRequestsGetCommentResponseLinks = {
    self: PullRequestsGetCommentResponseLinksSelf;
    html: PullRequestsGetCommentResponseLinksHtml;
    pull_request: PullRequestsGetCommentResponseLinksPullRequest;
  };
  type PullRequestsGetCommentResponseUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type PullRequestsGetCommentResponse = {
    url: string;
    id: number;
    node_id: string;
    pull_request_review_id: number;
    diff_hunk: string;
    path: string;
    position: number;
    original_position: number;
    commit_id: string;
    original_commit_id: string;
    in_reply_to_id: number;
    user: PullRequestsGetCommentResponseUser;
    body: string;
    created_at: string;
    updated_at: string;
    html_url: string;
    pull_request_url: string;
    _links: PullRequestsGetCommentResponseLinks;
  };
  type PullRequestsGetResponseMergedBy = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type PullRequestsGetResponseUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type PullRequestsGetResponseLinksStatuses = { href: string };
  type PullRequestsGetResponseLinksCommits = { href: string };
  type PullRequestsGetResponseLinksReviewComment = { href: string };
  type PullRequestsGetResponseLinksReviewComments = { href: string };
  type PullRequestsGetResponseLinksComments = { href: string };
  type PullRequestsGetResponseLinksIssue = { href: string };
  type PullRequestsGetResponseLinksHtml = { href: string };
  type PullRequestsGetResponseLinksSelf = { href: string };
  type PullRequestsGetResponseLinks = {
    self: PullRequestsGetResponseLinksSelf;
    html: PullRequestsGetResponseLinksHtml;
    issue: PullRequestsGetResponseLinksIssue;
    comments: PullRequestsGetResponseLinksComments;
    review_comments: PullRequestsGetResponseLinksReviewComments;
    review_comment: PullRequestsGetResponseLinksReviewComment;
    commits: PullRequestsGetResponseLinksCommits;
    statuses: PullRequestsGetResponseLinksStatuses;
  };
  type PullRequestsGetResponseBaseRepoPermissions = {
    admin: boolean;
    push: boolean;
    pull: boolean;
  };
  type PullRequestsGetResponseBaseRepoOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type PullRequestsGetResponseBaseRepo = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: PullRequestsGetResponseBaseRepoOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    clone_url: string;
    mirror_url: string;
    hooks_url: string;
    svn_url: string;
    homepage: string;
    language: null;
    forks_count: number;
    stargazers_count: number;
    watchers_count: number;
    size: number;
    default_branch: string;
    open_issues_count: number;
    topics: Array<string>;
    has_issues: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    has_pages: boolean;
    has_downloads: boolean;
    archived: boolean;
    pushed_at: string;
    created_at: string;
    updated_at: string;
    permissions: PullRequestsGetResponseBaseRepoPermissions;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    allow_merge_commit: boolean;
    subscribers_count: number;
    network_count: number;
  };
  type PullRequestsGetResponseBaseUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type PullRequestsGetResponseBase = {
    label: string;
    ref: string;
    sha: string;
    user: PullRequestsGetResponseBaseUser;
    repo: PullRequestsGetResponseBaseRepo;
  };
  type PullRequestsGetResponseHeadRepoPermissions = {
    admin: boolean;
    push: boolean;
    pull: boolean;
  };
  type PullRequestsGetResponseHeadRepoOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type PullRequestsGetResponseHeadRepo = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: PullRequestsGetResponseHeadRepoOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    clone_url: string;
    mirror_url: string;
    hooks_url: string;
    svn_url: string;
    homepage: string;
    language: null;
    forks_count: number;
    stargazers_count: number;
    watchers_count: number;
    size: number;
    default_branch: string;
    open_issues_count: number;
    topics: Array<string>;
    has_issues: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    has_pages: boolean;
    has_downloads: boolean;
    archived: boolean;
    pushed_at: string;
    created_at: string;
    updated_at: string;
    permissions: PullRequestsGetResponseHeadRepoPermissions;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    allow_merge_commit: boolean;
    subscribers_count: number;
    network_count: number;
  };
  type PullRequestsGetResponseHeadUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type PullRequestsGetResponseHead = {
    label: string;
    ref: string;
    sha: string;
    user: PullRequestsGetResponseHeadUser;
    repo: PullRequestsGetResponseHeadRepo;
  };
  type PullRequestsGetResponseMilestoneCreator = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type PullRequestsGetResponseMilestone = {
    url: string;
    html_url: string;
    labels_url: string;
    id: number;
    node_id: string;
    number: number;
    state: string;
    title: string;
    description: string;
    creator: PullRequestsGetResponseMilestoneCreator;
    open_issues: number;
    closed_issues: number;
    created_at: string;
    updated_at: string;
    closed_at: string;
    due_on: string;
  };
  type PullRequestsGetResponseLabelsItem = {
    id: number;
    node_id: string;
    url: string;
    name: string;
    description: string;
    color: string;
    default: boolean;
  };
  type PullRequestsGetResponseAssignee = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type PullRequestsGetResponse = {
    id: number;
    node_id: string;
    url: string;
    html_url: string;
    diff_url: string;
    patch_url: string;
    issue_url: string;
    commits_url: string;
    review_comments_url: string;
    review_comment_url: string;
    comments_url: string;
    statuses_url: string;
    number: number;
    state: string;
    title: string;
    body: string;
    assignee: PullRequestsGetResponseAssignee;
    labels: Array<PullRequestsGetResponseLabelsItem>;
    milestone: PullRequestsGetResponseMilestone;
    locked: boolean;
    active_lock_reason: string;
    created_at: string;
    updated_at: string;
    closed_at: string;
    merged_at: string;
    head: PullRequestsGetResponseHead;
    base: PullRequestsGetResponseBase;
    _links: PullRequestsGetResponseLinks;
    user: PullRequestsGetResponseUser;
    merge_commit_sha: string;
    merged: boolean;
    mergeable: boolean;
    merged_by: PullRequestsGetResponseMergedBy;
    comments: number;
    commits: number;
    additions: number;
    deletions: number;
    changed_files: number;
    maintainer_can_modify: boolean;
  };
  type PullRequestsDismissReviewResponseLinksPullRequest = { href: string };
  type PullRequestsDismissReviewResponseLinksHtml = { href: string };
  type PullRequestsDismissReviewResponseLinks = {
    html: PullRequestsDismissReviewResponseLinksHtml;
    pull_request: PullRequestsDismissReviewResponseLinksPullRequest;
  };
  type PullRequestsDismissReviewResponseUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type PullRequestsDismissReviewResponse = {
    id: number;
    node_id: string;
    user: PullRequestsDismissReviewResponseUser;
    body: string;
    commit_id: string;
    state: string;
    html_url: string;
    pull_request_url: string;
    _links: PullRequestsDismissReviewResponseLinks;
  };
  type PullRequestsDeleteReviewRequestResponse = {};
  type PullRequestsDeletePendingReviewResponseLinksPullRequest = {
    href: string;
  };
  type PullRequestsDeletePendingReviewResponseLinksHtml = { href: string };
  type PullRequestsDeletePendingReviewResponseLinks = {
    html: PullRequestsDeletePendingReviewResponseLinksHtml;
    pull_request: PullRequestsDeletePendingReviewResponseLinksPullRequest;
  };
  type PullRequestsDeletePendingReviewResponseUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type PullRequestsDeletePendingReviewResponse = {
    id: number;
    node_id: string;
    user: PullRequestsDeletePendingReviewResponseUser;
    body: string;
    commit_id: string;
    state: string;
    html_url: string;
    pull_request_url: string;
    _links: PullRequestsDeletePendingReviewResponseLinks;
  };
  type PullRequestsDeleteCommentResponse = {};
  type PullRequestsCreateReviewRequestResponseRequestedTeamsItem = {
    id: number;
    node_id: string;
    url: string;
    name: string;
    slug: string;
    description: string;
    privacy: string;
    permission: string;
    members_url: string;
    repositories_url: string;
    parent: null;
  };
  type PullRequestsCreateReviewRequestResponseRequestedReviewersItem = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type PullRequestsCreateReviewRequestResponseUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type PullRequestsCreateReviewRequestResponseLinksStatuses = { href: string };
  type PullRequestsCreateReviewRequestResponseLinksCommits = { href: string };
  type PullRequestsCreateReviewRequestResponseLinksReviewComment = {
    href: string;
  };
  type PullRequestsCreateReviewRequestResponseLinksReviewComments = {
    href: string;
  };
  type PullRequestsCreateReviewRequestResponseLinksComments = { href: string };
  type PullRequestsCreateReviewRequestResponseLinksIssue = { href: string };
  type PullRequestsCreateReviewRequestResponseLinksHtml = { href: string };
  type PullRequestsCreateReviewRequestResponseLinksSelf = { href: string };
  type PullRequestsCreateReviewRequestResponseLinks = {
    self: PullRequestsCreateReviewRequestResponseLinksSelf;
    html: PullRequestsCreateReviewRequestResponseLinksHtml;
    issue: PullRequestsCreateReviewRequestResponseLinksIssue;
    comments: PullRequestsCreateReviewRequestResponseLinksComments;
    review_comments: PullRequestsCreateReviewRequestResponseLinksReviewComments;
    review_comment: PullRequestsCreateReviewRequestResponseLinksReviewComment;
    commits: PullRequestsCreateReviewRequestResponseLinksCommits;
    statuses: PullRequestsCreateReviewRequestResponseLinksStatuses;
  };
  type PullRequestsCreateReviewRequestResponseBaseRepoPermissions = {
    admin: boolean;
    push: boolean;
    pull: boolean;
  };
  type PullRequestsCreateReviewRequestResponseBaseRepoOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type PullRequestsCreateReviewRequestResponseBaseRepo = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: PullRequestsCreateReviewRequestResponseBaseRepoOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    clone_url: string;
    mirror_url: string;
    hooks_url: string;
    svn_url: string;
    homepage: string;
    language: null;
    forks_count: number;
    stargazers_count: number;
    watchers_count: number;
    size: number;
    default_branch: string;
    open_issues_count: number;
    topics: Array<string>;
    has_issues: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    has_pages: boolean;
    has_downloads: boolean;
    archived: boolean;
    pushed_at: string;
    created_at: string;
    updated_at: string;
    permissions: PullRequestsCreateReviewRequestResponseBaseRepoPermissions;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    allow_merge_commit: boolean;
    subscribers_count: number;
    network_count: number;
  };
  type PullRequestsCreateReviewRequestResponseBaseUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type PullRequestsCreateReviewRequestResponseBase = {
    label: string;
    ref: string;
    sha: string;
    user: PullRequestsCreateReviewRequestResponseBaseUser;
    repo: PullRequestsCreateReviewRequestResponseBaseRepo;
  };
  type PullRequestsCreateReviewRequestResponseHeadRepoPermissions = {
    admin: boolean;
    push: boolean;
    pull: boolean;
  };
  type PullRequestsCreateReviewRequestResponseHeadRepoOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type PullRequestsCreateReviewRequestResponseHeadRepo = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: PullRequestsCreateReviewRequestResponseHeadRepoOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    clone_url: string;
    mirror_url: string;
    hooks_url: string;
    svn_url: string;
    homepage: string;
    language: null;
    forks_count: number;
    stargazers_count: number;
    watchers_count: number;
    size: number;
    default_branch: string;
    open_issues_count: number;
    topics: Array<string>;
    has_issues: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    has_pages: boolean;
    has_downloads: boolean;
    archived: boolean;
    pushed_at: string;
    created_at: string;
    updated_at: string;
    permissions: PullRequestsCreateReviewRequestResponseHeadRepoPermissions;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    allow_merge_commit: boolean;
    subscribers_count: number;
    network_count: number;
  };
  type PullRequestsCreateReviewRequestResponseHeadUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type PullRequestsCreateReviewRequestResponseHead = {
    label: string;
    ref: string;
    sha: string;
    user: PullRequestsCreateReviewRequestResponseHeadUser;
    repo: PullRequestsCreateReviewRequestResponseHeadRepo;
  };
  type PullRequestsCreateReviewRequestResponseMilestoneCreator = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type PullRequestsCreateReviewRequestResponseMilestone = {
    url: string;
    html_url: string;
    labels_url: string;
    id: number;
    node_id: string;
    number: number;
    state: string;
    title: string;
    description: string;
    creator: PullRequestsCreateReviewRequestResponseMilestoneCreator;
    open_issues: number;
    closed_issues: number;
    created_at: string;
    updated_at: string;
    closed_at: string;
    due_on: string;
  };
  type PullRequestsCreateReviewRequestResponseLabelsItem = {
    id: number;
    node_id: string;
    url: string;
    name: string;
    description: string;
    color: string;
    default: boolean;
  };
  type PullRequestsCreateReviewRequestResponseAssignee = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type PullRequestsCreateReviewRequestResponse = {
    id: number;
    node_id: string;
    url: string;
    html_url: string;
    diff_url: string;
    patch_url: string;
    issue_url: string;
    commits_url: string;
    review_comments_url: string;
    review_comment_url: string;
    comments_url: string;
    statuses_url: string;
    number: number;
    state: string;
    title: string;
    body: string;
    assignee: PullRequestsCreateReviewRequestResponseAssignee;
    labels: Array<PullRequestsCreateReviewRequestResponseLabelsItem>;
    milestone: PullRequestsCreateReviewRequestResponseMilestone;
    locked: boolean;
    active_lock_reason: string;
    created_at: string;
    updated_at: string;
    closed_at: string;
    merged_at: string;
    head: PullRequestsCreateReviewRequestResponseHead;
    base: PullRequestsCreateReviewRequestResponseBase;
    _links: PullRequestsCreateReviewRequestResponseLinks;
    user: PullRequestsCreateReviewRequestResponseUser;
    requested_reviewers: Array<
      PullRequestsCreateReviewRequestResponseRequestedReviewersItem
    >;
    requested_teams: Array<
      PullRequestsCreateReviewRequestResponseRequestedTeamsItem
    >;
  };
  type PullRequestsCreateReviewResponseLinksPullRequest = { href: string };
  type PullRequestsCreateReviewResponseLinksHtml = { href: string };
  type PullRequestsCreateReviewResponseLinks = {
    html: PullRequestsCreateReviewResponseLinksHtml;
    pull_request: PullRequestsCreateReviewResponseLinksPullRequest;
  };
  type PullRequestsCreateReviewResponseUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type PullRequestsCreateReviewResponse = {
    id: number;
    node_id: string;
    user: PullRequestsCreateReviewResponseUser;
    body: string;
    commit_id: string;
    state: string;
    html_url: string;
    pull_request_url: string;
    _links: PullRequestsCreateReviewResponseLinks;
  };
  type PullRequestsCreateFromIssueResponseUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type PullRequestsCreateFromIssueResponseLinksStatuses = { href: string };
  type PullRequestsCreateFromIssueResponseLinksCommits = { href: string };
  type PullRequestsCreateFromIssueResponseLinksReviewComment = { href: string };
  type PullRequestsCreateFromIssueResponseLinksReviewComments = {
    href: string;
  };
  type PullRequestsCreateFromIssueResponseLinksComments = { href: string };
  type PullRequestsCreateFromIssueResponseLinksIssue = { href: string };
  type PullRequestsCreateFromIssueResponseLinksHtml = { href: string };
  type PullRequestsCreateFromIssueResponseLinksSelf = { href: string };
  type PullRequestsCreateFromIssueResponseLinks = {
    self: PullRequestsCreateFromIssueResponseLinksSelf;
    html: PullRequestsCreateFromIssueResponseLinksHtml;
    issue: PullRequestsCreateFromIssueResponseLinksIssue;
    comments: PullRequestsCreateFromIssueResponseLinksComments;
    review_comments: PullRequestsCreateFromIssueResponseLinksReviewComments;
    review_comment: PullRequestsCreateFromIssueResponseLinksReviewComment;
    commits: PullRequestsCreateFromIssueResponseLinksCommits;
    statuses: PullRequestsCreateFromIssueResponseLinksStatuses;
  };
  type PullRequestsCreateFromIssueResponseBaseRepoPermissions = {
    admin: boolean;
    push: boolean;
    pull: boolean;
  };
  type PullRequestsCreateFromIssueResponseBaseRepoOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type PullRequestsCreateFromIssueResponseBaseRepo = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: PullRequestsCreateFromIssueResponseBaseRepoOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    clone_url: string;
    mirror_url: string;
    hooks_url: string;
    svn_url: string;
    homepage: string;
    language: null;
    forks_count: number;
    stargazers_count: number;
    watchers_count: number;
    size: number;
    default_branch: string;
    open_issues_count: number;
    topics: Array<string>;
    has_issues: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    has_pages: boolean;
    has_downloads: boolean;
    archived: boolean;
    pushed_at: string;
    created_at: string;
    updated_at: string;
    permissions: PullRequestsCreateFromIssueResponseBaseRepoPermissions;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    allow_merge_commit: boolean;
    subscribers_count: number;
    network_count: number;
  };
  type PullRequestsCreateFromIssueResponseBaseUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type PullRequestsCreateFromIssueResponseBase = {
    label: string;
    ref: string;
    sha: string;
    user: PullRequestsCreateFromIssueResponseBaseUser;
    repo: PullRequestsCreateFromIssueResponseBaseRepo;
  };
  type PullRequestsCreateFromIssueResponseHeadRepoPermissions = {
    admin: boolean;
    push: boolean;
    pull: boolean;
  };
  type PullRequestsCreateFromIssueResponseHeadRepoOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type PullRequestsCreateFromIssueResponseHeadRepo = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: PullRequestsCreateFromIssueResponseHeadRepoOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    clone_url: string;
    mirror_url: string;
    hooks_url: string;
    svn_url: string;
    homepage: string;
    language: null;
    forks_count: number;
    stargazers_count: number;
    watchers_count: number;
    size: number;
    default_branch: string;
    open_issues_count: number;
    topics: Array<string>;
    has_issues: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    has_pages: boolean;
    has_downloads: boolean;
    archived: boolean;
    pushed_at: string;
    created_at: string;
    updated_at: string;
    permissions: PullRequestsCreateFromIssueResponseHeadRepoPermissions;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    allow_merge_commit: boolean;
    subscribers_count: number;
    network_count: number;
  };
  type PullRequestsCreateFromIssueResponseHeadUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type PullRequestsCreateFromIssueResponseHead = {
    label: string;
    ref: string;
    sha: string;
    user: PullRequestsCreateFromIssueResponseHeadUser;
    repo: PullRequestsCreateFromIssueResponseHeadRepo;
  };
  type PullRequestsCreateFromIssueResponseMilestoneCreator = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type PullRequestsCreateFromIssueResponseMilestone = {
    url: string;
    html_url: string;
    labels_url: string;
    id: number;
    node_id: string;
    number: number;
    state: string;
    title: string;
    description: string;
    creator: PullRequestsCreateFromIssueResponseMilestoneCreator;
    open_issues: number;
    closed_issues: number;
    created_at: string;
    updated_at: string;
    closed_at: string;
    due_on: string;
  };
  type PullRequestsCreateFromIssueResponseLabelsItem = {
    id: number;
    node_id: string;
    url: string;
    name: string;
    description: string;
    color: string;
    default: boolean;
  };
  type PullRequestsCreateFromIssueResponseAssignee = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type PullRequestsCreateFromIssueResponse = {
    id: number;
    node_id: string;
    url: string;
    html_url: string;
    diff_url: string;
    patch_url: string;
    issue_url: string;
    commits_url: string;
    review_comments_url: string;
    review_comment_url: string;
    comments_url: string;
    statuses_url: string;
    number: number;
    state: string;
    title: string;
    body: string;
    assignee: PullRequestsCreateFromIssueResponseAssignee;
    labels: Array<PullRequestsCreateFromIssueResponseLabelsItem>;
    milestone: PullRequestsCreateFromIssueResponseMilestone;
    locked: boolean;
    active_lock_reason: string;
    created_at: string;
    updated_at: string;
    closed_at: string;
    merged_at: string;
    head: PullRequestsCreateFromIssueResponseHead;
    base: PullRequestsCreateFromIssueResponseBase;
    _links: PullRequestsCreateFromIssueResponseLinks;
    user: PullRequestsCreateFromIssueResponseUser;
  };
  type PullRequestsCreateCommentReplyResponseLinksPullRequest = {
    href: string;
  };
  type PullRequestsCreateCommentReplyResponseLinksHtml = { href: string };
  type PullRequestsCreateCommentReplyResponseLinksSelf = { href: string };
  type PullRequestsCreateCommentReplyResponseLinks = {
    self: PullRequestsCreateCommentReplyResponseLinksSelf;
    html: PullRequestsCreateCommentReplyResponseLinksHtml;
    pull_request: PullRequestsCreateCommentReplyResponseLinksPullRequest;
  };
  type PullRequestsCreateCommentReplyResponseUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type PullRequestsCreateCommentReplyResponse = {
    url: string;
    id: number;
    node_id: string;
    pull_request_review_id: number;
    diff_hunk: string;
    path: string;
    position: number;
    original_position: number;
    commit_id: string;
    original_commit_id: string;
    in_reply_to_id: number;
    user: PullRequestsCreateCommentReplyResponseUser;
    body: string;
    created_at: string;
    updated_at: string;
    html_url: string;
    pull_request_url: string;
    _links: PullRequestsCreateCommentReplyResponseLinks;
  };
  type PullRequestsCreateCommentResponseLinksPullRequest = { href: string };
  type PullRequestsCreateCommentResponseLinksHtml = { href: string };
  type PullRequestsCreateCommentResponseLinksSelf = { href: string };
  type PullRequestsCreateCommentResponseLinks = {
    self: PullRequestsCreateCommentResponseLinksSelf;
    html: PullRequestsCreateCommentResponseLinksHtml;
    pull_request: PullRequestsCreateCommentResponseLinksPullRequest;
  };
  type PullRequestsCreateCommentResponseUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type PullRequestsCreateCommentResponse = {
    url: string;
    id: number;
    node_id: string;
    pull_request_review_id: number;
    diff_hunk: string;
    path: string;
    position: number;
    original_position: number;
    commit_id: string;
    original_commit_id: string;
    in_reply_to_id: number;
    user: PullRequestsCreateCommentResponseUser;
    body: string;
    created_at: string;
    updated_at: string;
    html_url: string;
    pull_request_url: string;
    _links: PullRequestsCreateCommentResponseLinks;
  };
  type PullRequestsCreateResponseUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type PullRequestsCreateResponseLinksStatuses = { href: string };
  type PullRequestsCreateResponseLinksCommits = { href: string };
  type PullRequestsCreateResponseLinksReviewComment = { href: string };
  type PullRequestsCreateResponseLinksReviewComments = { href: string };
  type PullRequestsCreateResponseLinksComments = { href: string };
  type PullRequestsCreateResponseLinksIssue = { href: string };
  type PullRequestsCreateResponseLinksHtml = { href: string };
  type PullRequestsCreateResponseLinksSelf = { href: string };
  type PullRequestsCreateResponseLinks = {
    self: PullRequestsCreateResponseLinksSelf;
    html: PullRequestsCreateResponseLinksHtml;
    issue: PullRequestsCreateResponseLinksIssue;
    comments: PullRequestsCreateResponseLinksComments;
    review_comments: PullRequestsCreateResponseLinksReviewComments;
    review_comment: PullRequestsCreateResponseLinksReviewComment;
    commits: PullRequestsCreateResponseLinksCommits;
    statuses: PullRequestsCreateResponseLinksStatuses;
  };
  type PullRequestsCreateResponseBaseRepoPermissions = {
    admin: boolean;
    push: boolean;
    pull: boolean;
  };
  type PullRequestsCreateResponseBaseRepoOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type PullRequestsCreateResponseBaseRepo = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: PullRequestsCreateResponseBaseRepoOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    clone_url: string;
    mirror_url: string;
    hooks_url: string;
    svn_url: string;
    homepage: string;
    language: null;
    forks_count: number;
    stargazers_count: number;
    watchers_count: number;
    size: number;
    default_branch: string;
    open_issues_count: number;
    topics: Array<string>;
    has_issues: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    has_pages: boolean;
    has_downloads: boolean;
    archived: boolean;
    pushed_at: string;
    created_at: string;
    updated_at: string;
    permissions: PullRequestsCreateResponseBaseRepoPermissions;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    allow_merge_commit: boolean;
    subscribers_count: number;
    network_count: number;
  };
  type PullRequestsCreateResponseBaseUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type PullRequestsCreateResponseBase = {
    label: string;
    ref: string;
    sha: string;
    user: PullRequestsCreateResponseBaseUser;
    repo: PullRequestsCreateResponseBaseRepo;
  };
  type PullRequestsCreateResponseHeadRepoPermissions = {
    admin: boolean;
    push: boolean;
    pull: boolean;
  };
  type PullRequestsCreateResponseHeadRepoOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type PullRequestsCreateResponseHeadRepo = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: PullRequestsCreateResponseHeadRepoOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    clone_url: string;
    mirror_url: string;
    hooks_url: string;
    svn_url: string;
    homepage: string;
    language: null;
    forks_count: number;
    stargazers_count: number;
    watchers_count: number;
    size: number;
    default_branch: string;
    open_issues_count: number;
    topics: Array<string>;
    has_issues: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    has_pages: boolean;
    has_downloads: boolean;
    archived: boolean;
    pushed_at: string;
    created_at: string;
    updated_at: string;
    permissions: PullRequestsCreateResponseHeadRepoPermissions;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    allow_merge_commit: boolean;
    subscribers_count: number;
    network_count: number;
  };
  type PullRequestsCreateResponseHeadUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type PullRequestsCreateResponseHead = {
    label: string;
    ref: string;
    sha: string;
    user: PullRequestsCreateResponseHeadUser;
    repo: PullRequestsCreateResponseHeadRepo;
  };
  type PullRequestsCreateResponseMilestoneCreator = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type PullRequestsCreateResponseMilestone = {
    url: string;
    html_url: string;
    labels_url: string;
    id: number;
    node_id: string;
    number: number;
    state: string;
    title: string;
    description: string;
    creator: PullRequestsCreateResponseMilestoneCreator;
    open_issues: number;
    closed_issues: number;
    created_at: string;
    updated_at: string;
    closed_at: string;
    due_on: string;
  };
  type PullRequestsCreateResponseLabelsItem = {
    id: number;
    node_id: string;
    url: string;
    name: string;
    description: string;
    color: string;
    default: boolean;
  };
  type PullRequestsCreateResponseAssignee = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type PullRequestsCreateResponse = {
    id: number;
    node_id: string;
    url: string;
    html_url: string;
    diff_url: string;
    patch_url: string;
    issue_url: string;
    commits_url: string;
    review_comments_url: string;
    review_comment_url: string;
    comments_url: string;
    statuses_url: string;
    number: number;
    state: string;
    title: string;
    body: string;
    assignee: PullRequestsCreateResponseAssignee;
    labels: Array<PullRequestsCreateResponseLabelsItem>;
    milestone: PullRequestsCreateResponseMilestone;
    locked: boolean;
    active_lock_reason: string;
    created_at: string;
    updated_at: string;
    closed_at: string;
    merged_at: string;
    head: PullRequestsCreateResponseHead;
    base: PullRequestsCreateResponseBase;
    _links: PullRequestsCreateResponseLinks;
    user: PullRequestsCreateResponseUser;
  };
  type ProjectsUpdateResponseCreator = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ProjectsUpdateResponse = {
    owner_url: string;
    url: string;
    html_url: string;
    columns_url: string;
    id: number;
    node_id: string;
    name: string;
    body: string;
    number: number;
    state: string;
    creator: ProjectsUpdateResponseCreator;
    created_at: string;
    updated_at: string;
  };
  type ProjectsReviewUserPermissionLevelResponseUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ProjectsReviewUserPermissionLevelResponse = {
    permission: string;
    user: ProjectsReviewUserPermissionLevelResponseUser;
  };
  type ProjectsRemoveCollaboratorResponse = {};
  type ProjectsMoveColumnResponse = {};
  type ProjectsMoveCardResponse = {};
  type ProjectsListForRepoResponseItemCreator = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ProjectsListForRepoResponseItem = {
    owner_url: string;
    url: string;
    html_url: string;
    columns_url: string;
    id: number;
    node_id: string;
    name: string;
    body: string;
    number: number;
    state: string;
    creator: ProjectsListForRepoResponseItemCreator;
    created_at: string;
    updated_at: string;
  };
  type ProjectsListForOrgResponseItemCreator = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ProjectsListForOrgResponseItem = {
    owner_url: string;
    url: string;
    html_url: string;
    columns_url: string;
    id: number;
    node_id: string;
    name: string;
    body: string;
    number: number;
    state: string;
    creator: ProjectsListForOrgResponseItemCreator;
    created_at: string;
    updated_at: string;
  };
  type ProjectsListColumnsResponseItem = {
    url: string;
    project_url: string;
    cards_url: string;
    id: number;
    node_id: string;
    name: string;
    created_at: string;
    updated_at: string;
  };
  type ProjectsListCollaboratorsResponseItem = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ProjectsListCardsResponseItemCreator = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ProjectsListCardsResponseItem = {
    url: string;
    id: number;
    node_id: string;
    note: string;
    creator: ProjectsListCardsResponseItemCreator;
    created_at: string;
    updated_at: string;
    archived: boolean;
    column_url: string;
    content_url: string;
    project_url: string;
  };
  type ProjectsGetResponseCreator = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ProjectsGetResponse = {
    owner_url: string;
    url: string;
    html_url: string;
    columns_url: string;
    id: number;
    node_id: string;
    name: string;
    body: string;
    number: number;
    state: string;
    creator: ProjectsGetResponseCreator;
    created_at: string;
    updated_at: string;
  };
  type ProjectsDeleteColumnResponse = {};
  type ProjectsDeleteCardResponse = {};
  type ProjectsCreateForRepoResponseCreator = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ProjectsCreateForRepoResponse = {
    owner_url: string;
    url: string;
    html_url: string;
    columns_url: string;
    id: number;
    node_id: string;
    name: string;
    body: string;
    number: number;
    state: string;
    creator: ProjectsCreateForRepoResponseCreator;
    created_at: string;
    updated_at: string;
  };
  type ProjectsCreateForOrgResponseCreator = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ProjectsCreateForOrgResponse = {
    owner_url: string;
    url: string;
    html_url: string;
    columns_url: string;
    id: number;
    node_id: string;
    name: string;
    body: string;
    number: number;
    state: string;
    creator: ProjectsCreateForOrgResponseCreator;
    created_at: string;
    updated_at: string;
  };
  type ProjectsCreateCardResponseCreator = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ProjectsCreateCardResponse = {
    url: string;
    id: number;
    node_id: string;
    note: string;
    creator: ProjectsCreateCardResponseCreator;
    created_at: string;
    updated_at: string;
    archived: boolean;
    column_url: string;
    content_url: string;
    project_url: string;
  };
  type ProjectsAddCollaboratorResponse = {};
  type OrgsUpdateMembershipResponseUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type OrgsUpdateMembershipResponseOrganization = {
    login: string;
    id: number;
    node_id: string;
    url: string;
    repos_url: string;
    events_url: string;
    hooks_url: string;
    issues_url: string;
    members_url: string;
    public_members_url: string;
    avatar_url: string;
    description: string;
  };
  type OrgsUpdateMembershipResponse = {
    url: string;
    state: string;
    role: string;
    organization_url: string;
    organization: OrgsUpdateMembershipResponseOrganization;
    user: OrgsUpdateMembershipResponseUser;
  };
  type OrgsUpdateHookResponseConfig = { url: string; content_type: string };
  type OrgsUpdateHookResponse = {
    id: number;
    url: string;
    ping_url: string;
    name: string;
    events: Array<string>;
    active: boolean;
    config: OrgsUpdateHookResponseConfig;
    updated_at: string;
    created_at: string;
  };
  type OrgsUpdateResponsePlan = {
    name: string;
    space: number;
    private_repos: number;
  };
  type OrgsUpdateResponse = {
    login: string;
    id: number;
    node_id: string;
    url: string;
    repos_url: string;
    events_url: string;
    hooks_url: string;
    issues_url: string;
    members_url: string;
    public_members_url: string;
    avatar_url: string;
    description: string;
    name: string;
    company: string;
    blog: string;
    location: string;
    email: string;
    is_verified: boolean;
    has_organization_projects: boolean;
    has_repository_projects: boolean;
    public_repos: number;
    public_gists: number;
    followers: number;
    following: number;
    html_url: string;
    created_at: string;
    type: string;
    total_private_repos: number;
    owned_private_repos: number;
    private_gists: number;
    disk_usage: number;
    collaborators: number;
    billing_email: string;
    plan: OrgsUpdateResponsePlan;
    default_repository_settings: string;
    members_can_create_repositories: boolean;
    two_factor_requirement_enabled: boolean;
  };
  type OrgsUnblockUserResponse = {};
  type OrgsRemoveOutsideCollaboratorResponse = {};
  type OrgsRemoveMembershipResponse = {};
  type OrgsRemoveMemberResponse = {};
  type OrgsPublicizeMembershipResponse = {};
  type OrgsPingHookResponse = {};
  type OrgsListPublicMembersResponseItem = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type OrgsListPendingInvitationsResponseItemInviter = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type OrgsListPendingInvitationsResponseItem = {
    id: number;
    login: string;
    email: string;
    role: string;
    created_at: string;
    inviter: OrgsListPendingInvitationsResponseItemInviter;
    team_count: number;
    invitation_team_url: string;
  };
  type OrgsListOutsideCollaboratorsResponseItem = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type OrgsListMembershipsResponseItemUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type OrgsListMembershipsResponseItemOrganization = {
    login: string;
    id: number;
    node_id: string;
    url: string;
    repos_url: string;
    events_url: string;
    hooks_url: string;
    issues_url: string;
    members_url: string;
    public_members_url: string;
    avatar_url: string;
    description: string;
  };
  type OrgsListMembershipsResponseItem = {
    url: string;
    state: string;
    role: string;
    organization_url: string;
    organization: OrgsListMembershipsResponseItemOrganization;
    user: OrgsListMembershipsResponseItemUser;
  };
  type OrgsListMembersResponseItem = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type OrgsListInvitationTeamsResponseItem = {
    id: number;
    node_id: string;
    url: string;
    name: string;
    slug: string;
    description: string;
    privacy: string;
    permission: string;
    members_url: string;
    repositories_url: string;
    parent: null;
  };
  type OrgsListHooksResponseItemConfig = { url: string; content_type: string };
  type OrgsListHooksResponseItem = {
    id: number;
    url: string;
    ping_url: string;
    name: string;
    events: Array<string>;
    active: boolean;
    config: OrgsListHooksResponseItemConfig;
    updated_at: string;
    created_at: string;
  };
  type OrgsListForUserResponseItem = {
    login: string;
    id: number;
    node_id: string;
    url: string;
    repos_url: string;
    events_url: string;
    hooks_url: string;
    issues_url: string;
    members_url: string;
    public_members_url: string;
    avatar_url: string;
    description: string;
  };
  type OrgsListForAuthenticatedUserResponseItem = {
    login: string;
    id: number;
    node_id: string;
    url: string;
    repos_url: string;
    events_url: string;
    hooks_url: string;
    issues_url: string;
    members_url: string;
    public_members_url: string;
    avatar_url: string;
    description: string;
  };
  type OrgsListBlockedUsersResponseItem = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type OrgsListResponseItem = {
    login: string;
    id: number;
    node_id: string;
    url: string;
    repos_url: string;
    events_url: string;
    hooks_url: string;
    issues_url: string;
    members_url: string;
    public_members_url: string;
    avatar_url: string;
    description: string;
  };
  type OrgsGetMembershipForAuthenticatedUserResponseUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type OrgsGetMembershipForAuthenticatedUserResponseOrganization = {
    login: string;
    id: number;
    node_id: string;
    url: string;
    repos_url: string;
    events_url: string;
    hooks_url: string;
    issues_url: string;
    members_url: string;
    public_members_url: string;
    avatar_url: string;
    description: string;
  };
  type OrgsGetMembershipForAuthenticatedUserResponse = {
    url: string;
    state: string;
    role: string;
    organization_url: string;
    organization: OrgsGetMembershipForAuthenticatedUserResponseOrganization;
    user: OrgsGetMembershipForAuthenticatedUserResponseUser;
  };
  type OrgsGetHookResponseConfig = { url: string; content_type: string };
  type OrgsGetHookResponse = {
    id: number;
    url: string;
    ping_url: string;
    name: string;
    events: Array<string>;
    active: boolean;
    config: OrgsGetHookResponseConfig;
    updated_at: string;
    created_at: string;
  };
  type OrgsGetResponsePlan = {
    name: string;
    space: number;
    private_repos: number;
  };
  type OrgsGetResponse = {
    login: string;
    id: number;
    node_id: string;
    url: string;
    repos_url: string;
    events_url: string;
    hooks_url: string;
    issues_url: string;
    members_url: string;
    public_members_url: string;
    avatar_url: string;
    description: string;
    name: string;
    company: string;
    blog: string;
    location: string;
    email: string;
    is_verified: boolean;
    has_organization_projects: boolean;
    has_repository_projects: boolean;
    public_repos: number;
    public_gists: number;
    followers: number;
    following: number;
    html_url: string;
    created_at: string;
    type: string;
    total_private_repos: number;
    owned_private_repos: number;
    private_gists: number;
    disk_usage: number;
    collaborators: number;
    billing_email: string;
    plan: OrgsGetResponsePlan;
    default_repository_settings: string;
    members_can_create_repositories: boolean;
    two_factor_requirement_enabled: boolean;
  };
  type OrgsDeleteHookResponse = {};
  type OrgsCreateInvitationResponseInviter = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type OrgsCreateInvitationResponse = {
    id: number;
    login: string;
    email: string;
    role: string;
    created_at: string;
    inviter: OrgsCreateInvitationResponseInviter;
    team_count: number;
    invitation_team_url: string;
  };
  type OrgsCreateHookResponseConfig = { url: string; content_type: string };
  type OrgsCreateHookResponse = {
    id: number;
    url: string;
    ping_url: string;
    name: string;
    events: Array<string>;
    active: boolean;
    config: OrgsCreateHookResponseConfig;
    updated_at: string;
    created_at: string;
  };
  type OrgsConvertMemberToOutsideCollaboratorResponse = {};
  type OrgsConcealMembershipResponse = {};
  type OrgsCheckBlockedUserResponse = {};
  type OrgsBlockUserResponse = {};
  type MigrationsUpdateImportResponse = {
    vcs: string;
    use_lfs: string;
    vcs_url: string;
    status: string;
    url: string;
    html_url: string;
    authors_url: string;
    repository_url: string;
  };
  type MigrationsUnlockRepoForOrgResponse = {};
  type MigrationsUnlockRepoForAuthenticatedUserResponse = {};
  type MigrationsStartImportResponse = {
    vcs: string;
    use_lfs: string;
    vcs_url: string;
    status: string;
    status_text: string;
    has_large_files: boolean;
    large_files_size: number;
    large_files_count: number;
    authors_count: number;
    percent: number;
    commit_count: number;
    url: string;
    html_url: string;
    authors_url: string;
    repository_url: string;
  };
  type MigrationsStartForOrgResponseRepositoriesItemPermissions = {
    admin: boolean;
    push: boolean;
    pull: boolean;
  };
  type MigrationsStartForOrgResponseRepositoriesItemOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type MigrationsStartForOrgResponseRepositoriesItem = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: MigrationsStartForOrgResponseRepositoriesItemOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    clone_url: string;
    mirror_url: string;
    hooks_url: string;
    svn_url: string;
    homepage: string;
    language: null;
    forks_count: number;
    stargazers_count: number;
    watchers_count: number;
    size: number;
    default_branch: string;
    open_issues_count: number;
    topics: Array<string>;
    has_issues: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    has_pages: boolean;
    has_downloads: boolean;
    archived: boolean;
    pushed_at: string;
    created_at: string;
    updated_at: string;
    permissions: MigrationsStartForOrgResponseRepositoriesItemPermissions;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    allow_merge_commit: boolean;
    subscribers_count: number;
    network_count: number;
  };
  type MigrationsStartForOrgResponseOwner = {
    login: string;
    id: number;
    node_id: string;
    url: string;
    repos_url: string;
    events_url: string;
    hooks_url: string;
    issues_url: string;
    members_url: string;
    public_members_url: string;
    avatar_url: string;
    description: string;
  };
  type MigrationsStartForOrgResponse = {
    id: number;
    owner: MigrationsStartForOrgResponseOwner;
    guid: string;
    state: string;
    lock_repositories: boolean;
    exclude_attachments: boolean;
    repositories: Array<MigrationsStartForOrgResponseRepositoriesItem>;
    url: string;
    created_at: string;
    updated_at: string;
  };
  type MigrationsStartForAuthenticatedUserResponseRepositoriesItemPermissions = {
    admin: boolean;
    push: boolean;
    pull: boolean;
  };
  type MigrationsStartForAuthenticatedUserResponseRepositoriesItemOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type MigrationsStartForAuthenticatedUserResponseRepositoriesItem = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: MigrationsStartForAuthenticatedUserResponseRepositoriesItemOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    clone_url: string;
    mirror_url: string;
    hooks_url: string;
    svn_url: string;
    homepage: string;
    language: null;
    forks_count: number;
    stargazers_count: number;
    watchers_count: number;
    size: number;
    default_branch: string;
    open_issues_count: number;
    topics: Array<string>;
    has_issues: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    has_pages: boolean;
    has_downloads: boolean;
    archived: boolean;
    pushed_at: string;
    created_at: string;
    updated_at: string;
    permissions: MigrationsStartForAuthenticatedUserResponseRepositoriesItemPermissions;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    allow_merge_commit: boolean;
    subscribers_count: number;
    network_count: number;
  };
  type MigrationsStartForAuthenticatedUserResponseOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type MigrationsStartForAuthenticatedUserResponse = {
    id: number;
    owner: MigrationsStartForAuthenticatedUserResponseOwner;
    guid: string;
    state: string;
    lock_repositories: boolean;
    exclude_attachments: boolean;
    repositories: Array<
      MigrationsStartForAuthenticatedUserResponseRepositoriesItem
    >;
    url: string;
    created_at: string;
    updated_at: string;
  };
  type MigrationsSetLfsPreferenceResponse = {
    vcs: string;
    use_lfs: string;
    vcs_url: string;
    status: string;
    status_text: string;
    has_large_files: boolean;
    large_files_size: number;
    large_files_count: number;
    authors_count: number;
    url: string;
    html_url: string;
    authors_url: string;
    repository_url: string;
  };
  type MigrationsMapCommitAuthorResponse = {
    id: number;
    remote_id: string;
    remote_name: string;
    email: string;
    name: string;
    url: string;
    import_url: string;
  };
  type MigrationsListForOrgResponseItemRepositoriesItemPermissions = {
    admin: boolean;
    push: boolean;
    pull: boolean;
  };
  type MigrationsListForOrgResponseItemRepositoriesItemOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type MigrationsListForOrgResponseItemRepositoriesItem = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: MigrationsListForOrgResponseItemRepositoriesItemOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    clone_url: string;
    mirror_url: string;
    hooks_url: string;
    svn_url: string;
    homepage: string;
    language: null;
    forks_count: number;
    stargazers_count: number;
    watchers_count: number;
    size: number;
    default_branch: string;
    open_issues_count: number;
    topics: Array<string>;
    has_issues: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    has_pages: boolean;
    has_downloads: boolean;
    archived: boolean;
    pushed_at: string;
    created_at: string;
    updated_at: string;
    permissions: MigrationsListForOrgResponseItemRepositoriesItemPermissions;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    allow_merge_commit: boolean;
    subscribers_count: number;
    network_count: number;
  };
  type MigrationsListForOrgResponseItemOwner = {
    login: string;
    id: number;
    node_id: string;
    url: string;
    repos_url: string;
    events_url: string;
    hooks_url: string;
    issues_url: string;
    members_url: string;
    public_members_url: string;
    avatar_url: string;
    description: string;
  };
  type MigrationsListForOrgResponseItem = {
    id: number;
    owner: MigrationsListForOrgResponseItemOwner;
    guid: string;
    state: string;
    lock_repositories: boolean;
    exclude_attachments: boolean;
    repositories: Array<MigrationsListForOrgResponseItemRepositoriesItem>;
    url: string;
    created_at: string;
    updated_at: string;
  };
  type MigrationsListForAuthenticatedUserResponseItemRepositoriesItemPermissions = {
    admin: boolean;
    push: boolean;
    pull: boolean;
  };
  type MigrationsListForAuthenticatedUserResponseItemRepositoriesItemOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type MigrationsListForAuthenticatedUserResponseItemRepositoriesItem = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: MigrationsListForAuthenticatedUserResponseItemRepositoriesItemOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    clone_url: string;
    mirror_url: string;
    hooks_url: string;
    svn_url: string;
    homepage: string;
    language: null;
    forks_count: number;
    stargazers_count: number;
    watchers_count: number;
    size: number;
    default_branch: string;
    open_issues_count: number;
    topics: Array<string>;
    has_issues: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    has_pages: boolean;
    has_downloads: boolean;
    archived: boolean;
    pushed_at: string;
    created_at: string;
    updated_at: string;
    permissions: MigrationsListForAuthenticatedUserResponseItemRepositoriesItemPermissions;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    allow_merge_commit: boolean;
    subscribers_count: number;
    network_count: number;
  };
  type MigrationsListForAuthenticatedUserResponseItemOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type MigrationsListForAuthenticatedUserResponseItem = {
    id: number;
    owner: MigrationsListForAuthenticatedUserResponseItemOwner;
    guid: string;
    state: string;
    lock_repositories: boolean;
    exclude_attachments: boolean;
    repositories: Array<
      MigrationsListForAuthenticatedUserResponseItemRepositoriesItem
    >;
    url: string;
    created_at: string;
    updated_at: string;
  };
  type MigrationsGetStatusForOrgResponseRepositoriesItemPermissions = {
    admin: boolean;
    push: boolean;
    pull: boolean;
  };
  type MigrationsGetStatusForOrgResponseRepositoriesItemOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type MigrationsGetStatusForOrgResponseRepositoriesItem = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: MigrationsGetStatusForOrgResponseRepositoriesItemOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    clone_url: string;
    mirror_url: string;
    hooks_url: string;
    svn_url: string;
    homepage: string;
    language: null;
    forks_count: number;
    stargazers_count: number;
    watchers_count: number;
    size: number;
    default_branch: string;
    open_issues_count: number;
    topics: Array<string>;
    has_issues: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    has_pages: boolean;
    has_downloads: boolean;
    archived: boolean;
    pushed_at: string;
    created_at: string;
    updated_at: string;
    permissions: MigrationsGetStatusForOrgResponseRepositoriesItemPermissions;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    allow_merge_commit: boolean;
    subscribers_count: number;
    network_count: number;
  };
  type MigrationsGetStatusForOrgResponseOwner = {
    login: string;
    id: number;
    node_id: string;
    url: string;
    repos_url: string;
    events_url: string;
    hooks_url: string;
    issues_url: string;
    members_url: string;
    public_members_url: string;
    avatar_url: string;
    description: string;
  };
  type MigrationsGetStatusForOrgResponse = {
    id: number;
    owner: MigrationsGetStatusForOrgResponseOwner;
    guid: string;
    state: string;
    lock_repositories: boolean;
    exclude_attachments: boolean;
    repositories: Array<MigrationsGetStatusForOrgResponseRepositoriesItem>;
    url: string;
    created_at: string;
    updated_at: string;
  };
  type MigrationsGetStatusForAuthenticatedUserResponseRepositoriesItemPermissions = {
    admin: boolean;
    push: boolean;
    pull: boolean;
  };
  type MigrationsGetStatusForAuthenticatedUserResponseRepositoriesItemOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type MigrationsGetStatusForAuthenticatedUserResponseRepositoriesItem = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: MigrationsGetStatusForAuthenticatedUserResponseRepositoriesItemOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    clone_url: string;
    mirror_url: string;
    hooks_url: string;
    svn_url: string;
    homepage: string;
    language: null;
    forks_count: number;
    stargazers_count: number;
    watchers_count: number;
    size: number;
    default_branch: string;
    open_issues_count: number;
    topics: Array<string>;
    has_issues: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    has_pages: boolean;
    has_downloads: boolean;
    archived: boolean;
    pushed_at: string;
    created_at: string;
    updated_at: string;
    permissions: MigrationsGetStatusForAuthenticatedUserResponseRepositoriesItemPermissions;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    allow_merge_commit: boolean;
    subscribers_count: number;
    network_count: number;
  };
  type MigrationsGetStatusForAuthenticatedUserResponseOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type MigrationsGetStatusForAuthenticatedUserResponse = {
    id: number;
    owner: MigrationsGetStatusForAuthenticatedUserResponseOwner;
    guid: string;
    state: string;
    lock_repositories: boolean;
    exclude_attachments: boolean;
    repositories: Array<
      MigrationsGetStatusForAuthenticatedUserResponseRepositoriesItem
    >;
    url: string;
    created_at: string;
    updated_at: string;
  };
  type MigrationsGetLargeFilesResponseItem = {
    ref_name: string;
    path: string;
    oid: string;
    size: number;
  };
  type MigrationsGetImportProgressResponse = {
    vcs: string;
    use_lfs: string;
    vcs_url: string;
    status: string;
    status_text: string;
    has_large_files: boolean;
    large_files_size: number;
    large_files_count: number;
    authors_count: number;
    url: string;
    html_url: string;
    authors_url: string;
    repository_url: string;
  };
  type MigrationsGetCommitAuthorsResponseItem = {
    id: number;
    remote_id: string;
    remote_name: string;
    email: string;
    name: string;
    url: string;
    import_url: string;
  };
  type MigrationsGetArchiveForOrgResponse = {};
  type MigrationsGetArchiveForAuthenticatedUserResponse = {};
  type MigrationsDeleteArchiveForOrgResponse = {};
  type MigrationsDeleteArchiveForAuthenticatedUserResponse = {};
  type MigrationsCancelImportResponse = {};
  type MetaGetResponse = {
    verifiable_password_authentication: boolean;
    github_services_sha: string;
    hooks: Array<string>;
    git: Array<string>;
    pages: Array<string>;
    importer: Array<string>;
  };
  type MarkdownRenderRawResponse = {};
  type MarkdownRenderResponse = {};
  type LicensesListResponseItem = {
    key: string;
    name: string;
    spdx_id: string;
    url: string;
    node_id?: string;
  };
  type LicensesGetForRepoResponseLicense = {
    key: string;
    name: string;
    spdx_id: string;
    url: string;
    node_id: string;
  };
  type LicensesGetForRepoResponseLinks = {
    self: string;
    git: string;
    html: string;
  };
  type LicensesGetForRepoResponse = {
    name: string;
    path: string;
    sha: string;
    size: number;
    url: string;
    html_url: string;
    git_url: string;
    download_url: string;
    type: string;
    content: string;
    encoding: string;
    _links: LicensesGetForRepoResponseLinks;
    license: LicensesGetForRepoResponseLicense;
  };
  type LicensesGetResponse = {
    key: string;
    name: string;
    spdx_id: string;
    url: string;
    node_id: string;
    html_url: string;
    description: string;
    implementation: string;
    permissions: Array<string>;
    conditions: Array<string>;
    limitations: Array<string>;
    body: string;
    featured: boolean;
  };
  type IssuesUpdateMilestoneResponseCreator = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type IssuesUpdateMilestoneResponse = {
    url: string;
    html_url: string;
    labels_url: string;
    id: number;
    node_id: string;
    number: number;
    state: string;
    title: string;
    description: string;
    creator: IssuesUpdateMilestoneResponseCreator;
    open_issues: number;
    closed_issues: number;
    created_at: string;
    updated_at: string;
    closed_at: string;
    due_on: string;
  };
  type IssuesUpdateLabelResponse = {
    id: number;
    node_id: string;
    url: string;
    name: string;
    description: string;
    color: string;
    default: boolean;
  };
  type IssuesUpdateCommentResponseUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type IssuesUpdateCommentResponse = {
    id: number;
    node_id: string;
    url: string;
    html_url: string;
    body: string;
    user: IssuesUpdateCommentResponseUser;
    created_at: string;
    updated_at: string;
  };
  type IssuesUpdateResponseClosedBy = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type IssuesUpdateResponsePullRequest = {
    url: string;
    html_url: string;
    diff_url: string;
    patch_url: string;
  };
  type IssuesUpdateResponseMilestoneCreator = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type IssuesUpdateResponseMilestone = {
    url: string;
    html_url: string;
    labels_url: string;
    id: number;
    node_id: string;
    number: number;
    state: string;
    title: string;
    description: string;
    creator: IssuesUpdateResponseMilestoneCreator;
    open_issues: number;
    closed_issues: number;
    created_at: string;
    updated_at: string;
    closed_at: string;
    due_on: string;
  };
  type IssuesUpdateResponseAssigneesItem = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type IssuesUpdateResponseAssignee = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type IssuesUpdateResponseLabelsItem = {
    id: number;
    node_id: string;
    url: string;
    name: string;
    description: string;
    color: string;
    default: boolean;
  };
  type IssuesUpdateResponseUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type IssuesUpdateResponse = {
    id: number;
    node_id: string;
    url: string;
    repository_url: string;
    labels_url: string;
    comments_url: string;
    events_url: string;
    html_url: string;
    number: number;
    state: string;
    title: string;
    body: string;
    user: IssuesUpdateResponseUser;
    labels: Array<IssuesUpdateResponseLabelsItem>;
    assignee: IssuesUpdateResponseAssignee;
    assignees: Array<IssuesUpdateResponseAssigneesItem>;
    milestone: IssuesUpdateResponseMilestone;
    locked: boolean;
    active_lock_reason: string;
    comments: number;
    pull_request: IssuesUpdateResponsePullRequest;
    closed_at: null;
    created_at: string;
    updated_at: string;
    closed_by: IssuesUpdateResponseClosedBy;
  };
  type IssuesUnlockResponse = {};
  type IssuesReplaceLabelsResponseItem = {
    id: number;
    node_id: string;
    url: string;
    name: string;
    description: string;
    color: string;
    default: boolean;
  };
  type IssuesRemoveLabelsResponse = {};
  type IssuesRemoveAssigneesResponsePullRequest = {
    url: string;
    html_url: string;
    diff_url: string;
    patch_url: string;
  };
  type IssuesRemoveAssigneesResponseMilestoneCreator = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type IssuesRemoveAssigneesResponseMilestone = {
    url: string;
    html_url: string;
    labels_url: string;
    id: number;
    node_id: string;
    number: number;
    state: string;
    title: string;
    description: string;
    creator: IssuesRemoveAssigneesResponseMilestoneCreator;
    open_issues: number;
    closed_issues: number;
    created_at: string;
    updated_at: string;
    closed_at: string;
    due_on: string;
  };
  type IssuesRemoveAssigneesResponseAssigneesItem = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type IssuesRemoveAssigneesResponseAssignee = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type IssuesRemoveAssigneesResponseLabelsItem = {
    id: number;
    node_id: string;
    url: string;
    name: string;
    description: string;
    color: string;
    default: boolean;
  };
  type IssuesRemoveAssigneesResponseUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type IssuesRemoveAssigneesResponse = {
    id: number;
    node_id: string;
    url: string;
    repository_url: string;
    labels_url: string;
    comments_url: string;
    events_url: string;
    html_url: string;
    number: number;
    state: string;
    title: string;
    body: string;
    user: IssuesRemoveAssigneesResponseUser;
    labels: Array<IssuesRemoveAssigneesResponseLabelsItem>;
    assignee: IssuesRemoveAssigneesResponseAssignee;
    assignees: Array<IssuesRemoveAssigneesResponseAssigneesItem>;
    milestone: IssuesRemoveAssigneesResponseMilestone;
    locked: boolean;
    active_lock_reason: string;
    comments: number;
    pull_request: IssuesRemoveAssigneesResponsePullRequest;
    closed_at: null;
    created_at: string;
    updated_at: string;
  };
  type IssuesLockResponse = {};
  type IssuesListMilestonesForRepoResponseItemCreator = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type IssuesListMilestonesForRepoResponseItem = {
    url: string;
    html_url: string;
    labels_url: string;
    id: number;
    node_id: string;
    number: number;
    state: string;
    title: string;
    description: string;
    creator: IssuesListMilestonesForRepoResponseItemCreator;
    open_issues: number;
    closed_issues: number;
    created_at: string;
    updated_at: string;
    closed_at: string;
    due_on: string;
  };
  type IssuesListLabelsOnIssueResponseItem = {
    id: number;
    node_id: string;
    url: string;
    name: string;
    description: string;
    color: string;
    default: boolean;
  };
  type IssuesListLabelsForRepoResponseItem = {
    id: number;
    node_id: string;
    url: string;
    name: string;
    description: string;
    color: string;
    default: boolean;
  };
  type IssuesListLabelsForMilestoneResponseItem = {
    id: number;
    node_id: string;
    url: string;
    name: string;
    description: string;
    color: string;
    default: boolean;
  };
  type IssuesListForRepoResponseItemPullRequest = {
    url: string;
    html_url: string;
    diff_url: string;
    patch_url: string;
  };
  type IssuesListForRepoResponseItemMilestoneCreator = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type IssuesListForRepoResponseItemMilestone = {
    url: string;
    html_url: string;
    labels_url: string;
    id: number;
    node_id: string;
    number: number;
    state: string;
    title: string;
    description: string;
    creator: IssuesListForRepoResponseItemMilestoneCreator;
    open_issues: number;
    closed_issues: number;
    created_at: string;
    updated_at: string;
    closed_at: string;
    due_on: string;
  };
  type IssuesListForRepoResponseItemAssigneesItem = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type IssuesListForRepoResponseItemAssignee = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type IssuesListForRepoResponseItemLabelsItem = {
    id: number;
    node_id: string;
    url: string;
    name: string;
    description: string;
    color: string;
    default: boolean;
  };
  type IssuesListForRepoResponseItemUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type IssuesListForRepoResponseItem = {
    id: number;
    node_id: string;
    url: string;
    repository_url: string;
    labels_url: string;
    comments_url: string;
    events_url: string;
    html_url: string;
    number: number;
    state: string;
    title: string;
    body: string;
    user: IssuesListForRepoResponseItemUser;
    labels: Array<IssuesListForRepoResponseItemLabelsItem>;
    assignee: IssuesListForRepoResponseItemAssignee;
    assignees: Array<IssuesListForRepoResponseItemAssigneesItem>;
    milestone: IssuesListForRepoResponseItemMilestone;
    locked: boolean;
    active_lock_reason: string;
    comments: number;
    pull_request: IssuesListForRepoResponseItemPullRequest;
    closed_at: null;
    created_at: string;
    updated_at: string;
  };
  type IssuesListForOrgResponseItemRepositoryPermissions = {
    admin: boolean;
    push: boolean;
    pull: boolean;
  };
  type IssuesListForOrgResponseItemRepositoryOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type IssuesListForOrgResponseItemRepository = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: IssuesListForOrgResponseItemRepositoryOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    clone_url: string;
    mirror_url: string;
    hooks_url: string;
    svn_url: string;
    homepage: string;
    language: null;
    forks_count: number;
    stargazers_count: number;
    watchers_count: number;
    size: number;
    default_branch: string;
    open_issues_count: number;
    topics: Array<string>;
    has_issues: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    has_pages: boolean;
    has_downloads: boolean;
    archived: boolean;
    pushed_at: string;
    created_at: string;
    updated_at: string;
    permissions: IssuesListForOrgResponseItemRepositoryPermissions;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    allow_merge_commit: boolean;
    subscribers_count: number;
    network_count: number;
  };
  type IssuesListForOrgResponseItemPullRequest = {
    url: string;
    html_url: string;
    diff_url: string;
    patch_url: string;
  };
  type IssuesListForOrgResponseItemMilestoneCreator = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type IssuesListForOrgResponseItemMilestone = {
    url: string;
    html_url: string;
    labels_url: string;
    id: number;
    node_id: string;
    number: number;
    state: string;
    title: string;
    description: string;
    creator: IssuesListForOrgResponseItemMilestoneCreator;
    open_issues: number;
    closed_issues: number;
    created_at: string;
    updated_at: string;
    closed_at: string;
    due_on: string;
  };
  type IssuesListForOrgResponseItemAssigneesItem = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type IssuesListForOrgResponseItemAssignee = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type IssuesListForOrgResponseItemLabelsItem = {
    id: number;
    node_id: string;
    url: string;
    name: string;
    description: string;
    color: string;
    default: boolean;
  };
  type IssuesListForOrgResponseItemUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type IssuesListForOrgResponseItem = {
    id: number;
    node_id: string;
    url: string;
    repository_url: string;
    labels_url: string;
    comments_url: string;
    events_url: string;
    html_url: string;
    number: number;
    state: string;
    title: string;
    body: string;
    user: IssuesListForOrgResponseItemUser;
    labels: Array<IssuesListForOrgResponseItemLabelsItem>;
    assignee: IssuesListForOrgResponseItemAssignee;
    assignees: Array<IssuesListForOrgResponseItemAssigneesItem>;
    milestone: IssuesListForOrgResponseItemMilestone;
    locked: boolean;
    active_lock_reason: string;
    comments: number;
    pull_request: IssuesListForOrgResponseItemPullRequest;
    closed_at: null;
    created_at: string;
    updated_at: string;
    repository: IssuesListForOrgResponseItemRepository;
  };
  type IssuesListForAuthenticatedUserResponseItemRepositoryPermissions = {
    admin: boolean;
    push: boolean;
    pull: boolean;
  };
  type IssuesListForAuthenticatedUserResponseItemRepositoryOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type IssuesListForAuthenticatedUserResponseItemRepository = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: IssuesListForAuthenticatedUserResponseItemRepositoryOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    clone_url: string;
    mirror_url: string;
    hooks_url: string;
    svn_url: string;
    homepage: string;
    language: null;
    forks_count: number;
    stargazers_count: number;
    watchers_count: number;
    size: number;
    default_branch: string;
    open_issues_count: number;
    topics: Array<string>;
    has_issues: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    has_pages: boolean;
    has_downloads: boolean;
    archived: boolean;
    pushed_at: string;
    created_at: string;
    updated_at: string;
    permissions: IssuesListForAuthenticatedUserResponseItemRepositoryPermissions;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    allow_merge_commit: boolean;
    subscribers_count: number;
    network_count: number;
  };
  type IssuesListForAuthenticatedUserResponseItemPullRequest = {
    url: string;
    html_url: string;
    diff_url: string;
    patch_url: string;
  };
  type IssuesListForAuthenticatedUserResponseItemMilestoneCreator = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type IssuesListForAuthenticatedUserResponseItemMilestone = {
    url: string;
    html_url: string;
    labels_url: string;
    id: number;
    node_id: string;
    number: number;
    state: string;
    title: string;
    description: string;
    creator: IssuesListForAuthenticatedUserResponseItemMilestoneCreator;
    open_issues: number;
    closed_issues: number;
    created_at: string;
    updated_at: string;
    closed_at: string;
    due_on: string;
  };
  type IssuesListForAuthenticatedUserResponseItemAssigneesItem = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type IssuesListForAuthenticatedUserResponseItemAssignee = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type IssuesListForAuthenticatedUserResponseItemLabelsItem = {
    id: number;
    node_id: string;
    url: string;
    name: string;
    description: string;
    color: string;
    default: boolean;
  };
  type IssuesListForAuthenticatedUserResponseItemUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type IssuesListForAuthenticatedUserResponseItem = {
    id: number;
    node_id: string;
    url: string;
    repository_url: string;
    labels_url: string;
    comments_url: string;
    events_url: string;
    html_url: string;
    number: number;
    state: string;
    title: string;
    body: string;
    user: IssuesListForAuthenticatedUserResponseItemUser;
    labels: Array<IssuesListForAuthenticatedUserResponseItemLabelsItem>;
    assignee: IssuesListForAuthenticatedUserResponseItemAssignee;
    assignees: Array<IssuesListForAuthenticatedUserResponseItemAssigneesItem>;
    milestone: IssuesListForAuthenticatedUserResponseItemMilestone;
    locked: boolean;
    active_lock_reason: string;
    comments: number;
    pull_request: IssuesListForAuthenticatedUserResponseItemPullRequest;
    closed_at: null;
    created_at: string;
    updated_at: string;
    repository: IssuesListForAuthenticatedUserResponseItemRepository;
  };
  type IssuesListEventsForTimelineResponseItemActor = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type IssuesListEventsForTimelineResponseItem = {
    id: number;
    node_id: string;
    url: string;
    actor: IssuesListEventsForTimelineResponseItemActor;
    event: string;
    commit_id: string;
    commit_url: string;
    created_at: string;
  };
  type IssuesListEventsForRepoResponseItemIssuePullRequest = {
    url: string;
    html_url: string;
    diff_url: string;
    patch_url: string;
  };
  type IssuesListEventsForRepoResponseItemIssueMilestoneCreator = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type IssuesListEventsForRepoResponseItemIssueMilestone = {
    url: string;
    html_url: string;
    labels_url: string;
    id: number;
    node_id: string;
    number: number;
    state: string;
    title: string;
    description: string;
    creator: IssuesListEventsForRepoResponseItemIssueMilestoneCreator;
    open_issues: number;
    closed_issues: number;
    created_at: string;
    updated_at: string;
    closed_at: string;
    due_on: string;
  };
  type IssuesListEventsForRepoResponseItemIssueAssigneesItem = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type IssuesListEventsForRepoResponseItemIssueAssignee = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type IssuesListEventsForRepoResponseItemIssueLabelsItem = {
    id: number;
    node_id: string;
    url: string;
    name: string;
    description: string;
    color: string;
    default: boolean;
  };
  type IssuesListEventsForRepoResponseItemIssueUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type IssuesListEventsForRepoResponseItemIssue = {
    id: number;
    node_id: string;
    url: string;
    repository_url: string;
    labels_url: string;
    comments_url: string;
    events_url: string;
    html_url: string;
    number: number;
    state: string;
    title: string;
    body: string;
    user: IssuesListEventsForRepoResponseItemIssueUser;
    labels: Array<IssuesListEventsForRepoResponseItemIssueLabelsItem>;
    assignee: IssuesListEventsForRepoResponseItemIssueAssignee;
    assignees: Array<IssuesListEventsForRepoResponseItemIssueAssigneesItem>;
    milestone: IssuesListEventsForRepoResponseItemIssueMilestone;
    locked: boolean;
    active_lock_reason: string;
    comments: number;
    pull_request: IssuesListEventsForRepoResponseItemIssuePullRequest;
    closed_at: null;
    created_at: string;
    updated_at: string;
  };
  type IssuesListEventsForRepoResponseItemActor = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type IssuesListEventsForRepoResponseItem = {
    id: number;
    node_id: string;
    url: string;
    actor: IssuesListEventsForRepoResponseItemActor;
    event: string;
    commit_id: string;
    commit_url: string;
    created_at: string;
    issue: IssuesListEventsForRepoResponseItemIssue;
  };
  type IssuesListEventsResponseItemActor = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type IssuesListEventsResponseItem = {
    id: number;
    node_id: string;
    url: string;
    actor: IssuesListEventsResponseItemActor;
    event: string;
    commit_id: string;
    commit_url: string;
    created_at: string;
  };
  type IssuesListCommentsForRepoResponseItemUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type IssuesListCommentsForRepoResponseItem = {
    id: number;
    node_id: string;
    url: string;
    html_url: string;
    body: string;
    user: IssuesListCommentsForRepoResponseItemUser;
    created_at: string;
    updated_at: string;
  };
  type IssuesListCommentsResponseItemUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type IssuesListCommentsResponseItem = {
    id: number;
    node_id: string;
    url: string;
    html_url: string;
    body: string;
    user: IssuesListCommentsResponseItemUser;
    created_at: string;
    updated_at: string;
  };
  type IssuesListAssigneesResponseItem = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type IssuesListResponseItemRepositoryPermissions = {
    admin: boolean;
    push: boolean;
    pull: boolean;
  };
  type IssuesListResponseItemRepositoryOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type IssuesListResponseItemRepository = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: IssuesListResponseItemRepositoryOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    clone_url: string;
    mirror_url: string;
    hooks_url: string;
    svn_url: string;
    homepage: string;
    language: null;
    forks_count: number;
    stargazers_count: number;
    watchers_count: number;
    size: number;
    default_branch: string;
    open_issues_count: number;
    topics: Array<string>;
    has_issues: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    has_pages: boolean;
    has_downloads: boolean;
    archived: boolean;
    pushed_at: string;
    created_at: string;
    updated_at: string;
    permissions: IssuesListResponseItemRepositoryPermissions;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    allow_merge_commit: boolean;
    subscribers_count: number;
    network_count: number;
  };
  type IssuesListResponseItemPullRequest = {
    url: string;
    html_url: string;
    diff_url: string;
    patch_url: string;
  };
  type IssuesListResponseItemMilestoneCreator = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type IssuesListResponseItemMilestone = {
    url: string;
    html_url: string;
    labels_url: string;
    id: number;
    node_id: string;
    number: number;
    state: string;
    title: string;
    description: string;
    creator: IssuesListResponseItemMilestoneCreator;
    open_issues: number;
    closed_issues: number;
    created_at: string;
    updated_at: string;
    closed_at: string;
    due_on: string;
  };
  type IssuesListResponseItemAssigneesItem = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type IssuesListResponseItemAssignee = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type IssuesListResponseItemLabelsItem = {
    id: number;
    node_id: string;
    url: string;
    name: string;
    description: string;
    color: string;
    default: boolean;
  };
  type IssuesListResponseItemUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type IssuesListResponseItem = {
    id: number;
    node_id: string;
    url: string;
    repository_url: string;
    labels_url: string;
    comments_url: string;
    events_url: string;
    html_url: string;
    number: number;
    state: string;
    title: string;
    body: string;
    user: IssuesListResponseItemUser;
    labels: Array<IssuesListResponseItemLabelsItem>;
    assignee: IssuesListResponseItemAssignee;
    assignees: Array<IssuesListResponseItemAssigneesItem>;
    milestone: IssuesListResponseItemMilestone;
    locked: boolean;
    active_lock_reason: string;
    comments: number;
    pull_request: IssuesListResponseItemPullRequest;
    closed_at: null;
    created_at: string;
    updated_at: string;
    repository: IssuesListResponseItemRepository;
  };
  type IssuesGetMilestoneResponseCreator = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type IssuesGetMilestoneResponse = {
    url: string;
    html_url: string;
    labels_url: string;
    id: number;
    node_id: string;
    number: number;
    state: string;
    title: string;
    description: string;
    creator: IssuesGetMilestoneResponseCreator;
    open_issues: number;
    closed_issues: number;
    created_at: string;
    updated_at: string;
    closed_at: string;
    due_on: string;
  };
  type IssuesGetLabelResponse = {
    id: number;
    node_id: string;
    url: string;
    name: string;
    description: string;
    color: string;
    default: boolean;
  };
  type IssuesGetEventResponseIssuePullRequest = {
    url: string;
    html_url: string;
    diff_url: string;
    patch_url: string;
  };
  type IssuesGetEventResponseIssueMilestoneCreator = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type IssuesGetEventResponseIssueMilestone = {
    url: string;
    html_url: string;
    labels_url: string;
    id: number;
    node_id: string;
    number: number;
    state: string;
    title: string;
    description: string;
    creator: IssuesGetEventResponseIssueMilestoneCreator;
    open_issues: number;
    closed_issues: number;
    created_at: string;
    updated_at: string;
    closed_at: string;
    due_on: string;
  };
  type IssuesGetEventResponseIssueAssigneesItem = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type IssuesGetEventResponseIssueAssignee = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type IssuesGetEventResponseIssueLabelsItem = {
    id: number;
    node_id: string;
    url: string;
    name: string;
    description: string;
    color: string;
    default: boolean;
  };
  type IssuesGetEventResponseIssueUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type IssuesGetEventResponseIssue = {
    id: number;
    node_id: string;
    url: string;
    repository_url: string;
    labels_url: string;
    comments_url: string;
    events_url: string;
    html_url: string;
    number: number;
    state: string;
    title: string;
    body: string;
    user: IssuesGetEventResponseIssueUser;
    labels: Array<IssuesGetEventResponseIssueLabelsItem>;
    assignee: IssuesGetEventResponseIssueAssignee;
    assignees: Array<IssuesGetEventResponseIssueAssigneesItem>;
    milestone: IssuesGetEventResponseIssueMilestone;
    locked: boolean;
    active_lock_reason: string;
    comments: number;
    pull_request: IssuesGetEventResponseIssuePullRequest;
    closed_at: null;
    created_at: string;
    updated_at: string;
  };
  type IssuesGetEventResponseActor = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type IssuesGetEventResponse = {
    id: number;
    node_id: string;
    url: string;
    actor: IssuesGetEventResponseActor;
    event: string;
    commit_id: string;
    commit_url: string;
    created_at: string;
    issue: IssuesGetEventResponseIssue;
  };
  type IssuesGetCommentResponseUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type IssuesGetCommentResponse = {
    id: number;
    node_id: string;
    url: string;
    html_url: string;
    body: string;
    user: IssuesGetCommentResponseUser;
    created_at: string;
    updated_at: string;
  };
  type IssuesGetResponseClosedBy = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type IssuesGetResponsePullRequest = {
    url: string;
    html_url: string;
    diff_url: string;
    patch_url: string;
  };
  type IssuesGetResponseMilestoneCreator = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type IssuesGetResponseMilestone = {
    url: string;
    html_url: string;
    labels_url: string;
    id: number;
    node_id: string;
    number: number;
    state: string;
    title: string;
    description: string;
    creator: IssuesGetResponseMilestoneCreator;
    open_issues: number;
    closed_issues: number;
    created_at: string;
    updated_at: string;
    closed_at: string;
    due_on: string;
  };
  type IssuesGetResponseAssigneesItem = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type IssuesGetResponseAssignee = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type IssuesGetResponseLabelsItem = {
    id: number;
    node_id: string;
    url: string;
    name: string;
    description: string;
    color: string;
    default: boolean;
  };
  type IssuesGetResponseUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type IssuesGetResponse = {
    id: number;
    node_id: string;
    url: string;
    repository_url: string;
    labels_url: string;
    comments_url: string;
    events_url: string;
    html_url: string;
    number: number;
    state: string;
    title: string;
    body: string;
    user: IssuesGetResponseUser;
    labels: Array<IssuesGetResponseLabelsItem>;
    assignee: IssuesGetResponseAssignee;
    assignees: Array<IssuesGetResponseAssigneesItem>;
    milestone: IssuesGetResponseMilestone;
    locked: boolean;
    active_lock_reason: string;
    comments: number;
    pull_request: IssuesGetResponsePullRequest;
    closed_at: null;
    created_at: string;
    updated_at: string;
    closed_by: IssuesGetResponseClosedBy;
  };
  type IssuesDeleteMilestoneResponse = {};
  type IssuesDeleteLabelResponse = {};
  type IssuesDeleteCommentResponse = {};
  type IssuesCreateMilestoneResponseCreator = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type IssuesCreateMilestoneResponse = {
    url: string;
    html_url: string;
    labels_url: string;
    id: number;
    node_id: string;
    number: number;
    state: string;
    title: string;
    description: string;
    creator: IssuesCreateMilestoneResponseCreator;
    open_issues: number;
    closed_issues: number;
    created_at: string;
    updated_at: string;
    closed_at: string;
    due_on: string;
  };
  type IssuesCreateLabelResponse = {
    id: number;
    node_id: string;
    url: string;
    name: string;
    description: string;
    color: string;
    default: boolean;
  };
  type IssuesCreateCommentResponseUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type IssuesCreateCommentResponse = {
    id: number;
    node_id: string;
    url: string;
    html_url: string;
    body: string;
    user: IssuesCreateCommentResponseUser;
    created_at: string;
    updated_at: string;
  };
  type IssuesCreateResponseClosedBy = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type IssuesCreateResponsePullRequest = {
    url: string;
    html_url: string;
    diff_url: string;
    patch_url: string;
  };
  type IssuesCreateResponseMilestoneCreator = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type IssuesCreateResponseMilestone = {
    url: string;
    html_url: string;
    labels_url: string;
    id: number;
    node_id: string;
    number: number;
    state: string;
    title: string;
    description: string;
    creator: IssuesCreateResponseMilestoneCreator;
    open_issues: number;
    closed_issues: number;
    created_at: string;
    updated_at: string;
    closed_at: string;
    due_on: string;
  };
  type IssuesCreateResponseAssigneesItem = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type IssuesCreateResponseAssignee = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type IssuesCreateResponseLabelsItem = {
    id: number;
    node_id: string;
    url: string;
    name: string;
    description: string;
    color: string;
    default: boolean;
  };
  type IssuesCreateResponseUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type IssuesCreateResponse = {
    id: number;
    node_id: string;
    url: string;
    repository_url: string;
    labels_url: string;
    comments_url: string;
    events_url: string;
    html_url: string;
    number: number;
    state: string;
    title: string;
    body: string;
    user: IssuesCreateResponseUser;
    labels: Array<IssuesCreateResponseLabelsItem>;
    assignee: IssuesCreateResponseAssignee;
    assignees: Array<IssuesCreateResponseAssigneesItem>;
    milestone: IssuesCreateResponseMilestone;
    locked: boolean;
    active_lock_reason: string;
    comments: number;
    pull_request: IssuesCreateResponsePullRequest;
    closed_at: null;
    created_at: string;
    updated_at: string;
    closed_by: IssuesCreateResponseClosedBy;
  };
  type IssuesCheckAssigneeResponse = {};
  type IssuesAddLabelsResponseItem = {
    id: number;
    node_id: string;
    url: string;
    name: string;
    description: string;
    color: string;
    default: boolean;
  };
  type IssuesAddAssigneesResponsePullRequest = {
    url: string;
    html_url: string;
    diff_url: string;
    patch_url: string;
  };
  type IssuesAddAssigneesResponseMilestoneCreator = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type IssuesAddAssigneesResponseMilestone = {
    url: string;
    html_url: string;
    labels_url: string;
    id: number;
    node_id: string;
    number: number;
    state: string;
    title: string;
    description: string;
    creator: IssuesAddAssigneesResponseMilestoneCreator;
    open_issues: number;
    closed_issues: number;
    created_at: string;
    updated_at: string;
    closed_at: string;
    due_on: string;
  };
  type IssuesAddAssigneesResponseAssigneesItem = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type IssuesAddAssigneesResponseAssignee = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type IssuesAddAssigneesResponseLabelsItem = {
    id: number;
    node_id: string;
    url: string;
    name: string;
    description: string;
    color: string;
    default: boolean;
  };
  type IssuesAddAssigneesResponseUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type IssuesAddAssigneesResponse = {
    id: number;
    node_id: string;
    url: string;
    repository_url: string;
    labels_url: string;
    comments_url: string;
    events_url: string;
    html_url: string;
    number: number;
    state: string;
    title: string;
    body: string;
    user: IssuesAddAssigneesResponseUser;
    labels: Array<IssuesAddAssigneesResponseLabelsItem>;
    assignee: IssuesAddAssigneesResponseAssignee;
    assignees: Array<IssuesAddAssigneesResponseAssigneesItem>;
    milestone: IssuesAddAssigneesResponseMilestone;
    locked: boolean;
    active_lock_reason: string;
    comments: number;
    pull_request: IssuesAddAssigneesResponsePullRequest;
    closed_at: null;
    created_at: string;
    updated_at: string;
  };
  type GitignoreGetTemplateResponse = { name?: string; source?: string };
  type GitdataUpdateRefResponseObject = {
    type: string;
    sha: string;
    url: string;
  };
  type GitdataUpdateRefResponse = {
    ref: string;
    node_id: string;
    url: string;
    object: GitdataUpdateRefResponseObject;
  };
  type GitdataGetTagResponseVerification = {
    verified: boolean;
    reason: string;
    signature: null;
    payload: null;
  };
  type GitdataGetTagResponseObject = { type: string; sha: string; url: string };
  type GitdataGetTagResponseTagger = {
    name: string;
    email: string;
    date: string;
  };
  type GitdataGetTagResponse = {
    node_id: string;
    tag: string;
    sha: string;
    url: string;
    message: string;
    tagger: GitdataGetTagResponseTagger;
    object: GitdataGetTagResponseObject;
    verification: GitdataGetTagResponseVerification;
  };
  type GitdataGetCommitResponseVerification = {
    verified: boolean;
    reason: string;
    signature: null;
    payload: null;
  };
  type GitdataGetCommitResponseParentsItem = { url: string; sha: string };
  type GitdataGetCommitResponseTree = { url: string; sha: string };
  type GitdataGetCommitResponseCommitter = {
    date: string;
    name: string;
    email: string;
  };
  type GitdataGetCommitResponseAuthor = {
    date: string;
    name: string;
    email: string;
  };
  type GitdataGetCommitResponse = {
    sha: string;
    url: string;
    author: GitdataGetCommitResponseAuthor;
    committer: GitdataGetCommitResponseCommitter;
    message: string;
    tree: GitdataGetCommitResponseTree;
    parents: Array<GitdataGetCommitResponseParentsItem>;
    verification: GitdataGetCommitResponseVerification;
  };
  type GitdataGetBlobResponse = {
    content: string;
    encoding: string;
    url: string;
    sha: string;
    size: number;
  };
  type GitdataDeleteRefResponse = {};
  type GitdataCreateTreeResponseTreeItem = {
    path: string;
    mode: string;
    type: string;
    size: number;
    sha: string;
    url: string;
  };
  type GitdataCreateTreeResponse = {
    sha: string;
    url: string;
    tree: Array<GitdataCreateTreeResponseTreeItem>;
  };
  type GitdataCreateTagResponseVerification = {
    verified: boolean;
    reason: string;
    signature: null;
    payload: null;
  };
  type GitdataCreateTagResponseObject = {
    type: string;
    sha: string;
    url: string;
  };
  type GitdataCreateTagResponseTagger = {
    name: string;
    email: string;
    date: string;
  };
  type GitdataCreateTagResponse = {
    node_id: string;
    tag: string;
    sha: string;
    url: string;
    message: string;
    tagger: GitdataCreateTagResponseTagger;
    object: GitdataCreateTagResponseObject;
    verification: GitdataCreateTagResponseVerification;
  };
  type GitdataCreateRefResponseObject = {
    type: string;
    sha: string;
    url: string;
  };
  type GitdataCreateRefResponse = {
    ref: string;
    node_id: string;
    url: string;
    object: GitdataCreateRefResponseObject;
  };
  type GitdataCreateCommitResponseVerification = {
    verified: boolean;
    reason: string;
    signature: null;
    payload: null;
  };
  type GitdataCreateCommitResponseParentsItem = { url: string; sha: string };
  type GitdataCreateCommitResponseTree = { url: string; sha: string };
  type GitdataCreateCommitResponseCommitter = {
    date: string;
    name: string;
    email: string;
  };
  type GitdataCreateCommitResponseAuthor = {
    date: string;
    name: string;
    email: string;
  };
  type GitdataCreateCommitResponse = {
    sha: string;
    node_id: string;
    url: string;
    author: GitdataCreateCommitResponseAuthor;
    committer: GitdataCreateCommitResponseCommitter;
    message: string;
    tree: GitdataCreateCommitResponseTree;
    parents: Array<GitdataCreateCommitResponseParentsItem>;
    verification: GitdataCreateCommitResponseVerification;
  };
  type GitdataCreateBlobResponse = { url: string; sha: string };
  type GistsUpdateCommentResponseUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type GistsUpdateCommentResponse = {
    id: number;
    node_id: string;
    url: string;
    body: string;
    user: GistsUpdateCommentResponseUser;
    created_at: string;
    updated_at: string;
  };
  type GistsUpdateResponseHistoryItemChangeStatus = {
    deletions: number;
    additions: number;
    total: number;
  };
  type GistsUpdateResponseHistoryItemUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type GistsUpdateResponseHistoryItem = {
    url: string;
    version: string;
    user: GistsUpdateResponseHistoryItemUser;
    change_status: GistsUpdateResponseHistoryItemChangeStatus;
    committed_at: string;
  };
  type GistsUpdateResponseForksItemUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type GistsUpdateResponseForksItem = {
    user: GistsUpdateResponseForksItemUser;
    url: string;
    id: string;
    created_at: string;
    updated_at: string;
  };
  type GistsUpdateResponseOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type GistsUpdateResponseFilesNewFileTxt = {
    filename: string;
    type: string;
    language: string;
    raw_url: string;
    size: number;
    truncated: boolean;
    content: string;
  };
  type GistsUpdateResponseFilesHelloWorldMd = {
    filename: string;
    type: string;
    language: string;
    raw_url: string;
    size: number;
    truncated: boolean;
    content: string;
  };
  type GistsUpdateResponseFilesHelloWorldPy = {
    filename: string;
    type: string;
    language: string;
    raw_url: string;
    size: number;
    truncated: boolean;
    content: string;
  };
  type GistsUpdateResponseFilesHelloWorldRb = {
    filename: string;
    type: string;
    language: string;
    raw_url: string;
    size: number;
    truncated: boolean;
    content: string;
  };
  type GistsUpdateResponseFiles = {
    "hello_world.rb": GistsUpdateResponseFilesHelloWorldRb;
    "hello_world.py": GistsUpdateResponseFilesHelloWorldPy;
    "hello_world.md": GistsUpdateResponseFilesHelloWorldMd;
    "new_file.txt": GistsUpdateResponseFilesNewFileTxt;
  };
  type GistsUpdateResponse = {
    url: string;
    forks_url: string;
    commits_url: string;
    id: string;
    node_id: string;
    git_pull_url: string;
    git_push_url: string;
    html_url: string;
    files: GistsUpdateResponseFiles;
    public: boolean;
    created_at: string;
    updated_at: string;
    description: string;
    comments: number;
    user: null;
    comments_url: string;
    owner: GistsUpdateResponseOwner;
    truncated: boolean;
    forks: Array<GistsUpdateResponseForksItem>;
    history: Array<GistsUpdateResponseHistoryItem>;
  };
  type GistsUnstarResponse = {};
  type GistsStarResponse = {};
  type GistsListStarredResponseItemOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type GistsListStarredResponseItemFilesHelloWorldRb = {
    filename: string;
    type: string;
    language: string;
    raw_url: string;
    size: number;
  };
  type GistsListStarredResponseItemFiles = {
    "hello_world.rb": GistsListStarredResponseItemFilesHelloWorldRb;
  };
  type GistsListStarredResponseItem = {
    url: string;
    forks_url: string;
    commits_url: string;
    id: string;
    node_id: string;
    git_pull_url: string;
    git_push_url: string;
    html_url: string;
    files: GistsListStarredResponseItemFiles;
    public: boolean;
    created_at: string;
    updated_at: string;
    description: string;
    comments: number;
    user: null;
    comments_url: string;
    owner: GistsListStarredResponseItemOwner;
    truncated: boolean;
  };
  type GistsListPublicForUserResponseItemOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type GistsListPublicForUserResponseItemFilesHelloWorldRb = {
    filename: string;
    type: string;
    language: string;
    raw_url: string;
    size: number;
  };
  type GistsListPublicForUserResponseItemFiles = {
    "hello_world.rb": GistsListPublicForUserResponseItemFilesHelloWorldRb;
  };
  type GistsListPublicForUserResponseItem = {
    url: string;
    forks_url: string;
    commits_url: string;
    id: string;
    node_id: string;
    git_pull_url: string;
    git_push_url: string;
    html_url: string;
    files: GistsListPublicForUserResponseItemFiles;
    public: boolean;
    created_at: string;
    updated_at: string;
    description: string;
    comments: number;
    user: null;
    comments_url: string;
    owner: GistsListPublicForUserResponseItemOwner;
    truncated: boolean;
  };
  type GistsListPublicResponseItemOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type GistsListPublicResponseItemFilesHelloWorldRb = {
    filename: string;
    type: string;
    language: string;
    raw_url: string;
    size: number;
  };
  type GistsListPublicResponseItemFiles = {
    "hello_world.rb": GistsListPublicResponseItemFilesHelloWorldRb;
  };
  type GistsListPublicResponseItem = {
    url: string;
    forks_url: string;
    commits_url: string;
    id: string;
    node_id: string;
    git_pull_url: string;
    git_push_url: string;
    html_url: string;
    files: GistsListPublicResponseItemFiles;
    public: boolean;
    created_at: string;
    updated_at: string;
    description: string;
    comments: number;
    user: null;
    comments_url: string;
    owner: GistsListPublicResponseItemOwner;
    truncated: boolean;
  };
  type GistsListForksResponseItemUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type GistsListForksResponseItem = {
    user: GistsListForksResponseItemUser;
    url: string;
    id: string;
    created_at: string;
    updated_at: string;
  };
  type GistsListCommitsResponseItemChangeStatus = {
    deletions: number;
    additions: number;
    total: number;
  };
  type GistsListCommitsResponseItemUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type GistsListCommitsResponseItem = {
    url: string;
    version: string;
    user: GistsListCommitsResponseItemUser;
    change_status: GistsListCommitsResponseItemChangeStatus;
    committed_at: string;
  };
  type GistsListCommentsResponseItemUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type GistsListCommentsResponseItem = {
    id: number;
    node_id: string;
    url: string;
    body: string;
    user: GistsListCommentsResponseItemUser;
    created_at: string;
    updated_at: string;
  };
  type GistsListResponseItemOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type GistsListResponseItemFilesHelloWorldRb = {
    filename: string;
    type: string;
    language: string;
    raw_url: string;
    size: number;
  };
  type GistsListResponseItemFiles = {
    "hello_world.rb": GistsListResponseItemFilesHelloWorldRb;
  };
  type GistsListResponseItem = {
    url: string;
    forks_url: string;
    commits_url: string;
    id: string;
    node_id: string;
    git_pull_url: string;
    git_push_url: string;
    html_url: string;
    files: GistsListResponseItemFiles;
    public: boolean;
    created_at: string;
    updated_at: string;
    description: string;
    comments: number;
    user: null;
    comments_url: string;
    owner: GistsListResponseItemOwner;
    truncated: boolean;
  };
  type GistsGetRevisionResponseHistoryItemChangeStatus = {
    deletions: number;
    additions: number;
    total: number;
  };
  type GistsGetRevisionResponseHistoryItemUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type GistsGetRevisionResponseHistoryItem = {
    url: string;
    version: string;
    user: GistsGetRevisionResponseHistoryItemUser;
    change_status: GistsGetRevisionResponseHistoryItemChangeStatus;
    committed_at: string;
  };
  type GistsGetRevisionResponseForksItemUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type GistsGetRevisionResponseForksItem = {
    user: GistsGetRevisionResponseForksItemUser;
    url: string;
    id: string;
    created_at: string;
    updated_at: string;
  };
  type GistsGetRevisionResponseOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type GistsGetRevisionResponseFilesHelloWorldPythonTxt = {
    filename: string;
    type: string;
    language: string;
    raw_url: string;
    size: number;
    truncated: boolean;
    content: string;
  };
  type GistsGetRevisionResponseFilesHelloWorldRubyTxt = {
    filename: string;
    type: string;
    language: string;
    raw_url: string;
    size: number;
    truncated: boolean;
    content: string;
  };
  type GistsGetRevisionResponseFilesHelloWorldPy = {
    filename: string;
    type: string;
    language: string;
    raw_url: string;
    size: number;
    truncated: boolean;
    content: string;
  };
  type GistsGetRevisionResponseFilesHelloWorldRb = {
    filename: string;
    type: string;
    language: string;
    raw_url: string;
    size: number;
    truncated: boolean;
    content: string;
  };
  type GistsGetRevisionResponseFiles = {
    "hello_world.rb": GistsGetRevisionResponseFilesHelloWorldRb;
    "hello_world.py": GistsGetRevisionResponseFilesHelloWorldPy;
    "hello_world_ruby.txt": GistsGetRevisionResponseFilesHelloWorldRubyTxt;
    "hello_world_python.txt": GistsGetRevisionResponseFilesHelloWorldPythonTxt;
  };
  type GistsGetRevisionResponse = {
    url: string;
    forks_url: string;
    commits_url: string;
    id: string;
    node_id: string;
    git_pull_url: string;
    git_push_url: string;
    html_url: string;
    files: GistsGetRevisionResponseFiles;
    public: boolean;
    created_at: string;
    updated_at: string;
    description: string;
    comments: number;
    user: null;
    comments_url: string;
    owner: GistsGetRevisionResponseOwner;
    truncated: boolean;
    forks: Array<GistsGetRevisionResponseForksItem>;
    history: Array<GistsGetRevisionResponseHistoryItem>;
  };
  type GistsGetCommentResponseUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type GistsGetCommentResponse = {
    id: number;
    node_id: string;
    url: string;
    body: string;
    user: GistsGetCommentResponseUser;
    created_at: string;
    updated_at: string;
  };
  type GistsGetResponseHistoryItemChangeStatus = {
    deletions: number;
    additions: number;
    total: number;
  };
  type GistsGetResponseHistoryItemUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type GistsGetResponseHistoryItem = {
    url: string;
    version: string;
    user: GistsGetResponseHistoryItemUser;
    change_status: GistsGetResponseHistoryItemChangeStatus;
    committed_at: string;
  };
  type GistsGetResponseForksItemUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type GistsGetResponseForksItem = {
    user: GistsGetResponseForksItemUser;
    url: string;
    id: string;
    created_at: string;
    updated_at: string;
  };
  type GistsGetResponseOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type GistsGetResponseFilesHelloWorldPythonTxt = {
    filename: string;
    type: string;
    language: string;
    raw_url: string;
    size: number;
    truncated: boolean;
    content: string;
  };
  type GistsGetResponseFilesHelloWorldRubyTxt = {
    filename: string;
    type: string;
    language: string;
    raw_url: string;
    size: number;
    truncated: boolean;
    content: string;
  };
  type GistsGetResponseFilesHelloWorldPy = {
    filename: string;
    type: string;
    language: string;
    raw_url: string;
    size: number;
    truncated: boolean;
    content: string;
  };
  type GistsGetResponseFilesHelloWorldRb = {
    filename: string;
    type: string;
    language: string;
    raw_url: string;
    size: number;
    truncated: boolean;
    content: string;
  };
  type GistsGetResponseFiles = {
    "hello_world.rb": GistsGetResponseFilesHelloWorldRb;
    "hello_world.py": GistsGetResponseFilesHelloWorldPy;
    "hello_world_ruby.txt": GistsGetResponseFilesHelloWorldRubyTxt;
    "hello_world_python.txt": GistsGetResponseFilesHelloWorldPythonTxt;
  };
  type GistsGetResponse = {
    url: string;
    forks_url: string;
    commits_url: string;
    id: string;
    node_id: string;
    git_pull_url: string;
    git_push_url: string;
    html_url: string;
    files: GistsGetResponseFiles;
    public: boolean;
    created_at: string;
    updated_at: string;
    description: string;
    comments: number;
    user: null;
    comments_url: string;
    owner: GistsGetResponseOwner;
    truncated: boolean;
    forks: Array<GistsGetResponseForksItem>;
    history: Array<GistsGetResponseHistoryItem>;
  };
  type GistsForkResponseOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type GistsForkResponseFilesHelloWorldRb = {
    filename: string;
    type: string;
    language: string;
    raw_url: string;
    size: number;
  };
  type GistsForkResponseFiles = {
    "hello_world.rb": GistsForkResponseFilesHelloWorldRb;
  };
  type GistsForkResponse = {
    url: string;
    forks_url: string;
    commits_url: string;
    id: string;
    node_id: string;
    git_pull_url: string;
    git_push_url: string;
    html_url: string;
    files: GistsForkResponseFiles;
    public: boolean;
    created_at: string;
    updated_at: string;
    description: string;
    comments: number;
    user: null;
    comments_url: string;
    owner: GistsForkResponseOwner;
    truncated: boolean;
  };
  type GistsDeleteCommentResponse = {};
  type GistsDeleteResponse = {};
  type GistsCreateCommentResponseUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type GistsCreateCommentResponse = {
    id: number;
    node_id: string;
    url: string;
    body: string;
    user: GistsCreateCommentResponseUser;
    created_at: string;
    updated_at: string;
  };
  type GistsCreateResponseHistoryItemChangeStatus = {
    deletions: number;
    additions: number;
    total: number;
  };
  type GistsCreateResponseHistoryItemUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type GistsCreateResponseHistoryItem = {
    url: string;
    version: string;
    user: GistsCreateResponseHistoryItemUser;
    change_status: GistsCreateResponseHistoryItemChangeStatus;
    committed_at: string;
  };
  type GistsCreateResponseForksItemUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type GistsCreateResponseForksItem = {
    user: GistsCreateResponseForksItemUser;
    url: string;
    id: string;
    created_at: string;
    updated_at: string;
  };
  type GistsCreateResponseOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type GistsCreateResponseFilesHelloWorldPythonTxt = {
    filename: string;
    type: string;
    language: string;
    raw_url: string;
    size: number;
    truncated: boolean;
    content: string;
  };
  type GistsCreateResponseFilesHelloWorldRubyTxt = {
    filename: string;
    type: string;
    language: string;
    raw_url: string;
    size: number;
    truncated: boolean;
    content: string;
  };
  type GistsCreateResponseFilesHelloWorldPy = {
    filename: string;
    type: string;
    language: string;
    raw_url: string;
    size: number;
    truncated: boolean;
    content: string;
  };
  type GistsCreateResponseFilesHelloWorldRb = {
    filename: string;
    type: string;
    language: string;
    raw_url: string;
    size: number;
    truncated: boolean;
    content: string;
  };
  type GistsCreateResponseFiles = {
    "hello_world.rb": GistsCreateResponseFilesHelloWorldRb;
    "hello_world.py": GistsCreateResponseFilesHelloWorldPy;
    "hello_world_ruby.txt": GistsCreateResponseFilesHelloWorldRubyTxt;
    "hello_world_python.txt": GistsCreateResponseFilesHelloWorldPythonTxt;
  };
  type GistsCreateResponse = {
    url: string;
    forks_url: string;
    commits_url: string;
    id: string;
    node_id: string;
    git_pull_url: string;
    git_push_url: string;
    html_url: string;
    files: GistsCreateResponseFiles;
    public: boolean;
    created_at: string;
    updated_at: string;
    description: string;
    comments: number;
    user: null;
    comments_url: string;
    owner: GistsCreateResponseOwner;
    truncated: boolean;
    forks: Array<GistsCreateResponseForksItem>;
    history: Array<GistsCreateResponseHistoryItem>;
  };
  type EmojisGetResponse = {};
  type CodesOfConductListConductCodesResponseItem = {
    key: string;
    name: string;
    url: string;
  };
  type CodesOfConductGetForRepoResponse = {
    key: string;
    name: string;
    url: string;
    body: string;
  };
  type CodesOfConductGetConductCodeResponse = {
    key: string;
    name: string;
    url: string;
    body: string;
  };
  type ChecksUpdateResponsePullRequestsItemBaseRepo = {
    id: number;
    url: string;
    name: string;
  };
  type ChecksUpdateResponsePullRequestsItemBase = {
    ref: string;
    sha: string;
    repo: ChecksUpdateResponsePullRequestsItemBaseRepo;
  };
  type ChecksUpdateResponsePullRequestsItemHeadRepo = {
    id: number;
    url: string;
    name: string;
  };
  type ChecksUpdateResponsePullRequestsItemHead = {
    ref: string;
    sha: string;
    repo: ChecksUpdateResponsePullRequestsItemHeadRepo;
  };
  type ChecksUpdateResponsePullRequestsItem = {
    url: string;
    id: number;
    number: number;
    head: ChecksUpdateResponsePullRequestsItemHead;
    base: ChecksUpdateResponsePullRequestsItemBase;
  };
  type ChecksUpdateResponseAppOwner = {
    login: string;
    id: number;
    node_id: string;
    url: string;
    repos_url: string;
    events_url: string;
    hooks_url: string;
    issues_url: string;
    members_url: string;
    public_members_url: string;
    avatar_url: string;
    description: string;
  };
  type ChecksUpdateResponseApp = {
    id: number;
    node_id: string;
    owner: ChecksUpdateResponseAppOwner;
    name: string;
    description: string;
    external_url: string;
    html_url: string;
    created_at: string;
    updated_at: string;
  };
  type ChecksUpdateResponseCheckSuite = { id: number };
  type ChecksUpdateResponseOutput = {
    title: string;
    summary: string;
    text: string;
    annotations_count: number;
    annotations_url: string;
  };
  type ChecksUpdateResponse = {
    id: number;
    head_sha: string;
    node_id: string;
    external_id: string;
    url: string;
    html_url: string;
    details_url: string;
    status: string;
    conclusion: string;
    started_at: string;
    completed_at: string;
    output: ChecksUpdateResponseOutput;
    name: string;
    check_suite: ChecksUpdateResponseCheckSuite;
    app: ChecksUpdateResponseApp;
    pull_requests: Array<ChecksUpdateResponsePullRequestsItem>;
  };
  type ChecksSetSuitesPreferencesResponseRepositoryPermissions = {
    admin: boolean;
    push: boolean;
    pull: boolean;
  };
  type ChecksSetSuitesPreferencesResponseRepositoryOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ChecksSetSuitesPreferencesResponseRepository = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: ChecksSetSuitesPreferencesResponseRepositoryOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    clone_url: string;
    mirror_url: string;
    hooks_url: string;
    svn_url: string;
    homepage: string;
    language: null;
    forks_count: number;
    stargazers_count: number;
    watchers_count: number;
    size: number;
    default_branch: string;
    open_issues_count: number;
    topics: Array<string>;
    has_issues: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    has_pages: boolean;
    has_downloads: boolean;
    archived: boolean;
    pushed_at: string;
    created_at: string;
    updated_at: string;
    permissions: ChecksSetSuitesPreferencesResponseRepositoryPermissions;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    allow_merge_commit: boolean;
    subscribers_count: number;
    network_count: number;
  };
  type ChecksSetSuitesPreferencesResponsePreferencesAutoTriggerChecksItem = {
    app_id: number;
    setting: boolean;
  };
  type ChecksSetSuitesPreferencesResponsePreferences = {
    auto_trigger_checks: Array<
      ChecksSetSuitesPreferencesResponsePreferencesAutoTriggerChecksItem
    >;
  };
  type ChecksSetSuitesPreferencesResponse = {
    preferences: ChecksSetSuitesPreferencesResponsePreferences;
    repository: ChecksSetSuitesPreferencesResponseRepository;
  };
  type ChecksRerequestSuiteResponse = {};
  type ChecksListSuitesForRefResponseCheckSuitesItemRepositoryPermissions = {
    admin: boolean;
    push: boolean;
    pull: boolean;
  };
  type ChecksListSuitesForRefResponseCheckSuitesItemRepositoryOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ChecksListSuitesForRefResponseCheckSuitesItemRepository = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: ChecksListSuitesForRefResponseCheckSuitesItemRepositoryOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    clone_url: string;
    mirror_url: string;
    hooks_url: string;
    svn_url: string;
    homepage: string;
    language: null;
    forks_count: number;
    stargazers_count: number;
    watchers_count: number;
    size: number;
    default_branch: string;
    open_issues_count: number;
    topics: Array<string>;
    has_issues: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    has_pages: boolean;
    has_downloads: boolean;
    archived: boolean;
    pushed_at: string;
    created_at: string;
    updated_at: string;
    permissions: ChecksListSuitesForRefResponseCheckSuitesItemRepositoryPermissions;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    allow_merge_commit: boolean;
    subscribers_count: number;
    network_count: number;
  };
  type ChecksListSuitesForRefResponseCheckSuitesItemAppOwner = {
    login: string;
    id: number;
    node_id: string;
    url: string;
    repos_url: string;
    events_url: string;
    hooks_url: string;
    issues_url: string;
    members_url: string;
    public_members_url: string;
    avatar_url: string;
    description: string;
  };
  type ChecksListSuitesForRefResponseCheckSuitesItemApp = {
    id: number;
    node_id: string;
    owner: ChecksListSuitesForRefResponseCheckSuitesItemAppOwner;
    name: string;
    description: string;
    external_url: string;
    html_url: string;
    created_at: string;
    updated_at: string;
  };
  type ChecksListSuitesForRefResponseCheckSuitesItem = {
    id: number;
    node_id: string;
    head_branch: string;
    head_sha: string;
    status: string;
    conclusion: string;
    url: string;
    before: string;
    after: string;
    pull_requests: Array<any>;
    app: ChecksListSuitesForRefResponseCheckSuitesItemApp;
    repository: ChecksListSuitesForRefResponseCheckSuitesItemRepository;
  };
  type ChecksListSuitesForRefResponse = {
    total_count: number;
    check_suites: Array<ChecksListSuitesForRefResponseCheckSuitesItem>;
  };
  type ChecksListForSuiteResponseCheckRunsItemPullRequestsItemBaseRepo = {
    id: number;
    url: string;
    name: string;
  };
  type ChecksListForSuiteResponseCheckRunsItemPullRequestsItemBase = {
    ref: string;
    sha: string;
    repo: ChecksListForSuiteResponseCheckRunsItemPullRequestsItemBaseRepo;
  };
  type ChecksListForSuiteResponseCheckRunsItemPullRequestsItemHeadRepo = {
    id: number;
    url: string;
    name: string;
  };
  type ChecksListForSuiteResponseCheckRunsItemPullRequestsItemHead = {
    ref: string;
    sha: string;
    repo: ChecksListForSuiteResponseCheckRunsItemPullRequestsItemHeadRepo;
  };
  type ChecksListForSuiteResponseCheckRunsItemPullRequestsItem = {
    url: string;
    id: number;
    number: number;
    head: ChecksListForSuiteResponseCheckRunsItemPullRequestsItemHead;
    base: ChecksListForSuiteResponseCheckRunsItemPullRequestsItemBase;
  };
  type ChecksListForSuiteResponseCheckRunsItemAppOwner = {
    login: string;
    id: number;
    node_id: string;
    url: string;
    repos_url: string;
    events_url: string;
    hooks_url: string;
    issues_url: string;
    members_url: string;
    public_members_url: string;
    avatar_url: string;
    description: string;
  };
  type ChecksListForSuiteResponseCheckRunsItemApp = {
    id: number;
    node_id: string;
    owner: ChecksListForSuiteResponseCheckRunsItemAppOwner;
    name: string;
    description: string;
    external_url: string;
    html_url: string;
    created_at: string;
    updated_at: string;
  };
  type ChecksListForSuiteResponseCheckRunsItemCheckSuite = { id: number };
  type ChecksListForSuiteResponseCheckRunsItemOutput = {
    title: string;
    summary: string;
    text: string;
    annotations_count: number;
    annotations_url: string;
  };
  type ChecksListForSuiteResponseCheckRunsItem = {
    id: number;
    head_sha: string;
    node_id: string;
    external_id: string;
    url: string;
    html_url: string;
    details_url: string;
    status: string;
    conclusion: string;
    started_at: string;
    completed_at: string;
    output: ChecksListForSuiteResponseCheckRunsItemOutput;
    name: string;
    check_suite: ChecksListForSuiteResponseCheckRunsItemCheckSuite;
    app: ChecksListForSuiteResponseCheckRunsItemApp;
    pull_requests: Array<
      ChecksListForSuiteResponseCheckRunsItemPullRequestsItem
    >;
  };
  type ChecksListForSuiteResponse = {
    total_count: number;
    check_runs: Array<ChecksListForSuiteResponseCheckRunsItem>;
  };
  type ChecksListForRefResponseCheckRunsItemPullRequestsItemBaseRepo = {
    id: number;
    url: string;
    name: string;
  };
  type ChecksListForRefResponseCheckRunsItemPullRequestsItemBase = {
    ref: string;
    sha: string;
    repo: ChecksListForRefResponseCheckRunsItemPullRequestsItemBaseRepo;
  };
  type ChecksListForRefResponseCheckRunsItemPullRequestsItemHeadRepo = {
    id: number;
    url: string;
    name: string;
  };
  type ChecksListForRefResponseCheckRunsItemPullRequestsItemHead = {
    ref: string;
    sha: string;
    repo: ChecksListForRefResponseCheckRunsItemPullRequestsItemHeadRepo;
  };
  type ChecksListForRefResponseCheckRunsItemPullRequestsItem = {
    url: string;
    id: number;
    number: number;
    head: ChecksListForRefResponseCheckRunsItemPullRequestsItemHead;
    base: ChecksListForRefResponseCheckRunsItemPullRequestsItemBase;
  };
  type ChecksListForRefResponseCheckRunsItemAppOwner = {
    login: string;
    id: number;
    node_id: string;
    url: string;
    repos_url: string;
    events_url: string;
    hooks_url: string;
    issues_url: string;
    members_url: string;
    public_members_url: string;
    avatar_url: string;
    description: string;
  };
  type ChecksListForRefResponseCheckRunsItemApp = {
    id: number;
    node_id: string;
    owner: ChecksListForRefResponseCheckRunsItemAppOwner;
    name: string;
    description: string;
    external_url: string;
    html_url: string;
    created_at: string;
    updated_at: string;
  };
  type ChecksListForRefResponseCheckRunsItemCheckSuite = { id: number };
  type ChecksListForRefResponseCheckRunsItemOutput = {
    title: string;
    summary: string;
    text: string;
    annotations_count: number;
    annotations_url: string;
  };
  type ChecksListForRefResponseCheckRunsItem = {
    id: number;
    head_sha: string;
    node_id: string;
    external_id: string;
    url: string;
    html_url: string;
    details_url: string;
    status: string;
    conclusion: string;
    started_at: string;
    completed_at: string;
    output: ChecksListForRefResponseCheckRunsItemOutput;
    name: string;
    check_suite: ChecksListForRefResponseCheckRunsItemCheckSuite;
    app: ChecksListForRefResponseCheckRunsItemApp;
    pull_requests: Array<ChecksListForRefResponseCheckRunsItemPullRequestsItem>;
  };
  type ChecksListForRefResponse = {
    total_count: number;
    check_runs: Array<ChecksListForRefResponseCheckRunsItem>;
  };
  type ChecksListAnnotationsResponseItem = {
    path: string;
    start_line: number;
    end_line: number;
    start_column: number;
    end_column: number;
    annotation_level: string;
    title: string;
    message: string;
    raw_details: string;
  };
  type ChecksGetSuiteResponseRepositoryPermissions = {
    admin: boolean;
    push: boolean;
    pull: boolean;
  };
  type ChecksGetSuiteResponseRepositoryOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ChecksGetSuiteResponseRepository = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: ChecksGetSuiteResponseRepositoryOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    clone_url: string;
    mirror_url: string;
    hooks_url: string;
    svn_url: string;
    homepage: string;
    language: null;
    forks_count: number;
    stargazers_count: number;
    watchers_count: number;
    size: number;
    default_branch: string;
    open_issues_count: number;
    topics: Array<string>;
    has_issues: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    has_pages: boolean;
    has_downloads: boolean;
    archived: boolean;
    pushed_at: string;
    created_at: string;
    updated_at: string;
    permissions: ChecksGetSuiteResponseRepositoryPermissions;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    allow_merge_commit: boolean;
    subscribers_count: number;
    network_count: number;
  };
  type ChecksGetSuiteResponseAppOwner = {
    login: string;
    id: number;
    node_id: string;
    url: string;
    repos_url: string;
    events_url: string;
    hooks_url: string;
    issues_url: string;
    members_url: string;
    public_members_url: string;
    avatar_url: string;
    description: string;
  };
  type ChecksGetSuiteResponseApp = {
    id: number;
    node_id: string;
    owner: ChecksGetSuiteResponseAppOwner;
    name: string;
    description: string;
    external_url: string;
    html_url: string;
    created_at: string;
    updated_at: string;
  };
  type ChecksGetSuiteResponse = {
    id: number;
    node_id: string;
    head_branch: string;
    head_sha: string;
    status: string;
    conclusion: string;
    url: string;
    before: string;
    after: string;
    pull_requests: Array<any>;
    app: ChecksGetSuiteResponseApp;
    repository: ChecksGetSuiteResponseRepository;
  };
  type ChecksGetResponsePullRequestsItemBaseRepo = {
    id: number;
    url: string;
    name: string;
  };
  type ChecksGetResponsePullRequestsItemBase = {
    ref: string;
    sha: string;
    repo: ChecksGetResponsePullRequestsItemBaseRepo;
  };
  type ChecksGetResponsePullRequestsItemHeadRepo = {
    id: number;
    url: string;
    name: string;
  };
  type ChecksGetResponsePullRequestsItemHead = {
    ref: string;
    sha: string;
    repo: ChecksGetResponsePullRequestsItemHeadRepo;
  };
  type ChecksGetResponsePullRequestsItem = {
    url: string;
    id: number;
    number: number;
    head: ChecksGetResponsePullRequestsItemHead;
    base: ChecksGetResponsePullRequestsItemBase;
  };
  type ChecksGetResponseAppOwner = {
    login: string;
    id: number;
    node_id: string;
    url: string;
    repos_url: string;
    events_url: string;
    hooks_url: string;
    issues_url: string;
    members_url: string;
    public_members_url: string;
    avatar_url: string;
    description: string;
  };
  type ChecksGetResponseApp = {
    id: number;
    node_id: string;
    owner: ChecksGetResponseAppOwner;
    name: string;
    description: string;
    external_url: string;
    html_url: string;
    created_at: string;
    updated_at: string;
  };
  type ChecksGetResponseCheckSuite = { id: number };
  type ChecksGetResponseOutput = {
    title: string;
    summary: string;
    text: string;
    annotations_count: number;
    annotations_url: string;
  };
  type ChecksGetResponse = {
    id: number;
    head_sha: string;
    node_id: string;
    external_id: string;
    url: string;
    html_url: string;
    details_url: string;
    status: string;
    conclusion: string;
    started_at: string;
    completed_at: string;
    output: ChecksGetResponseOutput;
    name: string;
    check_suite: ChecksGetResponseCheckSuite;
    app: ChecksGetResponseApp;
    pull_requests: Array<ChecksGetResponsePullRequestsItem>;
  };
  type ChecksCreateSuiteResponseRepositoryPermissions = {
    admin: boolean;
    push: boolean;
    pull: boolean;
  };
  type ChecksCreateSuiteResponseRepositoryOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ChecksCreateSuiteResponseRepository = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: ChecksCreateSuiteResponseRepositoryOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    clone_url: string;
    mirror_url: string;
    hooks_url: string;
    svn_url: string;
    homepage: string;
    language: null;
    forks_count: number;
    stargazers_count: number;
    watchers_count: number;
    size: number;
    default_branch: string;
    open_issues_count: number;
    topics: Array<string>;
    has_issues: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    has_pages: boolean;
    has_downloads: boolean;
    archived: boolean;
    pushed_at: string;
    created_at: string;
    updated_at: string;
    permissions: ChecksCreateSuiteResponseRepositoryPermissions;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    allow_merge_commit: boolean;
    subscribers_count: number;
    network_count: number;
  };
  type ChecksCreateSuiteResponseAppOwner = {
    login: string;
    id: number;
    node_id: string;
    url: string;
    repos_url: string;
    events_url: string;
    hooks_url: string;
    issues_url: string;
    members_url: string;
    public_members_url: string;
    avatar_url: string;
    description: string;
  };
  type ChecksCreateSuiteResponseApp = {
    id: number;
    node_id: string;
    owner: ChecksCreateSuiteResponseAppOwner;
    name: string;
    description: string;
    external_url: string;
    html_url: string;
    created_at: string;
    updated_at: string;
  };
  type ChecksCreateSuiteResponse = {
    id: number;
    node_id: string;
    head_branch: string;
    head_sha: string;
    status: string;
    conclusion: string;
    url: string;
    before: string;
    after: string;
    pull_requests: Array<any>;
    app: ChecksCreateSuiteResponseApp;
    repository: ChecksCreateSuiteResponseRepository;
  };
  type ChecksCreateResponsePullRequestsItemBaseRepo = {
    id: number;
    url: string;
    name: string;
  };
  type ChecksCreateResponsePullRequestsItemBase = {
    ref: string;
    sha: string;
    repo: ChecksCreateResponsePullRequestsItemBaseRepo;
  };
  type ChecksCreateResponsePullRequestsItemHeadRepo = {
    id: number;
    url: string;
    name: string;
  };
  type ChecksCreateResponsePullRequestsItemHead = {
    ref: string;
    sha: string;
    repo: ChecksCreateResponsePullRequestsItemHeadRepo;
  };
  type ChecksCreateResponsePullRequestsItem = {
    url: string;
    id: number;
    number: number;
    head: ChecksCreateResponsePullRequestsItemHead;
    base: ChecksCreateResponsePullRequestsItemBase;
  };
  type ChecksCreateResponseAppOwner = {
    login: string;
    id: number;
    node_id: string;
    url: string;
    repos_url: string;
    events_url: string;
    hooks_url: string;
    issues_url: string;
    members_url: string;
    public_members_url: string;
    avatar_url: string;
    description: string;
  };
  type ChecksCreateResponseApp = {
    id: number;
    node_id: string;
    owner: ChecksCreateResponseAppOwner;
    name: string;
    description: string;
    external_url: string;
    html_url: string;
    created_at: string;
    updated_at: string;
  };
  type ChecksCreateResponseCheckSuite = { id: number };
  type ChecksCreateResponseOutput = {
    title: string;
    summary: string;
    text: string;
  };
  type ChecksCreateResponse = {
    id: number;
    head_sha: string;
    node_id: string;
    external_id: string;
    url: string;
    html_url: string;
    details_url: string;
    status: string;
    conclusion: null;
    started_at: string;
    completed_at: null;
    output: ChecksCreateResponseOutput;
    name: string;
    check_suite: ChecksCreateResponseCheckSuite;
    app: ChecksCreateResponseApp;
    pull_requests: Array<ChecksCreateResponsePullRequestsItem>;
  };
  type AuthorizationUpdateAuthorizationResponseApp = {
    url: string;
    name: string;
    client_id: string;
  };
  type AuthorizationUpdateAuthorizationResponse = {
    id: number;
    url: string;
    scopes: Array<string>;
    token: string;
    token_last_eight: string;
    hashed_token: string;
    app: AuthorizationUpdateAuthorizationResponseApp;
    note: string;
    note_url: string;
    updated_at: string;
    created_at: string;
    fingerprint: string;
  };
  type AuthorizationRevokeGrantForApplicationResponse = {};
  type AuthorizationRevokeAuthorizationForApplicationResponse = {};
  type AuthorizationResetAuthorizationResponseUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type AuthorizationResetAuthorizationResponseApp = {
    url: string;
    name: string;
    client_id: string;
  };
  type AuthorizationResetAuthorizationResponse = {
    id: number;
    url: string;
    scopes: Array<string>;
    token: string;
    token_last_eight: string;
    hashed_token: string;
    app: AuthorizationResetAuthorizationResponseApp;
    note: string;
    note_url: string;
    updated_at: string;
    created_at: string;
    fingerprint: string;
    user: AuthorizationResetAuthorizationResponseUser;
  };
  type AuthorizationListGrantsResponseItemApp = {
    url: string;
    name: string;
    client_id: string;
  };
  type AuthorizationListGrantsResponseItem = {
    id: number;
    url: string;
    app: AuthorizationListGrantsResponseItemApp;
    created_at: string;
    updated_at: string;
    scopes: Array<string>;
  };
  type AuthorizationListAuthorizationsResponseItemApp = {
    url: string;
    name: string;
    client_id: string;
  };
  type AuthorizationListAuthorizationsResponseItem = {
    id: number;
    url: string;
    scopes: Array<string>;
    token: string;
    token_last_eight: string;
    hashed_token: string;
    app: AuthorizationListAuthorizationsResponseItemApp;
    note: string;
    note_url: string;
    updated_at: string;
    created_at: string;
    fingerprint: string;
  };
  type AuthorizationGetGrantResponseApp = {
    url: string;
    name: string;
    client_id: string;
  };
  type AuthorizationGetGrantResponse = {
    id: number;
    url: string;
    app: AuthorizationGetGrantResponseApp;
    created_at: string;
    updated_at: string;
    scopes: Array<string>;
  };
  type AuthorizationGetAuthorizationResponseApp = {
    url: string;
    name: string;
    client_id: string;
  };
  type AuthorizationGetAuthorizationResponse = {
    id: number;
    url: string;
    scopes: Array<string>;
    token: string;
    token_last_eight: string;
    hashed_token: string;
    app: AuthorizationGetAuthorizationResponseApp;
    note: string;
    note_url: string;
    updated_at: string;
    created_at: string;
    fingerprint: string;
  };
  type AuthorizationDeleteGrantResponse = {};
  type AuthorizationDeleteAuthorizationResponse = {};
  type AuthorizationCreateAuthorizationResponseApp = {
    url: string;
    name: string;
    client_id: string;
  };
  type AuthorizationCreateAuthorizationResponse = {
    id: number;
    url: string;
    scopes: Array<string>;
    token: string;
    token_last_eight: string;
    hashed_token: string;
    app: AuthorizationCreateAuthorizationResponseApp;
    note: string;
    note_url: string;
    updated_at: string;
    created_at: string;
    fingerprint: string;
  };
  type AuthorizationCheckAuthorizationResponseUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type AuthorizationCheckAuthorizationResponseApp = {
    url: string;
    name: string;
    client_id: string;
  };
  type AuthorizationCheckAuthorizationResponse = {
    id: number;
    url: string;
    scopes: Array<string>;
    token: string;
    token_last_eight: string;
    hashed_token: string;
    app: AuthorizationCheckAuthorizationResponseApp;
    note: string;
    note_url: string;
    updated_at: string;
    created_at: string;
    fingerprint: string;
    user: AuthorizationCheckAuthorizationResponseUser;
  };
  type AppsRemoveRepoFromInstallationResponse = {};
  type AppsListReposResponseRepositoriesItemOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type AppsListReposResponseRepositoriesItem = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: AppsListReposResponseRepositoriesItemOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    clone_url: string;
    mirror_url: string;
    hooks_url: string;
    svn_url: string;
    homepage: string;
    language: null;
    forks_count: number;
    stargazers_count: number;
    watchers_count: number;
    size: number;
    default_branch: string;
    open_issues_count: number;
    topics: Array<string>;
    has_issues: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    has_pages: boolean;
    has_downloads: boolean;
    archived: boolean;
    pushed_at: string;
    created_at: string;
    updated_at: string;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    allow_merge_commit: boolean;
    subscribers_count: number;
    network_count: number;
  };
  type AppsListReposResponse = {
    total_count: number;
    repositories: Array<AppsListReposResponseRepositoriesItem>;
  };
  type AppsListPlansStubbedResponseItem = {
    url: string;
    accounts_url: string;
    id: number;
    number: number;
    name: string;
    description: string;
    monthly_price_in_cents: number;
    yearly_price_in_cents: number;
    price_model: string;
    has_free_trial: boolean;
    unit_name: null;
    state: string;
    bullets: Array<string>;
  };
  type AppsListPlansResponseItem = {
    url: string;
    accounts_url: string;
    id: number;
    number: number;
    name: string;
    description: string;
    monthly_price_in_cents: number;
    yearly_price_in_cents: number;
    price_model: string;
    has_free_trial: boolean;
    unit_name: null;
    state: string;
    bullets: Array<string>;
  };
  type AppsListMarketplacePurchasesForAuthenticatedUserStubbedResponseItemPlan = {
    url: string;
    accounts_url: string;
    id: number;
    number: number;
    name: string;
    description: string;
    monthly_price_in_cents: number;
    yearly_price_in_cents: number;
    price_model: string;
    has_free_trial: boolean;
    unit_name: null;
    state: string;
    bullets: Array<string>;
  };
  type AppsListMarketplacePurchasesForAuthenticatedUserStubbedResponseItemAccount = {
    login: string;
    id: number;
    url: string;
    email: null;
    organization_billing_email: string;
    type: string;
  };
  type AppsListMarketplacePurchasesForAuthenticatedUserStubbedResponseItem = {
    billing_cycle: string;
    next_billing_date: string;
    unit_count: null;
    on_free_trial: boolean;
    free_trial_ends_on: string;
    updated_at: string;
    account: AppsListMarketplacePurchasesForAuthenticatedUserStubbedResponseItemAccount;
    plan: AppsListMarketplacePurchasesForAuthenticatedUserStubbedResponseItemPlan;
  };
  type AppsListMarketplacePurchasesForAuthenticatedUserResponseItemPlan = {
    url: string;
    accounts_url: string;
    id: number;
    number: number;
    name: string;
    description: string;
    monthly_price_in_cents: number;
    yearly_price_in_cents: number;
    price_model: string;
    has_free_trial: boolean;
    unit_name: null;
    state: string;
    bullets: Array<string>;
  };
  type AppsListMarketplacePurchasesForAuthenticatedUserResponseItemAccount = {
    login: string;
    id: number;
    url: string;
    email: null;
    organization_billing_email: string;
    type: string;
  };
  type AppsListMarketplacePurchasesForAuthenticatedUserResponseItem = {
    billing_cycle: string;
    next_billing_date: string;
    unit_count: null;
    on_free_trial: boolean;
    free_trial_ends_on: string;
    updated_at: string;
    account: AppsListMarketplacePurchasesForAuthenticatedUserResponseItemAccount;
    plan: AppsListMarketplacePurchasesForAuthenticatedUserResponseItemPlan;
  };
  type AppsListInstallationsForAuthenticatedUserResponseInstallationsItemPermissions = {
    metadata: string;
    contents: string;
    issues: string;
    single_file: string;
  };
  type AppsListInstallationsForAuthenticatedUserResponseInstallationsItemAccount = {
    login: string;
    id: number;
    node_id: string;
    url: string;
    repos_url: string;
    events_url: string;
    hooks_url?: string;
    issues_url?: string;
    members_url?: string;
    public_members_url?: string;
    avatar_url: string;
    description?: string;
    gravatar_id?: string;
    html_url?: string;
    followers_url?: string;
    following_url?: string;
    gists_url?: string;
    starred_url?: string;
    subscriptions_url?: string;
    organizations_url?: string;
    received_events_url?: string;
    type?: string;
    site_admin?: boolean;
  };
  type AppsListInstallationsForAuthenticatedUserResponseInstallationsItem = {
    id: number;
    account: AppsListInstallationsForAuthenticatedUserResponseInstallationsItemAccount;
    access_tokens_url: string;
    repositories_url: string;
    html_url: string;
    app_id: number;
    target_id: number;
    target_type: string;
    permissions: AppsListInstallationsForAuthenticatedUserResponseInstallationsItemPermissions;
    events: Array<string>;
    single_file_name: string;
  };
  type AppsListInstallationsForAuthenticatedUserResponse = {
    total_count: number;
    installations: Array<
      AppsListInstallationsForAuthenticatedUserResponseInstallationsItem
    >;
  };
  type AppsListInstallationsResponseItemPermissions = {
    metadata: string;
    contents: string;
    issues: string;
    single_file: string;
  };
  type AppsListInstallationsResponseItemAccount = {
    login: string;
    id: number;
    node_id: string;
    url: string;
    repos_url: string;
    events_url: string;
    hooks_url: string;
    issues_url: string;
    members_url: string;
    public_members_url: string;
    avatar_url: string;
    description: string;
  };
  type AppsListInstallationsResponseItem = {
    id: number;
    account: AppsListInstallationsResponseItemAccount;
    access_tokens_url: string;
    repositories_url: string;
    html_url: string;
    app_id: number;
    target_id: number;
    target_type: string;
    permissions: AppsListInstallationsResponseItemPermissions;
    events: Array<string>;
    single_file_name: string;
    repository_selection: string;
  };
  type AppsListInstallationReposForAuthenticatedUserResponseRepositoriesItemPermissions = {
    admin: boolean;
    push: boolean;
    pull: boolean;
  };
  type AppsListInstallationReposForAuthenticatedUserResponseRepositoriesItemOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type AppsListInstallationReposForAuthenticatedUserResponseRepositoriesItem = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: AppsListInstallationReposForAuthenticatedUserResponseRepositoriesItemOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    clone_url: string;
    mirror_url: string;
    hooks_url: string;
    svn_url: string;
    homepage: string;
    language: null;
    forks_count: number;
    stargazers_count: number;
    watchers_count: number;
    size: number;
    default_branch: string;
    open_issues_count: number;
    topics: Array<string>;
    has_issues: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    has_pages: boolean;
    has_downloads: boolean;
    archived: boolean;
    pushed_at: string;
    created_at: string;
    updated_at: string;
    permissions: AppsListInstallationReposForAuthenticatedUserResponseRepositoriesItemPermissions;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    allow_merge_commit: boolean;
    subscribers_count: number;
    network_count: number;
  };
  type AppsListInstallationReposForAuthenticatedUserResponse = {
    total_count: number;
    repositories: Array<
      AppsListInstallationReposForAuthenticatedUserResponseRepositoriesItem
    >;
  };
  type AppsListAccountsUserOrOrgOnPlanStubbedResponseItemMarketplacePurchasePlan = {
    url: string;
    accounts_url: string;
    id: number;
    number: number;
    name: string;
    description: string;
    monthly_price_in_cents: number;
    yearly_price_in_cents: number;
    price_model: string;
    has_free_trial: boolean;
    unit_name: null;
    state: string;
    bullets: Array<string>;
  };
  type AppsListAccountsUserOrOrgOnPlanStubbedResponseItemMarketplacePurchase = {
    billing_cycle: string;
    next_billing_date: string;
    unit_count: null;
    on_free_trial: boolean;
    free_trial_ends_on: string;
    updated_at: string;
    plan: AppsListAccountsUserOrOrgOnPlanStubbedResponseItemMarketplacePurchasePlan;
  };
  type AppsListAccountsUserOrOrgOnPlanStubbedResponseItemMarketplacePendingChangePlan = {
    url: string;
    accounts_url: string;
    id: number;
    number: number;
    name: string;
    description: string;
    monthly_price_in_cents: number;
    yearly_price_in_cents: number;
    price_model: string;
    has_free_trial: boolean;
    state: string;
    unit_name: null;
    bullets: Array<string>;
  };
  type AppsListAccountsUserOrOrgOnPlanStubbedResponseItemMarketplacePendingChange = {
    effective_date: string;
    unit_count: null;
    id: number;
    plan: AppsListAccountsUserOrOrgOnPlanStubbedResponseItemMarketplacePendingChangePlan;
  };
  type AppsListAccountsUserOrOrgOnPlanStubbedResponseItem = {
    url: string;
    type: string;
    id: number;
    login: string;
    email: null;
    organization_billing_email: string;
    marketplace_pending_change: AppsListAccountsUserOrOrgOnPlanStubbedResponseItemMarketplacePendingChange;
    marketplace_purchase: AppsListAccountsUserOrOrgOnPlanStubbedResponseItemMarketplacePurchase;
  };
  type AppsListAccountsUserOrOrgOnPlanResponseItemMarketplacePurchasePlan = {
    url: string;
    accounts_url: string;
    id: number;
    number: number;
    name: string;
    description: string;
    monthly_price_in_cents: number;
    yearly_price_in_cents: number;
    price_model: string;
    has_free_trial: boolean;
    unit_name: null;
    state: string;
    bullets: Array<string>;
  };
  type AppsListAccountsUserOrOrgOnPlanResponseItemMarketplacePurchase = {
    billing_cycle: string;
    next_billing_date: string;
    unit_count: null;
    on_free_trial: boolean;
    free_trial_ends_on: string;
    updated_at: string;
    plan: AppsListAccountsUserOrOrgOnPlanResponseItemMarketplacePurchasePlan;
  };
  type AppsListAccountsUserOrOrgOnPlanResponseItemMarketplacePendingChangePlan = {
    url: string;
    accounts_url: string;
    id: number;
    number: number;
    name: string;
    description: string;
    monthly_price_in_cents: number;
    yearly_price_in_cents: number;
    price_model: string;
    has_free_trial: boolean;
    state: string;
    unit_name: null;
    bullets: Array<string>;
  };
  type AppsListAccountsUserOrOrgOnPlanResponseItemMarketplacePendingChange = {
    effective_date: string;
    unit_count: null;
    id: number;
    plan: AppsListAccountsUserOrOrgOnPlanResponseItemMarketplacePendingChangePlan;
  };
  type AppsListAccountsUserOrOrgOnPlanResponseItem = {
    url: string;
    type: string;
    id: number;
    login: string;
    email: null;
    organization_billing_email: string;
    marketplace_pending_change: AppsListAccountsUserOrOrgOnPlanResponseItemMarketplacePendingChange;
    marketplace_purchase: AppsListAccountsUserOrOrgOnPlanResponseItemMarketplacePurchase;
  };
  type AppsGetInstallationResponsePermissions = {
    metadata: string;
    contents: string;
    issues: string;
    single_file: string;
  };
  type AppsGetInstallationResponseAccount = {
    login: string;
    id: number;
    node_id: string;
    url: string;
    repos_url: string;
    events_url: string;
    hooks_url: string;
    issues_url: string;
    members_url: string;
    public_members_url: string;
    avatar_url: string;
    description: string;
  };
  type AppsGetInstallationResponse = {
    id: number;
    account: AppsGetInstallationResponseAccount;
    access_tokens_url: string;
    repositories_url: string;
    html_url: string;
    app_id: number;
    target_id: number;
    target_type: string;
    permissions: AppsGetInstallationResponsePermissions;
    events: Array<string>;
    single_file_name: string;
    repository_selection: string;
  };
  type AppsGetBySlugResponseOwner = {
    login: string;
    id: number;
    node_id: string;
    url: string;
    repos_url: string;
    events_url: string;
    hooks_url: string;
    issues_url: string;
    members_url: string;
    public_members_url: string;
    avatar_url: string;
    description: string;
  };
  type AppsGetBySlugResponse = {
    id: number;
    node_id: string;
    owner: AppsGetBySlugResponseOwner;
    name: string;
    description: string;
    external_url: string;
    html_url: string;
    created_at: string;
    updated_at: string;
  };
  type AppsGetAuthenticatedResponseOwner = {
    login: string;
    id: number;
    node_id: string;
    url: string;
    repos_url: string;
    events_url: string;
    hooks_url: string;
    issues_url: string;
    members_url: string;
    public_members_url: string;
    avatar_url: string;
    description: string;
  };
  type AppsGetAuthenticatedResponse = {
    id: number;
    node_id: string;
    owner: AppsGetAuthenticatedResponseOwner;
    name: string;
    description: string;
    external_url: string;
    html_url: string;
    created_at: string;
    updated_at: string;
  };
  type AppsFindUserInstallationResponsePermissions = {
    checks: string;
    metadata: string;
    contents: string;
  };
  type AppsFindUserInstallationResponseAccount = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type AppsFindUserInstallationResponse = {
    id: number;
    account: AppsFindUserInstallationResponseAccount;
    repository_selection: string;
    access_tokens_url: string;
    repositories_url: string;
    html_url: string;
    app_id: number;
    target_id: number;
    target_type: string;
    permissions: AppsFindUserInstallationResponsePermissions;
    events: Array<string>;
    created_at: string;
    updated_at: string;
    single_file_name: null;
  };
  type AppsFindRepoInstallationResponsePermissions = {
    checks: string;
    metadata: string;
    contents: string;
  };
  type AppsFindRepoInstallationResponseAccount = {
    login: string;
    id: number;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type AppsFindRepoInstallationResponse = {
    id: number;
    account: AppsFindRepoInstallationResponseAccount;
    repository_selection: string;
    access_tokens_url: string;
    repositories_url: string;
    html_url: string;
    app_id: number;
    target_id: number;
    target_type: string;
    permissions: AppsFindRepoInstallationResponsePermissions;
    events: Array<string>;
    created_at: string;
    updated_at: string;
    single_file_name: null;
  };
  type AppsFindOrgInstallationResponsePermissions = {
    checks: string;
    metadata: string;
    contents: string;
  };
  type AppsFindOrgInstallationResponseAccount = {
    login: string;
    id: number;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type AppsFindOrgInstallationResponse = {
    id: number;
    account: AppsFindOrgInstallationResponseAccount;
    repository_selection: string;
    access_tokens_url: string;
    repositories_url: string;
    html_url: string;
    app_id: number;
    target_id: number;
    target_type: string;
    permissions: AppsFindOrgInstallationResponsePermissions;
    events: Array<string>;
    created_at: string;
    updated_at: string;
    single_file_name: null;
  };
  type AppsCreateInstallationTokenResponse = {
    token: string;
    expires_at: string;
  };
  type AppsCreateFromManifestResponseOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type AppsCreateFromManifestResponse = {
    id: number;
    node_id: string;
    owner: AppsCreateFromManifestResponseOwner;
    name: string;
    description: null;
    external_url: string;
    html_url: string;
    created_at: string;
    updated_at: string;
    webhook_secret: string;
    pem: string;
  };
  type AppsCheckAccountIsAssociatedWithAnyStubbedResponseMarketplacePurchasePlan = {
    url: string;
    accounts_url: string;
    id: number;
    number: number;
    name: string;
    description: string;
    monthly_price_in_cents: number;
    yearly_price_in_cents: number;
    price_model: string;
    has_free_trial: boolean;
    unit_name: null;
    state: string;
    bullets: Array<string>;
  };
  type AppsCheckAccountIsAssociatedWithAnyStubbedResponseMarketplacePurchase = {
    billing_cycle: string;
    next_billing_date: string;
    unit_count: null;
    on_free_trial: boolean;
    free_trial_ends_on: string;
    updated_at: string;
    plan: AppsCheckAccountIsAssociatedWithAnyStubbedResponseMarketplacePurchasePlan;
  };
  type AppsCheckAccountIsAssociatedWithAnyStubbedResponseMarketplacePendingChangePlan = {
    url: string;
    accounts_url: string;
    id: number;
    number: number;
    name: string;
    description: string;
    monthly_price_in_cents: number;
    yearly_price_in_cents: number;
    price_model: string;
    has_free_trial: boolean;
    state: string;
    unit_name: null;
    bullets: Array<string>;
  };
  type AppsCheckAccountIsAssociatedWithAnyStubbedResponseMarketplacePendingChange = {
    effective_date: string;
    unit_count: null;
    id: number;
    plan: AppsCheckAccountIsAssociatedWithAnyStubbedResponseMarketplacePendingChangePlan;
  };
  type AppsCheckAccountIsAssociatedWithAnyStubbedResponse = {
    url: string;
    type: string;
    id: number;
    login: string;
    email: null;
    organization_billing_email: string;
    marketplace_pending_change: AppsCheckAccountIsAssociatedWithAnyStubbedResponseMarketplacePendingChange;
    marketplace_purchase: AppsCheckAccountIsAssociatedWithAnyStubbedResponseMarketplacePurchase;
  };
  type AppsCheckAccountIsAssociatedWithAnyResponseMarketplacePurchasePlan = {
    url: string;
    accounts_url: string;
    id: number;
    number: number;
    name: string;
    description: string;
    monthly_price_in_cents: number;
    yearly_price_in_cents: number;
    price_model: string;
    has_free_trial: boolean;
    unit_name: null;
    state: string;
    bullets: Array<string>;
  };
  type AppsCheckAccountIsAssociatedWithAnyResponseMarketplacePurchase = {
    billing_cycle: string;
    next_billing_date: string;
    unit_count: null;
    on_free_trial: boolean;
    free_trial_ends_on: string;
    updated_at: string;
    plan: AppsCheckAccountIsAssociatedWithAnyResponseMarketplacePurchasePlan;
  };
  type AppsCheckAccountIsAssociatedWithAnyResponseMarketplacePendingChangePlan = {
    url: string;
    accounts_url: string;
    id: number;
    number: number;
    name: string;
    description: string;
    monthly_price_in_cents: number;
    yearly_price_in_cents: number;
    price_model: string;
    has_free_trial: boolean;
    state: string;
    unit_name: null;
    bullets: Array<string>;
  };
  type AppsCheckAccountIsAssociatedWithAnyResponseMarketplacePendingChange = {
    effective_date: string;
    unit_count: null;
    id: number;
    plan: AppsCheckAccountIsAssociatedWithAnyResponseMarketplacePendingChangePlan;
  };
  type AppsCheckAccountIsAssociatedWithAnyResponse = {
    url: string;
    type: string;
    id: number;
    login: string;
    email: null;
    organization_billing_email: string;
    marketplace_pending_change: AppsCheckAccountIsAssociatedWithAnyResponseMarketplacePendingChange;
    marketplace_purchase: AppsCheckAccountIsAssociatedWithAnyResponseMarketplacePurchase;
  };
  type AppsAddRepoToInstallationResponse = {};
  type ActivityUnstarRepoResponse = {};
  type ActivityStarRepoResponse = {};
  type ActivitySetThreadSubscriptionResponse = {
    subscribed: boolean;
    ignored: boolean;
    reason: null;
    created_at: string;
    url: string;
    thread_url: string;
  };
  type ActivitySetRepoSubscriptionResponse = {
    subscribed: boolean;
    ignored: boolean;
    reason: null;
    created_at: string;
    url: string;
    repository_url: string;
  };
  type ActivityMarkThreadAsReadResponse = {};
  type ActivityMarkNotificationsAsReadForRepoResponse = {};
  type ActivityMarkAsReadResponse = {};
  type ActivityListWatchersForRepoResponseItem = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ActivityListWatchedReposForAuthenticatedUserResponseItemLicense = {
    key: string;
    name: string;
    spdx_id: string;
    url: string;
    node_id: string;
  };
  type ActivityListWatchedReposForAuthenticatedUserResponseItemPermissions = {
    admin: boolean;
    push: boolean;
    pull: boolean;
  };
  type ActivityListWatchedReposForAuthenticatedUserResponseItemOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ActivityListWatchedReposForAuthenticatedUserResponseItem = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: ActivityListWatchedReposForAuthenticatedUserResponseItemOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    clone_url: string;
    mirror_url: string;
    hooks_url: string;
    svn_url: string;
    homepage: string;
    language: null;
    forks_count: number;
    stargazers_count: number;
    watchers_count: number;
    size: number;
    default_branch: string;
    open_issues_count: number;
    topics: Array<string>;
    has_issues: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    has_pages: boolean;
    has_downloads: boolean;
    archived: boolean;
    pushed_at: string;
    created_at: string;
    updated_at: string;
    permissions: ActivityListWatchedReposForAuthenticatedUserResponseItemPermissions;
    subscribers_count: number;
    network_count: number;
    license: ActivityListWatchedReposForAuthenticatedUserResponseItemLicense;
  };
  type ActivityListStargazersForRepoResponseItem = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ActivityListReposWatchedByUserResponseItemLicense = {
    key: string;
    name: string;
    spdx_id: string;
    url: string;
    node_id: string;
  };
  type ActivityListReposWatchedByUserResponseItemPermissions = {
    admin: boolean;
    push: boolean;
    pull: boolean;
  };
  type ActivityListReposWatchedByUserResponseItemOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ActivityListReposWatchedByUserResponseItem = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: ActivityListReposWatchedByUserResponseItemOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    clone_url: string;
    mirror_url: string;
    hooks_url: string;
    svn_url: string;
    homepage: string;
    language: null;
    forks_count: number;
    stargazers_count: number;
    watchers_count: number;
    size: number;
    default_branch: string;
    open_issues_count: number;
    topics: Array<string>;
    has_issues: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    has_pages: boolean;
    has_downloads: boolean;
    archived: boolean;
    pushed_at: string;
    created_at: string;
    updated_at: string;
    permissions: ActivityListReposWatchedByUserResponseItemPermissions;
    subscribers_count: number;
    network_count: number;
    license: ActivityListReposWatchedByUserResponseItemLicense;
  };
  type ActivityListReposStarredByUserResponseItemPermissions = {
    admin: boolean;
    push: boolean;
    pull: boolean;
  };
  type ActivityListReposStarredByUserResponseItemOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ActivityListReposStarredByUserResponseItem = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: ActivityListReposStarredByUserResponseItemOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    clone_url: string;
    mirror_url: string;
    hooks_url: string;
    svn_url: string;
    homepage: string;
    language: null;
    forks_count: number;
    stargazers_count: number;
    watchers_count: number;
    size: number;
    default_branch: string;
    open_issues_count: number;
    topics: Array<string>;
    has_issues: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    has_pages: boolean;
    has_downloads: boolean;
    archived: boolean;
    pushed_at: string;
    created_at: string;
    updated_at: string;
    permissions: ActivityListReposStarredByUserResponseItemPermissions;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    allow_merge_commit: boolean;
    subscribers_count: number;
    network_count: number;
  };
  type ActivityListReposStarredByAuthenticatedUserResponseItemPermissions = {
    admin: boolean;
    push: boolean;
    pull: boolean;
  };
  type ActivityListReposStarredByAuthenticatedUserResponseItemOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ActivityListReposStarredByAuthenticatedUserResponseItem = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: ActivityListReposStarredByAuthenticatedUserResponseItemOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    clone_url: string;
    mirror_url: string;
    hooks_url: string;
    svn_url: string;
    homepage: string;
    language: null;
    forks_count: number;
    stargazers_count: number;
    watchers_count: number;
    size: number;
    default_branch: string;
    open_issues_count: number;
    topics: Array<string>;
    has_issues: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    has_pages: boolean;
    has_downloads: boolean;
    archived: boolean;
    pushed_at: string;
    created_at: string;
    updated_at: string;
    permissions: ActivityListReposStarredByAuthenticatedUserResponseItemPermissions;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    allow_merge_commit: boolean;
    subscribers_count: number;
    network_count: number;
  };
  type ActivityListNotificationsForRepoResponseItemSubject = {
    title: string;
    url: string;
    latest_comment_url: string;
    type: string;
  };
  type ActivityListNotificationsForRepoResponseItemRepositoryOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ActivityListNotificationsForRepoResponseItemRepository = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: ActivityListNotificationsForRepoResponseItemRepositoryOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
  };
  type ActivityListNotificationsForRepoResponseItem = {
    id: string;
    repository: ActivityListNotificationsForRepoResponseItemRepository;
    subject: ActivityListNotificationsForRepoResponseItemSubject;
    reason: string;
    unread: boolean;
    updated_at: string;
    last_read_at: string;
    url: string;
  };
  type ActivityListNotificationsResponseItemSubject = {
    title: string;
    url: string;
    latest_comment_url: string;
    type: string;
  };
  type ActivityListNotificationsResponseItemRepositoryOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ActivityListNotificationsResponseItemRepository = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: ActivityListNotificationsResponseItemRepositoryOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
  };
  type ActivityListNotificationsResponseItem = {
    id: string;
    repository: ActivityListNotificationsResponseItemRepository;
    subject: ActivityListNotificationsResponseItemSubject;
    reason: string;
    unread: boolean;
    updated_at: string;
    last_read_at: string;
    url: string;
  };
  type ActivityListFeedsResponseLinksSecurityAdvisories = {
    href: string;
    type: string;
  };
  type ActivityListFeedsResponseLinksCurrentUserOrganizationsItem = {
    href: string;
    type: string;
  };
  type ActivityListFeedsResponseLinksCurrentUserOrganization = {
    href: string;
    type: string;
  };
  type ActivityListFeedsResponseLinksCurrentUserActor = {
    href: string;
    type: string;
  };
  type ActivityListFeedsResponseLinksCurrentUser = {
    href: string;
    type: string;
  };
  type ActivityListFeedsResponseLinksCurrentUserPublic = {
    href: string;
    type: string;
  };
  type ActivityListFeedsResponseLinksUser = { href: string; type: string };
  type ActivityListFeedsResponseLinksTimeline = { href: string; type: string };
  type ActivityListFeedsResponseLinks = {
    timeline: ActivityListFeedsResponseLinksTimeline;
    user: ActivityListFeedsResponseLinksUser;
    current_user_public: ActivityListFeedsResponseLinksCurrentUserPublic;
    current_user: ActivityListFeedsResponseLinksCurrentUser;
    current_user_actor: ActivityListFeedsResponseLinksCurrentUserActor;
    current_user_organization: ActivityListFeedsResponseLinksCurrentUserOrganization;
    current_user_organizations: Array<
      ActivityListFeedsResponseLinksCurrentUserOrganizationsItem
    >;
    security_advisories: ActivityListFeedsResponseLinksSecurityAdvisories;
  };
  type ActivityListFeedsResponse = {
    timeline_url: string;
    user_url: string;
    current_user_public_url: string;
    current_user_url: string;
    current_user_actor_url: string;
    current_user_organization_url: string;
    current_user_organization_urls: Array<string>;
    security_advisories_url: string;
    _links: ActivityListFeedsResponseLinks;
  };
  type ActivityGetThreadSubscriptionResponse = {
    subscribed: boolean;
    ignored: boolean;
    reason: null;
    created_at: string;
    url: string;
    thread_url: string;
  };
  type ActivityGetThreadResponseSubject = {
    title: string;
    url: string;
    latest_comment_url: string;
    type: string;
  };
  type ActivityGetThreadResponseRepositoryOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
  };
  type ActivityGetThreadResponseRepository = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: ActivityGetThreadResponseRepositoryOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
  };
  type ActivityGetThreadResponse = {
    id: string;
    repository: ActivityGetThreadResponseRepository;
    subject: ActivityGetThreadResponseSubject;
    reason: string;
    unread: boolean;
    updated_at: string;
    last_read_at: string;
    url: string;
  };
  type ActivityDeleteThreadSubscriptionResponse = {};
  type ActivityDeleteRepoSubscriptionResponse = {};
  type ActivityListNotificationsResponse = Array<
    ActivityListNotificationsResponseItem
  >;
  type ActivityListNotificationsForRepoResponse = Array<
    ActivityListNotificationsForRepoResponseItem
  >;
  type ActivityListReposStarredByAuthenticatedUserResponse = Array<
    ActivityListReposStarredByAuthenticatedUserResponseItem
  >;
  type ActivityListReposStarredByUserResponse = Array<
    ActivityListReposStarredByUserResponseItem
  >;
  type ActivityListReposWatchedByUserResponse = Array<
    ActivityListReposWatchedByUserResponseItem
  >;
  type ActivityListStargazersForRepoResponse = Array<
    ActivityListStargazersForRepoResponseItem
  >;
  type ActivityListWatchedReposForAuthenticatedUserResponse = Array<
    ActivityListWatchedReposForAuthenticatedUserResponseItem
  >;
  type ActivityListWatchersForRepoResponse = Array<
    ActivityListWatchersForRepoResponseItem
  >;
  type AppsListAccountsUserOrOrgOnPlanResponse = Array<
    AppsListAccountsUserOrOrgOnPlanResponseItem
  >;
  type AppsListAccountsUserOrOrgOnPlanStubbedResponse = Array<
    AppsListAccountsUserOrOrgOnPlanStubbedResponseItem
  >;
  type AppsListInstallationsResponse = Array<AppsListInstallationsResponseItem>;
  type AppsListMarketplacePurchasesForAuthenticatedUserResponse = Array<
    AppsListMarketplacePurchasesForAuthenticatedUserResponseItem
  >;
  type AppsListMarketplacePurchasesForAuthenticatedUserStubbedResponse = Array<
    AppsListMarketplacePurchasesForAuthenticatedUserStubbedResponseItem
  >;
  type AppsListPlansResponse = Array<AppsListPlansResponseItem>;
  type AppsListPlansStubbedResponse = Array<AppsListPlansStubbedResponseItem>;
  type AuthorizationListAuthorizationsResponse = Array<
    AuthorizationListAuthorizationsResponseItem
  >;
  type AuthorizationListGrantsResponse = Array<
    AuthorizationListGrantsResponseItem
  >;
  type ChecksListAnnotationsResponse = Array<ChecksListAnnotationsResponseItem>;
  type CodesOfConductListConductCodesResponse = Array<
    CodesOfConductListConductCodesResponseItem
  >;
  type GistsListResponse = Array<GistsListResponseItem>;
  type GistsListCommentsResponse = Array<GistsListCommentsResponseItem>;
  type GistsListCommitsResponse = Array<GistsListCommitsResponseItem>;
  type GistsListForksResponse = Array<GistsListForksResponseItem>;
  type GistsListPublicResponse = Array<GistsListPublicResponseItem>;
  type GistsListPublicForUserResponse = Array<
    GistsListPublicForUserResponseItem
  >;
  type GistsListStarredResponse = Array<GistsListStarredResponseItem>;
  type GitignoreListTemplatesResponse = Array<string>;
  type IssuesAddLabelsResponse = Array<IssuesAddLabelsResponseItem>;
  type IssuesListResponse = Array<IssuesListResponseItem>;
  type IssuesListAssigneesResponse = Array<IssuesListAssigneesResponseItem>;
  type IssuesListCommentsResponse = Array<IssuesListCommentsResponseItem>;
  type IssuesListCommentsForRepoResponse = Array<
    IssuesListCommentsForRepoResponseItem
  >;
  type IssuesListEventsResponse = Array<IssuesListEventsResponseItem>;
  type IssuesListEventsForRepoResponse = Array<
    IssuesListEventsForRepoResponseItem
  >;
  type IssuesListEventsForTimelineResponse = Array<
    IssuesListEventsForTimelineResponseItem
  >;
  type IssuesListForAuthenticatedUserResponse = Array<
    IssuesListForAuthenticatedUserResponseItem
  >;
  type IssuesListForOrgResponse = Array<IssuesListForOrgResponseItem>;
  type IssuesListForRepoResponse = Array<IssuesListForRepoResponseItem>;
  type IssuesListLabelsForMilestoneResponse = Array<
    IssuesListLabelsForMilestoneResponseItem
  >;
  type IssuesListLabelsForRepoResponse = Array<
    IssuesListLabelsForRepoResponseItem
  >;
  type IssuesListLabelsOnIssueResponse = Array<
    IssuesListLabelsOnIssueResponseItem
  >;
  type IssuesListMilestonesForRepoResponse = Array<
    IssuesListMilestonesForRepoResponseItem
  >;
  type IssuesReplaceLabelsResponse = Array<IssuesReplaceLabelsResponseItem>;
  type LicensesListResponse = Array<LicensesListResponseItem>;
  type MigrationsGetCommitAuthorsResponse = Array<
    MigrationsGetCommitAuthorsResponseItem
  >;
  type MigrationsGetLargeFilesResponse = Array<
    MigrationsGetLargeFilesResponseItem
  >;
  type MigrationsListForAuthenticatedUserResponse = Array<
    MigrationsListForAuthenticatedUserResponseItem
  >;
  type MigrationsListForOrgResponse = Array<MigrationsListForOrgResponseItem>;
  type OrgsListResponse = Array<OrgsListResponseItem>;
  type OrgsListBlockedUsersResponse = Array<OrgsListBlockedUsersResponseItem>;
  type OrgsListForAuthenticatedUserResponse = Array<
    OrgsListForAuthenticatedUserResponseItem
  >;
  type OrgsListForUserResponse = Array<OrgsListForUserResponseItem>;
  type OrgsListHooksResponse = Array<OrgsListHooksResponseItem>;
  type OrgsListInvitationTeamsResponse = Array<
    OrgsListInvitationTeamsResponseItem
  >;
  type OrgsListMembersResponse = Array<OrgsListMembersResponseItem>;
  type OrgsListMembershipsResponse = Array<OrgsListMembershipsResponseItem>;
  type OrgsListOutsideCollaboratorsResponse = Array<
    OrgsListOutsideCollaboratorsResponseItem
  >;
  type OrgsListPendingInvitationsResponse = Array<
    OrgsListPendingInvitationsResponseItem
  >;
  type OrgsListPublicMembersResponse = Array<OrgsListPublicMembersResponseItem>;
  type ProjectsListCardsResponse = Array<ProjectsListCardsResponseItem>;
  type ProjectsListCollaboratorsResponse = Array<
    ProjectsListCollaboratorsResponseItem
  >;
  type ProjectsListColumnsResponse = Array<ProjectsListColumnsResponseItem>;
  type ProjectsListForOrgResponse = Array<ProjectsListForOrgResponseItem>;
  type ProjectsListForRepoResponse = Array<ProjectsListForRepoResponseItem>;
  type PullRequestsGetCommentsForReviewResponse = Array<
    PullRequestsGetCommentsForReviewResponseItem
  >;
  type PullRequestsListResponse = Array<PullRequestsListResponseItem>;
  type PullRequestsListCommentsResponse = Array<
    PullRequestsListCommentsResponseItem
  >;
  type PullRequestsListCommentsForRepoResponse = Array<
    PullRequestsListCommentsForRepoResponseItem
  >;
  type PullRequestsListCommitsResponse = Array<
    PullRequestsListCommitsResponseItem
  >;
  type PullRequestsListFilesResponse = Array<PullRequestsListFilesResponseItem>;
  type PullRequestsListReviewsResponse = Array<
    PullRequestsListReviewsResponseItem
  >;
  type ReactionsListForCommitCommentResponse = Array<
    ReactionsListForCommitCommentResponseItem
  >;
  type ReactionsListForIssueResponse = Array<ReactionsListForIssueResponseItem>;
  type ReactionsListForIssueCommentResponse = Array<
    ReactionsListForIssueCommentResponseItem
  >;
  type ReactionsListForPullRequestReviewCommentResponse = Array<
    ReactionsListForPullRequestReviewCommentResponseItem
  >;
  type ReactionsListForTeamDiscussionResponse = Array<
    ReactionsListForTeamDiscussionResponseItem
  >;
  type ReactionsListForTeamDiscussionCommentResponse = Array<
    ReactionsListForTeamDiscussionCommentResponseItem
  >;
  type ReposAddProtectedBranchRequiredStatusChecksContextsResponse = Array<
    string
  >;
  type ReposAddProtectedBranchTeamRestrictionsResponse = Array<
    ReposAddProtectedBranchTeamRestrictionsResponseItem
  >;
  type ReposAddProtectedBranchUserRestrictionsResponse = Array<
    ReposAddProtectedBranchUserRestrictionsResponseItem
  >;
  type ReposCompareCommitsResponse = any;
  type ReposGetCodeFrequencyStatsResponse = Array<Array<number>>;
  type ReposGetCommitActivityStatsResponse = Array<
    ReposGetCommitActivityStatsResponseItem
  >;
  type ReposGetContributorsStatsResponse = Array<
    ReposGetContributorsStatsResponseItem
  >;
  type ReposGetPunchCardStatsResponse = Array<Array<number>>;
  type ReposGetTopPathsResponse = Array<ReposGetTopPathsResponseItem>;
  type ReposGetTopReferrersResponse = Array<ReposGetTopReferrersResponseItem>;
  type ReposListAssetsForReleaseResponse = Array<
    ReposListAssetsForReleaseResponseItem
  >;
  type ReposListBranchesResponse = Array<ReposListBranchesResponseItem>;
  type ReposListCollaboratorsResponse = Array<
    ReposListCollaboratorsResponseItem
  >;
  type ReposListCommentsForCommitResponse = Array<
    ReposListCommentsForCommitResponseItem
  >;
  type ReposListCommitCommentsResponse = Array<
    ReposListCommitCommentsResponseItem
  >;
  type ReposListCommitsResponse = Array<ReposListCommitsResponseItem>;
  type ReposListDeployKeysResponse = Array<ReposListDeployKeysResponseItem>;
  type ReposListDeploymentStatusesResponse = Array<
    ReposListDeploymentStatusesResponseItem
  >;
  type ReposListDeploymentsResponse = Array<ReposListDeploymentsResponseItem>;
  type ReposListDownloadsResponse = Array<ReposListDownloadsResponseItem>;
  type ReposListForOrgResponse = Array<ReposListForOrgResponseItem>;
  type ReposListForksResponse = Array<ReposListForksResponseItem>;
  type ReposListHooksResponse = Array<ReposListHooksResponseItem>;
  type ReposListInvitationsResponse = Array<ReposListInvitationsResponseItem>;
  type ReposListInvitationsForAuthenticatedUserResponse = Array<
    ReposListInvitationsForAuthenticatedUserResponseItem
  >;
  type ReposListProtectedBranchTeamRestrictionsResponse = any;
  type ReposListPublicResponse = Array<ReposListPublicResponseItem>;
  type ReposListReleasesResponse = Array<ReposListReleasesResponseItem>;
  type ReposListStatusesForRefResponse = Array<
    ReposListStatusesForRefResponseItem
  >;
  type ReposListTagsResponse = Array<ReposListTagsResponseItem>;
  type ReposListTeamsResponse = Array<ReposListTeamsResponseItem>;
  type ReposRemoveProtectedBranchRequiredStatusChecksContextsResponse = Array<
    string
  >;
  type ReposRemoveProtectedBranchTeamRestrictionsResponse = Array<
    ReposRemoveProtectedBranchTeamRestrictionsResponseItem
  >;
  type ReposRemoveProtectedBranchUserRestrictionsResponse = Array<
    ReposRemoveProtectedBranchUserRestrictionsResponseItem
  >;
  type ReposReplaceProtectedBranchRequiredStatusChecksContextsResponse = Array<
    string
  >;
  type ReposReplaceProtectedBranchTeamRestrictionsResponse = Array<
    ReposReplaceProtectedBranchTeamRestrictionsResponseItem
  >;
  type ReposReplaceProtectedBranchUserRestrictionsResponse = Array<
    ReposReplaceProtectedBranchUserRestrictionsResponseItem
  >;
  type TeamsListResponse = Array<TeamsListResponseItem>;
  type TeamsListDiscussionCommentsResponse = Array<
    TeamsListDiscussionCommentsResponseItem
  >;
  type TeamsListDiscussionsResponse = Array<TeamsListDiscussionsResponseItem>;
  type TeamsListForAuthenticatedUserResponse = Array<
    TeamsListForAuthenticatedUserResponseItem
  >;
  type TeamsListMembersResponse = Array<TeamsListMembersResponseItem>;
  type TeamsListPendingInvitationsResponse = Array<
    TeamsListPendingInvitationsResponseItem
  >;
  type TeamsListProjectsResponse = Array<TeamsListProjectsResponseItem>;
  type TeamsListReposResponse = Array<TeamsListReposResponseItem>;
  type UsersAddEmailsResponse = Array<UsersAddEmailsResponseItem>;
  type UsersGetContextForUserResponse = any;
  type UsersListResponse = Array<UsersListResponseItem>;
  type UsersListBlockedResponse = Array<UsersListBlockedResponseItem>;
  type UsersListEmailsResponse = Array<UsersListEmailsResponseItem>;
  type UsersListFollowersForAuthenticatedUserResponse = Array<
    UsersListFollowersForAuthenticatedUserResponseItem
  >;
  type UsersListFollowersForUserResponse = Array<
    UsersListFollowersForUserResponseItem
  >;
  type UsersListFollowingForAuthenticatedUserResponse = Array<
    UsersListFollowingForAuthenticatedUserResponseItem
  >;
  type UsersListFollowingForUserResponse = Array<
    UsersListFollowingForUserResponseItem
  >;
  type UsersListGpgKeysResponse = Array<UsersListGpgKeysResponseItem>;
  type UsersListGpgKeysForUserResponse = Array<
    UsersListGpgKeysForUserResponseItem
  >;
  type UsersListPublicEmailsResponse = Array<UsersListPublicEmailsResponseItem>;
  type UsersListPublicKeysResponse = Array<UsersListPublicKeysResponseItem>;
  type UsersListPublicKeysForUserResponse = Array<
    UsersListPublicKeysForUserResponseItem
  >;
  type UsersTogglePrimaryEmailVisibilityResponse = Array<
    UsersTogglePrimaryEmailVisibilityResponseItem
  >;

  export type ActivityCheckStarringRepoParams = {
    owner: string;

    repo: string;
  };
  export type ActivityDeleteRepoSubscriptionParams = {
    owner: string;

    repo: string;
  };
  export type ActivityDeleteThreadSubscriptionParams = {
    thread_id: number;
  };
  export type ActivityGetRepoSubscriptionParams = {
    owner: string;

    repo: string;
  };
  export type ActivityGetThreadParams = {
    thread_id: number;
  };
  export type ActivityGetThreadSubscriptionParams = {
    thread_id: number;
  };
  export type ActivityListEventsForOrgParams = {
    username: string;

    org: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type ActivityListEventsForUserParams = {
    username: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type ActivityListNotificationsParams = {
    /**
     * If `true`, show notifications marked as read.
     */
    all?: boolean;
    /**
     * If `true`, only shows notifications in which the user is directly participating or mentioned.
     */
    participating?: boolean;
    /**
     * Only show notifications updated after the given time. This is a timestamp in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    since?: string;
    /**
     * Only show notifications updated before the given time. This is a timestamp in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    before?: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type ActivityListNotificationsForRepoParams = {
    owner: string;

    repo: string;
    /**
     * If `true`, show notifications marked as read.
     */
    all?: boolean;
    /**
     * If `true`, only shows notifications in which the user is directly participating or mentioned.
     */
    participating?: boolean;
    /**
     * Only show notifications updated after the given time. This is a timestamp in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    since?: string;
    /**
     * Only show notifications updated before the given time. This is a timestamp in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    before?: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type ActivityListPublicEventsParams = {
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type ActivityListPublicEventsForOrgParams = {
    org: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type ActivityListPublicEventsForRepoNetworkParams = {
    owner: string;

    repo: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type ActivityListPublicEventsForUserParams = {
    username: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type ActivityListReceivedEventsForUserParams = {
    username: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type ActivityListReceivedPublicEventsForUserParams = {
    username: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type ActivityListRepoEventsParams = {
    owner: string;

    repo: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type ActivityListReposStarredByAuthenticatedUserParams = {
    /**
     * One of `created` (when the repository was starred) or `updated` (when it was last pushed to).
     */
    sort?: "created" | "updated";
    /**
     * One of `asc` (ascending) or `desc` (descending).
     */
    direction?: "asc" | "desc";
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type ActivityListReposStarredByUserParams = {
    username: string;
    /**
     * One of `created` (when the repository was starred) or `updated` (when it was last pushed to).
     */
    sort?: "created" | "updated";
    /**
     * One of `asc` (ascending) or `desc` (descending).
     */
    direction?: "asc" | "desc";
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type ActivityListReposWatchedByUserParams = {
    username: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type ActivityListStargazersForRepoParams = {
    owner: string;

    repo: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type ActivityListWatchedReposForAuthenticatedUserParams = {
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type ActivityListWatchersForRepoParams = {
    owner: string;

    repo: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type ActivityMarkAsReadParams = {
    /**
     * Describes the last point that notifications were checked. Anything updated since this time will not be updated. This is a timestamp in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    last_read_at?: string;
  };
  export type ActivityMarkNotificationsAsReadForRepoParams = {
    owner: string;

    repo: string;
    /**
     * Describes the last point that notifications were checked. Anything updated since this time will not be updated. This is a timestamp in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    last_read_at?: string;
  };
  export type ActivityMarkThreadAsReadParams = {
    thread_id: number;
  };
  export type ActivitySetRepoSubscriptionParams = {
    owner: string;

    repo: string;
    /**
     * Determines if notifications should be received from this repository.
     */
    subscribed?: boolean;
    /**
     * Determines if all notifications should be blocked from this repository.
     */
    ignored?: boolean;
  };
  export type ActivitySetThreadSubscriptionParams = {
    thread_id: number;
    /**
     * Unsubscribes and subscribes you to a conversation. Set `ignored` to `true` to block all notifications from this thread.
     */
    ignored?: boolean;
  };
  export type ActivityStarRepoParams = {
    owner: string;

    repo: string;
  };
  export type ActivityUnstarRepoParams = {
    owner: string;

    repo: string;
  };
  export type AppsAddRepoToInstallationParams = {
    installation_id: number;

    repository_id: number;
  };
  export type AppsCheckAccountIsAssociatedWithAnyParams = {
    account_id: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type AppsCheckAccountIsAssociatedWithAnyStubbedParams = {
    account_id: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type AppsCreateFromManifestParams = {
    code: string;
  };
  export type AppsCreateInstallationTokenParams = {
    installation_id: number;
  };
  export type AppsFindOrgInstallationParams = {
    org: string;
  };
  export type AppsFindRepoInstallationParams = {
    owner: string;

    repo: string;
  };
  export type AppsFindUserInstallationParams = {
    username: string;
  };
  export type AppsGetBySlugParams = {
    app_slug: string;
  };
  export type AppsGetInstallationParams = {
    installation_id: number;
  };
  export type AppsListAccountsUserOrOrgOnPlanParams = {
    plan_id: number;
    /**
     * Sorts the GitHub accounts by the date they were created or last updated. Can be one of `created` or `updated`.
     */
    sort?: "created" | "updated";
    /**
     * To return the oldest accounts first, set to `asc`. Can be one of `asc` or `desc`. Ignored without the `sort` parameter.
     */
    direction?: "asc" | "desc";
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type AppsListAccountsUserOrOrgOnPlanStubbedParams = {
    plan_id: number;
    /**
     * Sorts the GitHub accounts by the date they were created or last updated. Can be one of `created` or `updated`.
     */
    sort?: "created" | "updated";
    /**
     * To return the oldest accounts first, set to `asc`. Can be one of `asc` or `desc`. Ignored without the `sort` parameter.
     */
    direction?: "asc" | "desc";
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type AppsListInstallationReposForAuthenticatedUserParams = {
    installation_id: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type AppsListInstallationsParams = {
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type AppsListInstallationsForAuthenticatedUserParams = {
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type AppsListMarketplacePurchasesForAuthenticatedUserParams = {
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type AppsListMarketplacePurchasesForAuthenticatedUserStubbedParams = {
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type AppsListPlansParams = {
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type AppsListPlansStubbedParams = {
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type AppsListReposParams = {
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type AppsRemoveRepoFromInstallationParams = {
    installation_id: number;

    repository_id: number;
  };
  export type AuthorizationCheckAuthorizationParams = {
    client_id: string;

    access_token: string;
  };
  export type AuthorizationCreateAuthorizationParams = {
    /**
     * A list of scopes that this authorization is in.
     */
    scopes?: string[];
    /**
     * A note to remind you what the OAuth token is for. Tokens not associated with a specific OAuth application (i.e. personal access tokens) must have a unique note.
     */
    note: string;
    /**
     * A URL to remind you what app the OAuth token is for.
     */
    note_url?: string;
    /**
     * The 20 character OAuth app client key for which to create the token.
     */
    client_id?: string;
    /**
     * The 40 character OAuth app client secret for which to create the token.
     */
    client_secret?: string;
    /**
     * A unique string to distinguish an authorization from others created for the same client ID and user.
     */
    fingerprint?: string;
  };
  export type AuthorizationDeleteAuthorizationParams = {
    authorization_id: number;
  };
  export type AuthorizationDeleteGrantParams = {
    grant_id: number;
  };
  export type AuthorizationGetAuthorizationParams = {
    authorization_id: number;
  };
  export type AuthorizationGetGrantParams = {
    grant_id: number;
  };
  export type AuthorizationGetOrCreateAuthorizationForAppParams = {
    client_id: string;
    /**
     * The 40 character OAuth app client secret associated with the client ID specified in the URL.
     */
    client_secret: string;
    /**
     * A list of scopes that this authorization is in.
     */
    scopes?: string[];
    /**
     * A note to remind you what the OAuth token is for.
     */
    note?: string;
    /**
     * A URL to remind you what app the OAuth token is for.
     */
    note_url?: string;
    /**
     * A unique string to distinguish an authorization from others created for the same client and user. If provided, this API is functionally equivalent to [Get-or-create an authorization for a specific app and fingerprint](https://developer.github.com/v3/oauth_authorizations/#get-or-create-an-authorization-for-a-specific-app-and-fingerprint).
     */
    fingerprint?: string;
  };
  export type AuthorizationGetOrCreateAuthorizationForAppFingerprintParams = {
    client_id: string;

    fingerprint: string;
    /**
     * The 40 character OAuth app client secret associated with the client ID specified in the URL.
     */
    client_secret: string;
    /**
     * A list of scopes that this authorization is in.
     */
    scopes?: string[];
    /**
     * A note to remind you what the OAuth token is for.
     */
    note?: string;
    /**
     * A URL to remind you what app the OAuth token is for.
     */
    note_url?: string;
  };
  export type AuthorizationListAuthorizationsParams = {
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type AuthorizationListGrantsParams = {
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type AuthorizationResetAuthorizationParams = {
    client_id: string;

    access_token: string;
  };
  export type AuthorizationRevokeAuthorizationForApplicationParams = {
    client_id: string;

    access_token: string;
  };
  export type AuthorizationRevokeGrantForApplicationParams = {
    client_id: string;

    access_token: string;
  };
  export type AuthorizationUpdateAuthorizationParams = {
    authorization_id: number;
    /**
     * Replaces the authorization scopes with these.
     */
    scopes?: string[];
    /**
     * A list of scopes to add to this authorization.
     */
    add_scopes?: string[];
    /**
     * A list of scopes to remove from this authorization.
     */
    remove_scopes?: string[];
    /**
     * A note to remind you what the OAuth token is for. Tokens not associated with a specific OAuth application (i.e. personal access tokens) must have a unique note.
     */
    note?: string;
    /**
     * A URL to remind you what app the OAuth token is for.
     */
    note_url?: string;
    /**
     * A unique string to distinguish an authorization from others created for the same client ID and user.
     */
    fingerprint?: string;
  };
  export type ChecksCreateParams = {
    owner: string;

    repo: string;
    /**
     * The name of the check. For example, "code-coverage".
     */
    name: string;
    /**
     * The SHA of the commit.
     */
    head_sha: string;
    /**
     * The URL of the integrator's site that has the full details of the check.
     */
    details_url?: string;
    /**
     * A reference for the run on the integrator's system.
     */
    external_id?: string;
    /**
     * The current status. Can be one of `queued`, `in_progress`, or `completed`.
     */
    status?: "queued" | "in_progress" | "completed";
    /**
     * The time that the check run began in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    started_at?: string;
    /**
     * **Required if you provide `completed_at` or a `status` of `completed`**. The final conclusion of the check. Can be one of `success`, `failure`, `neutral`, `cancelled`, `timed_out`, or `action_required`. When the conclusion is `action_required`, additional details should be provided on the site specified by `details_url`.  ,* **Note:** Providing `conclusion` will automatically set the `status` parameter to `completed`.
     */
    conclusion?:
      | "success"
      | "failure"
      | "neutral"
      | "cancelled"
      | "timed_out"
      | "action_required";
    /**
     * **Required if you provide `conclusion`**. The time the check completed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    completed_at?: string;
    /**
     * Check runs can accept a variety of data in the `output` object, including a `title` and `summary` and can optionally provide descriptive details about the run. See the [`output` object](#output-object) description.
     */
    output?: ChecksCreateParamsOutput;
    /**
     * Possible further actions the integrator can perform, which a user may trigger. Each action includes a `label`, `identifier` and `description`. A maximum of three actions are accepted. See the [`actions` object](#actions-object) description.
     */
    actions?: ChecksCreateParamsActions[];
  };
  export type ChecksCreateSuiteParams = {
    owner: string;

    repo: string;
    /**
     * The sha of the head commit.
     */
    head_sha: string;
  };
  export type ChecksGetParams = {
    owner: string;

    repo: string;

    check_run_id: number;
  };
  export type ChecksGetSuiteParams = {
    owner: string;

    repo: string;

    check_suite_id: number;
  };
  export type ChecksListAnnotationsParams = {
    owner: string;

    repo: string;

    check_run_id: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type ChecksListForRefParams = {
    owner: string;

    repo: string;

    ref: string;
    /**
     * Returns check runs with the specified `name`.
     */
    check_name?: string;
    /**
     * Returns check runs with the specified `status`. Can be one of `queued`, `in_progress`, or `completed`.
     */
    status?: "queued" | "in_progress" | "completed";
    /**
     * Filters check runs by their `completed_at` timestamp. Can be one of `latest` (returning the most recent check runs) or `all`.
     */
    filter?: "latest" | "all";
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type ChecksListForSuiteParams = {
    owner: string;

    repo: string;

    check_suite_id: number;
    /**
     * Returns check runs with the specified `name`.
     */
    check_name?: string;
    /**
     * Returns check runs with the specified `status`. Can be one of `queued`, `in_progress`, or `completed`.
     */
    status?: "queued" | "in_progress" | "completed";
    /**
     * Filters check runs by their `completed_at` timestamp. Can be one of `latest` (returning the most recent check runs) or `all`.
     */
    filter?: "latest" | "all";
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type ChecksListSuitesForRefParams = {
    owner: string;

    repo: string;

    ref: string;
    /**
     * Filters check suites by GitHub App `id`.
     */
    app_id?: number;
    /**
     * Filters checks suites by the name of the [check run](https://developer.github.com/v3/checks/runs/).
     */
    check_name?: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type ChecksRerequestSuiteParams = {
    owner: string;

    repo: string;

    check_suite_id: number;
  };
  export type ChecksSetSuitesPreferencesParams = {
    owner: string;

    repo: string;
    /**
     * Enables or disables automatic creation of CheckSuite events upon pushes to the repository. Enabled by default. See the [`auto_trigger_checks` object](#auto_trigger_checks-object) description for details.
     */
    auto_trigger_checks?: ChecksSetSuitesPreferencesParamsAutoTriggerChecks[];
  };
  export type ChecksUpdateParams = {
    owner: string;

    repo: string;

    check_run_id: number;
    /**
     * The name of the check. For example, "code-coverage".
     */
    name?: string;
    /**
     * The URL of the integrator's site that has the full details of the check.
     */
    details_url?: string;
    /**
     * A reference for the run on the integrator's system.
     */
    external_id?: string;
    /**
     * A timestamp in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    started_at?: string;
    /**
     * The current status. Can be one of `queued`, `in_progress`, or `completed`.
     */
    status?: "queued" | "in_progress" | "completed";
    /**
     * **Required if you provide `completed_at` or a `status` of `completed`**. The final conclusion of the check. Can be one of `success`, `failure`, `neutral`, `cancelled`, `timed_out`, or `action_required`.  ,* **Note:** Providing `conclusion` will automatically set the `status` parameter to `completed`.
     */
    conclusion?:
      | "success"
      | "failure"
      | "neutral"
      | "cancelled"
      | "timed_out"
      | "action_required";
    /**
     * **Required if you provide `conclusion`**. The time the check completed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    completed_at?: string;
    /**
     * Check runs can accept a variety of data in the `output` object, including a `title` and `summary` and can optionally provide descriptive details about the run. See the [`output` object](#output-object-1) description.
     */
    output?: ChecksUpdateParamsOutput;
    /**
     * Possible further actions the integrator can perform, which a user may trigger. Each action includes a `label`, `identifier` and `description`. A maximum of three actions are accepted. See the [`actions` object](#actions-object) description.
     */
    actions?: ChecksUpdateParamsActions[];
  };
  export type CodesOfConductGetConductCodeParams = {
    key: string;
  };
  export type CodesOfConductGetForRepoParams = {
    owner: string;

    repo: string;
  };
  export type GistsCheckIsStarredParams = {
    gist_id: string;
  };
  export type GistsCreateParams = {
    /**
     * The filenames and content of each file in the gist. The keys in the `files` object represent the filename and have the type `string`.
     */
    files: GistsCreateParamsFiles;
    /**
     * A descriptive name for this gist.
     */
    description?: string;
    /**
     * When `true`, the gist will be public and available for anyone to see.
     */
    public?: boolean;
  };
  export type GistsCreateCommentParams = {
    gist_id: string;
    /**
     * The comment text.
     */
    body: string;
  };
  export type GistsDeleteParams = {
    gist_id: string;
  };
  export type GistsDeleteCommentParams = {
    gist_id: string;

    comment_id: number;
  };
  export type GistsForkParams = {
    gist_id: string;
  };
  export type GistsGetParams = {
    gist_id: string;
  };
  export type GistsGetCommentParams = {
    gist_id: string;

    comment_id: number;
  };
  export type GistsGetRevisionParams = {
    gist_id: string;

    sha: string;
  };
  export type GistsListParams = {
    /**
     * A timestamp in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`. Only gists updated at or after this time are returned.
     */
    since?: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type GistsListCommentsParams = {
    gist_id: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type GistsListCommitsParams = {
    gist_id: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type GistsListForksParams = {
    gist_id: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type GistsListPublicParams = {
    /**
     * A timestamp in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`. Only gists updated at or after this time are returned.
     */
    since?: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type GistsListPublicForUserParams = {
    username: string;
    /**
     * A timestamp in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`. Only gists updated at or after this time are returned.
     */
    since?: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type GistsListStarredParams = {
    /**
     * A timestamp in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`. Only gists updated at or after this time are returned.
     */
    since?: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type GistsStarParams = {
    gist_id: string;
  };
  export type GistsUnstarParams = {
    gist_id: string;
  };
  export type GistsUpdateParams = {
    gist_id: string;
    /**
     * A descriptive name for this gist.
     */
    description?: string;
    /**
     * The filenames and content that make up this gist.
     */
    files?: GistsUpdateParamsFiles;
  };
  export type GistsUpdateCommentParams = {
    gist_id: string;

    comment_id: number;
    /**
     * The comment text.
     */
    body: string;
  };
  export type GitdataCreateBlobParams = {
    owner: string;

    repo: string;
    /**
     * The new blob's content.
     */
    content: string;
    /**
     * The encoding used for `content`. Currently, `"utf-8"` and `"base64"` are supported.
     */
    encoding?: string;
  };
  export type GitdataCreateCommitParams = {
    owner: string;

    repo: string;
    /**
     * The commit message
     */
    message: string;
    /**
     * The SHA of the tree object this commit points to
     */
    tree: string;
    /**
     * The SHAs of the commits that were the parents of this commit. If omitted or empty, the commit will be written as a root commit. For a single parent, an array of one SHA should be provided; for a merge commit, an array of more than one should be provided.
     */
    parents: string[];
    /**
     * object containing information about the committer.
     */
    committer?: GitdataCreateCommitParamsCommitter;
    /**
     * object containing information about the author.
     */
    author?: GitdataCreateCommitParamsAuthor;
  };
  export type GitdataCreateRefParams = {
    owner: string;

    repo: string;
    /**
     * The name of the fully qualified reference (ie: `refs/heads/master`). If it doesn't start with 'refs' and have at least two slashes, it will be rejected.
     */
    ref: string;
    /**
     * The SHA1 value for this reference.
     */
    sha: string;
  };
  export type GitdataCreateTagParams = {
    owner: string;

    repo: string;
    /**
     * The tag's name. This is typically a version (e.g., "v0.0.1").
     */
    tag: string;
    /**
     * The tag message.
     */
    message: string;
    /**
     * The SHA of the git object this is tagging.
     */
    object: string;
    /**
     * The type of the object we're tagging. Normally this is a `commit` but it can also be a `tree` or a `blob`.
     */
    type: "commit" | "tree" | "blob";
    /**
     * An object with information about the individual creating the tag.
     */
    tagger?: GitdataCreateTagParamsTagger;
  };
  export type GitdataCreateTreeParams = {
    owner: string;

    repo: string;
    /**
     * Objects (of `path`, `mode`, `type`, and `sha`) specifying a tree structure
     */
    tree: GitdataCreateTreeParamsTree[];
    /**
     * The SHA1 of the tree you want to update with new data. If you don't set this, the commit will be created on top of everything; however, it will only contain your change, the rest of your files will show up as deleted.
     */
    base_tree?: string;
  };
  export type GitdataDeleteRefParams = {
    owner: string;

    repo: string;

    ref: string;
  };
  export type GitdataGetBlobParams = {
    owner: string;

    repo: string;

    file_sha: string;
  };
  export type GitdataGetCommitParams = {
    owner: string;

    repo: string;

    commit_sha: string;
  };
  export type GitdataGetRefParams = {
    owner: string;

    repo: string;
    /**
     * Must be formatted as `heads/branch`, not just `branch`
     */
    ref: string;
  };
  export type GitdataGetTagParams = {
    owner: string;

    repo: string;

    tag_sha: string;
  };
  export type GitdataGetTreeParams = {
    owner: string;

    repo: string;

    tree_sha: string;

    recursive?: 1;
  };
  export type GitdataListRefsParams = {
    owner: string;

    repo: string;
    /**
     * Filter by sub-namespace (reference prefix). Most commen examples would be `'heads/'` and `'tags/'` to retrieve branches or tags
     */
    namespace?: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type GitdataUpdateRefParams = {
    owner: string;

    repo: string;

    ref: string;
    /**
     * The SHA1 value to set this reference to
     */
    sha: string;
    /**
     * Indicates whether to force the update or to make sure the update is a fast-forward update. Leaving this out or setting it to `false` will make sure you're not overwriting work.
     */
    force?: boolean;
  };
  export type GitignoreGetTemplateParams = {
    name: string;
  };
  export type IssuesAddAssigneesParams = {
    owner: string;

    repo: string;

    number: number;
    /**
     * Usernames of people to assign this issue to. _NOTE: Only users with push access can add assignees to an issue. Assignees are silently ignored otherwise._
     */
    assignees?: string[];
  };
  export type IssuesAddLabelsParams = {
    owner: string;

    repo: string;

    number: number;
    /**
     * The name of the label to add to the issue. Must contain at least one label. **Note:** Alternatively, you can pass a single label as a `string` or an `array` of labels directly, but GitHub recommends passing an object with the `labels` key.
     */
    labels: string[];
  };
  export type IssuesCheckAssigneeParams = {
    owner: string;

    repo: string;

    assignee: string;
  };
  export type IssuesCreateParams = {
    owner: string;

    repo: string;
    /**
     * The title of the issue.
     */
    title: string;
    /**
     * The contents of the issue.
     */
    body?: string;
    /**
     * Login for the user that this issue should be assigned to. _NOTE: Only users with push access can set the assignee for new issues. The assignee is silently dropped otherwise. **This field is deprecated.**_
     */
    assignee?: string;
    /**
     * The `number` of the milestone to associate this issue with. _NOTE: Only users with push access can set the milestone for new issues. The milestone is silently dropped otherwise._
     */
    milestone?: number;
    /**
     * Labels to associate with this issue. _NOTE: Only users with push access can set labels for new issues. Labels are silently dropped otherwise._
     */
    labels?: string[];
    /**
     * Logins for Users to assign to this issue. _NOTE: Only users with push access can set assignees for new issues. Assignees are silently dropped otherwise._
     */
    assignees?: string[];
  };
  export type IssuesCreateCommentParams = {
    owner: string;

    repo: string;

    number: number;
    /**
     * The contents of the comment.
     */
    body: string;
  };
  export type IssuesCreateLabelParams = {
    owner: string;

    repo: string;
    /**
     * The name of the label. Emoji can be added to label names, using either native emoji or colon-style markup. For example, typing `:strawberry:` will render the emoji ![:strawberry:](https://a248.e.akamai.net/assets.github.com/images/icons/emoji/unicode/1f353.png ":strawberry:"). For a full list of available emoji and codes, see [emoji-cheat-sheet.com](http://emoji-cheat-sheet.com/).
     */
    name: string;
    /**
     * The [hexadecimal color code](http://www.color-hex.com/) for the label, without the leading `#`.
     */
    color: string;
    /**
     * A short description of the label.
     */
    description?: string;
  };
  export type IssuesCreateMilestoneParams = {
    owner: string;

    repo: string;
    /**
     * The title of the milestone.
     */
    title: string;
    /**
     * The state of the milestone. Either `open` or `closed`.
     */
    state?: "open" | "closed";
    /**
     * A description of the milestone.
     */
    description?: string;
    /**
     * The milestone due date. This is a timestamp in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    due_on?: string;
  };
  export type IssuesDeleteCommentParams = {
    owner: string;

    repo: string;

    comment_id: number;
  };
  export type IssuesDeleteLabelParams = {
    owner: string;

    repo: string;

    name: string;
  };
  export type IssuesDeleteMilestoneParams = {
    owner: string;

    repo: string;

    number: number;
  };
  export type IssuesGetParams = {
    owner: string;

    repo: string;

    number: number;
  };
  export type IssuesGetCommentParams = {
    owner: string;

    repo: string;

    comment_id: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type IssuesGetEventParams = {
    owner: string;

    repo: string;

    event_id: number;
  };
  export type IssuesGetLabelParams = {
    owner: string;

    repo: string;

    name: string;
  };
  export type IssuesGetMilestoneParams = {
    owner: string;

    repo: string;

    number: number;
  };
  export type IssuesListParams = {
    /**
     * Indicates which sorts of issues to return. Can be one of:  ,* \* `assigned`: Issues assigned to you  ,* \* `created`: Issues created by you  ,* \* `mentioned`: Issues mentioning you  ,* \* `subscribed`: Issues you're subscribed to updates for  ,* \* `all`: All issues the authenticated user can see, regardless of participation or creation
     */
    filter?: "assigned" | "created" | "mentioned" | "subscribed" | "all";
    /**
     * Indicates the state of the issues to return. Can be either `open`, `closed`, or `all`.
     */
    state?: "open" | "closed" | "all";
    /**
     * A list of comma separated label names. Example: `bug,ui,@high`
     */
    labels?: string;
    /**
     * What to sort results by. Can be either `created`, `updated`, `comments`.
     */
    sort?: "created" | "updated" | "comments";
    /**
     * The direction of the sort. Can be either `asc` or `desc`.
     */
    direction?: "asc" | "desc";
    /**
     * Only issues updated at or after this time are returned. This is a timestamp in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    since?: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type IssuesListAssigneesParams = {
    owner: string;

    repo: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type IssuesListCommentsParams = {
    owner: string;

    repo: string;

    number: number;
    /**
     * Only comments updated at or after this time are returned. This is a timestamp in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    since?: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type IssuesListCommentsForRepoParams = {
    owner: string;

    repo: string;
    /**
     * Either `created` or `updated`.
     */
    sort?: "created" | "updated";
    /**
     * Either `asc` or `desc`. Ignored without the `sort` parameter.
     */
    direction?: "asc" | "desc";
    /**
     * Only comments updated at or after this time are returned. This is a timestamp in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    since?: string;
  };
  export type IssuesListEventsParams = {
    owner: string;

    repo: string;

    number: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type IssuesListEventsForRepoParams = {
    owner: string;

    repo: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type IssuesListEventsForTimelineParams = {
    owner: string;

    repo: string;

    number: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type IssuesListForAuthenticatedUserParams = {
    /**
     * Indicates which sorts of issues to return. Can be one of:  ,* \* `assigned`: Issues assigned to you  ,* \* `created`: Issues created by you  ,* \* `mentioned`: Issues mentioning you  ,* \* `subscribed`: Issues you're subscribed to updates for  ,* \* `all`: All issues the authenticated user can see, regardless of participation or creation
     */
    filter?: "assigned" | "created" | "mentioned" | "subscribed" | "all";
    /**
     * Indicates the state of the issues to return. Can be either `open`, `closed`, or `all`.
     */
    state?: "open" | "closed" | "all";
    /**
     * A list of comma separated label names. Example: `bug,ui,@high`
     */
    labels?: string;
    /**
     * What to sort results by. Can be either `created`, `updated`, `comments`.
     */
    sort?: "created" | "updated" | "comments";
    /**
     * The direction of the sort. Can be either `asc` or `desc`.
     */
    direction?: "asc" | "desc";
    /**
     * Only issues updated at or after this time are returned. This is a timestamp in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    since?: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type IssuesListForOrgParams = {
    org: string;
    /**
     * Indicates which sorts of issues to return. Can be one of:  ,* \* `assigned`: Issues assigned to you  ,* \* `created`: Issues created by you  ,* \* `mentioned`: Issues mentioning you  ,* \* `subscribed`: Issues you're subscribed to updates for  ,* \* `all`: All issues the authenticated user can see, regardless of participation or creation
     */
    filter?: "assigned" | "created" | "mentioned" | "subscribed" | "all";
    /**
     * Indicates the state of the issues to return. Can be either `open`, `closed`, or `all`.
     */
    state?: "open" | "closed" | "all";
    /**
     * A list of comma separated label names. Example: `bug,ui,@high`
     */
    labels?: string;
    /**
     * What to sort results by. Can be either `created`, `updated`, `comments`.
     */
    sort?: "created" | "updated" | "comments";
    /**
     * The direction of the sort. Can be either `asc` or `desc`.
     */
    direction?: "asc" | "desc";
    /**
     * Only issues updated at or after this time are returned. This is a timestamp in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    since?: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type IssuesListForRepoParams = {
    owner: string;

    repo: string;
    /**
     * If an `integer` is passed, it should refer to a milestone by its `number` field. If the string `*` is passed, issues with any milestone are accepted. If the string `none` is passed, issues without milestones are returned.
     */
    milestone?: string;
    /**
     * Indicates the state of the issues to return. Can be either `open`, `closed`, or `all`.
     */
    state?: "open" | "closed" | "all";
    /**
     * Can be the name of a user. Pass in `none` for issues with no assigned user, and `*` for issues assigned to any user.
     */
    assignee?: string;
    /**
     * The user that created the issue.
     */
    creator?: string;
    /**
     * A user that's mentioned in the issue.
     */
    mentioned?: string;
    /**
     * A list of comma separated label names. Example: `bug,ui,@high`
     */
    labels?: string;
    /**
     * What to sort results by. Can be either `created`, `updated`, `comments`.
     */
    sort?: "created" | "updated" | "comments";
    /**
     * The direction of the sort. Can be either `asc` or `desc`.
     */
    direction?: "asc" | "desc";
    /**
     * Only issues updated at or after this time are returned. This is a timestamp in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    since?: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type IssuesListLabelsForMilestoneParams = {
    owner: string;

    repo: string;

    number: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type IssuesListLabelsForRepoParams = {
    owner: string;

    repo: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type IssuesListLabelsOnIssueParams = {
    owner: string;

    repo: string;

    number: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type IssuesListMilestonesForRepoParams = {
    owner: string;

    repo: string;
    /**
     * The state of the milestone. Either `open`, `closed`, or `all`.
     */
    state?: "open" | "closed" | "all";
    /**
     * What to sort results by. Either `due_on` or `completeness`.
     */
    sort?: "due_on" | "completeness";
    /**
     * The direction of the sort. Either `asc` or `desc`.
     */
    direction?: "asc" | "desc";
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type IssuesLockParams = {
    owner: string;

    repo: string;

    number: number;
    /**
     * The reason for locking the issue or pull request conversation. Lock will fail if you don't use one of these reasons:  ,* \* `off-topic`  ,* \* `too heated`  ,* \* `resolved`  ,* \* `spam`
     */
    lock_reason?: "off-topic" | "too heated" | "resolved" | "spam";
  };
  export type IssuesRemoveAssigneesParams = {
    owner: string;

    repo: string;

    number: number;
    /**
     * Usernames of assignees to remove from an issue. _NOTE: Only users with push access can remove assignees from an issue. Assignees are silently ignored otherwise._
     */
    assignees?: string[];
  };
  export type IssuesRemoveLabelParams = {
    owner: string;

    repo: string;

    number: number;

    name: string;
  };
  export type IssuesRemoveLabelsParams = {
    owner: string;

    repo: string;

    number: number;
  };
  export type IssuesReplaceLabelsParams = {
    owner: string;

    repo: string;

    number: number;
    /**
     * The names of the labels to add to the issue. You can pass an empty array to remove all labels. **Note:** Alternatively, you can pass a single label as a `string` or an `array` of labels directly, but GitHub recommends passing an object with the `labels` key.
     */
    labels?: string[];
  };
  export type IssuesUnlockParams = {
    owner: string;

    repo: string;

    number: number;
  };
  export type IssuesUpdateParams = {
    owner: string;

    repo: string;

    number: number;
    /**
     * The title of the issue.
     */
    title?: string;
    /**
     * The contents of the issue.
     */
    body?: string;
    /**
     * Login for the user that this issue should be assigned to. **This field is deprecated.**
     */
    assignee?: string;
    /**
     * State of the issue. Either `open` or `closed`.
     */
    state?: "open" | "closed";
    /**
     * The `number` of the milestone to associate this issue with or `null` to remove current. _NOTE: Only users with push access can set the milestone for issues. The milestone is silently dropped otherwise._
     */
    milestone?: number | null;
    /**
     * Labels to associate with this issue. Pass one or more Labels to _replace_ the set of Labels on this Issue. Send an empty array (`[]`) to clear all Labels from the Issue. _NOTE: Only users with push access can set labels for issues. Labels are silently dropped otherwise._
     */
    labels?: string[];
    /**
     * Logins for Users to assign to this issue. Pass one or more user logins to _replace_ the set of assignees on this Issue. Send an empty array (`[]`) to clear all assignees from the Issue. _NOTE: Only users with push access can set assignees for new issues. Assignees are silently dropped otherwise._
     */
    assignees?: string[];
  };
  export type IssuesUpdateCommentParams = {
    owner: string;

    repo: string;

    comment_id: number;
    /**
     * The contents of the comment.
     */
    body: string;
  };
  export type IssuesUpdateLabelParams = {
    owner: string;

    repo: string;

    current_name: string;
    /**
     * The new name of the label. Emoji can be added to label names, using either native emoji or colon-style markup. For example, typing `:strawberry:` will render the emoji ![:strawberry:](https://a248.e.akamai.net/assets.github.com/images/icons/emoji/unicode/1f353.png ":strawberry:"). For a full list of available emoji and codes, see [emoji-cheat-sheet.com](http://emoji-cheat-sheet.com/).
     */
    name?: string;
    /**
     * The [hexadecimal color code](http://www.color-hex.com/) for the label, without the leading `#`.
     */
    color?: string;
    /**
     * A short description of the label.
     */
    description?: string;
  };
  export type IssuesUpdateMilestoneParams = {
    owner: string;

    repo: string;

    number: number;
    /**
     * The title of the milestone.
     */
    title?: string;
    /**
     * The state of the milestone. Either `open` or `closed`.
     */
    state?: "open" | "closed";
    /**
     * A description of the milestone.
     */
    description?: string;
    /**
     * The milestone due date. This is a timestamp in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    due_on?: string;
  };
  export type LicensesGetParams = {
    license: string;
  };
  export type LicensesGetForRepoParams = {
    owner: string;

    repo: string;
  };
  export type MarkdownRenderParams = {
    /**
     * The Markdown text to render in HTML. Markdown content must be 400 KB or less.
     */
    text: string;
    /**
     * The rendering mode. Can be either:  ,* \* `markdown` to render a document in plain Markdown, just like README.md files are rendered.  ,* \* `gfm` to render a document in [GitHub Flavored Markdown](https://github.github.com/gfm/), which creates links for user mentions as well as references to SHA-1 hashes, issues, and pull requests.
     */
    mode?: "markdown" | "gfm";
    /**
     * The repository context to use when creating references in `gfm` mode. Omit this parameter when using `markdown` mode.
     */
    context?: string;
  };
  export type MarkdownRenderRawParams = {
    data: string;
  };
  export type MigrationsCancelImportParams = {
    owner: string;

    repo: string;
  };
  export type MigrationsDeleteArchiveForAuthenticatedUserParams = {
    migration_id: number;
  };
  export type MigrationsDeleteArchiveForOrgParams = {
    org: string;

    migration_id: number;
  };
  export type MigrationsGetArchiveForAuthenticatedUserParams = {
    migration_id: number;
  };
  export type MigrationsGetArchiveForOrgParams = {
    org: string;

    migration_id: number;
  };
  export type MigrationsGetCommitAuthorsParams = {
    owner: string;

    repo: string;
    /**
     * Only authors found after this id are returned. Provide the highest author ID you've seen so far. New authors may be added to the list at any point while the importer is performing the `raw` step.
     */
    since?: string;
  };
  export type MigrationsGetImportProgressParams = {
    owner: string;

    repo: string;
  };
  export type MigrationsGetLargeFilesParams = {
    owner: string;

    repo: string;
  };
  export type MigrationsGetStatusForAuthenticatedUserParams = {
    migration_id: number;
  };
  export type MigrationsGetStatusForOrgParams = {
    org: string;

    migration_id: number;
  };
  export type MigrationsListForAuthenticatedUserParams = {
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type MigrationsListForOrgParams = {
    org: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type MigrationsMapCommitAuthorParams = {
    owner: string;

    repo: string;

    author_id: number;
    /**
     * The new Git author email.
     */
    email?: string;
    /**
     * The new Git author name.
     */
    name?: string;
  };
  export type MigrationsSetLfsPreferenceParams = {
    owner: string;

    repo: string;
    /**
     * Can be one of `opt_in` (large files will be stored using Git LFS) or `opt_out` (large files will be removed during the import).
     */
    use_lfs: "opt_in" | "opt_out";
  };
  export type MigrationsStartForAuthenticatedUserParams = {
    /**
     * An array of repositories to include in the migration.
     */
    repositories: string[];
    /**
     * Locks the `repositories` to prevent changes during the migration when set to `true`.
     */
    lock_repositories?: boolean;
    /**
     * Does not include attachments uploaded to GitHub.com in the migration data when set to `true`. Excluding attachments will reduce the migration archive file size.
     */
    exclude_attachments?: boolean;
  };
  export type MigrationsStartForOrgParams = {
    org: string;
    /**
     * A list of arrays indicating which repositories should be migrated.
     */
    repositories: string[];
    /**
     * Indicates whether repositories should be locked (to prevent manipulation) while migrating data.
     */
    lock_repositories?: boolean;
    /**
     * Indicates whether attachments should be excluded from the migration (to reduce migration archive file size).
     */
    exclude_attachments?: boolean;
  };
  export type MigrationsStartImportParams = {
    owner: string;

    repo: string;
    /**
     * The URL of the originating repository.
     */
    vcs_url: string;
    /**
     * The originating VCS type. Can be one of `subversion`, `git`, `mercurial`, or `tfvc`. Please be aware that without this parameter, the import job will take additional time to detect the VCS type before beginning the import. This detection step will be reflected in the response.
     */
    vcs?: "subversion" | "git" | "mercurial" | "tfvc";
    /**
     * If authentication is required, the username to provide to `vcs_url`.
     */
    vcs_username?: string;
    /**
     * If authentication is required, the password to provide to `vcs_url`.
     */
    vcs_password?: string;
    /**
     * For a tfvc import, the name of the project that is being imported.
     */
    tfvc_project?: string;
  };
  export type MigrationsUnlockRepoForAuthenticatedUserParams = {
    migration_id: number;

    repo_name: string;
  };
  export type MigrationsUnlockRepoForOrgParams = {
    org: string;

    migration_id: number;

    repo_name: string;
  };
  export type MigrationsUpdateImportParams = {
    owner: string;

    repo: string;
    /**
     * The username to provide to the originating repository.
     */
    vcs_username?: string;
    /**
     * The password to provide to the originating repository.
     */
    vcs_password?: string;
  };
  export type OrgsAddOrUpdateMembershipParams = {
    org: string;

    username: string;
    /**
     * The role to give the user in the organization. Can be one of:  ,* \* `admin` - The user will become an owner of the organization.  ,* \* `member` - The user will become a non-owner member of the organization.
     */
    role?: "admin" | "member";
  };
  export type OrgsBlockUserParams = {
    org: string;

    username: string;
  };
  export type OrgsCheckBlockedUserParams = {
    org: string;

    username: string;
  };
  export type OrgsCheckMembershipParams = {
    org: string;

    username: string;
  };
  export type OrgsCheckPublicMembershipParams = {
    org: string;

    username: string;
  };
  export type OrgsConcealMembershipParams = {
    org: string;

    username: string;
  };
  export type OrgsConvertMemberToOutsideCollaboratorParams = {
    org: string;

    username: string;
  };
  export type OrgsCreateHookParams = {
    org: string;
    /**
     * Must be passed as "web".
     */
    name: string;
    /**
     * Key/value pairs to provide settings for this webhook. [These are defined below](#create-hook-config-params).
     */
    config: OrgsCreateHookParamsConfig;
    /**
     * Determines what [events](https://developer.github.com/v3/activity/events/types/) the hook is triggered for.
     */
    events?: string[];
    /**
     * Determines if notifications are sent when the webhook is triggered. Set to `true` to send notifications.
     */
    active?: boolean;
  };
  export type OrgsCreateInvitationParams = {
    org: string;
    /**
     * **Required unless you provide `email`**. GitHub user ID for the person you are inviting.
     */
    invitee_id?: number;
    /**
     * **Required unless you provide `invitee_id`**. Email address of the person you are inviting, which can be an existing GitHub user.
     */
    email?: string;
    /**
     * Specify role for new member. Can be one of:  ,* \* `admin` - Organization owners with full administrative rights to the organization and complete access to all repositories and teams.  ,* \* `direct_member` - Non-owner organization members with ability to see other members and join teams by invitation.  ,* \* `billing_manager` - Non-owner organization members with ability to manage the billing settings of your organization.
     */
    role?: "admin" | "direct_member" | "billing_manager";
    /**
     * Specify IDs for the teams you want to invite new members to.
     */
    team_ids?: number[];
  };
  export type OrgsDeleteHookParams = {
    org: string;

    hook_id: number;
  };
  export type OrgsGetParams = {
    org: string;
  };
  export type OrgsGetHookParams = {
    org: string;

    hook_id: number;
  };
  export type OrgsGetMembershipParams = {
    org: string;

    username: string;
  };
  export type OrgsGetMembershipForAuthenticatedUserParams = {
    org: string;
  };
  export type OrgsListParams = {
    /**
     * The integer ID of the last Organization that you've seen.
     */
    since?: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type OrgsListBlockedUsersParams = {
    org: string;
  };
  export type OrgsListForAuthenticatedUserParams = {
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type OrgsListForUserParams = {
    username: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type OrgsListHooksParams = {
    org: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type OrgsListInvitationTeamsParams = {
    org: string;

    invitation_id: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type OrgsListMembersParams = {
    org: string;
    /**
     * Filter members returned in the list. Can be one of:  ,* \* `2fa_disabled` - Members without [two-factor authentication](https://github.com/blog/1614-two-factor-authentication) enabled. Available for organization owners.  ,* \* `all` - All members the authenticated user can see.
     */
    filter?: "2fa_disabled" | "all";
    /**
     * Filter members returned by their role. Can be one of:  ,* \* `all` - All members of the organization, regardless of role.  ,* \* `admin` - Organization owners.  ,* \* `member` - Non-owner organization members.
     */
    role?: "all" | "admin" | "member";
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type OrgsListMembershipsParams = {
    /**
     * Indicates the state of the memberships to return. Can be either `active` or `pending`. If not specified, the API returns both active and pending memberships.
     */
    state?: "active" | "pending";
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type OrgsListOutsideCollaboratorsParams = {
    org: string;
    /**
     * Filter the list of outside collaborators. Can be one of:  ,* \* `2fa_disabled`: Outside collaborators without [two-factor authentication](https://github.com/blog/1614-two-factor-authentication) enabled.  ,* \* `all`: All outside collaborators.
     */
    filter?: "2fa_disabled" | "all";
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type OrgsListPendingInvitationsParams = {
    org: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type OrgsListPublicMembersParams = {
    org: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type OrgsPingHookParams = {
    org: string;

    hook_id: number;
  };
  export type OrgsPublicizeMembershipParams = {
    org: string;

    username: string;
  };
  export type OrgsRemoveMemberParams = {
    org: string;

    username: string;
  };
  export type OrgsRemoveMembershipParams = {
    org: string;

    username: string;
  };
  export type OrgsRemoveOutsideCollaboratorParams = {
    org: string;

    username: string;
  };
  export type OrgsUnblockUserParams = {
    org: string;

    username: string;
  };
  export type OrgsUpdateParams = {
    org: string;
    /**
     * Billing email address. This address is not publicized.
     */
    billing_email?: string;
    /**
     * The company name.
     */
    company?: string;
    /**
     * The publicly visible email address.
     */
    email?: string;
    /**
     * The location.
     */
    location?: string;
    /**
     * The shorthand name of the company.
     */
    name?: string;
    /**
     * The description of the company.
     */
    description?: string;
    /**
     * Toggles whether organization projects are enabled for the organization.
     */
    has_organization_projects?: boolean;
    /**
     * Toggles whether repository projects are enabled for repositories that belong to the organization.
     */
    has_repository_projects?: boolean;
    /**
     * Default permission level members have for organization repositories:  ,* \* `read` - can pull, but not push to or administer this repository.  ,* \* `write` - can pull and push, but not administer this repository.  ,* \* `admin` - can pull, push, and administer this repository.  ,* \* `none` - no permissions granted by default.
     */
    default_repository_permission?: "read" | "write" | "admin" | "none";
    /**
     * Toggles ability of non-admin organization members to create repositories  ,* \* `true` - all organization members can create repositories.  ,* \* `false` - only admin members can create repositories.
     */
    members_can_create_repositories?: boolean;
  };
  export type OrgsUpdateHookParams = {
    org: string;

    hook_id: number;
    /**
     * Key/value pairs to provide settings for this webhook. [These are defined below](#update-hook-config-params).
     */
    config?: OrgsUpdateHookParamsConfig;
    /**
     * Determines what [events](https://developer.github.com/v3/activity/events/types/) the hook is triggered for.
     */
    events?: string[];
    /**
     * Determines if notifications are sent when the webhook is triggered. Set to `true` to send notifications.
     */
    active?: boolean;
  };
  export type OrgsUpdateMembershipParams = {
    org: string;
    /**
     * The state that the membership should be in. Only `"active"` will be accepted.
     */
    state: "active";
  };
  export type ProjectsAddCollaboratorParams = {
    project_id: number;

    username: string;
    /**
     * The permission to grant the collaborator. Note that, if you choose not to pass any parameters, you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP verbs](https://developer.github.com/v3/#http-verbs)." Can be one of:  ,* \* `read` - can read, but not write to or administer this project.  ,* \* `write` - can read and write, but not administer this project.  ,* \* `admin` - can read, write and administer this project.
     */
    permission?: "read" | "write" | "admin";
  };
  export type ProjectsCreateCardParams = {
    column_id: number;
    /**
     * The card's note content. Only valid for cards without another type of content, so you must omit when specifying `content_id` and `content_type`.
     */
    note?: string;
    /**
     * The issue or pull request id you want to associate with this card. You can use the [List issues for a repository](https://developer.github.com/v3/issues/#list-issues-for-a-repository) and [List pull requests](https://developer.github.com/v3/pulls/#list-pull-requests) endpoints to find this id.  ,* **Note:** Depending on whether you use the issue id or pull request id, you will need to specify `Issue` or `PullRequest` as the `content_type`.
     */
    content_id?: number;
    /**
     * **Required if you provide `content_id`**. The type of content you want to associate with this card. Use `Issue` when `content_id` is an issue id and use `PullRequest` when `content_id` is a pull request id.
     */
    content_type?: string;
  };
  export type ProjectsCreateColumnParams = {
    project_id: number;
    /**
     * The name of the column.
     */
    name: string;
  };
  export type ProjectsCreateForOrgParams = {
    org: string;
    /**
     * The name of the project.
     */
    name: string;
    /**
     * The body of the project.
     */
    body?: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type ProjectsCreateForRepoParams = {
    owner: string;

    repo: string;
    /**
     * The name of the project.
     */
    name: string;
    /**
     * The body of the project.
     */
    body?: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type ProjectsDeleteParams = {
    project_id: number;
  };
  export type ProjectsDeleteCardParams = {
    card_id: number;
  };
  export type ProjectsDeleteColumnParams = {
    column_id: number;
  };
  export type ProjectsGetParams = {
    project_id: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type ProjectsGetCardParams = {
    card_id: number;
  };
  export type ProjectsGetColumnParams = {
    column_id: number;
  };
  export type ProjectsListCardsParams = {
    column_id: number;
    /**
     * Filters the project cards that are returned by the card's state. Can be one of `all`,`archived`, or `not_archived`.
     */
    archived_state?: "all" | "archived" | "not_archived";
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type ProjectsListCollaboratorsParams = {
    project_id: number;
    /**
     * Filters the collaborators by their affiliation. Can be one of:  ,* \* `outside`: Outside collaborators of a project that are not a member of the project's organization.  ,* \* `direct`: Collaborators with permissions to a project, regardless of organization membership status.  ,* \* `all`: All collaborators the authenticated user can see.
     */
    affiliation?: "outside" | "direct" | "all";
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type ProjectsListColumnsParams = {
    project_id: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type ProjectsListForOrgParams = {
    org: string;
    /**
     * Indicates the state of the projects to return. Can be either `open`, `closed`, or `all`.
     */
    state?: "open" | "closed" | "all";
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type ProjectsListForRepoParams = {
    owner: string;

    repo: string;
    /**
     * Indicates the state of the projects to return. Can be either `open`, `closed`, or `all`.
     */
    state?: "open" | "closed" | "all";
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type ProjectsMoveCardParams = {
    card_id: number;
    /**
     * Can be one of `top`, `bottom`, or `after:<card_id>`, where `<card_id>` is the `id` value of a card in the same column, or in the new column specified by `column_id`.
     */
    position: string;
    /**
     * The `id` value of a column in the same project.
     */
    column_id?: number;
  };
  export type ProjectsMoveColumnParams = {
    column_id: number;
    /**
     * Can be one of `first`, `last`, or `after:<column_id>`, where `<column_id>` is the `id` value of a column in the same project.
     */
    position: string;
  };
  export type ProjectsRemoveCollaboratorParams = {
    project_id: number;

    username: string;
  };
  export type ProjectsReviewUserPermissionLevelParams = {
    project_id: number;

    username: string;
  };
  export type ProjectsUpdateParams = {
    project_id: number;
    /**
     * The name of the project.
     */
    name?: string;
    /**
     * The body of the project.
     */
    body?: string;
    /**
     * State of the project. Either `open` or `closed`.
     */
    state?: "open" | "closed";
    /**
     * The permission level that all members of the project's organization will have on this project. If an organization member belongs to a team with a higher level of access or is a collaborator with a higher level of access, their permission level is not lowered by `organization_permission`. Updating a project's organization permission requires `admin` access to the project. Setting the organization permission is only available for organization projects.
     */
    organization_permission?: string;
    /**
     * Sets visibility of the project within the organization. Updating a project's visibility requires `admin` access to the project. Setting visibility is only available for organization projects. Can be one of:  ,* \* `true` - Anyone that can view the organization can see the project.  ,* \* `false` - The project must be an organization project to set project visibility.
     */
    public?: boolean;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type ProjectsUpdateCardParams = {
    card_id: number;
    /**
     * The card's note content. Only valid for cards without another type of content, so this cannot be specified if the card already has a `content_id` and `content_type`.
     */
    note?: string;
    /**
     * Use `true` to archive a project card. Specify `false` if you need to restore a previously archived project card.
     */
    archived?: boolean;
  };
  export type ProjectsUpdateColumnParams = {
    column_id: number;
    /**
     * The new name of the column.
     */
    name: string;
  };
  export type PullRequestsCheckIfMergedParams = {
    owner: string;

    repo: string;

    number: number;
  };
  export type PullRequestsCreateParams = {
    owner: string;

    repo: string;
    /**
     * The title of the pull request.
     */
    title: string;
    /**
     * The name of the branch where your changes are implemented. For cross-repository pull requests in the same network, namespace `head` with a user like this: `username:branch`.
     */
    head: string;
    /**
     * The name of the branch you want the changes pulled into. This should be an existing branch on the current repository. You cannot submit a pull request to one repository that requests a merge to a base of another repository.
     */
    base: string;
    /**
     * The contents of the pull request.
     */
    body?: string;
    /**
     * Indicates whether [maintainers can modify](https://help.github.com/articles/allowing-changes-to-a-pull-request-branch-created-from-a-fork/) the pull request.
     */
    maintainer_can_modify?: boolean;
  };
  export type PullRequestsCreateCommentParams = {
    owner: string;

    repo: string;

    number: number;
    /**
     * The text of the comment.
     */
    body: string;
    /**
     * The SHA of the commit needing a comment. Not using the latest commit SHA may render your comment outdated if a subsequent commit modifies the line you specify as the `position`.
     */
    commit_id: string;
    /**
     * The relative path to the file that necessitates a comment.
     */
    path: string;
    /**
     * The position in the diff where you want to add a review comment. Note this value is not the same as the line number in the file. For help finding the position value, read the note below.
     */
    position: number;
  };
  export type PullRequestsCreateCommentReplyParams = {
    owner: string;

    repo: string;

    number: number;
    /**
     * The text of the comment.
     */
    body: string;
    /**
     * The comment ID to reply to. **Note**: This must be the ID of a _top-level comment_, not a reply to that comment. Replies to replies are not supported.
     */
    in_reply_to: number;
  };
  export type PullRequestsCreateFromIssueParams = {
    owner: string;

    repo: string;
    /**
     * The issue number in this repository to turn into a Pull Request.
     */
    issue: number;
    /**
     * The name of the branch where your changes are implemented. For cross-repository pull requests in the same network, namespace `head` with a user like this: `username:branch`.
     */
    head: string;
    /**
     * The name of the branch you want the changes pulled into. This should be an existing branch on the current repository. You cannot submit a pull request to one repository that requests a merge to a base of another repository.
     */
    base: string;
    /**
     * Indicates whether [maintainers can modify](https://help.github.com/articles/allowing-changes-to-a-pull-request-branch-created-from-a-fork/) the pull request.
     */
    maintainer_can_modify?: boolean;
  };
  export type PullRequestsCreateReviewParams = {
    owner: string;

    repo: string;

    number: number;
    /**
     * The SHA of the commit that needs a review. Not using the latest commit SHA may render your review comment outdated if a subsequent commit modifies the line you specify as the `position`. Defaults to the most recent commit in the pull request when you do not specify a value.
     */
    commit_id?: string;
    /**
     * **Required** when using `REQUEST_CHANGES` or `COMMENT` for the `event` parameter. The body text of the pull request review.
     */
    body?: string;
    /**
     * The review action you want to perform. The review actions include: `APPROVE`, `REQUEST_CHANGES`, or `COMMENT`. By leaving this blank, you set the review action state to `PENDING`, which means you will need to [submit the pull request review](https://developer.github.com/v3/pulls/reviews/#submit-a-pull-request-review) when you are ready.
     */
    event?: "APPROVE" | "REQUEST_CHANGES" | "COMMENT";
    /**
     * Use the following table to specify the location, destination, and contents of the draft review comment.
     */
    comments?: PullRequestsCreateReviewParamsComments[];
  };
  export type PullRequestsCreateReviewRequestParams = {
    owner: string;

    repo: string;

    number: number;
    /**
     * An array of user `login`s that will be requested.
     */
    reviewers?: string[];
    /**
     * An array of team `slug`s that will be requested.
     */
    team_reviewers?: string[];
  };
  export type PullRequestsDeleteCommentParams = {
    owner: string;

    repo: string;

    comment_id: number;
  };
  export type PullRequestsDeletePendingReviewParams = {
    owner: string;

    repo: string;

    number: number;

    review_id: number;
  };
  export type PullRequestsDeleteReviewRequestParams = {
    owner: string;

    repo: string;

    number: number;
    /**
     * An array of user `login`s that will be removed.
     */
    reviewers?: string[];
    /**
     * An array of team `slug`s that will be removed.
     */
    team_reviewers?: string[];
  };
  export type PullRequestsDismissReviewParams = {
    owner: string;

    repo: string;

    number: number;

    review_id: number;
    /**
     * The message for the pull request review dismissal
     */
    message: string;
  };
  export type PullRequestsGetParams = {
    owner: string;

    repo: string;

    number: number;
  };
  export type PullRequestsGetCommentParams = {
    owner: string;

    repo: string;

    comment_id: number;
  };
  export type PullRequestsGetCommentsForReviewParams = {
    owner: string;

    repo: string;

    number: number;

    review_id: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type PullRequestsGetReviewParams = {
    owner: string;

    repo: string;

    number: number;

    review_id: number;
  };
  export type PullRequestsListParams = {
    owner: string;

    repo: string;
    /**
     * Either `open`, `closed`, or `all` to filter by state.
     */
    state?: "open" | "closed" | "all";
    /**
     * Filter pulls by head user and branch name in the format of `user:ref-name`. Example: `github:new-script-format`.
     */
    head?: string;
    /**
     * Filter pulls by base branch name. Example: `gh-pages`.
     */
    base?: string;
    /**
     * What to sort results by. Can be either `created`, `updated`, `popularity` (comment count) or `long-running` (age, filtering by pulls updated in the last month).
     */
    sort?: "created" | "updated" | "popularity" | "long-running";
    /**
     * The direction of the sort. Can be either `asc` or `desc`.
     */
    direction?: "asc" | "desc";
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type PullRequestsListCommentsParams = {
    owner: string;

    repo: string;

    number: number;
    /**
     * Can be either `created` or `updated` comments.
     */
    sort?: "created" | "updated";
    /**
     * Can be either `asc` or `desc`. Ignored without `sort` parameter.
     */
    direction?: "asc" | "desc";
    /**
     * This is a timestamp in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`. Only returns comments `updated` at or after this time.
     */
    since?: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type PullRequestsListCommentsForRepoParams = {
    owner: string;

    repo: string;
    /**
     * Can be either `created` or `updated` comments.
     */
    sort?: "created" | "updated";
    /**
     * Can be either `asc` or `desc`. Ignored without `sort` parameter.
     */
    direction?: "asc" | "desc";
    /**
     * This is a timestamp in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`. Only returns comments `updated` at or after this time.
     */
    since?: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type PullRequestsListCommitsParams = {
    owner: string;

    repo: string;

    number: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type PullRequestsListFilesParams = {
    owner: string;

    repo: string;

    number: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type PullRequestsListReviewRequestsParams = {
    owner: string;

    repo: string;

    number: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type PullRequestsListReviewsParams = {
    owner: string;

    repo: string;

    number: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type PullRequestsMergeParams = {
    owner: string;

    repo: string;

    number: number;
    /**
     * Title for the automatic commit message.
     */
    commit_title?: string;
    /**
     * Extra detail to append to automatic commit message.
     */
    commit_message?: string;
    /**
     * SHA that pull request head must match to allow merge.
     */
    sha?: string;
    /**
     * Merge method to use. Possible values are `merge`, `squash` or `rebase`. Default is `merge`.
     */
    merge_method?: "merge" | "squash" | "rebase";
  };
  export type PullRequestsSubmitReviewParams = {
    owner: string;

    repo: string;

    number: number;

    review_id: number;
    /**
     * The body text of the pull request review
     */
    body?: string;
    /**
     * The review action you want to perform. The review actions include: `APPROVE`, `REQUEST_CHANGES`, or `COMMENT`. When you leave this blank, the API returns _HTTP 422 (Unrecognizable entity)_ and sets the review action state to `PENDING`, which means you will need to re-submit the pull request review using a review action.
     */
    event: "APPROVE" | "REQUEST_CHANGES" | "COMMENT";
  };
  export type PullRequestsUpdateParams = {
    owner: string;

    repo: string;

    number: number;
    /**
     * The title of the pull request.
     */
    title?: string;
    /**
     * The contents of the pull request.
     */
    body?: string;
    /**
     * State of this Pull Request. Either `open` or `closed`.
     */
    state?: "open" | "closed";
    /**
     * The name of the branch you want your changes pulled into. This should be an existing branch on the current repository. You cannot update the base branch on a pull request to point to another repository.
     */
    base?: string;
    /**
     * Indicates whether [maintainers can modify](https://help.github.com/articles/allowing-changes-to-a-pull-request-branch-created-from-a-fork/) the pull request.
     */
    maintainer_can_modify?: boolean;
  };
  export type PullRequestsUpdateCommentParams = {
    owner: string;

    repo: string;

    comment_id: number;
    /**
     * The text of the comment.
     */
    body: string;
  };
  export type ReactionsCreateForCommitCommentParams = {
    owner: string;

    repo: string;

    comment_id: number;
    /**
     * The [reaction type](https://developer.github.com/v3/reactions/#reaction-types) to add to the commit comment.
     */
    content: "+1" | "-1" | "laugh" | "confused" | "heart" | "hooray";
  };
  export type ReactionsCreateForIssueParams = {
    owner: string;

    repo: string;

    number: number;
    /**
     * The [reaction type](https://developer.github.com/v3/reactions/#reaction-types) to add to the issue.
     */
    content: "+1" | "-1" | "laugh" | "confused" | "heart" | "hooray";
  };
  export type ReactionsCreateForIssueCommentParams = {
    owner: string;

    repo: string;

    comment_id: number;
    /**
     * The [reaction type](https://developer.github.com/v3/reactions/#reaction-types) to add to the issue comment.
     */
    content: "+1" | "-1" | "laugh" | "confused" | "heart" | "hooray";
  };
  export type ReactionsCreateForPullRequestReviewCommentParams = {
    owner: string;

    repo: string;

    comment_id: number;
    /**
     * The [reaction type](https://developer.github.com/v3/reactions/#reaction-types) to add to the pull request review comment.
     */
    content: "+1" | "-1" | "laugh" | "confused" | "heart" | "hooray";
  };
  export type ReactionsCreateForTeamDiscussionParams = {
    team_id: number;

    discussion_number: number;
    /**
     * The [reaction type](https://developer.github.com/v3/reactions/#reaction-types) to add to the team discussion.
     */
    content: "+1" | "-1" | "laugh" | "confused" | "heart" | "hooray";
  };
  export type ReactionsCreateForTeamDiscussionCommentParams = {
    team_id: number;

    discussion_number: number;

    comment_number: number;
    /**
     * The [reaction type](https://developer.github.com/v3/reactions/#reaction-types) to add to the team discussion comment.
     */
    content: "+1" | "-1" | "laugh" | "confused" | "heart" | "hooray";
  };
  export type ReactionsDeleteParams = {
    reaction_id: number;
  };
  export type ReactionsListForCommitCommentParams = {
    owner: string;

    repo: string;

    comment_id: number;
    /**
     * Returns a single [reaction type](https://developer.github.com/v3/reactions/#reaction-types). Omit this parameter to list all reactions to a commit comment.
     */
    content?: "+1" | "-1" | "laugh" | "confused" | "heart" | "hooray";
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type ReactionsListForIssueParams = {
    owner: string;

    repo: string;

    number: number;
    /**
     * Returns a single [reaction type](https://developer.github.com/v3/reactions/#reaction-types). Omit this parameter to list all reactions to an issue.
     */
    content?: "+1" | "-1" | "laugh" | "confused" | "heart" | "hooray";
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type ReactionsListForIssueCommentParams = {
    owner: string;

    repo: string;

    comment_id: number;
    /**
     * Returns a single [reaction type](https://developer.github.com/v3/reactions/#reaction-types). Omit this parameter to list all reactions to an issue comment.
     */
    content?: "+1" | "-1" | "laugh" | "confused" | "heart" | "hooray";
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type ReactionsListForPullRequestReviewCommentParams = {
    owner: string;

    repo: string;

    comment_id: number;
    /**
     * Returns a single [reaction type](https://developer.github.com/v3/reactions/#reaction-types). Omit this parameter to list all reactions to a pull request review comment.
     */
    content?: "+1" | "-1" | "laugh" | "confused" | "heart" | "hooray";
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type ReactionsListForTeamDiscussionParams = {
    team_id: number;

    discussion_number: number;
    /**
     * Returns a single [reaction type](https://developer.github.com/v3/reactions/#reaction-types). Omit this parameter to list all reactions to a team discussion.
     */
    content?: "+1" | "-1" | "laugh" | "confused" | "heart" | "hooray";
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type ReactionsListForTeamDiscussionCommentParams = {
    team_id: number;

    discussion_number: number;

    comment_number: number;
    /**
     * Returns a single [reaction type](https://developer.github.com/v3/reactions/#reaction-types). Omit this parameter to list all reactions to a team discussion comment.
     */
    content?: "+1" | "-1" | "laugh" | "confused" | "heart" | "hooray";
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type ReposAcceptInvitationParams = {
    invitation_id: number;
  };
  export type ReposAddCollaboratorParams = {
    owner: string;

    repo: string;

    username: string;
    /**
     * The permission to grant the collaborator. **Only valid on organization-owned repositories.** Can be one of:  ,* \* `pull` - can pull, but not push to or administer this repository.  ,* \* `push` - can pull and push, but not administer this repository.  ,* \* `admin` - can pull, push and administer this repository.
     */
    permission?: "pull" | "push" | "admin";
  };
  export type ReposAddDeployKeyParams = {
    owner: string;

    repo: string;
    /**
     * A name for the key.
     */
    title?: string;
    /**
     * The contents of the key.
     */
    key: string;
    /**
     * If `true`, the key will only be able to read repository contents. Otherwise, the key will be able to read and write.  ,*   ,* Deploy keys with write access can perform the same actions as an organization member with admin access, or a collaborator on a personal repository. For more information, see "[Repository permission levels for an organization](https://help.github.com/articles/repository-permission-levels-for-an-organization/)" and "[Permission levels for a user account repository](https://help.github.com/articles/permission-levels-for-a-user-account-repository/)."
     */
    read_only?: boolean;
  };
  export type ReposAddProtectedBranchAdminEnforcementParams = {
    owner: string;

    repo: string;

    branch: string;
  };
  export type ReposAddProtectedBranchRequiredSignaturesParams = {
    owner: string;

    repo: string;

    branch: string;
  };
  export type ReposAddProtectedBranchRequiredStatusChecksContextsParams = {
    owner: string;

    repo: string;

    branch: string;

    contexts: string[];
  };
  export type ReposAddProtectedBranchTeamRestrictionsParams = {
    owner: string;

    repo: string;

    branch: string;

    teams: string[];
  };
  export type ReposAddProtectedBranchUserRestrictionsParams = {
    owner: string;

    repo: string;

    branch: string;

    users: string[];
  };
  export type ReposCheckCollaboratorParams = {
    owner: string;

    repo: string;

    username: string;
  };
  export type ReposCompareCommitsParams = {
    owner: string;

    repo: string;

    base: string;

    head: string;
  };
  export type ReposCreateCommitCommentParams = {
    owner: string;

    repo: string;

    sha: string;
    /**
     * The contents of the comment.
     */
    body: string;
    /**
     * Relative path of the file to comment on.
     */
    path?: string;
    /**
     * Line index in the diff to comment on.
     */
    position?: number;
    /**
     * **Deprecated**. Use **position** parameter instead. Line number in the file to comment on.
     */
    line?: number;
  };
  export type ReposCreateDeploymentParams = {
    owner: string;

    repo: string;
    /**
     * The ref to deploy. This can be a branch, tag, or SHA.
     */
    ref: string;
    /**
     * Specifies a task to execute (e.g., `deploy` or `deploy:migrations`).
     */
    task?: string;
    /**
     * Attempts to automatically merge the default branch into the requested ref, if it's behind the default branch.
     */
    auto_merge?: boolean;
    /**
     * The [status](https://developer.github.com/v3/repos/statuses/) contexts to verify against commit status checks. If you omit this parameter, GitHub verifies all unique contexts before creating a deployment. To bypass checking entirely, pass an empty array. Defaults to all unique contexts.
     */
    required_contexts?: string[];
    /**
     * JSON payload with extra information about the deployment.
     */
    payload?: string;
    /**
     * Name for the target deployment environment (e.g., `production`, `staging`, `qa`).
     */
    environment?: string;
    /**
     * Short description of the deployment.
     */
    description?: string;
    /**
     * Specifies if the given environment is specific to the deployment and will no longer exist at some point in the future. Default: `false`  ,* **Note:** This parameter requires you to use the [`application/vnd.github.ant-man-preview+json`](https://developer.github.com/v3/previews/#enhanced-deployments) custom media type. **Note:** This parameter requires you to use the [`application/vnd.github.ant-man-preview+json`](https://developer.github.com/v3/previews/#enhanced-deployments) custom media type.
     */
    transient_environment?: boolean;
    /**
     * Specifies if the given environment is one that end-users directly interact with. Default: `true` when `environment` is `production` and `false` otherwise.  ,* **Note:** This parameter requires you to use the [`application/vnd.github.ant-man-preview+json`](https://developer.github.com/v3/previews/#enhanced-deployments) custom media type.
     */
    production_environment?: boolean;
  };
  export type ReposCreateDeploymentStatusParams = {
    owner: string;

    repo: string;

    deployment_id: number;
    /**
     * The state of the status. Can be one of `error`, `failure`, `inactive`, `in_progress`, `queued` `pending`, or `success`. **Note:** To use the `inactive` state, you must provide the [`application/vnd.github.ant-man-preview+json`](https://developer.github.com/v3/previews/#enhanced-deployments) custom media type. To use the `in_progress` and `queued` states, you must provide the [`application/vnd.github.flash-preview+json`](https://developer.github.com/v3/previews/#deployment-statuses) custom media type.
     */
    state:
      | "error"
      | "failure"
      | "inactive"
      | "in_progress"
      | "queued"
      | "pending"
      | "success";
    /**
     * The target URL to associate with this status. This URL should contain output to keep the user updated while the task is running or serve as historical information for what happened in the deployment. **Note:** It's recommended to use the `log_url` parameter, which replaces `target_url`.
     */
    target_url?: string;
    /**
     * The full URL of the deployment's output. This parameter replaces `target_url`. We will continue to accept `target_url` to support legacy uses, but we recommend replacing `target_url` with `log_url`. Setting `log_url` will automatically set `target_url` to the same value. Default: `""`  ,* **Note:** This parameter requires you to use the [`application/vnd.github.ant-man-preview+json`](https://developer.github.com/v3/previews/#enhanced-deployments) custom media type. **Note:** This parameter requires you to use the [`application/vnd.github.ant-man-preview+json`](https://developer.github.com/v3/previews/#enhanced-deployments) custom media type.
     */
    log_url?: string;
    /**
     * A short description of the status. The maximum description length is 140 characters.
     */
    description?: string;
    /**
     * Name for the target deployment environment, which can be changed when setting a deploy status. For example, `production`, `staging`, or `qa`. **Note:** This parameter requires you to use the [`application/vnd.github.flash-preview+json`](https://developer.github.com/v3/previews/#deployment-statuses) custom media type.
     */
    environment?: "production" | "staging" | "qa";
    /**
     * Sets the URL for accessing your environment. Default: `""`  ,* **Note:** This parameter requires you to use the [`application/vnd.github.ant-man-preview+json`](https://developer.github.com/v3/previews/#enhanced-deployments) custom media type. **Note:** This parameter requires you to use the [`application/vnd.github.ant-man-preview+json`](https://developer.github.com/v3/previews/#enhanced-deployments) custom media type.
     */
    environment_url?: string;
    /**
     * Adds a new `inactive` status to all prior non-transient, non-production environment deployments with the same repository and `environment` name as the created status's deployment. An `inactive` status is only added to deployments that had a `success` state. Default: `true`  ,* **Note:** To add an `inactive` status to `production` environments, you must use the [`application/vnd.github.flash-preview+json`](https://developer.github.com/v3/previews/#deployment-statuses) custom media type.  ,* **Note:** This parameter requires you to use the [`application/vnd.github.ant-man-preview+json`](https://developer.github.com/v3/previews/#enhanced-deployments) custom media type. **Note:** To add an `inactive` status to `production` environments, you must use the [`application/vnd.github.flash-preview+json`](https://developer.github.com/v3/previews/#deployment-statuses) custom media type.
     */
    auto_inactive?: boolean;
  };
  export type ReposCreateFileParams = {
    owner: string;

    repo: string;

    path: string;
    /**
     * The commit message.
     */
    message: string;
    /**
     * The new file content, using Base64 encoding.
     */
    content: string;
    /**
     * The branch name.
     */
    branch?: string;
    /**
     * The person that committed the file.
     */
    committer?: ReposCreateFileParamsCommitter;
    /**
     * The author of the file.
     */
    author?: ReposCreateFileParamsAuthor;
  };
  export type ReposCreateForAuthenticatedUserParams = {
    /**
     * The name of the repository.
     */
    name: string;
    /**
     * A short description of the repository.
     */
    description?: string;
    /**
     * A URL with more information about the repository.
     */
    homepage?: string;
    /**
     * Either `true` to create a private repository or `false` to create a public one. Creating private repositories requires a paid GitHub account.
     */
    private?: boolean;
    /**
     * Either `true` to enable issues for this repository or `false` to disable them.
     */
    has_issues?: boolean;
    /**
     * Either `true` to enable projects for this repository or `false` to disable them. **Note:** If you're creating a repository in an organization that has disabled repository projects, the default is `false`, and if you pass `true`, the API returns an error.
     */
    has_projects?: boolean;
    /**
     * Either `true` to enable the wiki for this repository or `false` to disable it.
     */
    has_wiki?: boolean;
    /**
     * The id of the team that will be granted access to this repository. This is only valid when creating a repository in an organization.
     */
    team_id?: number;
    /**
     * Pass `true` to create an initial commit with empty README.
     */
    auto_init?: boolean;
    /**
     * Desired language or platform [.gitignore template](https://github.com/github/gitignore) to apply. Use the name of the template without the extension. For example, "Haskell".
     */
    gitignore_template?: string;
    /**
     * Choose an [open source license template](https://choosealicense.com/) that best suits your needs, and then use the [license keyword](https://help.github.com/articles/licensing-a-repository/#searching-github-by-license-type) as the `license_template` string. For example, "mit" or "mpl-2.0".
     */
    license_template?: string;
    /**
     * Either `true` to allow squash-merging pull requests, or `false` to prevent squash-merging.
     */
    allow_squash_merge?: boolean;
    /**
     * Either `true` to allow merging pull requests with a merge commit, or `false` to prevent merging pull requests with merge commits.
     */
    allow_merge_commit?: boolean;
    /**
     * Either `true` to allow rebase-merging pull requests, or `false` to prevent rebase-merging.
     */
    allow_rebase_merge?: boolean;
  };
  export type ReposCreateForkParams = {
    owner: string;

    repo: string;
    /**
     * Optional parameter to specify the organization name if forking into an organization.
     */
    organization?: string;
  };
  export type ReposCreateHookParams = {
    owner: string;

    repo: string;
    /**
     * Use "web" for a webhook. **Note**: Because we have [deprecated GitHub Services](/changes/2018-10-01-denying-new-github-services), this endpoint now only accepts `web` as a valid value for the `name` parameter. However, when we implement [stricter API validation](/changes/2018-09-25-stricter-validation-coming-soon-in-the-rest-api/) beginning November 1, 2018, requests sending this value will be rejected because `name` will no longer be an accepted parameter.
     */
    name: string;
    /**
     * Key/value pairs to provide settings for this webhook. [These are defined below](#create-hook-config-params).
     */
    config: ReposCreateHookParamsConfig;
    /**
     * Determines what [events](https://developer.github.com/v3/activity/events/types/) the hook is triggered for.
     */
    events?: string[];
    /**
     * Determines if notifications are sent when the webhook is triggered. Set to `true` to send notifications.
     */
    active?: boolean;
  };
  export type ReposCreateInOrgParams = {
    org: string;
    /**
     * The name of the repository.
     */
    name: string;
    /**
     * A short description of the repository.
     */
    description?: string;
    /**
     * A URL with more information about the repository.
     */
    homepage?: string;
    /**
     * Either `true` to create a private repository or `false` to create a public one. Creating private repositories requires a paid GitHub account.
     */
    private?: boolean;
    /**
     * Either `true` to enable issues for this repository or `false` to disable them.
     */
    has_issues?: boolean;
    /**
     * Either `true` to enable projects for this repository or `false` to disable them. **Note:** If you're creating a repository in an organization that has disabled repository projects, the default is `false`, and if you pass `true`, the API returns an error.
     */
    has_projects?: boolean;
    /**
     * Either `true` to enable the wiki for this repository or `false` to disable it.
     */
    has_wiki?: boolean;
    /**
     * The id of the team that will be granted access to this repository. This is only valid when creating a repository in an organization.
     */
    team_id?: number;
    /**
     * Pass `true` to create an initial commit with empty README.
     */
    auto_init?: boolean;
    /**
     * Desired language or platform [.gitignore template](https://github.com/github/gitignore) to apply. Use the name of the template without the extension. For example, "Haskell".
     */
    gitignore_template?: string;
    /**
     * Choose an [open source license template](https://choosealicense.com/) that best suits your needs, and then use the [license keyword](https://help.github.com/articles/licensing-a-repository/#searching-github-by-license-type) as the `license_template` string. For example, "mit" or "mpl-2.0".
     */
    license_template?: string;
    /**
     * Either `true` to allow squash-merging pull requests, or `false` to prevent squash-merging.
     */
    allow_squash_merge?: boolean;
    /**
     * Either `true` to allow merging pull requests with a merge commit, or `false` to prevent merging pull requests with merge commits.
     */
    allow_merge_commit?: boolean;
    /**
     * Either `true` to allow rebase-merging pull requests, or `false` to prevent rebase-merging.
     */
    allow_rebase_merge?: boolean;
  };
  export type ReposCreateReleaseParams = {
    owner: string;

    repo: string;
    /**
     * The name of the tag.
     */
    tag_name: string;
    /**
     * Specifies the commitish value that determines where the Git tag is created from. Can be any branch or commit SHA. Unused if the Git tag already exists.
     */
    target_commitish?: string;
    /**
     * The name of the release.
     */
    name?: string;
    /**
     * Text describing the contents of the tag.
     */
    body?: string;
    /**
     * `true` to create a draft (unpublished) release, `false` to create a published one.
     */
    draft?: boolean;
    /**
     * `true` to identify the release as a prerelease. `false` to identify the release as a full release.
     */
    prerelease?: boolean;
  };
  export type ReposCreateStatusParams = {
    owner: string;

    repo: string;

    sha: string;
    /**
     * The state of the status. Can be one of `error`, `failure`, `pending`, or `success`.
     */
    state: "error" | "failure" | "pending" | "success";
    /**
     * The target URL to associate with this status. This URL will be linked from the GitHub UI to allow users to easily see the source of the status.  ,* For example, if your continuous integration system is posting build status, you would want to provide the deep link for the build output for this specific SHA:  ,* `http://ci.example.com/user/repo/build/sha`
     */
    target_url?: string;
    /**
     * A short description of the status.
     */
    description?: string;
    /**
     * A string label to differentiate this status from the status of other systems.
     */
    context?: string;
  };
  export type ReposDeclineInvitationParams = {
    invitation_id: number;
  };
  export type ReposDeleteParams = {
    owner: string;

    repo: string;
  };
  export type ReposDeleteCommitCommentParams = {
    owner: string;

    repo: string;

    comment_id: number;
  };
  export type ReposDeleteDownloadParams = {
    owner: string;

    repo: string;

    download_id: number;
  };
  export type ReposDeleteFileParams = {
    owner: string;

    repo: string;

    path: string;
    /**
     * The commit message.
     */
    message: string;
    /**
     * The blob SHA of the file being replaced.
     */
    sha: string;
    /**
     * The branch name.
     */
    branch?: string;
    /**
     * object containing information about the committer.
     */
    committer?: ReposDeleteFileParamsCommitter;
    /**
     * object containing information about the author.
     */
    author?: ReposDeleteFileParamsAuthor;
  };
  export type ReposDeleteHookParams = {
    owner: string;

    repo: string;

    hook_id: number;
  };
  export type ReposDeleteInvitationParams = {
    owner: string;

    repo: string;

    invitation_id: number;
  };
  export type ReposDeleteReleaseParams = {
    owner: string;

    repo: string;

    release_id: number;
  };
  export type ReposDeleteReleaseAssetParams = {
    owner: string;

    repo: string;

    asset_id: number;
  };
  export type ReposGetParams = {
    owner: string;

    repo: string;
  };
  export type ReposGetArchiveLinkParams = {
    owner: string;

    repo: string;

    archive_format: string;

    ref: string;
  };
  export type ReposGetBranchParams = {
    owner: string;

    repo: string;

    branch: string;
  };
  export type ReposGetBranchProtectionParams = {
    owner: string;

    repo: string;

    branch: string;
  };
  export type ReposGetClonesParams = {
    owner: string;

    repo: string;
    /**
     * Must be one of: `day`, `week`.
     */
    per?: "day" | "week";
  };
  export type ReposGetCodeFrequencyStatsParams = {
    owner: string;

    repo: string;
  };
  export type ReposGetCollaboratorPermissionLevelParams = {
    owner: string;

    repo: string;

    username: string;
  };
  export type ReposGetCombinedStatusForRefParams = {
    owner: string;

    repo: string;

    ref: string;
  };
  export type ReposGetCommitParams = {
    owner: string;

    repo: string;

    sha: string;
  };
  export type ReposGetCommitActivityStatsParams = {
    owner: string;

    repo: string;
  };
  export type ReposGetCommitCommentParams = {
    owner: string;

    repo: string;

    comment_id: number;
  };
  export type ReposGetCommitRefShaParams = {
    owner: string;

    repo: string;

    ref: string;
  };
  export type ReposGetContentsParams = {
    owner: string;

    repo: string;

    path: string;
    /**
     * The name of the commit/branch/tag.
     */
    ref?: string;
  };
  export type ReposGetContributorsStatsParams = {
    owner: string;

    repo: string;
  };
  export type ReposGetDeployKeyParams = {
    owner: string;

    repo: string;

    key_id: number;
  };
  export type ReposGetDeploymentParams = {
    owner: string;

    repo: string;

    deployment_id: number;
  };
  export type ReposGetDeploymentStatusParams = {
    owner: string;

    repo: string;

    deployment_id: number;

    status_id: number;
  };
  export type ReposGetDownloadParams = {
    owner: string;

    repo: string;

    download_id: number;
  };
  export type ReposGetHookParams = {
    owner: string;

    repo: string;

    hook_id: number;
  };
  export type ReposGetLatestPagesBuildParams = {
    owner: string;

    repo: string;
  };
  export type ReposGetLatestReleaseParams = {
    owner: string;

    repo: string;
  };
  export type ReposGetPagesParams = {
    owner: string;

    repo: string;
  };
  export type ReposGetPagesBuildParams = {
    owner: string;

    repo: string;

    build_id: number;
  };
  export type ReposGetParticipationStatsParams = {
    owner: string;

    repo: string;
  };
  export type ReposGetProtectedBranchAdminEnforcementParams = {
    owner: string;

    repo: string;

    branch: string;
  };
  export type ReposGetProtectedBranchPullRequestReviewEnforcementParams = {
    owner: string;

    repo: string;

    branch: string;
  };
  export type ReposGetProtectedBranchRequiredSignaturesParams = {
    owner: string;

    repo: string;

    branch: string;
  };
  export type ReposGetProtectedBranchRequiredStatusChecksParams = {
    owner: string;

    repo: string;

    branch: string;
  };
  export type ReposGetProtectedBranchRestrictionsParams = {
    owner: string;

    repo: string;

    branch: string;
  };
  export type ReposGetPunchCardStatsParams = {
    owner: string;

    repo: string;
  };
  export type ReposGetReadmeParams = {
    owner: string;

    repo: string;
    /**
     * The name of the commit/branch/tag.
     */
    ref?: string;
  };
  export type ReposGetReleaseParams = {
    owner: string;

    repo: string;

    release_id: number;
  };
  export type ReposGetReleaseAssetParams = {
    owner: string;

    repo: string;

    asset_id: number;
  };
  export type ReposGetReleaseByTagParams = {
    owner: string;

    repo: string;

    tag: string;
  };
  export type ReposGetTopPathsParams = {
    owner: string;

    repo: string;
  };
  export type ReposGetTopReferrersParams = {
    owner: string;

    repo: string;
  };
  export type ReposGetViewsParams = {
    owner: string;

    repo: string;
    /**
     * Must be one of: `day`, `week`.
     */
    per?: "day" | "week";
  };
  export type ReposListParams = {
    /**
     * Can be one of `all`, `public`, or `private`.
     */
    visibility?: "all" | "public" | "private";
    /**
     * Comma-separated list of values. Can include:  ,* \* `owner`: Repositories that are owned by the authenticated user.  ,* \* `collaborator`: Repositories that the user has been added to as a collaborator.  ,* \* `organization_member`: Repositories that the user has access to through being a member of an organization. This includes every repository on every team that the user is on.
     */
    affiliation?: "owner" | "collaborator" | "organization_member";
    /**
     * Can be one of `all`, `owner`, `public`, `private`, `member`. Default: `all`  ,*   ,* Will cause a `422` error if used in the same request as **visibility** or **affiliation**. Will cause a `422` error if used in the same request as **visibility** or **affiliation**.
     */
    type?: "all" | "owner" | "public" | "private" | "member";
    /**
     * Can be one of `created`, `updated`, `pushed`, `full_name`.
     */
    sort?: "created" | "updated" | "pushed" | "full_name";
    /**
     * Can be one of `asc` or `desc`.
     */
    direction?: "asc" | "desc";
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type ReposListAssetsForReleaseParams = {
    owner: string;

    repo: string;

    release_id: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type ReposListBranchesParams = {
    owner: string;

    repo: string;
    /**
     * Setting to `true` returns only protected branches.
     */
    protected?: boolean;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type ReposListCollaboratorsParams = {
    owner: string;

    repo: string;
    /**
     * Filter collaborators returned by their affiliation. Can be one of:  ,* \* `outside`: All outside collaborators of an organization-owned repository.  ,* \* `direct`: All collaborators with permissions to an organization-owned repository, regardless of organization membership status.  ,* \* `all`: All collaborators the authenticated user can see.
     */
    affiliation?: "outside" | "direct" | "all";
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type ReposListCommentsForCommitParams = {
    owner: string;

    repo: string;

    ref: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type ReposListCommitCommentsParams = {
    owner: string;

    repo: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type ReposListCommitsParams = {
    owner: string;

    repo: string;
    /**
     * SHA or branch to start listing commits from.
     */
    sha?: string;
    /**
     * Only commits containing this file path will be returned.
     */
    path?: string;
    /**
     * GitHub login or email address by which to filter by commit author.
     */
    author?: string;
    /**
     * Only commits after this date will be returned. This is a timestamp in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    since?: string;
    /**
     * Only commits before this date will be returned. This is a timestamp in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    until?: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type ReposListContributorsParams = {
    owner: string;

    repo: string;
    /**
     * Set to `1` or `true` to include anonymous contributors in results.
     */
    anon?: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type ReposListDeployKeysParams = {
    owner: string;

    repo: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type ReposListDeploymentStatusesParams = {
    owner: string;

    repo: string;

    deployment_id: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type ReposListDeploymentsParams = {
    owner: string;

    repo: string;
    /**
     * The SHA recorded at creation time.
     */
    sha?: string;
    /**
     * The name of the ref. This can be a branch, tag, or SHA.
     */
    ref?: string;
    /**
     * The name of the task for the deployment (e.g., `deploy` or `deploy:migrations`).
     */
    task?: string;
    /**
     * The name of the environment that was deployed to (e.g., `staging` or `production`).
     */
    environment?: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type ReposListDownloadsParams = {
    owner: string;

    repo: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type ReposListForOrgParams = {
    org: string;
    /**
     * Can be one of `all`, `public`, `private`, `forks`, `sources`, `member`.
     */
    type?: "all" | "public" | "private" | "forks" | "sources" | "member";
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type ReposListForUserParams = {
    username: string;
    /**
     * Can be one of `all`, `owner`, `member`.
     */
    type?: "all" | "owner" | "member";
    /**
     * Can be one of `created`, `updated`, `pushed`, `full_name`.
     */
    sort?: "created" | "updated" | "pushed" | "full_name";
    /**
     * Can be one of `asc` or `desc`.
     */
    direction?: "asc" | "desc";
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type ReposListForksParams = {
    owner: string;

    repo: string;
    /**
     * The sort order. Can be either `newest`, `oldest`, or `stargazers`.
     */
    sort?: "newest" | "oldest" | "stargazers";
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type ReposListHooksParams = {
    owner: string;

    repo: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type ReposListInvitationsParams = {
    owner: string;

    repo: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type ReposListInvitationsForAuthenticatedUserParams = {
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type ReposListLanguagesParams = {
    owner: string;

    repo: string;
  };
  export type ReposListPagesBuildsParams = {
    owner: string;

    repo: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type ReposListProtectedBranchRequiredStatusChecksContextsParams = {
    owner: string;

    repo: string;

    branch: string;
  };
  export type ReposListProtectedBranchTeamRestrictionsParams = {
    owner: string;

    repo: string;

    branch: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type ReposListProtectedBranchUserRestrictionsParams = {
    owner: string;

    repo: string;

    branch: string;
  };
  export type ReposListPublicParams = {
    /**
     * The integer ID of the last Repository that you've seen.
     */
    since?: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type ReposListReleasesParams = {
    owner: string;

    repo: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type ReposListStatusesForRefParams = {
    owner: string;

    repo: string;

    ref: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type ReposListTagsParams = {
    owner: string;

    repo: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type ReposListTeamsParams = {
    owner: string;

    repo: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type ReposListTopicsParams = {
    owner: string;

    repo: string;
  };
  export type ReposMergeParams = {
    owner: string;

    repo: string;
    /**
     * The name of the base branch that the head will be merged into.
     */
    base: string;
    /**
     * The head to merge. This can be a branch name or a commit SHA1.
     */
    head: string;
    /**
     * Commit message to use for the merge commit. If omitted, a default message will be used.
     */
    commit_message?: string;
  };
  export type ReposPingHookParams = {
    owner: string;

    repo: string;

    hook_id: number;
  };
  export type ReposRemoveBranchProtectionParams = {
    owner: string;

    repo: string;

    branch: string;
  };
  export type ReposRemoveCollaboratorParams = {
    owner: string;

    repo: string;

    username: string;
  };
  export type ReposRemoveDeployKeyParams = {
    owner: string;

    repo: string;

    key_id: number;
  };
  export type ReposRemoveProtectedBranchAdminEnforcementParams = {
    owner: string;

    repo: string;

    branch: string;
  };
  export type ReposRemoveProtectedBranchPullRequestReviewEnforcementParams = {
    owner: string;

    repo: string;

    branch: string;
  };
  export type ReposRemoveProtectedBranchRequiredSignaturesParams = {
    owner: string;

    repo: string;

    branch: string;
  };
  export type ReposRemoveProtectedBranchRequiredStatusChecksParams = {
    owner: string;

    repo: string;

    branch: string;
  };
  export type ReposRemoveProtectedBranchRequiredStatusChecksContextsParams = {
    owner: string;

    repo: string;

    branch: string;

    contexts: string[];
  };
  export type ReposRemoveProtectedBranchRestrictionsParams = {
    owner: string;

    repo: string;

    branch: string;
  };
  export type ReposRemoveProtectedBranchTeamRestrictionsParams = {
    owner: string;

    repo: string;

    branch: string;

    teams: string[];
  };
  export type ReposRemoveProtectedBranchUserRestrictionsParams = {
    owner: string;

    repo: string;

    branch: string;

    users: string[];
  };
  export type ReposReplaceProtectedBranchRequiredStatusChecksContextsParams = {
    owner: string;

    repo: string;

    branch: string;

    contexts: string[];
  };
  export type ReposReplaceProtectedBranchTeamRestrictionsParams = {
    owner: string;

    repo: string;

    branch: string;

    teams: string[];
  };
  export type ReposReplaceProtectedBranchUserRestrictionsParams = {
    owner: string;

    repo: string;

    branch: string;

    users: string[];
  };
  export type ReposReplaceTopicsParams = {
    owner: string;

    repo: string;
    /**
     * An array of topics to add to the repository. Pass one or more topics to _replace_ the set of existing topics. Send an empty array (`[]`) to clear all topics from the repository.
     */
    names: string[];
  };
  export type ReposRequestPageBuildParams = {
    owner: string;

    repo: string;
  };
  export type ReposRetrieveCommunityProfileMetricsParams = {
    owner: string;

    repo: string;
  };
  export type ReposTestPushHookParams = {
    owner: string;

    repo: string;

    hook_id: number;
  };
  export type ReposTransferParams = {
    owner: string;

    repo: string;
    /**
     * **Required:** The username or organization name the repository will be transferred to.
     */
    new_owner?: string;
    /**
     * ID of the team or teams to add to the repository. Teams can only be added to organization-owned repositories.
     */
    team_ids?: number[];
  };
  export type ReposUpdateParams = {
    owner: string;

    repo: string;
    /**
     * The name of the repository.
     */
    name: string;
    /**
     * A short description of the repository.
     */
    description?: string;
    /**
     * A URL with more information about the repository.
     */
    homepage?: string;
    /**
     * Either `true` to make the repository private or `false` to make it public. Creating private repositories requires a paid GitHub account. Default: `false`.  ,* **Note**: You will get a `422` error if the organization restricts [changing repository visibility](https://help.github.com/articles/repository-permission-levels-for-an-organization#changing-the-visibility-of-repositories) to organization owners and a non-owner tries to change the value of private. **Note**: You will get a `422` error if the organization restricts [changing repository visibility](https://help.github.com/articles/repository-permission-levels-for-an-organization#changing-the-visibility-of-repositories) to organization owners and a non-owner tries to change the value of private.
     */
    private?: boolean;
    /**
     * Either `true` to enable issues for this repository or `false` to disable them.
     */
    has_issues?: boolean;
    /**
     * Either `true` to enable projects for this repository or `false` to disable them. **Note:** If you're creating a repository in an organization that has disabled repository projects, the default is `false`, and if you pass `true`, the API returns an error.
     */
    has_projects?: boolean;
    /**
     * Either `true` to enable the wiki for this repository or `false` to disable it.
     */
    has_wiki?: boolean;
    /**
     * Updates the default branch for this repository.
     */
    default_branch?: string;
    /**
     * Either `true` to allow squash-merging pull requests, or `false` to prevent squash-merging.
     */
    allow_squash_merge?: boolean;
    /**
     * Either `true` to allow merging pull requests with a merge commit, or `false` to prevent merging pull requests with merge commits.
     */
    allow_merge_commit?: boolean;
    /**
     * Either `true` to allow rebase-merging pull requests, or `false` to prevent rebase-merging.
     */
    allow_rebase_merge?: boolean;
    /**
     * `true` to archive this repository. **Note**: You cannot unarchive repositories through the API.
     */
    archived?: boolean;
  };
  export type ReposUpdateBranchProtectionParams = {
    owner: string;

    repo: string;

    branch: string;
    /**
     * Require status checks to pass before merging. Set to `null` to disable.
     */
    required_status_checks: ReposUpdateBranchProtectionParamsRequiredStatusChecks | null;
    /**
     * Enforce all configured restrictions for administrators. Set to `true` to enforce required status checks for repository administrators. Set to `null` to disable.
     */
    enforce_admins: boolean | null;
    /**
     * Require at least one approving review on a pull request, before merging. Set to `null` to disable.
     */
    required_pull_request_reviews: ReposUpdateBranchProtectionParamsRequiredPullRequestReviews | null;
    /**
     * Restrict who can push to this branch. Team and user `restrictions` are only available for organization-owned repositories. Set to `null` to disable.
     */
    restrictions: ReposUpdateBranchProtectionParamsRestrictions | null;
  };
  export type ReposUpdateCommitCommentParams = {
    owner: string;

    repo: string;

    comment_id: number;
    /**
     * The contents of the comment
     */
    body: string;
  };
  export type ReposUpdateFileParams = {
    owner: string;

    repo: string;

    path: string;
    /**
     * The commit message.
     */
    message: string;
    /**
     * The new file content, using Base64 encoding.
     */
    content: string;
    /**
     * The blob SHA of the file being replaced.
     */
    sha: string;
    /**
     * The branch name.
     */
    branch?: string;
    /**
     * The person that committed the file.
     */
    committer?: ReposUpdateFileParamsCommitter;
    /**
     * The author of the file.
     */
    author?: ReposUpdateFileParamsAuthor;
  };
  export type ReposUpdateHookParams = {
    owner: string;

    repo: string;

    hook_id: number;
    /**
     * Key/value pairs to provide settings for this webhook. [These are defined below](#create-hook-config-params).
     */
    config?: ReposUpdateHookParamsConfig;
    /**
     * Determines what [events](https://developer.github.com/v3/activity/events/types/) the hook is triggered for. This replaces the entire array of events.
     */
    events?: string[];
    /**
     * Determines a list of events to be added to the list of events that the Hook triggers for.
     */
    add_events?: string[];
    /**
     * Determines a list of events to be removed from the list of events that the Hook triggers for.
     */
    remove_events?: string[];
    /**
     * Determines if notifications are sent when the webhook is triggered. Set to `true` to send notifications.
     */
    active?: boolean;
  };
  export type ReposUpdateInformationAboutPagesSiteParams = {
    owner: string;

    repo: string;
    /**
     * Specify a custom domain for the repository. Sending a `null` value will remove the custom domain. For more about custom domains, see "[Using a custom domain with GitHub Pages](https://help.github.com/articles/using-a-custom-domain-with-github-pages/)."
     */
    cname?: string;
    /**
     * Update the source for the repository. Must include the branch name, and may optionally specify the subdirectory `/docs`. Possible values are `"gh-pages"`, `"master"`, and `"master /docs"`.
     */
    source?: '"gh-pages"' | '"master"' | '"master /docs"';
  };
  export type ReposUpdateInvitationParams = {
    owner: string;

    repo: string;

    invitation_id: number;
    /**
     * The permissions that the associated user will have on the repository. Valid values are `read`, `write`, and `admin`.
     */
    permissions?: "read" | "write" | "admin";
  };
  export type ReposUpdateProtectedBranchPullRequestReviewEnforcementParams = {
    owner: string;

    repo: string;

    branch: string;
    /**
     * Specify which users and teams can dismiss pull request reviews. Pass an empty `dismissal_restrictions` object to disable. User and team `dismissal_restrictions` are only available for organization-owned repositories. Omit this parameter for personal repositories.
     */
    dismissal_restrictions?: ReposUpdateProtectedBranchPullRequestReviewEnforcementParamsDismissalRestrictions;
    /**
     * Set to `true` if you want to automatically dismiss approving reviews when someone pushes a new commit.
     */
    dismiss_stale_reviews?: boolean;
    /**
     * Blocks merging pull requests until code owners have reviewed.
     */
    require_code_owner_reviews?: boolean;
    /**
     * Specifies the number of reviewers required to approve pull requests. Use a number between 1 and 6.
     */
    required_approving_review_count?: number;
  };
  export type ReposUpdateProtectedBranchRequiredStatusChecksParams = {
    owner: string;

    repo: string;

    branch: string;
    /**
     * Require branches to be up to date before merging.
     */
    strict?: boolean;
    /**
     * The list of status checks to require in order to merge into this branch
     */
    contexts?: string[];
  };
  export type ReposUpdateReleaseParams = {
    owner: string;

    repo: string;

    release_id: number;
    /**
     * The name of the tag.
     */
    tag_name?: string;
    /**
     * Specifies the commitish value that determines where the Git tag is created from. Can be any branch or commit SHA. Unused if the Git tag already exists.
     */
    target_commitish?: string;
    /**
     * The name of the release.
     */
    name?: string;
    /**
     * Text describing the contents of the tag.
     */
    body?: string;
    /**
     * `true` makes the release a draft, and `false` publishes the release.
     */
    draft?: boolean;
    /**
     * `true` to identify the release as a prerelease, `false` to identify the release as a full release.
     */
    prerelease?: boolean;
  };
  export type ReposUpdateReleaseAssetParams = {
    owner: string;

    repo: string;

    asset_id: number;
    /**
     * The file name of the asset.
     */
    name?: string;
    /**
     * An alternate short description of the asset. Used in place of the filename.
     */
    label?: string;
  };
  export type ReposUploadReleaseAssetParams = {
    url: string;
    /**
     * The content size of the asset in bytes
     */
    "Content-Length": number;
    /**
     * The content type of the asset. This should be set in the Header. Example: `"application/zip"`. For a list of acceptable types, refer this list of [media types](https://www.iana.org/assignments/media-types/media-types.xhtml).
     */
    "Content-Type": string;
    /**
     * The file name of the asset. This should be set in a URI query parameter.
     */
    name: string;
    /**
     * An alternate short description of the asset. Used in place of the filename. This should be set in a URI query parameter.
     */
    label?: string;

    file: string | object;
  };
  export type SearchCodeParams = {
    /**
     * The search terms.
     */
    q: string;
    /**
     * The sort field. Can only be `indexed`, which indicates how recently a file has been indexed by the GitHub search infrastructure.
     */
    sort?: "indexed";
    /**
     * The sort order if `sort` parameter is provided. One of `asc` or `desc`.
     */
    order?: "asc" | "desc";
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type SearchCommitsParams = {
    /**
     * The search terms.
     */
    q: string;
    /**
     * The sort field. Can be `author-date` or `committer-date`.
     */
    sort?: "author-date" | "committer-date";
    /**
     * The sort order if `sort` parameter is provided. One of `asc` or `desc`.
     */
    order?: "asc" | "desc";
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type SearchIssuesParams = {
    /**
     * The search terms.
     */
    q: string;
    /**
     * The sort field. Can be `comments`, `created`, or `updated`.
     */
    sort?: "comments" | "created" | "updated";
    /**
     * The sort order if `sort` parameter is provided. One of `asc` or `desc`.
     */
    order?: "asc" | "desc";
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type SearchLabelsParams = {
    /**
     * The id of the repository.
     */
    repository_id: number;
    /**
     * The search keywords.
     */
    q: string;
    /**
     * The sort field. Can be one of `created` or `updated`.
     */
    sort?: "created" | "updated";
    /**
     * The sort order if the sort parameter is provided. Can be one of `asc` or `desc`.
     */
    order?: "asc" | "desc";
  };
  export type SearchReposParams = {
    /**
     * The search keywords, as well as any qualifiers.
     */
    q: string;
    /**
     * The sort field. One of `stars`, `forks`, or `updated`.
     */
    sort?: "stars" | "forks" | "updated";
    /**
     * The sort order if `sort` parameter is provided. One of `asc` or `desc`.
     */
    order?: "asc" | "desc";
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type SearchTopicsParams = {
    /**
     * The search terms.
     */
    q: string;
  };
  export type SearchUsersParams = {
    /**
     * The search terms.
     */
    q: string;
    /**
     * The sort field. Can be `followers`, `repositories`, or `joined`.
     */
    sort?: "followers" | "repositories" | "joined";
    /**
     * The sort order if `sort` parameter is provided. One of `asc` or `desc`.
     */
    order?: "asc" | "desc";
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type TeamsAddMemberParams = {
    team_id: number;

    username: string;
  };
  export type TeamsAddOrUpdateMembershipParams = {
    team_id: number;

    username: string;
    /**
     * The role that this user should have in the team. Can be one of:  ,* \* `member` - a normal member of the team.  ,* \* `maintainer` - a team maintainer. Able to add/remove other team members, promote other team members to team maintainer, and edit the team's name and description.
     */
    role?: "member" | "maintainer";
  };
  export type TeamsAddOrUpdateProjectParams = {
    team_id: number;

    project_id: number;
    /**
     * The permission to grant to the team for this project. Can be one of:  ,* \* `read` - team members can read, but not write to or administer this project.  ,* \* `write` - team members can read and write, but not administer this project.  ,* \* `admin` - team members can read, write and administer this project.  ,* Default: the team's `permission` attribute will be used to determine what permission to grant the team on this project. Note that, if you choose not to pass any parameters, you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP verbs](https://developer.github.com/v3/#http-verbs)."  ,* **Note**: If you pass the `hellcat-preview` media type, you can promote—but not demote—a `permission` attribute inherited from a parent team.
     */
    permission?: "read" | "write" | "admin";
  };
  export type TeamsAddOrUpdateRepoParams = {
    team_id: number;

    owner: string;

    repo: string;
    /**
     * The permission to grant the team on this repository. Can be one of:  ,* \* `pull` - team members can pull, but not push to or administer this repository.  ,* \* `push` - team members can pull and push, but not administer this repository.  ,* \* `admin` - team members can pull, push and administer this repository.  ,*   ,* If no permission is specified, the team's `permission` attribute will be used to determine what permission to grant the team on this repository.  ,* **Note**: If you pass the `hellcat-preview` media type, you can promote—but not demote—a `permission` attribute inherited through a parent team.
     */
    permission?: "pull" | "push" | "admin";
  };
  export type TeamsCheckManagesRepoParams = {
    team_id: number;

    owner: string;

    repo: string;
  };
  export type TeamsCreateParams = {
    org: string;
    /**
     * The name of the team.
     */
    name: string;
    /**
     * The description of the team.
     */
    description?: string;
    /**
     * The logins of organization members to add as maintainers of the team.
     */
    maintainers?: string[];
    /**
     * The full name (e.g., "organization-name/repository-name") of repositories to add the team to.
     */
    repo_names?: string[];
    /**
     * The level of privacy this team should have. The options are:  ,* **For a non-nested team:**  ,* \* `secret` - only visible to organization owners and members of this team.  ,* \* `closed` - visible to all members of this organization.  ,* Default: `secret`  ,* **For a parent or child team:**  ,* \* `closed` - visible to all members of this organization.  ,* Default for child team: `closed`  ,* **Note**: You must pass the `hellcat-preview` media type to set privacy default to `closed` for child teams. **For a parent or child team:**
     */
    privacy?: "secret" | "closed";
    /**
     * **Deprecated**. The permission that new repositories will be added to the team with when none is specified. Can be one of:  ,* \* `pull` - team members can pull, but not push to or administer newly-added repositories.  ,* \* `push` - team members can pull and push, but not administer newly-added repositories.  ,* \* `admin` - team members can pull, push and administer newly-added repositories.
     */
    permission?: "pull" | "push" | "admin";
    /**
     * The ID of a team to set as the parent team. **Note**: You must pass the `hellcat-preview` media type to use this parameter.
     */
    parent_team_id?: number;
  };
  export type TeamsCreateDiscussionParams = {
    team_id: number;
    /**
     * The discussion post's title.
     */
    title: string;
    /**
     * The discussion post's body text.
     */
    body: string;
    /**
     * Private posts are only visible to team members, organization owners, and team maintainers. Public posts are visible to all members of the organization. Set to `true` to create a private post.
     */
    private?: boolean;
  };
  export type TeamsCreateDiscussionCommentParams = {
    team_id: number;

    discussion_number: number;
    /**
     * The discussion comment's body text.
     */
    body: string;
  };
  export type TeamsDeleteParams = {
    team_id: number;
  };
  export type TeamsDeleteDiscussionParams = {
    team_id: number;

    discussion_number: number;
  };
  export type TeamsDeleteDiscussionCommentParams = {
    team_id: number;

    discussion_number: number;

    comment_number: number;
  };
  export type TeamsGetParams = {
    team_id: number;
  };
  export type TeamsGetDiscussionParams = {
    team_id: number;

    discussion_number: number;
  };
  export type TeamsGetDiscussionCommentParams = {
    team_id: number;

    discussion_number: number;

    comment_number: number;
  };
  export type TeamsGetMemberParams = {
    team_id: number;

    username: string;
  };
  export type TeamsGetMembershipParams = {
    team_id: number;

    username: string;
  };
  export type TeamsListParams = {
    org: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type TeamsListChildParams = {
    team_id: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type TeamsListDiscussionCommentsParams = {
    team_id: number;

    discussion_number: number;
    /**
     * Sorts the discussion comments by the date they were created. To return the oldest comments first, set to `asc`. Can be one of `asc` or `desc`.
     */
    direction?: "asc" | "desc";
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type TeamsListDiscussionsParams = {
    team_id: number;
    /**
     * Sorts the discussion comments by the date they were created. To return the oldest comments first, set to `asc`. Can be one of `asc` or `desc`.
     */
    direction?: "asc" | "desc";
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type TeamsListForAuthenticatedUserParams = {
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type TeamsListMembersParams = {
    team_id: number;
    /**
     * Filters members returned by their role in the team. Can be one of:  ,* \* `member` - normal members of the team.  ,* \* `maintainer` - team maintainers.  ,* \* `all` - all members of the team.
     */
    role?: "member" | "maintainer" | "all";
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type TeamsListPendingInvitationsParams = {
    team_id: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type TeamsListProjectsParams = {
    team_id: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type TeamsListReposParams = {
    team_id: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type TeamsRemoveMemberParams = {
    team_id: number;

    username: string;
  };
  export type TeamsRemoveMembershipParams = {
    team_id: number;

    username: string;
  };
  export type TeamsRemoveProjectParams = {
    team_id: number;

    project_id: number;
  };
  export type TeamsRemoveRepoParams = {
    team_id: number;

    owner: string;

    repo: string;
  };
  export type TeamsReviewProjectParams = {
    team_id: number;

    project_id: number;
  };
  export type TeamsUpdateParams = {
    team_id: number;
    /**
     * The name of the team.
     */
    name: string;
    /**
     * The description of the team.
     */
    description?: string;
    /**
     * The level of privacy this team should have. Editing teams without specifying this parameter leaves `privacy` intact. The options are:  ,* **For a non-nested team:**  ,* \* `secret` - only visible to organization owners and members of this team.  ,* \* `closed` - visible to all members of this organization.  ,* **For a parent or child team:**  ,* \* `closed` - visible to all members of this organization.
     */
    privacy?: string;
    /**
     * **Deprecated**. The permission that new repositories will be added to the team with when none is specified. Can be one of:  ,* \* `pull` - team members can pull, but not push to or administer newly-added repositories.  ,* \* `push` - team members can pull and push, but not administer newly-added repositories.  ,* \* `admin` - team members can pull, push and administer newly-added repositories.
     */
    permission?: "pull" | "push" | "admin";
    /**
     * The ID of a team to set as the parent team. **Note**: You must pass the `hellcat-preview` media type to use this parameter.
     */
    parent_team_id?: number;
  };
  export type TeamsUpdateDiscussionParams = {
    team_id: number;

    discussion_number: number;
    /**
     * The discussion post's title.
     */
    title?: string;
    /**
     * The discussion post's body text.
     */
    body?: string;
  };
  export type TeamsUpdateDiscussionCommentParams = {
    team_id: number;

    discussion_number: number;

    comment_number: number;
    /**
     * The discussion comment's body text.
     */
    body: string;
  };
  export type UsersAddEmailsParams = {
    /**
     * Adds one or more email addresses to your GitHub account. Must contain at least one email address. **Note:** Alternatively, you can pass a single email address or an `array` of emails addresses directly, but we recommend that you pass an object using the `emails` key.
     */
    emails: string[];
  };
  export type UsersBlockParams = {
    username: string;
  };
  export type UsersCheckBlockedParams = {
    username: string;
  };
  export type UsersCheckFollowingParams = {
    username: string;
  };
  export type UsersCheckFollowingForUserParams = {
    username: string;

    target_user: string;
  };
  export type UsersCreateGpgKeyParams = {
    /**
     * Your GPG key, generated in ASCII-armored format. See "[Generating a new GPG key](https://help.github.com/articles/generating-a-new-gpg-key/)" for help creating a GPG key.
     */
    armored_public_key?: string;
  };
  export type UsersCreatePublicKeyParams = {
    /**
     * A descriptive name for the new key. Use a name that will help you recognize this key in your GitHub account. For example, if you're using a personal Mac, you might call this key "Personal MacBook Air".
     */
    title?: string;
    /**
     * The public SSH key to add to your GitHub account. See "[Generating a new SSH key](https://help.github.com/articles/generating-a-new-ssh-key-and-adding-it-to-the-ssh-agent/)" for guidance on how to create a public SSH key.
     */
    key?: string;
  };
  export type UsersDeleteEmailsParams = {
    /**
     * Deletes one or more email addresses from your GitHub account. Must contain at least one email address. **Note:** Alternatively, you can pass a single email address or an `array` of emails addresses directly, but we recommend that you pass an object using the `emails` key.
     */
    emails: string[];
  };
  export type UsersDeleteGpgKeyParams = {
    gpg_key_id: number;
  };
  export type UsersDeletePublicKeyParams = {
    key_id: number;
  };
  export type UsersFollowParams = {
    username: string;
  };
  export type UsersGetByUsernameParams = {
    username: string;
  };
  export type UsersGetContextForUserParams = {
    username: string;
    /**
     * Identifies which additional information you'd like to receive about the person's hovercard. Can be `organization`, `repository`, `issue`, `pull_request`. **Required** when using `subject_id`.
     */
    subject_type?: "organization" | "repository" | "issue" | "pull_request";
    /**
     * Uses the ID for the `subject_type` you specified. **Required** when using `subject_type`.
     */
    subject_id?: string;
  };
  export type UsersGetGpgKeyParams = {
    gpg_key_id: number;
  };
  export type UsersGetPublicKeyParams = {
    key_id: number;
  };
  export type UsersListParams = {
    /**
     * The integer ID of the last User that you've seen.
     */
    since?: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type UsersListEmailsParams = {
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type UsersListFollowersForAuthenticatedUserParams = {
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type UsersListFollowersForUserParams = {
    username: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type UsersListFollowingForAuthenticatedUserParams = {
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type UsersListFollowingForUserParams = {
    username: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type UsersListGpgKeysParams = {
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type UsersListGpgKeysForUserParams = {
    username: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type UsersListPublicEmailsParams = {
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type UsersListPublicKeysParams = {
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type UsersListPublicKeysForUserParams = {
    username: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
  };
  export type UsersTogglePrimaryEmailVisibilityParams = {
    /**
     * Specify the _primary_ email address that needs a visibility change.
     */
    email: string;
    /**
     * Use `public` to enable an authenticated user to view the specified email address, or use `private` so this primary email address cannot be seen publicly.
     */
    visibility: string;
  };
  export type UsersUnblockParams = {
    username: string;
  };
  export type UsersUnfollowParams = {
    username: string;
  };
  export type UsersUpdateAuthenticatedParams = {
    /**
     * The new name of the user.
     */
    name?: string;
    /**
     * The publicly visible email address of the user.
     */
    email?: string;
    /**
     * The new blog URL of the user.
     */
    blog?: string;
    /**
     * The new company of the user.
     */
    company?: string;
    /**
     * The new location of the user.
     */
    location?: string;
    /**
     * The new hiring availability of the user.
     */
    hireable?: boolean;
    /**
     * The new short biography of the user.
     */
    bio?: string;
  };
  export type ChecksCreateParamsOutput = {
    title: string;
    summary: string;
    text?: string;
    annotations?: ChecksCreateParamsOutputAnnotations[];
    images?: ChecksCreateParamsOutputImages[];
  };
  export type ChecksCreateParamsOutputAnnotations = {
    path: string;
    start_line: number;
    end_line: number;
    start_column?: number;
    end_column?: number;
    annotation_level: "notice" | "warning" | "failure";
    message: string;
    title?: string;
    raw_details?: string;
  };
  export type ChecksCreateParamsOutputImages = {
    alt: string;
    image_url: string;
    caption?: string;
  };
  export type ChecksCreateParamsActions = {
    label: string;
    description: string;
    identifier: string;
  };
  export type ChecksSetSuitesPreferencesParamsAutoTriggerChecks = {
    app_id: number;
    setting: boolean;
  };
  export type ChecksUpdateParamsOutput = {
    title?: string;
    summary: string;
    text?: string;
    annotations?: ChecksUpdateParamsOutputAnnotations[];
    images?: ChecksUpdateParamsOutputImages[];
  };
  export type ChecksUpdateParamsOutputAnnotations = {
    path: string;
    start_line: number;
    end_line: number;
    start_column?: number;
    end_column?: number;
    annotation_level: "notice" | "warning" | "failure";
    message: string;
    title?: string;
    raw_details?: string;
  };
  export type ChecksUpdateParamsOutputImages = {
    alt: string;
    image_url: string;
    caption?: string;
  };
  export type ChecksUpdateParamsActions = {
    label: string;
    description: string;
    identifier: string;
  };
  export type GistsCreateParamsFiles = {
    content?: string;
  };
  export type GistsUpdateParamsFiles = {
    content?: string;
    filename?: string;
  };
  export type GitdataCreateCommitParamsCommitter = {};
  export type GitdataCreateCommitParamsAuthor = {};
  export type GitdataCreateTagParamsTagger = {
    name?: string;
    email?: string;
    date?: string;
  };
  export type GitdataCreateTreeParamsTree = {
    path?: string;
    mode?: "100644" | "100755" | "040000" | "160000" | "120000";
    type?: "blob" | "tree" | "commit";
    sha?: string;
    content?: string;
  };
  export type OrgsCreateHookParamsConfig = {
    url: string;
    content_type?: string;
    secret?: string;
    insecure_ssl?: string;
  };
  export type OrgsUpdateHookParamsConfig = {
    url: string;
    content_type?: string;
    secret?: string;
    insecure_ssl?: string;
  };
  export type PullRequestsCreateReviewParamsComments = {
    path: string;
    position: number;
    body: string;
  };
  export type ReposCreateFileParamsCommitter = {
    name: string;
    email: string;
  };
  export type ReposCreateFileParamsAuthor = {
    name: string;
    email: string;
  };
  export type ReposCreateHookParamsConfig = {
    url: string;
    content_type?: string;
    secret?: string;
    insecure_ssl?: string;
  };
  export type ReposDeleteFileParamsCommitter = {};
  export type ReposDeleteFileParamsAuthor = {};
  export type ReposUpdateBranchProtectionParamsRequiredStatusChecks = {
    strict: boolean;
    contexts: string[];
  };
  export type ReposUpdateBranchProtectionParamsRequiredPullRequestReviews = {
    dismissal_restrictions?: ReposUpdateBranchProtectionParamsRequiredPullRequestReviewsDismissalRestrictions;
    dismiss_stale_reviews?: boolean;
    require_code_owner_reviews?: boolean;
    required_approving_review_count?: number;
  };
  export type ReposUpdateBranchProtectionParamsRequiredPullRequestReviewsDismissalRestrictions = {
    users?: string[];
    teams?: string[];
  };
  export type ReposUpdateBranchProtectionParamsRestrictions = {
    users?: string[];
    teams?: string[];
  };
  export type ReposUpdateFileParamsCommitter = {
    name: string;
    email: string;
  };
  export type ReposUpdateFileParamsAuthor = {
    name: string;
    email: string;
  };
  export type ReposUpdateHookParamsConfig = {
    url: string;
    content_type?: string;
    secret?: string;
    insecure_ssl?: string;
  };
  export type ReposUpdateProtectedBranchPullRequestReviewEnforcementParamsDismissalRestrictions = {
    users?: string[];
    teams?: string[];
  };
}

declare class Github {
  constructor(options?: Github.Options);
  authenticate(auth: Github.Auth): void;
  hasNextPage(link: Github.Link): string | undefined;
  hasPreviousPage(link: Github.Link): string | undefined;
  hasLastPage(link: Github.Link): string | undefined;
  hasFirstPage(link: Github.Link): string | undefined;

  getNextPage(
    link: Github.Link,
    callback?: Github.Callback<Github.AnyResponse>
  ): Promise<Github.AnyResponse>;
  getNextPage(
    link: Github.Link,
    headers?: { [header: string]: any },
    callback?: Github.Callback<Github.AnyResponse>
  ): Promise<Github.AnyResponse>;

  getPreviousPage(
    link: Github.Link,
    callback?: Github.Callback<Github.AnyResponse>
  ): Promise<Github.AnyResponse>;
  getPreviousPage(
    link: Github.Link,
    headers?: { [header: string]: any },
    callback?: Github.Callback<Github.AnyResponse>
  ): Promise<Github.AnyResponse>;

  getLastPage(
    link: Github.Link,
    callback?: Github.Callback<Github.AnyResponse>
  ): Promise<Github.AnyResponse>;
  getLastPage(
    link: Github.Link,
    headers?: { [header: string]: any },
    callback?: Github.Callback<Github.AnyResponse>
  ): Promise<Github.AnyResponse>;

  getFirstPage(
    link: Github.Link,
    callback?: Github.Callback<Github.AnyResponse>
  ): Promise<Github.AnyResponse>;
  getFirstPage(
    link: Github.Link,
    headers?: { [header: string]: any },
    callback?: Github.Callback<Github.AnyResponse>
  ): Promise<Github.AnyResponse>;

  activity: {
    /**
     * Requires for the user to be authenticated.
     */
    checkStarringRepo(
      params: Github.ActivityCheckStarringRepoParams,
      callback?: Github.Callback<Github.AnyResponse>
    ): Promise<Github.AnyResponse>;
    /**
     * This endpoint should only be used to stop watching a repository. To control whether or not you wish to receive notifications from a repository, [set the repository's subscription manually](#set-a-repository-subscription).
     */
    deleteRepoSubscription(
      params: Github.ActivityDeleteRepoSubscriptionParams,
      callback?: Github.Callback<
        Github.Response<Github.ActivityDeleteRepoSubscriptionResponse>
      >
    ): Promise<Github.Response<Github.ActivityDeleteRepoSubscriptionResponse>>;
    /**
     * Mutes all future notifications for a conversation until you comment on the thread or get **@mention**ed.
     */
    deleteThreadSubscription(
      params: Github.ActivityDeleteThreadSubscriptionParams,
      callback?: Github.Callback<
        Github.Response<Github.ActivityDeleteThreadSubscriptionResponse>
      >
    ): Promise<
      Github.Response<Github.ActivityDeleteThreadSubscriptionResponse>
    >;

    getRepoSubscription(
      params: Github.ActivityGetRepoSubscriptionParams,
      callback?: Github.Callback<Github.AnyResponse>
    ): Promise<Github.AnyResponse>;

    getThread(
      params: Github.ActivityGetThreadParams,
      callback?: Github.Callback<
        Github.Response<Github.ActivityGetThreadResponse>
      >
    ): Promise<Github.Response<Github.ActivityGetThreadResponse>>;
    /**
     * This checks to see if the current user is subscribed to a thread. You can also [get a Repository subscription](https://developer.github.com/v3/activity/watching/#get-a-repository-subscription).,* ,* Note that subscriptions are only generated if a user is participating in a conversation--for example, they've replied to the thread, were **@mentioned**, or manually subscribe to a thread.
     */
    getThreadSubscription(
      params: Github.ActivityGetThreadSubscriptionParams,
      callback?: Github.Callback<
        Github.Response<Github.ActivityGetThreadSubscriptionResponse>
      >
    ): Promise<Github.Response<Github.ActivityGetThreadSubscriptionResponse>>;
    /**
     * This is the user's organization dashboard. You must be authenticated as the user to view this.
     */
    listEventsForOrg(
      params: Github.ActivityListEventsForOrgParams,
      callback?: Github.Callback<Github.AnyResponse>
    ): Promise<Github.AnyResponse>;
    /**
     * If you are authenticated as the given user, you will see your private events. Otherwise, you'll only see public events.
     */
    listEventsForUser(
      params: Github.ActivityListEventsForUserParams,
      callback?: Github.Callback<Github.AnyResponse>
    ): Promise<Github.AnyResponse>;
    /**
     * GitHub provides several timeline resources in [Atom](http://en.wikipedia.org/wiki/Atom_(standard)) format. The Feeds API lists all the feeds available to the authenticated user:,* ,* *   **Timeline**: The GitHub global public timeline,* *   **User**: The public timeline for any user, using [URI template](https://developer.github.com/v3/#hypermedia),* *   **Current user public**: The public timeline for the authenticated user,* *   **Current user**: The private timeline for the authenticated user,* *   **Current user actor**: The private timeline for activity created by the authenticated user,* *   **Current user organizations**: The private timeline for the organizations the authenticated user is a member of.,* *   **Security advisories**: A collection of public announcements that provide information about security-related vulnerabilities in software on GitHub.,* ,* **Note**: Private feeds are only returned when [authenticating via Basic Auth](https://developer.github.com/v3/#basic-authentication) since current feed URIs use the older, non revocable auth tokens.
     */
    listFeeds(
      params: Github.EmptyParams,
      callback?: Github.Callback<
        Github.Response<Github.ActivityListFeedsResponse>
      >
    ): Promise<Github.Response<Github.ActivityListFeedsResponse>>;
    /**
     * List all notifications for the current user, sorted by most recently updated.
     */
    listNotifications(
      params: Github.ActivityListNotificationsParams,
      callback?: Github.Callback<
        Github.Response<Github.ActivityListNotificationsResponse>
      >
    ): Promise<Github.Response<Github.ActivityListNotificationsResponse>>;
    /**
     * List all notifications for the current user.
     */
    listNotificationsForRepo(
      params: Github.ActivityListNotificationsForRepoParams,
      callback?: Github.Callback<
        Github.Response<Github.ActivityListNotificationsForRepoResponse>
      >
    ): Promise<
      Github.Response<Github.ActivityListNotificationsForRepoResponse>
    >;
    /**
     * We delay the public events feed by five minutes, which means the most recent event returned by the public events API actually occurred at least five minutes ago.
     */
    listPublicEvents(
      params: Github.ActivityListPublicEventsParams,
      callback?: Github.Callback<Github.AnyResponse>
    ): Promise<Github.AnyResponse>;

    listPublicEventsForOrg(
      params: Github.ActivityListPublicEventsForOrgParams,
      callback?: Github.Callback<Github.AnyResponse>
    ): Promise<Github.AnyResponse>;

    listPublicEventsForRepoNetwork(
      params: Github.ActivityListPublicEventsForRepoNetworkParams,
      callback?: Github.Callback<Github.AnyResponse>
    ): Promise<Github.AnyResponse>;

    listPublicEventsForUser(
      params: Github.ActivityListPublicEventsForUserParams,
      callback?: Github.Callback<Github.AnyResponse>
    ): Promise<Github.AnyResponse>;
    /**
     * These are events that you've received by watching repos and following users. If you are authenticated as the given user, you will see private events. Otherwise, you'll only see public events.
     */
    listReceivedEventsForUser(
      params: Github.ActivityListReceivedEventsForUserParams,
      callback?: Github.Callback<Github.AnyResponse>
    ): Promise<Github.AnyResponse>;

    listReceivedPublicEventsForUser(
      params: Github.ActivityListReceivedPublicEventsForUserParams,
      callback?: Github.Callback<Github.AnyResponse>
    ): Promise<Github.AnyResponse>;

    listRepoEvents(
      params: Github.ActivityListRepoEventsParams,
      callback?: Github.Callback<Github.AnyResponse>
    ): Promise<Github.AnyResponse>;
    /**
     * You can also find out _when_ stars were created by passing the following custom [media type](https://developer.github.com/v3/media/) via the `Accept` header:
     */
    listReposStarredByAuthenticatedUser(
      params: Github.ActivityListReposStarredByAuthenticatedUserParams,
      callback?: Github.Callback<
        Github.Response<
          Github.ActivityListReposStarredByAuthenticatedUserResponse
        >
      >
    ): Promise<
      Github.Response<
        Github.ActivityListReposStarredByAuthenticatedUserResponse
      >
    >;
    /**
     * You can also find out _when_ stars were created by passing the following custom [media type](https://developer.github.com/v3/media/) via the `Accept` header:
     */
    listReposStarredByUser(
      params: Github.ActivityListReposStarredByUserParams,
      callback?: Github.Callback<
        Github.Response<Github.ActivityListReposStarredByUserResponse>
      >
    ): Promise<Github.Response<Github.ActivityListReposStarredByUserResponse>>;

    listReposWatchedByUser(
      params: Github.ActivityListReposWatchedByUserParams,
      callback?: Github.Callback<
        Github.Response<Github.ActivityListReposWatchedByUserResponse>
      >
    ): Promise<Github.Response<Github.ActivityListReposWatchedByUserResponse>>;
    /**
     * You can also find out _when_ stars were created by passing the following custom [media type](https://developer.github.com/v3/media/) via the `Accept` header:
     */
    listStargazersForRepo(
      params: Github.ActivityListStargazersForRepoParams,
      callback?: Github.Callback<
        Github.Response<Github.ActivityListStargazersForRepoResponse>
      >
    ): Promise<Github.Response<Github.ActivityListStargazersForRepoResponse>>;

    listWatchedReposForAuthenticatedUser(
      params: Github.ActivityListWatchedReposForAuthenticatedUserParams,
      callback?: Github.Callback<
        Github.Response<
          Github.ActivityListWatchedReposForAuthenticatedUserResponse
        >
      >
    ): Promise<
      Github.Response<
        Github.ActivityListWatchedReposForAuthenticatedUserResponse
      >
    >;

    listWatchersForRepo(
      params: Github.ActivityListWatchersForRepoParams,
      callback?: Github.Callback<
        Github.Response<Github.ActivityListWatchersForRepoResponse>
      >
    ): Promise<Github.Response<Github.ActivityListWatchersForRepoResponse>>;
    /**
     * Marking a notification as "read" removes it from the [default view on GitHub](https://github.com/notifications).
     */
    markAsRead(
      params: Github.ActivityMarkAsReadParams,
      callback?: Github.Callback<
        Github.Response<Github.ActivityMarkAsReadResponse>
      >
    ): Promise<Github.Response<Github.ActivityMarkAsReadResponse>>;
    /**
     * Marking all notifications in a repository as "read" removes them from the [default view on GitHub](https://github.com/notifications).
     */
    markNotificationsAsReadForRepo(
      params: Github.ActivityMarkNotificationsAsReadForRepoParams,
      callback?: Github.Callback<
        Github.Response<Github.ActivityMarkNotificationsAsReadForRepoResponse>
      >
    ): Promise<
      Github.Response<Github.ActivityMarkNotificationsAsReadForRepoResponse>
    >;

    markThreadAsRead(
      params: Github.ActivityMarkThreadAsReadParams,
      callback?: Github.Callback<
        Github.Response<Github.ActivityMarkThreadAsReadResponse>
      >
    ): Promise<Github.Response<Github.ActivityMarkThreadAsReadResponse>>;
    /**
     * If you would like to watch a repository, set `subscribed` to `true`. If you would like to ignore notifications made within a repository, set `ignored` to `true`. If you would like to stop watching a repository, [delete the repository's subscription](#delete-a-repository-subscription) completely.
     */
    setRepoSubscription(
      params: Github.ActivitySetRepoSubscriptionParams,
      callback?: Github.Callback<
        Github.Response<Github.ActivitySetRepoSubscriptionResponse>
      >
    ): Promise<Github.Response<Github.ActivitySetRepoSubscriptionResponse>>;
    /**
     * This lets you subscribe or unsubscribe from a conversation.
     */
    setThreadSubscription(
      params: Github.ActivitySetThreadSubscriptionParams,
      callback?: Github.Callback<
        Github.Response<Github.ActivitySetThreadSubscriptionResponse>
      >
    ): Promise<Github.Response<Github.ActivitySetThreadSubscriptionResponse>>;
    /**
     * Requires for the user to be authenticated.,* ,* Note that you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP verbs](https://developer.github.com/v3/#http-verbs)."
     */
    starRepo(
      params: Github.ActivityStarRepoParams,
      callback?: Github.Callback<
        Github.Response<Github.ActivityStarRepoResponse>
      >
    ): Promise<Github.Response<Github.ActivityStarRepoResponse>>;
    /**
     * Requires for the user to be authenticated.
     */
    unstarRepo(
      params: Github.ActivityUnstarRepoParams,
      callback?: Github.Callback<
        Github.Response<Github.ActivityUnstarRepoResponse>
      >
    ): Promise<Github.Response<Github.ActivityUnstarRepoResponse>>;
  };
  apps: {
    /**
     * Add a single repository to an installation. The authenticated user must have admin access to the repository.,* ,* You must use a personal access token (which you can create via the [command line](https://help.github.com/articles/creating-a-personal-access-token-for-the-command-line/) or the [OAuth Authorizations API](https://developer.github.com/v3/oauth_authorizations/#create-a-new-authorization)) or [Basic Authentication](https://developer.github.com/v3/auth/#basic-authentication) to access this endpoint.
     */
    addRepoToInstallation(
      params: Github.AppsAddRepoToInstallationParams,
      callback?: Github.Callback<
        Github.Response<Github.AppsAddRepoToInstallationResponse>
      >
    ): Promise<Github.Response<Github.AppsAddRepoToInstallationResponse>>;
    /**
     * Shows whether the user or organization account actively subscribes to a plan listed by the authenticated GitHub App. When someone submits a plan change that won't be processed until the end of their billing cycle, you will also see the upcoming pending change.,* ,* GitHub Apps must use a [JWT](https://developer.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint. OAuth Apps must use [basic authentication](https://developer.github.com/v3/auth/#basic-authentication) with their client ID and client secret to access this endpoint.
     */
    checkAccountIsAssociatedWithAny(
      params: Github.AppsCheckAccountIsAssociatedWithAnyParams,
      callback?: Github.Callback<
        Github.Response<Github.AppsCheckAccountIsAssociatedWithAnyResponse>
      >
    ): Promise<
      Github.Response<Github.AppsCheckAccountIsAssociatedWithAnyResponse>
    >;
    /**
     * Shows whether the user or organization account actively subscribes to a plan listed by the authenticated GitHub App. When someone submits a plan change that won't be processed until the end of their billing cycle, you will also see the upcoming pending change.,* ,* GitHub Apps must use a [JWT](https://developer.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint. OAuth Apps must use [basic authentication](https://developer.github.com/v3/auth/#basic-authentication) with their client ID and client secret to access this endpoint.
     */
    checkAccountIsAssociatedWithAnyStubbed(
      params: Github.AppsCheckAccountIsAssociatedWithAnyStubbedParams,
      callback?: Github.Callback<
        Github.Response<
          Github.AppsCheckAccountIsAssociatedWithAnyStubbedResponse
        >
      >
    ): Promise<
      Github.Response<Github.AppsCheckAccountIsAssociatedWithAnyStubbedResponse>
    >;
    /**
     * Use this endpoint to complete the handshake necessary when implementing the [GitHub App Manifest flow](https://developer.github.com/apps/building-github-apps/creating-github-apps-from-a-manifest/). When you create a GitHub App with the manifest flow, you receive a temporary `code` used to retrieve the GitHub App's `id`, `pem` (private key), and `webhook_secret`.
     */
    createFromManifest(
      params: Github.AppsCreateFromManifestParams,
      callback?: Github.Callback<
        Github.Response<Github.AppsCreateFromManifestResponse>
      >
    ): Promise<Github.Response<Github.AppsCreateFromManifestResponse>>;
    /**
     * Creates an access token that enables a GitHub App to make authenticated API requests for the app's installation on an organization or individual account. Installation tokens expire one hour from the time you create them. Using an expired token produces a status code of `401 - Unauthorized`, and requires creating a new installation token.,* ,* You must use a [JWT](https://developer.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
     */
    createInstallationToken(
      params: Github.AppsCreateInstallationTokenParams,
      callback?: Github.Callback<
        Github.Response<Github.AppsCreateInstallationTokenResponse>
      >
    ): Promise<Github.Response<Github.AppsCreateInstallationTokenResponse>>;
    /**
     * Enables an authenticated GitHub App to find the organization's installation information.,* ,* You must use a [JWT](https://developer.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
     */
    findOrgInstallation(
      params: Github.AppsFindOrgInstallationParams,
      callback?: Github.Callback<
        Github.Response<Github.AppsFindOrgInstallationResponse>
      >
    ): Promise<Github.Response<Github.AppsFindOrgInstallationResponse>>;
    /**
     * Enables an authenticated GitHub App to find the repository's installation information. The installation's account type will be either an organization or a user account, depending which account the repository belongs to.,* ,* You must use a [JWT](https://developer.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
     */
    findRepoInstallation(
      params: Github.AppsFindRepoInstallationParams,
      callback?: Github.Callback<
        Github.Response<Github.AppsFindRepoInstallationResponse>
      >
    ): Promise<Github.Response<Github.AppsFindRepoInstallationResponse>>;
    /**
     * Enables an authenticated GitHub App to find the user’s installation information.,* ,* You must use a [JWT](https://developer.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
     */
    findUserInstallation(
      params: Github.AppsFindUserInstallationParams,
      callback?: Github.Callback<
        Github.Response<Github.AppsFindUserInstallationResponse>
      >
    ): Promise<Github.Response<Github.AppsFindUserInstallationResponse>>;
    /**
     * Returns the GitHub App associated with the authentication credentials used.,* ,* You must use a [JWT](https://developer.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
     */
    getAuthenticated(
      params: Github.EmptyParams,
      callback?: Github.Callback<
        Github.Response<Github.AppsGetAuthenticatedResponse>
      >
    ): Promise<Github.Response<Github.AppsGetAuthenticatedResponse>>;
    /**
     * **Note**: The `:app_slug` is just the URL-friendly name of your GitHub App. You can find this on the settings page for your GitHub App (e.g., `https://github.com/settings/apps/:app_slug`).,* ,* If the GitHub App you specify is public, you can access this endpoint without authenticating. If the GitHub App you specify is private, you must authenticate with a [personal access token](https://help.github.com/articles/creating-a-personal-access-token-for-the-command-line/) or an [installation access token](https://developer.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-an-installation) to access this endpoint.
     */
    getBySlug(
      params: Github.AppsGetBySlugParams,
      callback?: Github.Callback<Github.Response<Github.AppsGetBySlugResponse>>
    ): Promise<Github.Response<Github.AppsGetBySlugResponse>>;
    /**
     * You must use a [JWT](https://developer.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
     */
    getInstallation(
      params: Github.AppsGetInstallationParams,
      callback?: Github.Callback<
        Github.Response<Github.AppsGetInstallationResponse>
      >
    ): Promise<Github.Response<Github.AppsGetInstallationResponse>>;
    /**
     * Returns any accounts associated with a plan, including free plans. For per-seat pricing, you see the list of accounts that have purchased the plan, including the number of seats purchased. When someone submits a plan change that won't be processed until the end of their billing cycle, you will also see the upcoming pending change.,* ,* GitHub Apps must use a [JWT](https://developer.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint. OAuth Apps must use [basic authentication](https://developer.github.com/v3/auth/#basic-authentication) with their client ID and client secret to access this endpoint.
     */
    listAccountsUserOrOrgOnPlan(
      params: Github.AppsListAccountsUserOrOrgOnPlanParams,
      callback?: Github.Callback<
        Github.Response<Github.AppsListAccountsUserOrOrgOnPlanResponse>
      >
    ): Promise<Github.Response<Github.AppsListAccountsUserOrOrgOnPlanResponse>>;
    /**
     * Returns any accounts associated with a plan, including free plans. For per-seat pricing, you see the list of accounts that have purchased the plan, including the number of seats purchased. When someone submits a plan change that won't be processed until the end of their billing cycle, you will also see the upcoming pending change.,* ,* GitHub Apps must use a [JWT](https://developer.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint. OAuth Apps must use [basic authentication](https://developer.github.com/v3/auth/#basic-authentication) with their client ID and client secret to access this endpoint.
     */
    listAccountsUserOrOrgOnPlanStubbed(
      params: Github.AppsListAccountsUserOrOrgOnPlanStubbedParams,
      callback?: Github.Callback<
        Github.Response<Github.AppsListAccountsUserOrOrgOnPlanStubbedResponse>
      >
    ): Promise<
      Github.Response<Github.AppsListAccountsUserOrOrgOnPlanStubbedResponse>
    >;
    /**
     * List repositories that the authenticated user has explicit permission (`:read`, `:write`, or `:admin`) to access for an installation.,* ,* The authenticated user has explicit permission to access repositories they own, repositories where they are a collaborator, and repositories that they can access through an organization membership.,* ,* You must use a [user-to-server OAuth access token](https://developer.github.com/apps/building-github-apps/identifying-and-authorizing-users-for-github-apps/#identifying-users-on-your-site), created for a user who has authorized your GitHub App, to access this endpoint.,* ,* The access the user has to each repository is included in the hash under the `permissions` key.
     */
    listInstallationReposForAuthenticatedUser(
      params: Github.AppsListInstallationReposForAuthenticatedUserParams,
      callback?: Github.Callback<
        Github.Response<
          Github.AppsListInstallationReposForAuthenticatedUserResponse
        >
      >
    ): Promise<
      Github.Response<
        Github.AppsListInstallationReposForAuthenticatedUserResponse
      >
    >;
    /**
     * You must use a [JWT](https://developer.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.,* ,* The permissions the installation has are included under the `permissions` key.
     */
    listInstallations(
      params: Github.AppsListInstallationsParams,
      callback?: Github.Callback<
        Github.Response<Github.AppsListInstallationsResponse>
      >
    ): Promise<Github.Response<Github.AppsListInstallationsResponse>>;
    /**
     * Lists installations in a repository that the authenticated user has explicit permission (`:read`, `:write`, or `:admin`) to access.,* ,* You must use a [user-to-server OAuth access token](https://developer.github.com/apps/building-github-apps/identifying-and-authorizing-users-for-github-apps/#identifying-users-on-your-site), created for a user who has authorized your GitHub App, to access this endpoint.,* ,* The authenticated user has explicit permission to access repositories they own, repositories where they are a collaborator, and repositories that they can access through an organization membership.,* ,* The permissions the installation has are included under the `permissions` key.
     */
    listInstallationsForAuthenticatedUser(
      params: Github.AppsListInstallationsForAuthenticatedUserParams,
      callback?: Github.Callback<
        Github.Response<
          Github.AppsListInstallationsForAuthenticatedUserResponse
        >
      >
    ): Promise<
      Github.Response<Github.AppsListInstallationsForAuthenticatedUserResponse>
    >;
    /**
     * Returns only active subscriptions. You must use a [user-to-server OAuth access token](https://developer.github.com/apps/building-github-apps/identifying-and-authorizing-users-for-github-apps/#identifying-users-on-your-site), created for a user who has authorized your GitHub App, to access this endpoint. . OAuth Apps must authenticate using an [OAuth token](https://developer.github.com/apps/building-github-apps/authenticating-with-github-apps/).
     */
    listMarketplacePurchasesForAuthenticatedUser(
      params: Github.AppsListMarketplacePurchasesForAuthenticatedUserParams,
      callback?: Github.Callback<
        Github.Response<
          Github.AppsListMarketplacePurchasesForAuthenticatedUserResponse
        >
      >
    ): Promise<
      Github.Response<
        Github.AppsListMarketplacePurchasesForAuthenticatedUserResponse
      >
    >;
    /**
     * Returns only active subscriptions. You must use a [user-to-server OAuth access token](https://developer.github.com/apps/building-github-apps/identifying-and-authorizing-users-for-github-apps/#identifying-users-on-your-site), created for a user who has authorized your GitHub App, to access this endpoint. . OAuth Apps must authenticate using an [OAuth token](https://developer.github.com/apps/building-github-apps/authenticating-with-github-apps/).
     */
    listMarketplacePurchasesForAuthenticatedUserStubbed(
      params: Github.AppsListMarketplacePurchasesForAuthenticatedUserStubbedParams,
      callback?: Github.Callback<
        Github.Response<
          Github.AppsListMarketplacePurchasesForAuthenticatedUserStubbedResponse
        >
      >
    ): Promise<
      Github.Response<
        Github.AppsListMarketplacePurchasesForAuthenticatedUserStubbedResponse
      >
    >;
    /**
     * GitHub Apps must use a [JWT](https://developer.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint. OAuth Apps must use [basic authentication](https://developer.github.com/v3/auth/#basic-authentication) with their client ID and client secret to access this endpoint.
     */
    listPlans(
      params: Github.AppsListPlansParams,
      callback?: Github.Callback<Github.Response<Github.AppsListPlansResponse>>
    ): Promise<Github.Response<Github.AppsListPlansResponse>>;
    /**
     * GitHub Apps must use a [JWT](https://developer.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint. OAuth Apps must use [basic authentication](https://developer.github.com/v3/auth/#basic-authentication) with their client ID and client secret to access this endpoint.
     */
    listPlansStubbed(
      params: Github.AppsListPlansStubbedParams,
      callback?: Github.Callback<
        Github.Response<Github.AppsListPlansStubbedResponse>
      >
    ): Promise<Github.Response<Github.AppsListPlansStubbedResponse>>;
    /**
     * List repositories that the authenticated user has explicit permission (`:read`, `:write`, or `:admin`) to access for an installation.,* ,* The authenticated user has explicit permission to access repositories they own, repositories where they are a collaborator, and repositories that they can access through an organization membership.,* ,* You must use an [installation access token](https://developer.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-an-installation) to access this endpoint.
     */
    listRepos(
      params: Github.AppsListReposParams,
      callback?: Github.Callback<Github.Response<Github.AppsListReposResponse>>
    ): Promise<Github.Response<Github.AppsListReposResponse>>;
    /**
     * Remove a single repository from an installation. The authenticated user must have admin access to the repository.,* ,* You must use a personal access token (which you can create via the [command line](https://help.github.com/articles/creating-a-personal-access-token-for-the-command-line/) or the [OAuth Authorizations API](https://developer.github.com/v3/oauth_authorizations/#create-a-new-authorization)) or [Basic Authentication](https://developer.github.com/v3/auth/#basic-authentication) to access this endpoint.
     */
    removeRepoFromInstallation(
      params: Github.AppsRemoveRepoFromInstallationParams,
      callback?: Github.Callback<
        Github.Response<Github.AppsRemoveRepoFromInstallationResponse>
      >
    ): Promise<Github.Response<Github.AppsRemoveRepoFromInstallationResponse>>;
  };
  authorization: {
    /**
     * OAuth applications can use a special API method for checking OAuth token validity without running afoul of normal rate limits for failed login attempts. Authentication works differently with this particular endpoint. You must use [Basic Authentication](https://developer.github.com/v3/auth#basic-authentication) when accessing it, where the username is the OAuth application `client_id` and the password is its `client_secret`. Invalid tokens will return `404 NOT FOUND`.
     */
    checkAuthorization(
      params: Github.AuthorizationCheckAuthorizationParams,
      callback?: Github.Callback<
        Github.Response<Github.AuthorizationCheckAuthorizationResponse>
      >
    ): Promise<Github.Response<Github.AuthorizationCheckAuthorizationResponse>>;
    /**
     * If you need a small number of personal access tokens, implementing the [web flow](https://developer.github.com/apps/building-oauth-apps/authorizing-oauth-apps/) can be cumbersome. Instead, tokens can be created using the OAuth Authorizations API using [Basic Authentication](https://developer.github.com/v3/auth#basic-authentication). To create personal access tokens for a particular OAuth application, you must provide its client ID and secret, found on the OAuth application settings page, linked from your [OAuth applications listing on GitHub](https://github.com/settings/developers).,* ,* If your OAuth application intends to create multiple tokens for one user, use `fingerprint` to differentiate between them.,* ,* You can also create OAuth tokens through the web UI via the [personal access tokens settings](https://github.com/settings/tokens). Read more about these tokens on the [GitHub Help site](https://help.github.com/articles/creating-an-access-token-for-command-line-use).,* ,* Organizations that enforce SAML SSO require personal access tokens to be whitelisted. Read more about whitelisting tokens on the [GitHub Help site](https://help.github.com/articles/about-identity-and-access-management-with-saml-single-sign-on).
     */
    createAuthorization(
      params: Github.AuthorizationCreateAuthorizationParams,
      callback?: Github.Callback<
        Github.Response<Github.AuthorizationCreateAuthorizationResponse>
      >
    ): Promise<
      Github.Response<Github.AuthorizationCreateAuthorizationResponse>
    >;

    deleteAuthorization(
      params: Github.AuthorizationDeleteAuthorizationParams,
      callback?: Github.Callback<
        Github.Response<Github.AuthorizationDeleteAuthorizationResponse>
      >
    ): Promise<
      Github.Response<Github.AuthorizationDeleteAuthorizationResponse>
    >;
    /**
     * Deleting an OAuth application's grant will also delete all OAuth tokens associated with the application for your user. Once deleted, the application has no access to your account and is no longer listed on [the application authorizations settings screen within GitHub](https://github.com/settings/applications#authorized).
     */
    deleteGrant(
      params: Github.AuthorizationDeleteGrantParams,
      callback?: Github.Callback<
        Github.Response<Github.AuthorizationDeleteGrantResponse>
      >
    ): Promise<Github.Response<Github.AuthorizationDeleteGrantResponse>>;

    getAuthorization(
      params: Github.AuthorizationGetAuthorizationParams,
      callback?: Github.Callback<
        Github.Response<Github.AuthorizationGetAuthorizationResponse>
      >
    ): Promise<Github.Response<Github.AuthorizationGetAuthorizationResponse>>;

    getGrant(
      params: Github.AuthorizationGetGrantParams,
      callback?: Github.Callback<
        Github.Response<Github.AuthorizationGetGrantResponse>
      >
    ): Promise<Github.Response<Github.AuthorizationGetGrantResponse>>;
    /**
     * This method will create a new authorization for the specified OAuth application, only if an authorization for that application doesn't already exist for the user. The URL includes the 20 character client ID for the OAuth app that is requesting the token. It returns the user's existing authorization for the application if one is present. Otherwise, it creates and returns a new one.
     */
    getOrCreateAuthorizationForApp(
      params: Github.AuthorizationGetOrCreateAuthorizationForAppParams,
      callback?: Github.Callback<Github.AnyResponse>
    ): Promise<Github.AnyResponse>;
    /**
     * This method will create a new authorization for the specified OAuth application, only if an authorization for that application and fingerprint do not already exist for the user. The URL includes the 20 character client ID for the OAuth app that is requesting the token. `fingerprint` is a unique string to distinguish an authorization from others created for the same client ID and user. It returns the user's existing authorization for the application if one is present. Otherwise, it creates and returns a new one.
     */
    getOrCreateAuthorizationForAppFingerprint(
      params: Github.AuthorizationGetOrCreateAuthorizationForAppFingerprintParams,
      callback?: Github.Callback<Github.AnyResponse>
    ): Promise<Github.AnyResponse>;

    listAuthorizations(
      params: Github.AuthorizationListAuthorizationsParams,
      callback?: Github.Callback<
        Github.Response<Github.AuthorizationListAuthorizationsResponse>
      >
    ): Promise<Github.Response<Github.AuthorizationListAuthorizationsResponse>>;
    /**
     * You can use this API to list the set of OAuth applications that have been granted access to your account. Unlike the [list your authorizations](https://developer.github.com/v3/oauth_authorizations/#list-your-authorizations) API, this API does not manage individual tokens. This API will return one entry for each OAuth application that has been granted access to your account, regardless of the number of tokens an application has generated for your user. The list of OAuth applications returned matches what is shown on [the application authorizations settings screen within GitHub](https://github.com/settings/applications#authorized). The `scopes` returned are the union of scopes authorized for the application. For example, if an application has one token with `repo` scope and another token with `user` scope, the grant will return `["repo", "user"]`.
     */
    listGrants(
      params: Github.AuthorizationListGrantsParams,
      callback?: Github.Callback<
        Github.Response<Github.AuthorizationListGrantsResponse>
      >
    ): Promise<Github.Response<Github.AuthorizationListGrantsResponse>>;
    /**
     * OAuth applications can use this API method to reset a valid OAuth token without end user involvement. Applications must save the "token" property in the response, because changes take effect immediately. You must use [Basic Authentication](https://developer.github.com/v3/auth#basic-authentication) when accessing it, where the username is the OAuth application `client_id` and the password is its `client_secret`. Invalid tokens will return `404 NOT FOUND`.
     */
    resetAuthorization(
      params: Github.AuthorizationResetAuthorizationParams,
      callback?: Github.Callback<
        Github.Response<Github.AuthorizationResetAuthorizationResponse>
      >
    ): Promise<Github.Response<Github.AuthorizationResetAuthorizationResponse>>;
    /**
     * OAuth application owners can revoke a single token for an OAuth application. You must use [Basic Authentication](https://developer.github.com/v3/auth#basic-authentication) for this method, where the username is the OAuth application `client_id` and the password is its `client_secret`.
     */
    revokeAuthorizationForApplication(
      params: Github.AuthorizationRevokeAuthorizationForApplicationParams,
      callback?: Github.Callback<
        Github.Response<
          Github.AuthorizationRevokeAuthorizationForApplicationResponse
        >
      >
    ): Promise<
      Github.Response<
        Github.AuthorizationRevokeAuthorizationForApplicationResponse
      >
    >;
    /**
     * OAuth application owners can revoke a grant for their OAuth application and a specific user. You must use [Basic Authentication](https://developer.github.com/v3/auth#basic-authentication) for this method, where the username is the OAuth application `client_id` and the password is its `client_secret`. You must also provide a valid token as `:token` and the grant for the token's owner will be deleted.,* ,* Deleting an OAuth application's grant will also delete all OAuth tokens associated with the application for the user. Once deleted, the application will have no access to the user's account and will no longer be listed on [the application authorizations settings screen within GitHub](https://github.com/settings/applications#authorized).
     */
    revokeGrantForApplication(
      params: Github.AuthorizationRevokeGrantForApplicationParams,
      callback?: Github.Callback<
        Github.Response<Github.AuthorizationRevokeGrantForApplicationResponse>
      >
    ): Promise<
      Github.Response<Github.AuthorizationRevokeGrantForApplicationResponse>
    >;
    /**
     * You can only send one of these scope keys at a time.
     */
    updateAuthorization(
      params: Github.AuthorizationUpdateAuthorizationParams,
      callback?: Github.Callback<
        Github.Response<Github.AuthorizationUpdateAuthorizationResponse>
      >
    ): Promise<
      Github.Response<Github.AuthorizationUpdateAuthorizationResponse>
    >;
  };
  checks: {
    /**
     * Creates a new check run for a specific commit in a repository. Your GitHub App must have the `checks:write` permission to create check runs.
     */
    create(
      params: Github.ChecksCreateParams,
      callback?: Github.Callback<Github.Response<Github.ChecksCreateResponse>>
    ): Promise<Github.Response<Github.ChecksCreateResponse>>;
    /**
     * By default, check suites are automatically created when you create a [check run](https://developer.github.com/v3/checks/runs/). You only need to use this endpoint for manually creating check suites when you've disabled automatic creation using "[Set preferences for check suites on a repository](https://developer.github.com/v3/checks/suites/#set-preferences-for-check-suites-on-a-repository)". Your GitHub App must have the `checks:write` permission to create check suites.
     */
    createSuite(
      params: Github.ChecksCreateSuiteParams,
      callback?: Github.Callback<
        Github.Response<Github.ChecksCreateSuiteResponse>
      >
    ): Promise<Github.Response<Github.ChecksCreateSuiteResponse>>;
    /**
     * Gets a single check run using its `id`. GitHub Apps must have the `checks:read` permission on a private repository or pull access to a public repository to get check runs. OAuth Apps and authenticated users must have the `repo` scope to get check runs in a private repository.
     */
    get(
      params: Github.ChecksGetParams,
      callback?: Github.Callback<Github.Response<Github.ChecksGetResponse>>
    ): Promise<Github.Response<Github.ChecksGetResponse>>;
    /**
     * Gets a single check suite using its `id`. GitHub Apps must have the `checks:read` permission on a private repository or pull access to a public repository to get check suites. OAuth Apps and authenticated users must have the `repo` scope to get check suites in a private repository.
     */
    getSuite(
      params: Github.ChecksGetSuiteParams,
      callback?: Github.Callback<Github.Response<Github.ChecksGetSuiteResponse>>
    ): Promise<Github.Response<Github.ChecksGetSuiteResponse>>;
    /**
     * Lists annotations for a check run using the annotation `id`. GitHub Apps must have the `checks:read` permission on a private repository or pull access to a public repository to get annotations for a check run. OAuth Apps and authenticated users must have the `repo` scope to get annotations for a check run in a private repository.
     */
    listAnnotations(
      params: Github.ChecksListAnnotationsParams,
      callback?: Github.Callback<
        Github.Response<Github.ChecksListAnnotationsResponse>
      >
    ): Promise<Github.Response<Github.ChecksListAnnotationsResponse>>;
    /**
     * Lists check runs for a commit ref. The `ref` can be a SHA, branch name, or a tag name. GitHub Apps must have the `checks:read` permission on a private repository or pull access to a public repository to get check runs. OAuth Apps and authenticated users must have the `repo` scope to get check runs in a private repository.
     */
    listForRef(
      params: Github.ChecksListForRefParams,
      callback?: Github.Callback<
        Github.Response<Github.ChecksListForRefResponse>
      >
    ): Promise<Github.Response<Github.ChecksListForRefResponse>>;
    /**
     * Lists check runs for a check suite using its `id`. GitHub Apps must have the `checks:read` permission on a private repository or pull access to a public repository to get check runs. OAuth Apps and authenticated users must have the `repo` scope to get check runs in a private repository.
     */
    listForSuite(
      params: Github.ChecksListForSuiteParams,
      callback?: Github.Callback<
        Github.Response<Github.ChecksListForSuiteResponse>
      >
    ): Promise<Github.Response<Github.ChecksListForSuiteResponse>>;
    /**
     * Lists check suites for a commit `ref`. The `ref` can be a SHA, branch name, or a tag name. GitHub Apps must have the `checks:read` permission on a private repository or pull access to a public repository to list check suites. OAuth Apps and authenticated users must have the `repo` scope to get check suites in a private repository.
     */
    listSuitesForRef(
      params: Github.ChecksListSuitesForRefParams,
      callback?: Github.Callback<
        Github.Response<Github.ChecksListSuitesForRefResponse>
      >
    ): Promise<Github.Response<Github.ChecksListSuitesForRefResponse>>;
    /**
     * Triggers GitHub to rerequest an existing check suite, without pushing new code to a repository. This endpoint will trigger the [`check_run` webhook](https://developer.github.com/v3/activity/events/types/#checkrunevent) event with the action `rerequested`. When a check suite is `rerequested`, its `status` is reset to `queued` and the `conclusion` is cleared.,* ,* To rerequest a check suite, your GitHub App must have the `checks:read` permission on a private repository or pull access to a public repository.
     */
    rerequestSuite(
      params: Github.ChecksRerequestSuiteParams,
      callback?: Github.Callback<
        Github.Response<Github.ChecksRerequestSuiteResponse>
      >
    ): Promise<Github.Response<Github.ChecksRerequestSuiteResponse>>;
    /**
     * Changes the default automatic flow when creating check suites. By default, the CheckSuiteEvent is automatically created each time code is pushed to a repository. When you disable the automatic creation of check suites, you can manually [Create a check suite](https://developer.github.com/v3/checks/suites/#create-a-check-suite). You must have admin permissions in the repository to set preferences for check suites.
     */
    setSuitesPreferences(
      params: Github.ChecksSetSuitesPreferencesParams,
      callback?: Github.Callback<
        Github.Response<Github.ChecksSetSuitesPreferencesResponse>
      >
    ): Promise<Github.Response<Github.ChecksSetSuitesPreferencesResponse>>;
    /**
     * Updates a check run for a specific commit in a repository. Your GitHub App must have the `checks:write` permission to edit check runs.
     */
    update(
      params: Github.ChecksUpdateParams,
      callback?: Github.Callback<Github.Response<Github.ChecksUpdateResponse>>
    ): Promise<Github.Response<Github.ChecksUpdateResponse>>;
  };
  codesOfConduct: {
    getConductCode(
      params: Github.CodesOfConductGetConductCodeParams,
      callback?: Github.Callback<
        Github.Response<Github.CodesOfConductGetConductCodeResponse>
      >
    ): Promise<Github.Response<Github.CodesOfConductGetConductCodeResponse>>;
    /**
     * This method returns the contents of the repository's code of conduct file, if one is detected.
     */
    getForRepo(
      params: Github.CodesOfConductGetForRepoParams,
      callback?: Github.Callback<
        Github.Response<Github.CodesOfConductGetForRepoResponse>
      >
    ): Promise<Github.Response<Github.CodesOfConductGetForRepoResponse>>;

    listConductCodes(
      params: Github.EmptyParams,
      callback?: Github.Callback<
        Github.Response<Github.CodesOfConductListConductCodesResponse>
      >
    ): Promise<Github.Response<Github.CodesOfConductListConductCodesResponse>>;
  };
  emojis: {
    /**
     * Lists all the emojis available to use on GitHub.,* ,*
     */
    get(
      params: Github.EmptyParams,
      callback?: Github.Callback<Github.Response<Github.EmojisGetResponse>>
    ): Promise<Github.Response<Github.EmojisGetResponse>>;
  };
  gists: {
    checkIsStarred(
      params: Github.GistsCheckIsStarredParams,
      callback?: Github.Callback<Github.AnyResponse>
    ): Promise<Github.AnyResponse>;
    /**
     * Allows you to add a new gist with one or more files.,* ,* **Note:** Don't name your files "gistfile" with a numerical suffix. This is the format of the automatic naming scheme that Gist uses internally.
     */
    create(
      params: Github.GistsCreateParams,
      callback?: Github.Callback<Github.Response<Github.GistsCreateResponse>>
    ): Promise<Github.Response<Github.GistsCreateResponse>>;

    createComment(
      params: Github.GistsCreateCommentParams,
      callback?: Github.Callback<
        Github.Response<Github.GistsCreateCommentResponse>
      >
    ): Promise<Github.Response<Github.GistsCreateCommentResponse>>;

    delete(
      params: Github.GistsDeleteParams,
      callback?: Github.Callback<Github.Response<Github.GistsDeleteResponse>>
    ): Promise<Github.Response<Github.GistsDeleteResponse>>;

    deleteComment(
      params: Github.GistsDeleteCommentParams,
      callback?: Github.Callback<
        Github.Response<Github.GistsDeleteCommentResponse>
      >
    ): Promise<Github.Response<Github.GistsDeleteCommentResponse>>;
    /**
     * **Note**: This was previously `/gists/:gist_id/fork`.
     */
    fork(
      params: Github.GistsForkParams,
      callback?: Github.Callback<Github.Response<Github.GistsForkResponse>>
    ): Promise<Github.Response<Github.GistsForkResponse>>;

    get(
      params: Github.GistsGetParams,
      callback?: Github.Callback<Github.Response<Github.GistsGetResponse>>
    ): Promise<Github.Response<Github.GistsGetResponse>>;

    getComment(
      params: Github.GistsGetCommentParams,
      callback?: Github.Callback<
        Github.Response<Github.GistsGetCommentResponse>
      >
    ): Promise<Github.Response<Github.GistsGetCommentResponse>>;

    getRevision(
      params: Github.GistsGetRevisionParams,
      callback?: Github.Callback<
        Github.Response<Github.GistsGetRevisionResponse>
      >
    ): Promise<Github.Response<Github.GistsGetRevisionResponse>>;

    list(
      params: Github.GistsListParams,
      callback?: Github.Callback<Github.Response<Github.GistsListResponse>>
    ): Promise<Github.Response<Github.GistsListResponse>>;

    listComments(
      params: Github.GistsListCommentsParams,
      callback?: Github.Callback<
        Github.Response<Github.GistsListCommentsResponse>
      >
    ): Promise<Github.Response<Github.GistsListCommentsResponse>>;

    listCommits(
      params: Github.GistsListCommitsParams,
      callback?: Github.Callback<
        Github.Response<Github.GistsListCommitsResponse>
      >
    ): Promise<Github.Response<Github.GistsListCommitsResponse>>;

    listForks(
      params: Github.GistsListForksParams,
      callback?: Github.Callback<Github.Response<Github.GistsListForksResponse>>
    ): Promise<Github.Response<Github.GistsListForksResponse>>;
    /**
     * List all public gists sorted by most recently updated to least recently updated.,* ,* Note: With [pagination](https://developer.github.com/v3/#pagination), you can fetch up to 3000 gists. For example, you can fetch 100 pages with 30 gists per page or 30 pages with 100 gists per page.
     */
    listPublic(
      params: Github.GistsListPublicParams,
      callback?: Github.Callback<
        Github.Response<Github.GistsListPublicResponse>
      >
    ): Promise<Github.Response<Github.GistsListPublicResponse>>;

    listPublicForUser(
      params: Github.GistsListPublicForUserParams,
      callback?: Github.Callback<
        Github.Response<Github.GistsListPublicForUserResponse>
      >
    ): Promise<Github.Response<Github.GistsListPublicForUserResponse>>;
    /**
     * List the authenticated user's starred gists:
     */
    listStarred(
      params: Github.GistsListStarredParams,
      callback?: Github.Callback<
        Github.Response<Github.GistsListStarredResponse>
      >
    ): Promise<Github.Response<Github.GistsListStarredResponse>>;
    /**
     * Note that you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP verbs](https://developer.github.com/v3/#http-verbs)."
     */
    star(
      params: Github.GistsStarParams,
      callback?: Github.Callback<Github.Response<Github.GistsStarResponse>>
    ): Promise<Github.Response<Github.GistsStarResponse>>;

    unstar(
      params: Github.GistsUnstarParams,
      callback?: Github.Callback<Github.Response<Github.GistsUnstarResponse>>
    ): Promise<Github.Response<Github.GistsUnstarResponse>>;
    /**
     * Allows you to update or delete a gist file and rename gist files. Files from the previous version of the gist that aren't explicitly changed during an edit are unchanged.
     */
    update(
      params: Github.GistsUpdateParams,
      callback?: Github.Callback<Github.Response<Github.GistsUpdateResponse>>
    ): Promise<Github.Response<Github.GistsUpdateResponse>>;

    updateComment(
      params: Github.GistsUpdateCommentParams,
      callback?: Github.Callback<
        Github.Response<Github.GistsUpdateCommentResponse>
      >
    ): Promise<Github.Response<Github.GistsUpdateCommentResponse>>;
  };
  gitdata: {
    createBlob(
      params: Github.GitdataCreateBlobParams,
      callback?: Github.Callback<
        Github.Response<Github.GitdataCreateBlobResponse>
      >
    ): Promise<Github.Response<Github.GitdataCreateBlobResponse>>;
    /**
     * Creates a new Git [commit object](https://git-scm.com/book/en/v1/Git-Internals-Git-Objects#Commit-Objects).,* ,* The `committer` section is optional and will be filled with the `author` data if omitted. If the `author` section is omitted, it will be filled in with the authenticated user's information and the current date.,* ,* Both the `author` and `committer` parameters have the same keys:,* ,* | name  | type   | description                                                                                                             |,* | ----- | ------ | ----------------------------------------------------------------------------------------------------------------------- |,* | name  | string | The name of the author (or committer) of the commit                                                                     |,* | email | string | The email of the author (or committer) of the commit                                                                    |,* | date  | string | Indicates when this commit was authored (or committed). This is a timestamp in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`. |,* ,* You can also provide an optional string `signature` parameter. This value will be added to the `gpgsig` header of the created commit. For a commit signature to be verifiable by Git or GitHub, it must be an ASCII-armored detached PGP signature over the string commit as it would be written to the object database.,* ,* **Note**: To pass a `signature` parameter, you need to first manually create a valid PGP signature, which can be complicated. You may find it easier to [use the command line](https://git-scm.com/book/id/v2/Git-Tools-Signing-Your-Work) to create signed commits.,* ,* In this example, the payload that the signature is over would have been:,* ,*
     */
    createCommit(
      params: Github.GitdataCreateCommitParams,
      callback?: Github.Callback<
        Github.Response<Github.GitdataCreateCommitResponse>
      >
    ): Promise<Github.Response<Github.GitdataCreateCommitResponse>>;
    /**
     * Creates a reference for your repository. You are unable to create new references for empty repositories, even if the commit SHA-1 hash used exists. Empty repositories are repositories without branches.
     */
    createRef(
      params: Github.GitdataCreateRefParams,
      callback?: Github.Callback<
        Github.Response<Github.GitdataCreateRefResponse>
      >
    ): Promise<Github.Response<Github.GitdataCreateRefResponse>>;
    /**
     * Note that creating a tag object does not create the reference that makes a tag in Git. If you want to create an annotated tag in Git, you have to do this call to create the tag object, and then [create](https://developer.github.com/v3/git/refs/#create-a-reference) the `refs/tags/[tag]` reference. If you want to create a lightweight tag, you only have to [create](https://developer.github.com/v3/git/refs/#create-a-reference) the tag reference - this call would be unnecessary.
     */
    createTag(
      params: Github.GitdataCreateTagParams,
      callback?: Github.Callback<
        Github.Response<Github.GitdataCreateTagResponse>
      >
    ): Promise<Github.Response<Github.GitdataCreateTagResponse>>;
    /**
     * The tree creation API will take nested entries as well. If both a tree and a nested path modifying that tree are specified, it will overwrite the contents of that tree with the new path contents and write a new tree out.
     */
    createTree(
      params: Github.GitdataCreateTreeParams,
      callback?: Github.Callback<
        Github.Response<Github.GitdataCreateTreeResponse>
      >
    ): Promise<Github.Response<Github.GitdataCreateTreeResponse>>;
    /**
     * Example: Deleting a branch:,* ,* ```,* DELETE /repos/octocat/Hello-World/git/refs/heads/feature-a,* ```,* ,* Example: Deleting a tag:,* ,* ```,* DELETE /repos/octocat/Hello-World/git/refs/tags/v1.0,* ```
     */
    deleteRef(
      params: Github.GitdataDeleteRefParams,
      callback?: Github.Callback<
        Github.Response<Github.GitdataDeleteRefResponse>
      >
    ): Promise<Github.Response<Github.GitdataDeleteRefResponse>>;
    /**
     * The `content` in the response will always be Base64 encoded.,* ,* _Note_: This API supports blobs up to 100 megabytes in size.
     */
    getBlob(
      params: Github.GitdataGetBlobParams,
      callback?: Github.Callback<Github.Response<Github.GitdataGetBlobResponse>>
    ): Promise<Github.Response<Github.GitdataGetBlobResponse>>;
    /**
     * Gets a Git [commit object](https://git-scm.com/book/en/v1/Git-Internals-Git-Objects#Commit-Objects).
     */
    getCommit(
      params: Github.GitdataGetCommitParams,
      callback?: Github.Callback<
        Github.Response<Github.GitdataGetCommitResponse>
      >
    ): Promise<Github.Response<Github.GitdataGetCommitResponse>>;
    /**
     * Returns a branch or tag reference. Other than the [REST API](https://developer.github.com/v3/git/refs/#get-a-reference) it always returns a single reference. If the REST API returns with an array then the method responds with an error.
     */
    getRef(
      params: Github.GitdataGetRefParams,
      callback?: Github.Callback<Github.AnyResponse>
    ): Promise<Github.AnyResponse>;

    getTag(
      params: Github.GitdataGetTagParams,
      callback?: Github.Callback<Github.Response<Github.GitdataGetTagResponse>>
    ): Promise<Github.Response<Github.GitdataGetTagResponse>>;
    /**
     * If `truncated` in the response is `true`, the number of items in the `tree` array exceeded our maximum limit. If you need to fetch more items, omit the `recursive` parameter, and fetch one sub-tree at a time. If you need to fetch even more items, you can clone the repository and iterate over the Git data locally.
     */
    getTree(
      params: Github.GitdataGetTreeParams,
      callback?: Github.Callback<Github.AnyResponse>
    ): Promise<Github.AnyResponse>;
    /**
     * This will return an array of all the references on the system, including things like notes and stashes if they exist on the server
     */
    listRefs(
      params: Github.GitdataListRefsParams,
      callback?: Github.Callback<Github.AnyResponse>
    ): Promise<Github.AnyResponse>;

    updateRef(
      params: Github.GitdataUpdateRefParams,
      callback?: Github.Callback<
        Github.Response<Github.GitdataUpdateRefResponse>
      >
    ): Promise<Github.Response<Github.GitdataUpdateRefResponse>>;
  };
  gitignore: {
    /**
     * The API also allows fetching the source of a single template.,* ,* Use the raw [media type](https://developer.github.com/v3/media/) to get the raw contents.,* ,*
     */
    getTemplate(
      params: Github.GitignoreGetTemplateParams,
      callback?: Github.Callback<
        Github.Response<Github.GitignoreGetTemplateResponse>
      >
    ): Promise<Github.Response<Github.GitignoreGetTemplateResponse>>;
    /**
     * List all templates available to pass as an option when [creating a repository](https://developer.github.com/v3/repos/#create).
     */
    listTemplates(
      params: Github.EmptyParams,
      callback?: Github.Callback<
        Github.Response<Github.GitignoreListTemplatesResponse>
      >
    ): Promise<Github.Response<Github.GitignoreListTemplatesResponse>>;
  };
  issues: {
    /**
     * Adds up to 10 assignees to an issue. Users already assigned to an issue are not replaced.,* ,* This example adds two assignees to the existing `octocat` assignee.
     */
    addAssignees(
      params: Github.IssuesAddAssigneesParams,
      callback?: Github.Callback<
        Github.Response<Github.IssuesAddAssigneesResponse>
      >
    ): Promise<Github.Response<Github.IssuesAddAssigneesResponse>>;

    addLabels(
      params: Github.IssuesAddLabelsParams,
      callback?: Github.Callback<
        Github.Response<Github.IssuesAddLabelsResponse>
      >
    ): Promise<Github.Response<Github.IssuesAddLabelsResponse>>;
    /**
     * Checks if a user has permission to be assigned to an issue in this repository.,* ,* If the `assignee` can be assigned to issues in the repository, a `204` header with no content is returned.,* ,* Otherwise a `404` status code is returned.
     */
    checkAssignee(
      params: Github.IssuesCheckAssigneeParams,
      callback?: Github.Callback<
        Github.Response<Github.IssuesCheckAssigneeResponse>
      >
    ): Promise<Github.Response<Github.IssuesCheckAssigneeResponse>>;
    /**
     * Any user with pull access to a repository can create an issue.
     */
    create(
      params: Github.IssuesCreateParams,
      callback?: Github.Callback<Github.Response<Github.IssuesCreateResponse>>
    ): Promise<Github.Response<Github.IssuesCreateResponse>>;

    createComment(
      params: Github.IssuesCreateCommentParams,
      callback?: Github.Callback<
        Github.Response<Github.IssuesCreateCommentResponse>
      >
    ): Promise<Github.Response<Github.IssuesCreateCommentResponse>>;

    createLabel(
      params: Github.IssuesCreateLabelParams,
      callback?: Github.Callback<
        Github.Response<Github.IssuesCreateLabelResponse>
      >
    ): Promise<Github.Response<Github.IssuesCreateLabelResponse>>;

    createMilestone(
      params: Github.IssuesCreateMilestoneParams,
      callback?: Github.Callback<
        Github.Response<Github.IssuesCreateMilestoneResponse>
      >
    ): Promise<Github.Response<Github.IssuesCreateMilestoneResponse>>;

    deleteComment(
      params: Github.IssuesDeleteCommentParams,
      callback?: Github.Callback<
        Github.Response<Github.IssuesDeleteCommentResponse>
      >
    ): Promise<Github.Response<Github.IssuesDeleteCommentResponse>>;

    deleteLabel(
      params: Github.IssuesDeleteLabelParams,
      callback?: Github.Callback<
        Github.Response<Github.IssuesDeleteLabelResponse>
      >
    ): Promise<Github.Response<Github.IssuesDeleteLabelResponse>>;

    deleteMilestone(
      params: Github.IssuesDeleteMilestoneParams,
      callback?: Github.Callback<
        Github.Response<Github.IssuesDeleteMilestoneResponse>
      >
    ): Promise<Github.Response<Github.IssuesDeleteMilestoneResponse>>;
    /**
     * **Note**: GitHub's REST API v3 considers every pull request an issue, but not every issue is a pull request. For this reason, "Issues" endpoints may return both issues and pull requests in the response. You can identify pull requests by the `pull_request` key.,* ,* Be aware that the `id` of a pull request returned from "Issues" endpoints will be an _issue id_. To find out the pull request id, use the "[List pull requests](https://developer.github.com/v3/pulls/#list-pull-requests)" endpoint.,* ,*
     */
    get(
      params: Github.IssuesGetParams,
      callback?: Github.Callback<Github.Response<Github.IssuesGetResponse>>
    ): Promise<Github.Response<Github.IssuesGetResponse>>;

    getComment(
      params: Github.IssuesGetCommentParams,
      callback?: Github.Callback<
        Github.Response<Github.IssuesGetCommentResponse>
      >
    ): Promise<Github.Response<Github.IssuesGetCommentResponse>>;

    getEvent(
      params: Github.IssuesGetEventParams,
      callback?: Github.Callback<Github.Response<Github.IssuesGetEventResponse>>
    ): Promise<Github.Response<Github.IssuesGetEventResponse>>;

    getLabel(
      params: Github.IssuesGetLabelParams,
      callback?: Github.Callback<Github.Response<Github.IssuesGetLabelResponse>>
    ): Promise<Github.Response<Github.IssuesGetLabelResponse>>;

    getMilestone(
      params: Github.IssuesGetMilestoneParams,
      callback?: Github.Callback<
        Github.Response<Github.IssuesGetMilestoneResponse>
      >
    ): Promise<Github.Response<Github.IssuesGetMilestoneResponse>>;
    /**
     * **Note**: GitHub's REST API v3 considers every pull request an issue, but not every issue is a pull request. For this reason, "Issues" endpoints may return both issues and pull requests in the response. You can identify pull requests by the `pull_request` key.,* ,* Be aware that the `id` of a pull request returned from "Issues" endpoints will be an _issue id_. To find out the pull request id, use the "[List pull requests](https://developer.github.com/v3/pulls/#list-pull-requests)" endpoint.,* ,*
     */
    list(
      params: Github.IssuesListParams,
      callback?: Github.Callback<Github.Response<Github.IssuesListResponse>>
    ): Promise<Github.Response<Github.IssuesListResponse>>;
    /**
     * Lists the [available assignees](https://help.github.com/articles/assigning-issues-and-pull-requests-to-other-github-users/) for issues in a repository.
     */
    listAssignees(
      params: Github.IssuesListAssigneesParams,
      callback?: Github.Callback<
        Github.Response<Github.IssuesListAssigneesResponse>
      >
    ): Promise<Github.Response<Github.IssuesListAssigneesResponse>>;
    /**
     * Issue Comments are ordered by ascending ID.,* ,*
     */
    listComments(
      params: Github.IssuesListCommentsParams,
      callback?: Github.Callback<
        Github.Response<Github.IssuesListCommentsResponse>
      >
    ): Promise<Github.Response<Github.IssuesListCommentsResponse>>;
    /**
     * By default, Issue Comments are ordered by ascending ID.,* ,*
     */
    listCommentsForRepo(
      params: Github.IssuesListCommentsForRepoParams,
      callback?: Github.Callback<
        Github.Response<Github.IssuesListCommentsForRepoResponse>
      >
    ): Promise<Github.Response<Github.IssuesListCommentsForRepoResponse>>;

    listEvents(
      params: Github.IssuesListEventsParams,
      callback?: Github.Callback<
        Github.Response<Github.IssuesListEventsResponse>
      >
    ): Promise<Github.Response<Github.IssuesListEventsResponse>>;

    listEventsForRepo(
      params: Github.IssuesListEventsForRepoParams,
      callback?: Github.Callback<
        Github.Response<Github.IssuesListEventsForRepoResponse>
      >
    ): Promise<Github.Response<Github.IssuesListEventsForRepoResponse>>;

    listEventsForTimeline(
      params: Github.IssuesListEventsForTimelineParams,
      callback?: Github.Callback<
        Github.Response<Github.IssuesListEventsForTimelineResponse>
      >
    ): Promise<Github.Response<Github.IssuesListEventsForTimelineResponse>>;
    /**
     * **Note**: GitHub's REST API v3 considers every pull request an issue, but not every issue is a pull request. For this reason, "Issues" endpoints may return both issues and pull requests in the response. You can identify pull requests by the `pull_request` key.,* ,* Be aware that the `id` of a pull request returned from "Issues" endpoints will be an _issue id_. To find out the pull request id, use the "[List pull requests](https://developer.github.com/v3/pulls/#list-pull-requests)" endpoint.,* ,*
     */
    listForAuthenticatedUser(
      params: Github.IssuesListForAuthenticatedUserParams,
      callback?: Github.Callback<
        Github.Response<Github.IssuesListForAuthenticatedUserResponse>
      >
    ): Promise<Github.Response<Github.IssuesListForAuthenticatedUserResponse>>;
    /**
     * **Note**: GitHub's REST API v3 considers every pull request an issue, but not every issue is a pull request. For this reason, "Issues" endpoints may return both issues and pull requests in the response. You can identify pull requests by the `pull_request` key.,* ,* Be aware that the `id` of a pull request returned from "Issues" endpoints will be an _issue id_. To find out the pull request id, use the "[List pull requests](https://developer.github.com/v3/pulls/#list-pull-requests)" endpoint.,* ,*
     */
    listForOrg(
      params: Github.IssuesListForOrgParams,
      callback?: Github.Callback<
        Github.Response<Github.IssuesListForOrgResponse>
      >
    ): Promise<Github.Response<Github.IssuesListForOrgResponse>>;
    /**
     * **Note**: GitHub's REST API v3 considers every pull request an issue, but not every issue is a pull request. For this reason, "Issues" endpoints may return both issues and pull requests in the response. You can identify pull requests by the `pull_request` key.,* ,* Be aware that the `id` of a pull request returned from "Issues" endpoints will be an _issue id_. To find out the pull request id, use the "[List pull requests](https://developer.github.com/v3/pulls/#list-pull-requests)" endpoint.,* ,*
     */
    listForRepo(
      params: Github.IssuesListForRepoParams,
      callback?: Github.Callback<
        Github.Response<Github.IssuesListForRepoResponse>
      >
    ): Promise<Github.Response<Github.IssuesListForRepoResponse>>;

    listLabelsForMilestone(
      params: Github.IssuesListLabelsForMilestoneParams,
      callback?: Github.Callback<
        Github.Response<Github.IssuesListLabelsForMilestoneResponse>
      >
    ): Promise<Github.Response<Github.IssuesListLabelsForMilestoneResponse>>;

    listLabelsForRepo(
      params: Github.IssuesListLabelsForRepoParams,
      callback?: Github.Callback<
        Github.Response<Github.IssuesListLabelsForRepoResponse>
      >
    ): Promise<Github.Response<Github.IssuesListLabelsForRepoResponse>>;

    listLabelsOnIssue(
      params: Github.IssuesListLabelsOnIssueParams,
      callback?: Github.Callback<
        Github.Response<Github.IssuesListLabelsOnIssueResponse>
      >
    ): Promise<Github.Response<Github.IssuesListLabelsOnIssueResponse>>;

    listMilestonesForRepo(
      params: Github.IssuesListMilestonesForRepoParams,
      callback?: Github.Callback<
        Github.Response<Github.IssuesListMilestonesForRepoResponse>
      >
    ): Promise<Github.Response<Github.IssuesListMilestonesForRepoResponse>>;
    /**
     * Users with push access can lock an issue or pull request's conversation.,* ,* Note that, if you choose not to pass any parameters, you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP verbs](https://developer.github.com/v3/#http-verbs)."
     */
    lock(
      params: Github.IssuesLockParams,
      callback?: Github.Callback<Github.Response<Github.IssuesLockResponse>>
    ): Promise<Github.Response<Github.IssuesLockResponse>>;
    /**
     * Removes one or more assignees from an issue.,* ,* This example removes two of three assignees, leaving the `octocat` assignee.
     */
    removeAssignees(
      params: Github.IssuesRemoveAssigneesParams,
      callback?: Github.Callback<
        Github.Response<Github.IssuesRemoveAssigneesResponse>
      >
    ): Promise<Github.Response<Github.IssuesRemoveAssigneesResponse>>;
    /**
     * Removes the specified label from the issue, and returns the remaining labels on the issue.
     */
    removeLabel(
      params: Github.IssuesRemoveLabelParams,
      callback?: Github.Callback<Github.AnyResponse>
    ): Promise<Github.AnyResponse>;

    removeLabels(
      params: Github.IssuesRemoveLabelsParams,
      callback?: Github.Callback<
        Github.Response<Github.IssuesRemoveLabelsResponse>
      >
    ): Promise<Github.Response<Github.IssuesRemoveLabelsResponse>>;

    replaceLabels(
      params: Github.IssuesReplaceLabelsParams,
      callback?: Github.Callback<
        Github.Response<Github.IssuesReplaceLabelsResponse>
      >
    ): Promise<Github.Response<Github.IssuesReplaceLabelsResponse>>;
    /**
     * Users with push access can unlock an issue's conversation.
     */
    unlock(
      params: Github.IssuesUnlockParams,
      callback?: Github.Callback<Github.Response<Github.IssuesUnlockResponse>>
    ): Promise<Github.Response<Github.IssuesUnlockResponse>>;
    /**
     * Issue owners and users with push access can edit an issue.
     */
    update(
      params: Github.IssuesUpdateParams,
      callback?: Github.Callback<Github.Response<Github.IssuesUpdateResponse>>
    ): Promise<Github.Response<Github.IssuesUpdateResponse>>;

    updateComment(
      params: Github.IssuesUpdateCommentParams,
      callback?: Github.Callback<
        Github.Response<Github.IssuesUpdateCommentResponse>
      >
    ): Promise<Github.Response<Github.IssuesUpdateCommentResponse>>;

    updateLabel(
      params: Github.IssuesUpdateLabelParams,
      callback?: Github.Callback<
        Github.Response<Github.IssuesUpdateLabelResponse>
      >
    ): Promise<Github.Response<Github.IssuesUpdateLabelResponse>>;

    updateMilestone(
      params: Github.IssuesUpdateMilestoneParams,
      callback?: Github.Callback<
        Github.Response<Github.IssuesUpdateMilestoneResponse>
      >
    ): Promise<Github.Response<Github.IssuesUpdateMilestoneResponse>>;
  };
  licenses: {
    get(
      params: Github.LicensesGetParams,
      callback?: Github.Callback<Github.Response<Github.LicensesGetResponse>>
    ): Promise<Github.Response<Github.LicensesGetResponse>>;
    /**
     * This method returns the contents of the repository's license file, if one is detected.,* ,* Similar to [the repository contents API](https://developer.github.com/v3/repos/contents/#get-contents), this method also supports [custom media types](https://developer.github.com/v3/repos/contents/#custom-media-types) for retrieving the raw license content or rendered license HTML.
     */
    getForRepo(
      params: Github.LicensesGetForRepoParams,
      callback?: Github.Callback<
        Github.Response<Github.LicensesGetForRepoResponse>
      >
    ): Promise<Github.Response<Github.LicensesGetForRepoResponse>>;

    list(
      params: Github.EmptyParams,
      callback?: Github.Callback<Github.Response<Github.LicensesListResponse>>
    ): Promise<Github.Response<Github.LicensesListResponse>>;
  };
  markdown: {
    render(
      params: Github.MarkdownRenderParams,
      callback?: Github.Callback<Github.Response<Github.MarkdownRenderResponse>>
    ): Promise<Github.Response<Github.MarkdownRenderResponse>>;
    /**
     * You must send Markdown as plain text (using a `Content-Type` header of `text/plain` or `text/x-markdown`) to this endpoint, rather than using JSON format. In raw mode, [GitHub Flavored Markdown](https://github.github.com/gfm/) is not supported and Markdown will be rendered in plain format like a README.md file. Markdown content must be 400 KB or less.,* ,*
     */
    renderRaw(
      params: Github.MarkdownRenderRawParams,
      callback?: Github.Callback<
        Github.Response<Github.MarkdownRenderRawResponse>
      >
    ): Promise<Github.Response<Github.MarkdownRenderRawResponse>>;
  };
  meta: {
    /**
     * This endpoint provides a list of GitHub's IP addresses. For more information, see "[About GitHub's IP addresses](https://help.github.com/articles/about-github-s-ip-addresses/).",* ,* **Note**: We no longer support GitHub Services as of October 1, 2018, and GitHub Services will stop working on January 31, 2019. Please see the [blog post](/changes/2018-10-01-denying-new-github-services) for details. You can use the [Replacing GitHub Services guide](https://developer.github.com/v3/guides/replacing-github-services) to help you update your services to webhooks.,* ,* **Note**: We no longer support GitHub Services as of October 1, 2018, and GitHub Services will stop working on January 31, 2019. Please see the [blog post](/changes/2018-10-01-denying-new-github-services) for details. You can use the [Replacing GitHub Services guide](https://developer.github.com/v3/guides/replacing-github-services) to help you update your services to webhooks.
     */
    get(
      params: Github.EmptyParams,
      callback?: Github.Callback<Github.Response<Github.MetaGetResponse>>
    ): Promise<Github.Response<Github.MetaGetResponse>>;
  };
  migrations: {
    /**
     * Stop an import for a repository.
     */
    cancelImport(
      params: Github.MigrationsCancelImportParams,
      callback?: Github.Callback<
        Github.Response<Github.MigrationsCancelImportResponse>
      >
    ): Promise<Github.Response<Github.MigrationsCancelImportResponse>>;
    /**
     * Deletes a previous migration archive. Downloadable migration archives are automatically deleted after seven days. Migration metadata, which is returned in the [Get a list of user migrations](#get-a-list-of-user-migrations) and [Get the status of a user migration](#get-the-status-of-a-user-migration) endpoints, will continue to be available even after an archive is deleted.
     */
    deleteArchiveForAuthenticatedUser(
      params: Github.MigrationsDeleteArchiveForAuthenticatedUserParams,
      callback?: Github.Callback<
        Github.Response<
          Github.MigrationsDeleteArchiveForAuthenticatedUserResponse
        >
      >
    ): Promise<
      Github.Response<
        Github.MigrationsDeleteArchiveForAuthenticatedUserResponse
      >
    >;
    /**
     * Deletes a previous migration archive. Migration archives are automatically deleted after seven days.
     */
    deleteArchiveForOrg(
      params: Github.MigrationsDeleteArchiveForOrgParams,
      callback?: Github.Callback<
        Github.Response<Github.MigrationsDeleteArchiveForOrgResponse>
      >
    ): Promise<Github.Response<Github.MigrationsDeleteArchiveForOrgResponse>>;
    /**
     * Fetches the URL to download the migration archive as a `tar.gz` file. Depending on the resources your repository uses, the migration archive can contain JSON files with data for these objects:,* ,* *   attachments,* *   bases,* *   commit\_comments,* *   issue\_comments,* *   issue\_events,* *   issues,* *   milestones,* *   organizations,* *   projects,* *   protected\_branches,* *   pull\_request\_reviews,* *   pull\_requests,* *   releases,* *   repositories,* *   review\_comments,* *   schema,* *   users,* ,* The archive will also contain an `attachments` directory that includes all attachment files uploaded to GitHub.com and a `repositories` directory that contains the repository's Git data.,* ,*
     */
    getArchiveForAuthenticatedUser(
      params: Github.MigrationsGetArchiveForAuthenticatedUserParams,
      callback?: Github.Callback<
        Github.Response<Github.MigrationsGetArchiveForAuthenticatedUserResponse>
      >
    ): Promise<
      Github.Response<Github.MigrationsGetArchiveForAuthenticatedUserResponse>
    >;
    /**
     * Fetches the URL to a migration archive.,* ,*
     */
    getArchiveForOrg(
      params: Github.MigrationsGetArchiveForOrgParams,
      callback?: Github.Callback<
        Github.Response<Github.MigrationsGetArchiveForOrgResponse>
      >
    ): Promise<Github.Response<Github.MigrationsGetArchiveForOrgResponse>>;
    /**
     * Each type of source control system represents authors in a different way. For example, a Git commit author has a display name and an email address, but a Subversion commit author just has a username. The GitHub Importer will make the author information valid, but the author might not be correct. For example, it will change the bare Subversion username `hubot` into something like `hubot <hubot@12341234-abab-fefe-8787-fedcba987654>`.,* ,* This API method and the "Map a commit author" method allow you to provide correct Git author information.
     */
    getCommitAuthors(
      params: Github.MigrationsGetCommitAuthorsParams,
      callback?: Github.Callback<
        Github.Response<Github.MigrationsGetCommitAuthorsResponse>
      >
    ): Promise<Github.Response<Github.MigrationsGetCommitAuthorsResponse>>;
    /**
     * View the progress of an import.,* ,* **Import status**,* ,* This section includes details about the possible values of the `status` field of the Import Progress response.,* ,* An import that does not have errors will progress through these steps:,* ,* *   `detecting` - the "detection" step of the import is in progress because the request did not include a `vcs` parameter. The import is identifying the type of source control present at the URL.,* *   `importing` - the "raw" step of the import is in progress. This is where commit data is fetched from the original repository. The import progress response will include `commit_count` (the total number of raw commits that will be imported) and `percent` (0 - 100, the current progress through the import).,* *   `mapping` - the "rewrite" step of the import is in progress. This is where SVN branches are converted to Git branches, and where author updates are applied. The import progress response does not include progress information.,* *   `pushing` - the "push" step of the import is in progress. This is where the importer updates the repository on GitHub. The import progress response will include `push_percent`, which is the percent value reported by `git push` when it is "Writing objects".,* *   `complete` - the import is complete, and the repository is ready on GitHub.,* ,* If there are problems, you will see one of these in the `status` field:,* ,* *   `auth_failed` - the import requires authentication in order to connect to the original repository. To update authentication for the import, please see the [Update Existing Import](#update-existing-import) section.,* *   `error` - the import encountered an error. The import progress response will include the `failed_step` and an error message. Contact [GitHub Support](https://github.com/contact) for more information.,* *   `detection_needs_auth` - the importer requires authentication for the originating repository to continue detection. To update authentication for the import, please see the [Update Existing Import](#update-existing-import) section.,* *   `detection_found_nothing` - the importer didn't recognize any source control at the URL. To resolve, [Cancel the import](#cancel-an-import) and [retry](#start-an-import) with the correct URL.,* *   `detection_found_multiple` - the importer found several projects or repositories at the provided URL. When this is the case, the Import Progress response will also include a `project_choices` field with the possible project choices as values. To update project choice, please see the [Update Existing Import](#update-existing-import) section.,* ,* **The project_choices field**,* ,* When multiple projects are found at the provided URL, the response hash will include a `project_choices` field, the value of which is an array of hashes each representing a project choice. The exact key/value pairs of the project hashes will differ depending on the version control type.,* ,* **Git LFS related fields**,* ,* This section includes details about Git LFS related fields that may be present in the Import Progress response.,* ,* *   `use_lfs` - describes whether the import has been opted in or out of using Git LFS. The value can be `opt_in`, `opt_out`, or `undecided` if no action has been taken.,* *   `has_large_files` - the boolean value describing whether files larger than 100MB were found during the `importing` step.,* *   `large_files_size` - the total size in gigabytes of files larger than 100MB found in the originating repository.,* *   `large_files_count` - the total number of files larger than 100MB found in the originating repository. To see a list of these files, make a "Get Large Files" request.
     */
    getImportProgress(
      params: Github.MigrationsGetImportProgressParams,
      callback?: Github.Callback<
        Github.Response<Github.MigrationsGetImportProgressResponse>
      >
    ): Promise<Github.Response<Github.MigrationsGetImportProgressResponse>>;
    /**
     * List files larger than 100MB found during the import
     */
    getLargeFiles(
      params: Github.MigrationsGetLargeFilesParams,
      callback?: Github.Callback<
        Github.Response<Github.MigrationsGetLargeFilesResponse>
      >
    ): Promise<Github.Response<Github.MigrationsGetLargeFilesResponse>>;
    /**
     * Fetches a single user migration. The response includes the `state` of the migration, which can be one of the following values:,* ,* *   `pending` - the migration hasn't started yet.,* *   `exporting` - the migration is in progress.,* *   `exported` - the migration finished successfully.,* *   `failed` - the migration failed.,* ,* Once the migration has been `exported` you can [download the migration archive](#download-a-user-migration-archive).
     */
    getStatusForAuthenticatedUser(
      params: Github.MigrationsGetStatusForAuthenticatedUserParams,
      callback?: Github.Callback<
        Github.Response<Github.MigrationsGetStatusForAuthenticatedUserResponse>
      >
    ): Promise<
      Github.Response<Github.MigrationsGetStatusForAuthenticatedUserResponse>
    >;
    /**
     * Fetches the status of a migration.,* ,* The `state` of a migration can be one of the following values:,* ,* *   `pending`, which means the migration hasn't started yet.,* *   `exporting`, which means the migration is in progress.,* *   `exported`, which means the migration finished successfully.,* *   `failed`, which means the migration failed.
     */
    getStatusForOrg(
      params: Github.MigrationsGetStatusForOrgParams,
      callback?: Github.Callback<
        Github.Response<Github.MigrationsGetStatusForOrgResponse>
      >
    ): Promise<Github.Response<Github.MigrationsGetStatusForOrgResponse>>;
    /**
     * Lists all migrations a user has started.
     */
    listForAuthenticatedUser(
      params: Github.MigrationsListForAuthenticatedUserParams,
      callback?: Github.Callback<
        Github.Response<Github.MigrationsListForAuthenticatedUserResponse>
      >
    ): Promise<
      Github.Response<Github.MigrationsListForAuthenticatedUserResponse>
    >;
    /**
     * Lists the most recent migrations.
     */
    listForOrg(
      params: Github.MigrationsListForOrgParams,
      callback?: Github.Callback<
        Github.Response<Github.MigrationsListForOrgResponse>
      >
    ): Promise<Github.Response<Github.MigrationsListForOrgResponse>>;
    /**
     * Update an author's identity for the import. Your application can continue updating authors any time before you push new commits to the repository.
     */
    mapCommitAuthor(
      params: Github.MigrationsMapCommitAuthorParams,
      callback?: Github.Callback<
        Github.Response<Github.MigrationsMapCommitAuthorResponse>
      >
    ): Promise<Github.Response<Github.MigrationsMapCommitAuthorResponse>>;
    /**
     * You can import repositories from Subversion, Mercurial, and TFS that include files larger than 100MB. This ability is powered by [Git LFS](https://git-lfs.github.com). You can learn more about our LFS feature and working with large files [on our help site](https://help.github.com/articles/versioning-large-files/).
     */
    setLfsPreference(
      params: Github.MigrationsSetLfsPreferenceParams,
      callback?: Github.Callback<
        Github.Response<Github.MigrationsSetLfsPreferenceResponse>
      >
    ): Promise<Github.Response<Github.MigrationsSetLfsPreferenceResponse>>;
    /**
     * Initiates the generation of a user migration archive.
     */
    startForAuthenticatedUser(
      params: Github.MigrationsStartForAuthenticatedUserParams,
      callback?: Github.Callback<
        Github.Response<Github.MigrationsStartForAuthenticatedUserResponse>
      >
    ): Promise<
      Github.Response<Github.MigrationsStartForAuthenticatedUserResponse>
    >;
    /**
     * Initiates the generation of a migration archive.
     */
    startForOrg(
      params: Github.MigrationsStartForOrgParams,
      callback?: Github.Callback<
        Github.Response<Github.MigrationsStartForOrgResponse>
      >
    ): Promise<Github.Response<Github.MigrationsStartForOrgResponse>>;
    /**
     * Start a source import to a GitHub repository using GitHub Importer.
     */
    startImport(
      params: Github.MigrationsStartImportParams,
      callback?: Github.Callback<
        Github.Response<Github.MigrationsStartImportResponse>
      >
    ): Promise<Github.Response<Github.MigrationsStartImportResponse>>;
    /**
     * Unlocks a repository. You can lock repositories when you [start a user migration](#start-a-user-migration). Once the migration is complete you can unlock each repository to begin using it again or [delete the repository](https://developer.github.com/v3/repos/#delete-a-repository) if you no longer need the source data. Returns a status of `404 Not Found` if the repository is not locked.
     */
    unlockRepoForAuthenticatedUser(
      params: Github.MigrationsUnlockRepoForAuthenticatedUserParams,
      callback?: Github.Callback<
        Github.Response<Github.MigrationsUnlockRepoForAuthenticatedUserResponse>
      >
    ): Promise<
      Github.Response<Github.MigrationsUnlockRepoForAuthenticatedUserResponse>
    >;
    /**
     * Unlocks a repository that was locked for migration. You should unlock each migrated repository and [delete them](https://developer.github.com/v3/repos/#delete-a-repository) when the migration is complete and you no longer need the source data.
     */
    unlockRepoForOrg(
      params: Github.MigrationsUnlockRepoForOrgParams,
      callback?: Github.Callback<
        Github.Response<Github.MigrationsUnlockRepoForOrgResponse>
      >
    ): Promise<Github.Response<Github.MigrationsUnlockRepoForOrgResponse>>;
    /**
     * An import can be updated with credentials or a project choice by passing in the appropriate parameters in this API request. If no parameters are provided, the import will be restarted.,* ,* Some servers (e.g. TFS servers) can have several projects at a single URL. In those cases the import progress will have the status `detection_found_multiple` and the Import Progress response will include a `project_choices` array. You can select the project to import by providing one of the objects in the `project_choices` array in the update request.,* ,* The following example demonstrates the workflow for updating an import with "project1" as the project choice. Given a `project_choices` array like such:,* ,* To restart an import, no parameters are provided in the update request.
     */
    updateImport(
      params: Github.MigrationsUpdateImportParams,
      callback?: Github.Callback<
        Github.Response<Github.MigrationsUpdateImportResponse>
      >
    ): Promise<Github.Response<Github.MigrationsUpdateImportResponse>>;
  };
  misc: {};
  orgs: {
    /**
     * Only authenticated organization owners can add a member to the organization or update the member's role.,* ,* *   If the authenticated user is _adding_ a member to the organization, the invited user will receive an email inviting them to the organization. The user's [membership status](#get-organization-membership) will be `pending` until they accept the invitation.,*     ,* *   Authenticated users can _update_ a user's membership by passing the `role` parameter. If the authenticated user changes a member's role to `admin`, the affected user will receive an email notifying them that they've been made an organization owner. If the authenticated user changes an owner's role to `member`, no email will be sent.,* ,* **Rate limits**,* ,* To prevent abuse, the authenticated user is limited to 50 organization invitations per 24 hour period. If the organization is more than one month old or on a paid plan, the limit is 500 invitations per 24 hour period.
     */
    addOrUpdateMembership(
      params: Github.OrgsAddOrUpdateMembershipParams,
      callback?: Github.Callback<Github.AnyResponse>
    ): Promise<Github.AnyResponse>;

    blockUser(
      params: Github.OrgsBlockUserParams,
      callback?: Github.Callback<Github.Response<Github.OrgsBlockUserResponse>>
    ): Promise<Github.Response<Github.OrgsBlockUserResponse>>;
    /**
     * If the user is blocked:,* ,* If the user is not blocked:
     */
    checkBlockedUser(
      params: Github.OrgsCheckBlockedUserParams,
      callback?: Github.Callback<
        Github.Response<Github.OrgsCheckBlockedUserResponse>
      >
    ): Promise<Github.Response<Github.OrgsCheckBlockedUserResponse>>;
    /**
     * Check if a user is, publicly or privately, a member of the organization.
     */
    checkMembership(
      params: Github.OrgsCheckMembershipParams,
      callback?: Github.Callback<Github.AnyResponse>
    ): Promise<Github.AnyResponse>;

    checkPublicMembership(
      params: Github.OrgsCheckPublicMembershipParams,
      callback?: Github.Callback<Github.AnyResponse>
    ): Promise<Github.AnyResponse>;

    concealMembership(
      params: Github.OrgsConcealMembershipParams,
      callback?: Github.Callback<
        Github.Response<Github.OrgsConcealMembershipResponse>
      >
    ): Promise<Github.Response<Github.OrgsConcealMembershipResponse>>;
    /**
     * When an organization member is converted to an outside collaborator, they'll only have access to the repositories that their current team membership allows. The user will no longer be a member of the organization. For more information, see "[Converting an organization member to an outside collaborator](https://help.github.com/articles/converting-an-organization-member-to-an-outside-collaborator/)".
     */
    convertMemberToOutsideCollaborator(
      params: Github.OrgsConvertMemberToOutsideCollaboratorParams,
      callback?: Github.Callback<
        Github.Response<Github.OrgsConvertMemberToOutsideCollaboratorResponse>
      >
    ): Promise<
      Github.Response<Github.OrgsConvertMemberToOutsideCollaboratorResponse>
    >;
    /**
     * Here's how you can create a hook that posts payloads in JSON format:
     */
    createHook(
      params: Github.OrgsCreateHookParams,
      callback?: Github.Callback<Github.Response<Github.OrgsCreateHookResponse>>
    ): Promise<Github.Response<Github.OrgsCreateHookResponse>>;
    /**
     * Invite people to an organization by using their GitHub user ID or their email address. In order to create invitations in an organization, the authenticated user must be an organization owner.
     */
    createInvitation(
      params: Github.OrgsCreateInvitationParams,
      callback?: Github.Callback<
        Github.Response<Github.OrgsCreateInvitationResponse>
      >
    ): Promise<Github.Response<Github.OrgsCreateInvitationResponse>>;

    deleteHook(
      params: Github.OrgsDeleteHookParams,
      callback?: Github.Callback<Github.Response<Github.OrgsDeleteHookResponse>>
    ): Promise<Github.Response<Github.OrgsDeleteHookResponse>>;
    /**
     * To see many of the organization response values, you need to be an authenticated organization owner with the `admin:org` scope. When the value of `two_factor_requirement_enabled` is `true`, the organization requires all members, billing managers, and outside collaborators to enable [two-factor authentication](https://help.github.com/articles/securing-your-account-with-two-factor-authentication-2fa/).
     */
    get(
      params: Github.OrgsGetParams,
      callback?: Github.Callback<Github.Response<Github.OrgsGetResponse>>
    ): Promise<Github.Response<Github.OrgsGetResponse>>;

    getHook(
      params: Github.OrgsGetHookParams,
      callback?: Github.Callback<Github.Response<Github.OrgsGetHookResponse>>
    ): Promise<Github.Response<Github.OrgsGetHookResponse>>;
    /**
     * In order to get a user's membership with an organization, the authenticated user must be an organization member.
     */
    getMembership(
      params: Github.OrgsGetMembershipParams,
      callback?: Github.Callback<Github.AnyResponse>
    ): Promise<Github.AnyResponse>;

    getMembershipForAuthenticatedUser(
      params: Github.OrgsGetMembershipForAuthenticatedUserParams,
      callback?: Github.Callback<
        Github.Response<Github.OrgsGetMembershipForAuthenticatedUserResponse>
      >
    ): Promise<
      Github.Response<Github.OrgsGetMembershipForAuthenticatedUserResponse>
    >;
    /**
     * Lists all organizations, in the order that they were created on GitHub.,* ,* **Note:** Pagination is powered exclusively by the `since` parameter. Use the [Link header](https://developer.github.com/v3/#link-header) to get the URL for the next page of organizations.
     */
    list(
      params: Github.OrgsListParams,
      callback?: Github.Callback<Github.Response<Github.OrgsListResponse>>
    ): Promise<Github.Response<Github.OrgsListResponse>>;
    /**
     * List the users blocked by an organization.
     */
    listBlockedUsers(
      params: Github.OrgsListBlockedUsersParams,
      callback?: Github.Callback<
        Github.Response<Github.OrgsListBlockedUsersResponse>
      >
    ): Promise<Github.Response<Github.OrgsListBlockedUsersResponse>>;
    /**
     * List organizations for the authenticated user.,* ,* **OAuth scope requirements**,* ,* This only lists organizations that your authorization allows you to operate on in some way (e.g., you can list teams with `read:org` scope, you can publicize your organization membership with `user` scope, etc.). Therefore, this API requires at least `user` or `read:org` scope. OAuth requests with insufficient scope receive a `403 Forbidden` response.
     */
    listForAuthenticatedUser(
      params: Github.OrgsListForAuthenticatedUserParams,
      callback?: Github.Callback<
        Github.Response<Github.OrgsListForAuthenticatedUserResponse>
      >
    ): Promise<Github.Response<Github.OrgsListForAuthenticatedUserResponse>>;
    /**
     * List [public organization memberships](https://help.github.com/articles/publicizing-or-concealing-organization-membership) for the specified user.,* ,* This method only lists _public_ memberships, regardless of authentication. If you need to fetch all of the organization memberships (public and private) for the authenticated user, use the [List your organizations](#list-your-organizations) API instead.
     */
    listForUser(
      params: Github.OrgsListForUserParams,
      callback?: Github.Callback<
        Github.Response<Github.OrgsListForUserResponse>
      >
    ): Promise<Github.Response<Github.OrgsListForUserResponse>>;

    listHooks(
      params: Github.OrgsListHooksParams,
      callback?: Github.Callback<Github.Response<Github.OrgsListHooksResponse>>
    ): Promise<Github.Response<Github.OrgsListHooksResponse>>;
    /**
     * List all teams associated with an invitation. In order to see invitations in an organization, the authenticated user must be an organization owner.
     */
    listInvitationTeams(
      params: Github.OrgsListInvitationTeamsParams,
      callback?: Github.Callback<
        Github.Response<Github.OrgsListInvitationTeamsResponse>
      >
    ): Promise<Github.Response<Github.OrgsListInvitationTeamsResponse>>;
    /**
     * List all users who are members of an organization. If the authenticated user is also a member of this organization then both concealed and public members will be returned.,* ,*
     */
    listMembers(
      params: Github.OrgsListMembersParams,
      callback?: Github.Callback<
        Github.Response<Github.OrgsListMembersResponse>
      >
    ): Promise<Github.Response<Github.OrgsListMembersResponse>>;

    listMemberships(
      params: Github.OrgsListMembershipsParams,
      callback?: Github.Callback<
        Github.Response<Github.OrgsListMembershipsResponse>
      >
    ): Promise<Github.Response<Github.OrgsListMembershipsResponse>>;
    /**
     * List all users who are outside collaborators of an organization.,* ,*
     */
    listOutsideCollaborators(
      params: Github.OrgsListOutsideCollaboratorsParams,
      callback?: Github.Callback<
        Github.Response<Github.OrgsListOutsideCollaboratorsResponse>
      >
    ): Promise<Github.Response<Github.OrgsListOutsideCollaboratorsResponse>>;
    /**
     * The return hash contains a `role` field which refers to the Organization Invitation role and will be one of the following values: `direct_member`, `admin`, `billing_manager`, `hiring_manager`, or `reinstate`. If the invitee is not a GitHub member, the `login` field in the return hash will be `null`.
     */
    listPendingInvitations(
      params: Github.OrgsListPendingInvitationsParams,
      callback?: Github.Callback<
        Github.Response<Github.OrgsListPendingInvitationsResponse>
      >
    ): Promise<Github.Response<Github.OrgsListPendingInvitationsResponse>>;
    /**
     * Members of an organization can choose to have their membership publicized or not.
     */
    listPublicMembers(
      params: Github.OrgsListPublicMembersParams,
      callback?: Github.Callback<
        Github.Response<Github.OrgsListPublicMembersResponse>
      >
    ): Promise<Github.Response<Github.OrgsListPublicMembersResponse>>;
    /**
     * This will trigger a [ping event](https://developer.github.com/webhooks/#ping-event) to be sent to the hook.
     */
    pingHook(
      params: Github.OrgsPingHookParams,
      callback?: Github.Callback<Github.Response<Github.OrgsPingHookResponse>>
    ): Promise<Github.Response<Github.OrgsPingHookResponse>>;
    /**
     * The user can publicize their own membership. (A user cannot publicize the membership for another user.),* ,* Note that you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP verbs](https://developer.github.com/v3/#http-verbs)."
     */
    publicizeMembership(
      params: Github.OrgsPublicizeMembershipParams,
      callback?: Github.Callback<
        Github.Response<Github.OrgsPublicizeMembershipResponse>
      >
    ): Promise<Github.Response<Github.OrgsPublicizeMembershipResponse>>;
    /**
     * Removing a user from this list will remove them from all teams and they will no longer have any access to the organization's repositories.
     */
    removeMember(
      params: Github.OrgsRemoveMemberParams,
      callback?: Github.Callback<
        Github.Response<Github.OrgsRemoveMemberResponse>
      >
    ): Promise<Github.Response<Github.OrgsRemoveMemberResponse>>;
    /**
     * In order to remove a user's membership with an organization, the authenticated user must be an organization owner.,* ,* If the specified user is an active member of the organization, this will remove them from the organization. If the specified user has been invited to the organization, this will cancel their invitation. The specified user will receive an email notification in both cases.
     */
    removeMembership(
      params: Github.OrgsRemoveMembershipParams,
      callback?: Github.Callback<
        Github.Response<Github.OrgsRemoveMembershipResponse>
      >
    ): Promise<Github.Response<Github.OrgsRemoveMembershipResponse>>;
    /**
     * Removing a user from this list will remove them from all the organization's repositories.
     */
    removeOutsideCollaborator(
      params: Github.OrgsRemoveOutsideCollaboratorParams,
      callback?: Github.Callback<
        Github.Response<Github.OrgsRemoveOutsideCollaboratorResponse>
      >
    ): Promise<Github.Response<Github.OrgsRemoveOutsideCollaboratorResponse>>;

    unblockUser(
      params: Github.OrgsUnblockUserParams,
      callback?: Github.Callback<
        Github.Response<Github.OrgsUnblockUserResponse>
      >
    ): Promise<Github.Response<Github.OrgsUnblockUserResponse>>;

    update(
      params: Github.OrgsUpdateParams,
      callback?: Github.Callback<Github.Response<Github.OrgsUpdateResponse>>
    ): Promise<Github.Response<Github.OrgsUpdateResponse>>;

    updateHook(
      params: Github.OrgsUpdateHookParams,
      callback?: Github.Callback<Github.Response<Github.OrgsUpdateHookResponse>>
    ): Promise<Github.Response<Github.OrgsUpdateHookResponse>>;

    updateMembership(
      params: Github.OrgsUpdateMembershipParams,
      callback?: Github.Callback<
        Github.Response<Github.OrgsUpdateMembershipResponse>
      >
    ): Promise<Github.Response<Github.OrgsUpdateMembershipResponse>>;
  };
  projects: {
    /**
     * Adds a collaborator to a an organization project and sets their permission level. You must be an organization owner or a project `admin` to add a collaborator.
     */
    addCollaborator(
      params: Github.ProjectsAddCollaboratorParams,
      callback?: Github.Callback<
        Github.Response<Github.ProjectsAddCollaboratorResponse>
      >
    ): Promise<Github.Response<Github.ProjectsAddCollaboratorResponse>>;
    /**
     * **Note**: GitHub's REST API v3 considers every pull request an issue, but not every issue is a pull request. For this reason, "Issues" endpoints may return both issues and pull requests in the response. You can identify pull requests by the `pull_request` key.,* ,* Be aware that the `id` of a pull request returned from "Issues" endpoints will be an _issue id_. To find out the pull request id, use the "[List pull requests](https://developer.github.com/v3/pulls/#list-pull-requests)" endpoint.
     */
    createCard(
      params: Github.ProjectsCreateCardParams,
      callback?: Github.Callback<
        Github.Response<Github.ProjectsCreateCardResponse>
      >
    ): Promise<Github.Response<Github.ProjectsCreateCardResponse>>;

    createColumn(
      params: Github.ProjectsCreateColumnParams,
      callback?: Github.Callback<Github.AnyResponse>
    ): Promise<Github.AnyResponse>;
    /**
     * **Note**: The status code may also be `401` or `410`, depending on the scope of the authenticating token.
     */
    createForOrg(
      params: Github.ProjectsCreateForOrgParams,
      callback?: Github.Callback<
        Github.Response<Github.ProjectsCreateForOrgResponse>
      >
    ): Promise<Github.Response<Github.ProjectsCreateForOrgResponse>>;
    /**
     * **Note**: The status code may also be `401` or `410`, depending on the scope of the authenticating token.
     */
    createForRepo(
      params: Github.ProjectsCreateForRepoParams,
      callback?: Github.Callback<
        Github.Response<Github.ProjectsCreateForRepoResponse>
      >
    ): Promise<Github.Response<Github.ProjectsCreateForRepoResponse>>;

    delete(
      params: Github.ProjectsDeleteParams,
      callback?: Github.Callback<Github.AnyResponse>
    ): Promise<Github.AnyResponse>;

    deleteCard(
      params: Github.ProjectsDeleteCardParams,
      callback?: Github.Callback<
        Github.Response<Github.ProjectsDeleteCardResponse>
      >
    ): Promise<Github.Response<Github.ProjectsDeleteCardResponse>>;

    deleteColumn(
      params: Github.ProjectsDeleteColumnParams,
      callback?: Github.Callback<
        Github.Response<Github.ProjectsDeleteColumnResponse>
      >
    ): Promise<Github.Response<Github.ProjectsDeleteColumnResponse>>;
    /**
     * **Note**: The status code may also be `401` or `410`, depending on the scope of the authenticating token.
     */
    get(
      params: Github.ProjectsGetParams,
      callback?: Github.Callback<Github.Response<Github.ProjectsGetResponse>>
    ): Promise<Github.Response<Github.ProjectsGetResponse>>;

    getCard(
      params: Github.ProjectsGetCardParams,
      callback?: Github.Callback<Github.AnyResponse>
    ): Promise<Github.AnyResponse>;

    getColumn(
      params: Github.ProjectsGetColumnParams,
      callback?: Github.Callback<Github.AnyResponse>
    ): Promise<Github.AnyResponse>;

    listCards(
      params: Github.ProjectsListCardsParams,
      callback?: Github.Callback<
        Github.Response<Github.ProjectsListCardsResponse>
      >
    ): Promise<Github.Response<Github.ProjectsListCardsResponse>>;
    /**
     * Lists the collaborators for an organization project. For a project, the list of collaborators includes outside collaborators, organization members that are direct collaborators, organization members with access through team memberships, organization members with access through default organization permissions, and organization owners. You must be an organization owner or a project `admin` to list collaborators.
     */
    listCollaborators(
      params: Github.ProjectsListCollaboratorsParams,
      callback?: Github.Callback<
        Github.Response<Github.ProjectsListCollaboratorsResponse>
      >
    ): Promise<Github.Response<Github.ProjectsListCollaboratorsResponse>>;

    listColumns(
      params: Github.ProjectsListColumnsParams,
      callback?: Github.Callback<
        Github.Response<Github.ProjectsListColumnsResponse>
      >
    ): Promise<Github.Response<Github.ProjectsListColumnsResponse>>;
    /**
     * **Note**: The status code may also be `401` or `410`, depending on the scope of the authenticating token.
     */
    listForOrg(
      params: Github.ProjectsListForOrgParams,
      callback?: Github.Callback<
        Github.Response<Github.ProjectsListForOrgResponse>
      >
    ): Promise<Github.Response<Github.ProjectsListForOrgResponse>>;
    /**
     * **Note**: The status code may also be `401` or `410`, depending on the scope of the authenticating token.
     */
    listForRepo(
      params: Github.ProjectsListForRepoParams,
      callback?: Github.Callback<
        Github.Response<Github.ProjectsListForRepoResponse>
      >
    ): Promise<Github.Response<Github.ProjectsListForRepoResponse>>;

    moveCard(
      params: Github.ProjectsMoveCardParams,
      callback?: Github.Callback<
        Github.Response<Github.ProjectsMoveCardResponse>
      >
    ): Promise<Github.Response<Github.ProjectsMoveCardResponse>>;

    moveColumn(
      params: Github.ProjectsMoveColumnParams,
      callback?: Github.Callback<
        Github.Response<Github.ProjectsMoveColumnResponse>
      >
    ): Promise<Github.Response<Github.ProjectsMoveColumnResponse>>;
    /**
     * Removes a collaborator from an organization project. You must be an organization owner or a project `admin` to remove a collaborator.
     */
    removeCollaborator(
      params: Github.ProjectsRemoveCollaboratorParams,
      callback?: Github.Callback<
        Github.Response<Github.ProjectsRemoveCollaboratorResponse>
      >
    ): Promise<Github.Response<Github.ProjectsRemoveCollaboratorResponse>>;
    /**
     * Returns the collaborator's permission level for an organization project. Possible values for the `permission` key: `admin`, `write`, `read`, `none`. You must be an organization owner or a project `admin` to review a user's permission level.
     */
    reviewUserPermissionLevel(
      params: Github.ProjectsReviewUserPermissionLevelParams,
      callback?: Github.Callback<
        Github.Response<Github.ProjectsReviewUserPermissionLevelResponse>
      >
    ): Promise<
      Github.Response<Github.ProjectsReviewUserPermissionLevelResponse>
    >;
    /**
     * **Note**: The status code may also be `401` or `410`, depending on the scope of the authenticating token.
     */
    update(
      params: Github.ProjectsUpdateParams,
      callback?: Github.Callback<Github.Response<Github.ProjectsUpdateResponse>>
    ): Promise<Github.Response<Github.ProjectsUpdateResponse>>;

    updateCard(
      params: Github.ProjectsUpdateCardParams,
      callback?: Github.Callback<Github.AnyResponse>
    ): Promise<Github.AnyResponse>;

    updateColumn(
      params: Github.ProjectsUpdateColumnParams,
      callback?: Github.Callback<Github.AnyResponse>
    ): Promise<Github.AnyResponse>;
  };
  pullRequests: {
    checkIfMerged(
      params: Github.PullRequestsCheckIfMergedParams,
      callback?: Github.Callback<Github.AnyResponse>
    ): Promise<Github.AnyResponse>;
    /**
     * **Note:** To open a pull request in a public repository, you must have write access to the head or the source branch. For organization-owned repositories, you must be a member of the organization that owns the repository to open a pull request.
     */
    create(
      params: Github.PullRequestsCreateParams,
      callback?: Github.Callback<
        Github.Response<Github.PullRequestsCreateResponse>
      >
    ): Promise<Github.Response<Github.PullRequestsCreateResponse>>;
    /**
     * **Note:** To comment on a specific line in a file, you need to first determine the _position_ of that line in the diff. The GitHub REST API v3 offers the `application/vnd.github.v3.diff` [media type](https://developer.github.com/v3/media/#commits-commit-comparison-and-pull-requests). To see a pull request diff, add this media type to the `Accept` header of a call to the [single pull request](https://developer.github.com/v3/pulls/#get-a-single-pull-request) endpoint.,* ,* The `position` value equals the number of lines down from the first "@@" hunk header in the file you want to add a comment. The line just below the "@@" line is position 1, the next line is position 2, and so on. The position in the diff continues to increase through lines of whitespace and additional hunks until the beginning of a new file.
     */
    createComment(
      params: Github.PullRequestsCreateCommentParams,
      callback?: Github.Callback<
        Github.Response<Github.PullRequestsCreateCommentResponse>
      >
    ): Promise<Github.Response<Github.PullRequestsCreateCommentResponse>>;
    /**
     * **Note:** To comment on a specific line in a file, you need to first determine the _position_ of that line in the diff. The GitHub REST API v3 offers the `application/vnd.github.v3.diff` [media type](https://developer.github.com/v3/media/#commits-commit-comparison-and-pull-requests). To see a pull request diff, add this media type to the `Accept` header of a call to the [single pull request](https://developer.github.com/v3/pulls/#get-a-single-pull-request) endpoint.,* ,* The `position` value equals the number of lines down from the first "@@" hunk header in the file you want to add a comment. The line just below the "@@" line is position 1, the next line is position 2, and so on. The position in the diff continues to increase through lines of whitespace and additional hunks until the beginning of a new file.
     */
    createCommentReply(
      params: Github.PullRequestsCreateCommentReplyParams,
      callback?: Github.Callback<
        Github.Response<Github.PullRequestsCreateCommentReplyResponse>
      >
    ): Promise<Github.Response<Github.PullRequestsCreateCommentReplyResponse>>;
    /**
     * **Note:** To open a pull request in a public repository, you must have write access to the head or the source branch. For organization-owned repositories, you must be a member of the organization that owns the repository to open a pull request.
     */
    createFromIssue(
      params: Github.PullRequestsCreateFromIssueParams,
      callback?: Github.Callback<
        Github.Response<Github.PullRequestsCreateFromIssueResponse>
      >
    ): Promise<Github.Response<Github.PullRequestsCreateFromIssueResponse>>;
    /**
     * **Note:** To comment on a specific line in a file, you need to first determine the _position_ of that line in the diff. The GitHub REST API v3 offers the `application/vnd.github.v3.diff` [media type](https://developer.github.com/v3/media/#commits-commit-comparison-and-pull-requests). To see a pull request diff, add this media type to the `Accept` header of a call to the [single pull request](https://developer.github.com/v3/pulls/#get-a-single-pull-request) endpoint.,* ,* The `position` value equals the number of lines down from the first "@@" hunk header in the file you want to add a comment. The line just below the "@@" line is position 1, the next line is position 2, and so on. The position in the diff continues to increase through lines of whitespace and additional hunks until the beginning of a new file.
     */
    createReview(
      params: Github.PullRequestsCreateReviewParams,
      callback?: Github.Callback<
        Github.Response<Github.PullRequestsCreateReviewResponse>
      >
    ): Promise<Github.Response<Github.PullRequestsCreateReviewResponse>>;

    createReviewRequest(
      params: Github.PullRequestsCreateReviewRequestParams,
      callback?: Github.Callback<
        Github.Response<Github.PullRequestsCreateReviewRequestResponse>
      >
    ): Promise<Github.Response<Github.PullRequestsCreateReviewRequestResponse>>;

    deleteComment(
      params: Github.PullRequestsDeleteCommentParams,
      callback?: Github.Callback<
        Github.Response<Github.PullRequestsDeleteCommentResponse>
      >
    ): Promise<Github.Response<Github.PullRequestsDeleteCommentResponse>>;

    deletePendingReview(
      params: Github.PullRequestsDeletePendingReviewParams,
      callback?: Github.Callback<
        Github.Response<Github.PullRequestsDeletePendingReviewResponse>
      >
    ): Promise<Github.Response<Github.PullRequestsDeletePendingReviewResponse>>;

    deleteReviewRequest(
      params: Github.PullRequestsDeleteReviewRequestParams,
      callback?: Github.Callback<
        Github.Response<Github.PullRequestsDeleteReviewRequestResponse>
      >
    ): Promise<Github.Response<Github.PullRequestsDeleteReviewRequestResponse>>;
    /**
     * **Note:** To dismiss a pull request review on a [protected branch](https://developer.github.com/v3/repos/branches/), you must be a repository administrator or be included in the list of people or teams who can dismiss pull request reviews.
     */
    dismissReview(
      params: Github.PullRequestsDismissReviewParams,
      callback?: Github.Callback<
        Github.Response<Github.PullRequestsDismissReviewResponse>
      >
    ): Promise<Github.Response<Github.PullRequestsDismissReviewResponse>>;
    /**
     * Lists details of a pull request by providing its number.,* ,* When you get, [create](https://developer.github.com/v3/pulls/#create-a-pull-request), or [edit](https://developer.github.com/v3/pulls/#update-a-pull-request) a pull request, GitHub creates a merge commit to test whether the pull request can be automatically merged into the base branch. This test commit is not added to the base branch or the head branch. You can review the status of the test commit using the `mergeable` key. For more information, see "[Checking mergeability of pull requests](https://developer.github.com/v3/git/#checking-mergeability-of-pull-requests)".,* ,* The value of the `mergeable` attribute can be `true`, `false`, or `null`. If the value is `null`, then GitHub has started a background job to compute the mergeability. After giving the job time to complete, resubmit the request. When the job finishes, you will see a non-`null` value for the `mergeable` attribute in the response. If `mergeable` is `true`, then `merge_commit_sha` will be the SHA of the _test_ merge commit.,* ,* The value of the `merge_commit_sha` attribute changes depending on the state of the pull request. Before merging a pull request, the `merge_commit_sha` attribute holds the SHA of the _test_ merge commit. After merging a pull request, the `merge_commit_sha` attribute changes depending on how you merged the pull request:,* ,* *   If merged as a [merge commit](https://help.github.com/articles/about-merge-methods-on-github/), `merge_commit_sha` represents the SHA of the merge commit.,* *   If merged via a [squash](https://help.github.com/articles/about-merge-methods-on-github/#squashing-your-merge-commits), `merge_commit_sha` represents the SHA of the squashed commit on the base branch.,* *   If [rebased](https://help.github.com/articles/about-merge-methods-on-github/#rebasing-and-merging-your-commits), `merge_commit_sha` represents the commit that the base branch was updated to.,* ,* Pass the appropriate [media type](https://developer.github.com/v3/media/#commits-commit-comparison-and-pull-requests) to fetch diff and patch formats.
     */
    get(
      params: Github.PullRequestsGetParams,
      callback?: Github.Callback<
        Github.Response<Github.PullRequestsGetResponse>
      >
    ): Promise<Github.Response<Github.PullRequestsGetResponse>>;

    getComment(
      params: Github.PullRequestsGetCommentParams,
      callback?: Github.Callback<
        Github.Response<Github.PullRequestsGetCommentResponse>
      >
    ): Promise<Github.Response<Github.PullRequestsGetCommentResponse>>;

    getCommentsForReview(
      params: Github.PullRequestsGetCommentsForReviewParams,
      callback?: Github.Callback<
        Github.Response<Github.PullRequestsGetCommentsForReviewResponse>
      >
    ): Promise<
      Github.Response<Github.PullRequestsGetCommentsForReviewResponse>
    >;

    getReview(
      params: Github.PullRequestsGetReviewParams,
      callback?: Github.Callback<
        Github.Response<Github.PullRequestsGetReviewResponse>
      >
    ): Promise<Github.Response<Github.PullRequestsGetReviewResponse>>;

    list(
      params: Github.PullRequestsListParams,
      callback?: Github.Callback<
        Github.Response<Github.PullRequestsListResponse>
      >
    ): Promise<Github.Response<Github.PullRequestsListResponse>>;
    /**
     * By default, review comments are ordered by ascending ID.,* ,*
     */
    listComments(
      params: Github.PullRequestsListCommentsParams,
      callback?: Github.Callback<
        Github.Response<Github.PullRequestsListCommentsResponse>
      >
    ): Promise<Github.Response<Github.PullRequestsListCommentsResponse>>;
    /**
     * By default, review comments are ordered by ascending ID.,* ,*
     */
    listCommentsForRepo(
      params: Github.PullRequestsListCommentsForRepoParams,
      callback?: Github.Callback<
        Github.Response<Github.PullRequestsListCommentsForRepoResponse>
      >
    ): Promise<Github.Response<Github.PullRequestsListCommentsForRepoResponse>>;
    /**
     * **Note:** The response includes a maximum of 250 commits. To receive a complete commit list for pull requests with more than 250 commits, use the [Commit List API](https://developer.github.com/v3/repos/commits/#list-commits-on-a-repository).
     */
    listCommits(
      params: Github.PullRequestsListCommitsParams,
      callback?: Github.Callback<
        Github.Response<Github.PullRequestsListCommitsResponse>
      >
    ): Promise<Github.Response<Github.PullRequestsListCommitsResponse>>;
    /**
     * **Note:** The response includes a maximum of 300 files.
     */
    listFiles(
      params: Github.PullRequestsListFilesParams,
      callback?: Github.Callback<
        Github.Response<Github.PullRequestsListFilesResponse>
      >
    ): Promise<Github.Response<Github.PullRequestsListFilesResponse>>;

    listReviewRequests(
      params: Github.PullRequestsListReviewRequestsParams,
      callback?: Github.Callback<
        Github.Response<Github.PullRequestsListReviewRequestsResponse>
      >
    ): Promise<Github.Response<Github.PullRequestsListReviewRequestsResponse>>;
    /**
     * The list of reviews returns in chronological order.
     */
    listReviews(
      params: Github.PullRequestsListReviewsParams,
      callback?: Github.Callback<
        Github.Response<Github.PullRequestsListReviewsResponse>
      >
    ): Promise<Github.Response<Github.PullRequestsListReviewsResponse>>;

    merge(
      params: Github.PullRequestsMergeParams,
      callback?: Github.Callback<Github.AnyResponse>
    ): Promise<Github.AnyResponse>;

    submitReview(
      params: Github.PullRequestsSubmitReviewParams,
      callback?: Github.Callback<
        Github.Response<Github.PullRequestsSubmitReviewResponse>
      >
    ): Promise<Github.Response<Github.PullRequestsSubmitReviewResponse>>;
    /**
     * **Note:** To open a pull request in a public repository, you must have write access to the head or the source branch. For organization-owned repositories, you must be a member of the organization that owns the repository to open a pull request.
     */
    update(
      params: Github.PullRequestsUpdateParams,
      callback?: Github.Callback<
        Github.Response<Github.PullRequestsUpdateResponse>
      >
    ): Promise<Github.Response<Github.PullRequestsUpdateResponse>>;

    updateComment(
      params: Github.PullRequestsUpdateCommentParams,
      callback?: Github.Callback<
        Github.Response<Github.PullRequestsUpdateCommentResponse>
      >
    ): Promise<Github.Response<Github.PullRequestsUpdateCommentResponse>>;
  };
  rateLimit: {
    /**
     * **Note:** Accessing this endpoint does not count against your REST API rate limit.,* ,* **Understanding your rate limit status**,* ,* The Search API has a [custom rate limit](https://developer.github.com/v3/search/#rate-limit), separate from the rate limit governing the rest of the REST API. The GraphQL API also has a [custom rate limit](/v4/guides/resource-limitations/#rate-limit) that is separate from and calculated differently than rate limits in the REST API.,* ,* For these reasons, the Rate Limit API response categorizes your rate limit. Under `resources`, you'll see three objects:,* ,* *   The `core` object provides your rate limit status for all non-search-related resources in the REST API.,* *   The `search` object provides your rate limit status for the [Search API](https://developer.github.com/v3/search/).,* *   The `graphql` object provides your rate limit status for the [GraphQL API](/v4/).,* ,* For more information on the headers and values in the rate limit response, see "[Rate limiting](https://developer.github.com/v3/#rate-limiting).",* ,* The `rate` object (shown at the bottom of the response above) is deprecated.,* ,* If you're writing new API client code or updating existing code, you should use the `core` object instead of the `rate` object. The `core` object contains the same information that is present in the `rate` object.
     */
    get(
      params: Github.EmptyParams,
      callback?: Github.Callback<Github.Response<Github.RateLimitGetResponse>>
    ): Promise<Github.Response<Github.RateLimitGetResponse>>;
  };
  reactions: {
    /**
     * Create a reaction to a [commit comment](https://developer.github.com/v3/repos/comments/). A response with a `Status: 200 OK` means that you already added the reaction type to this commit comment.
     */
    createForCommitComment(
      params: Github.ReactionsCreateForCommitCommentParams,
      callback?: Github.Callback<
        Github.Response<Github.ReactionsCreateForCommitCommentResponse>
      >
    ): Promise<Github.Response<Github.ReactionsCreateForCommitCommentResponse>>;
    /**
     * Create a reaction to an [issue](https://developer.github.com/v3/issues/). A response with a `Status: 200 OK` means that you already added the reaction type to this issue.
     */
    createForIssue(
      params: Github.ReactionsCreateForIssueParams,
      callback?: Github.Callback<
        Github.Response<Github.ReactionsCreateForIssueResponse>
      >
    ): Promise<Github.Response<Github.ReactionsCreateForIssueResponse>>;
    /**
     * Create a reaction to an [issue comment](https://developer.github.com/v3/issues/comments/). A response with a `Status: 200 OK` means that you already added the reaction type to this issue comment.
     */
    createForIssueComment(
      params: Github.ReactionsCreateForIssueCommentParams,
      callback?: Github.Callback<
        Github.Response<Github.ReactionsCreateForIssueCommentResponse>
      >
    ): Promise<Github.Response<Github.ReactionsCreateForIssueCommentResponse>>;
    /**
     * Create a reaction to a [pull request review comment](https://developer.github.com/v3/pulls/comments/). A response with a `Status: 200 OK` means that you already added the reaction type to this pull request review comment.
     */
    createForPullRequestReviewComment(
      params: Github.ReactionsCreateForPullRequestReviewCommentParams,
      callback?: Github.Callback<
        Github.Response<
          Github.ReactionsCreateForPullRequestReviewCommentResponse
        >
      >
    ): Promise<
      Github.Response<Github.ReactionsCreateForPullRequestReviewCommentResponse>
    >;
    /**
     * Create a reaction to a [team discussion](https://developer.github.com/v3/teams/discussions/). OAuth access tokens require the `write:discussion` [scope](https://developer.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/). A response with a `Status: 200 OK` means that you already added the reaction type to this team discussion.
     */
    createForTeamDiscussion(
      params: Github.ReactionsCreateForTeamDiscussionParams,
      callback?: Github.Callback<
        Github.Response<Github.ReactionsCreateForTeamDiscussionResponse>
      >
    ): Promise<
      Github.Response<Github.ReactionsCreateForTeamDiscussionResponse>
    >;
    /**
     * Create a reaction to a [team discussion comment](https://developer.github.com/v3/teams/discussion_comments/). OAuth access tokens require the `write:discussion` [scope](https://developer.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/). A response with a `Status: 200 OK` means that you already added the reaction type to this team discussion comment.
     */
    createForTeamDiscussionComment(
      params: Github.ReactionsCreateForTeamDiscussionCommentParams,
      callback?: Github.Callback<
        Github.Response<Github.ReactionsCreateForTeamDiscussionCommentResponse>
      >
    ): Promise<
      Github.Response<Github.ReactionsCreateForTeamDiscussionCommentResponse>
    >;
    /**
     * OAuth access tokens require the `write:discussion` [scope](https://developer.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/), when deleting a [team discussion](https://developer.github.com/v3/teams/discussions/) or [team discussion comment](https://developer.github.com/v3/teams/discussion_comments/).
     */
    delete(
      params: Github.ReactionsDeleteParams,
      callback?: Github.Callback<
        Github.Response<Github.ReactionsDeleteResponse>
      >
    ): Promise<Github.Response<Github.ReactionsDeleteResponse>>;
    /**
     * List the reactions to a [commit comment](https://developer.github.com/v3/repos/comments/).
     */
    listForCommitComment(
      params: Github.ReactionsListForCommitCommentParams,
      callback?: Github.Callback<
        Github.Response<Github.ReactionsListForCommitCommentResponse>
      >
    ): Promise<Github.Response<Github.ReactionsListForCommitCommentResponse>>;
    /**
     * List the reactions to an [issue](https://developer.github.com/v3/issues/).
     */
    listForIssue(
      params: Github.ReactionsListForIssueParams,
      callback?: Github.Callback<
        Github.Response<Github.ReactionsListForIssueResponse>
      >
    ): Promise<Github.Response<Github.ReactionsListForIssueResponse>>;
    /**
     * List the reactions to an [issue comment](https://developer.github.com/v3/issues/comments/).
     */
    listForIssueComment(
      params: Github.ReactionsListForIssueCommentParams,
      callback?: Github.Callback<
        Github.Response<Github.ReactionsListForIssueCommentResponse>
      >
    ): Promise<Github.Response<Github.ReactionsListForIssueCommentResponse>>;
    /**
     * List the reactions to a [pull request review comment](https://developer.github.com/v3/pulls/comments/).
     */
    listForPullRequestReviewComment(
      params: Github.ReactionsListForPullRequestReviewCommentParams,
      callback?: Github.Callback<
        Github.Response<Github.ReactionsListForPullRequestReviewCommentResponse>
      >
    ): Promise<
      Github.Response<Github.ReactionsListForPullRequestReviewCommentResponse>
    >;
    /**
     * List the reactions to a [team discussion](https://developer.github.com/v3/teams/discussions/). OAuth access tokens require the `read:discussion` [scope](https://developer.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
     */
    listForTeamDiscussion(
      params: Github.ReactionsListForTeamDiscussionParams,
      callback?: Github.Callback<
        Github.Response<Github.ReactionsListForTeamDiscussionResponse>
      >
    ): Promise<Github.Response<Github.ReactionsListForTeamDiscussionResponse>>;
    /**
     * List the reactions to a [team discussion comment](https://developer.github.com/v3/teams/discussion_comments/). OAuth access tokens require the `read:discussion` [scope](https://developer.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
     */
    listForTeamDiscussionComment(
      params: Github.ReactionsListForTeamDiscussionCommentParams,
      callback?: Github.Callback<
        Github.Response<Github.ReactionsListForTeamDiscussionCommentResponse>
      >
    ): Promise<
      Github.Response<Github.ReactionsListForTeamDiscussionCommentResponse>
    >;
  };
  repos: {
    acceptInvitation(
      params: Github.ReposAcceptInvitationParams,
      callback?: Github.Callback<
        Github.Response<Github.ReposAcceptInvitationResponse>
      >
    ): Promise<Github.Response<Github.ReposAcceptInvitationResponse>>;
    /**
     * Note that, if you choose not to pass any parameters, you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP verbs](https://developer.github.com/v3/#http-verbs).",* ,* The invitee will receive a notification that they have been invited to the repository, which they must accept or decline. They may do this via the notifications page, the email they receive, or by using the [repository invitations API endpoints](https://developer.github.com/v3/repos/invitations/).,* ,* **Rate limits**,* ,* To prevent abuse, you are limited to sending 50 invitations to a repository per 24 hour period. Note there is no limit if you are inviting organization members to an organization repository.
     */
    addCollaborator(
      params: Github.ReposAddCollaboratorParams,
      callback?: Github.Callback<Github.AnyResponse>
    ): Promise<Github.AnyResponse>;
    /**
     * Here's how you can create a read-only deploy key:,* ,*
     */
    addDeployKey(
      params: Github.ReposAddDeployKeyParams,
      callback?: Github.Callback<
        Github.Response<Github.ReposAddDeployKeyResponse>
      >
    ): Promise<Github.Response<Github.ReposAddDeployKeyResponse>>;
    /**
     * Adding admin enforcement requires admin or owner permissions to the repository and branch protection to be enabled.
     */
    addProtectedBranchAdminEnforcement(
      params: Github.ReposAddProtectedBranchAdminEnforcementParams,
      callback?: Github.Callback<
        Github.Response<Github.ReposAddProtectedBranchAdminEnforcementResponse>
      >
    ): Promise<
      Github.Response<Github.ReposAddProtectedBranchAdminEnforcementResponse>
    >;
    /**
     * When authenticated with admin or owner permissions to the repository, you can use this endpoint to require signed commits on a branch. You must enable branch protection to require signed commits.
     */
    addProtectedBranchRequiredSignatures(
      params: Github.ReposAddProtectedBranchRequiredSignaturesParams,
      callback?: Github.Callback<
        Github.Response<
          Github.ReposAddProtectedBranchRequiredSignaturesResponse
        >
      >
    ): Promise<
      Github.Response<Github.ReposAddProtectedBranchRequiredSignaturesResponse>
    >;

    addProtectedBranchRequiredStatusChecksContexts(
      params: Github.ReposAddProtectedBranchRequiredStatusChecksContextsParams,
      callback?: Github.Callback<
        Github.Response<
          Github.ReposAddProtectedBranchRequiredStatusChecksContextsResponse
        >
      >
    ): Promise<
      Github.Response<
        Github.ReposAddProtectedBranchRequiredStatusChecksContextsResponse
      >
    >;
    /**
     * Grants the specified teams push access for this branch. If you pass the `hellcat-preview` media type, you can also give push access to child teams.,* ,* | Type    | Description                                                                                                                         |,* | ------- | ----------------------------------------------------------------------------------------------------------------------------------- |,* | `array` | The teams that can have push access. Use the team's `slug`. **Note**: The list of users and teams in total is limited to 100 items. |
     */
    addProtectedBranchTeamRestrictions(
      params: Github.ReposAddProtectedBranchTeamRestrictionsParams,
      callback?: Github.Callback<
        Github.Response<Github.ReposAddProtectedBranchTeamRestrictionsResponse>
      >
    ): Promise<
      Github.Response<Github.ReposAddProtectedBranchTeamRestrictionsResponse>
    >;
    /**
     * Grants the specified people push access for this branch.,* ,* | Type    | Description                                                                                                            |,* | ------- | ---------------------------------------------------------------------------------------------------------------------- |,* | `array` | Usernames for people who can have push access. **Note**: The list of users and teams in total is limited to 100 items. |
     */
    addProtectedBranchUserRestrictions(
      params: Github.ReposAddProtectedBranchUserRestrictionsParams,
      callback?: Github.Callback<
        Github.Response<Github.ReposAddProtectedBranchUserRestrictionsResponse>
      >
    ): Promise<
      Github.Response<Github.ReposAddProtectedBranchUserRestrictionsResponse>
    >;
    /**
     * For organization-owned repositories, the list of collaborators includes outside collaborators, organization members that are direct collaborators, organization members with access through team memberships, organization members with access through default organization permissions, and organization owners.,* ,* If you pass the `hellcat-preview` media type, team members will include the members of child teams.
     */
    checkCollaborator(
      params: Github.ReposCheckCollaboratorParams,
      callback?: Github.Callback<Github.AnyResponse>
    ): Promise<Github.AnyResponse>;
    /**
     * Both `:base` and `:head` must be branch names in `:repo`. To compare branches across other repositories in the same network as `:repo`, use the format `<USERNAME>:branch`. For example:,* ,* ```,* GET /repos/:owner/:repo/compare/hubot:branchname...octocat:branchname,* ```,* ,* The response from the API is equivalent to running the `git log base..head` command; however, commits are returned in reverse chronological order.,* ,* Pass the appropriate [media type](https://developer.github.com/v3/media/#commits-commit-comparison-and-pull-requests) to fetch diff and patch formats.,* ,* **Working with large comparisons**,* ,* The response will include a comparison of up to 250 commits. If you are working with a larger commit range, you can use the [Commit List API](https://developer.github.com/v3/repos/commits/#list-commits-on-a-repository) to enumerate all commits in the range.,* ,* For comparisons with extremely large diffs, you may receive an error response indicating that the diff took too long to generate. You can typically resolve this error by using a smaller commit range.
     */
    compareCommits(
      params: Github.ReposCompareCommitsParams,
      callback?: Github.Callback<
        Github.Response<Github.ReposCompareCommitsResponse>
      >
    ): Promise<Github.Response<Github.ReposCompareCommitsResponse>>;

    createCommitComment(
      params: Github.ReposCreateCommitCommentParams,
      callback?: Github.Callback<
        Github.Response<Github.ReposCreateCommitCommentResponse>
      >
    ): Promise<Github.Response<Github.ReposCreateCommitCommentResponse>>;
    /**
     * Deployments offer a few configurable parameters with sane defaults.,* ,* The `ref` parameter can be any named branch, tag, or SHA. At GitHub we often deploy branches and verify them before we merge a pull request.,* ,* The `environment` parameter allows deployments to be issued to different runtime environments. Teams often have multiple environments for verifying their applications, such as `production`, `staging`, and `qa`. This parameter makes it easier to track which environments have requested deployments. The default environment is `production`.,* ,* The `auto_merge` parameter is used to ensure that the requested ref is not behind the repository's default branch. If the ref _is_ behind the default branch for the repository, we will attempt to merge it for you. If the merge succeeds, the API will return a successful merge commit. If merge conflicts prevent the merge from succeeding, the API will return a failure response.,* ,* By default, [commit statuses](https://developer.github.com/v3/repos/statuses) for every submitted context must be in a `success` state. The `required_contexts` parameter allows you to specify a subset of contexts that must be `success`, or to specify contexts that have not yet been submitted. You are not required to use commit statuses to deploy. If you do not require any contexts or create any commit statuses, the deployment will always succeed.,* ,* The `payload` parameter is available for any extra information that a deployment system might need. It is a JSON text field that will be passed on when a deployment event is dispatched.,* ,* The `task` parameter is used by the deployment system to allow different execution paths. In the web world this might be `deploy:migrations` to run schema changes on the system. In the compiled world this could be a flag to compile an application with debugging enabled.,* ,* Users with `repo` or `repo_deployment` scopes can create a deployment for a given ref:,* ,* A simple example putting the user and room into the payload to notify back to chat networks.,* ,* A more advanced example specifying required commit statuses and bypassing auto-merging.,* ,* This error happens when the `auto_merge` option is enabled and when the default branch (in this case `master`), can't be merged into the branch that's being deployed (in this case `topic-branch`), due to merge conflicts.,* ,* This error happens when the `required_contexts` parameter indicates that one or more contexts need to have a `success` status for the commit to be deployed, but one or more of the required contexts do not have a state of `success`.
     */
    createDeployment(
      params: Github.ReposCreateDeploymentParams,
      callback?: Github.Callback<Github.AnyResponse>
    ): Promise<Github.AnyResponse>;
    /**
     * Users with `push` access can create deployment statuses for a given deployment.,* ,* GitHub Apps require `read & write` access to "Deployments" and `read-only` access to "Repo contents" (for private repos). OAuth Apps require the `repo_deployment` scope.
     */
    createDeploymentStatus(
      params: Github.ReposCreateDeploymentStatusParams,
      callback?: Github.Callback<
        Github.Response<Github.ReposCreateDeploymentStatusResponse>
      >
    ): Promise<Github.Response<Github.ReposCreateDeploymentStatusResponse>>;
    /**
     * Creates a new file in a repository.
     */
    createFile(
      params: Github.ReposCreateFileParams,
      callback?: Github.Callback<
        Github.Response<Github.ReposCreateFileResponse>
      >
    ): Promise<Github.Response<Github.ReposCreateFileResponse>>;
    /**
     * **Note**: There are two endpoints for creating a repository: one to create a repository on a user account, and one to create a repository in an organization. The organization endpoint is fully enabled for [GitHub Apps](https://developer.github.com/v3/apps/available-endpoints/), whereas the user endpoint is enabled only for [user-to-server requests](https://developer.github.com/apps/building-github-apps/identifying-and-authorizing-users-for-github-apps/#user-to-server-requests).,* ,* **OAuth scope requirements**,* ,* When using [OAuth](https://developer.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/), authorizations must include:,* ,* *   `public_repo` scope or `repo` scope to create a public repository,* *   `repo` scope to create a private repository
     */
    createForAuthenticatedUser(
      params: Github.ReposCreateForAuthenticatedUserParams,
      callback?: Github.Callback<
        Github.Response<Github.ReposCreateForAuthenticatedUserResponse>
      >
    ): Promise<Github.Response<Github.ReposCreateForAuthenticatedUserResponse>>;
    /**
     * Create a fork for the authenticated user.,* ,* **Note**: Forking a Repository happens asynchronously. You may have to wait a short period of time before you can access the git objects. If this takes longer than 5 minutes, be sure to contact [GitHub Support](https://github.com/contact).
     */
    createFork(
      params: Github.ReposCreateForkParams,
      callback?: Github.Callback<
        Github.Response<Github.ReposCreateForkResponse>
      >
    ): Promise<Github.Response<Github.ReposCreateForkResponse>>;
    /**
     * Repositories can have multiple webhooks installed. Each webhook should have a unique `config`. Multiple webhooks can share the same `config` as long as those webhooks do not have any `events` that overlap.,* ,* **Note**: We no longer support GitHub Services as of October 1, 2018, and GitHub Services will stop working on January 31, 2019. Please see the [blog post](/changes/2018-10-01-denying-new-github-services) for details. You can use the [Replacing GitHub Services guide](https://developer.github.com/v3/guides/replacing-github-services) to help you update your services to webhooks.,* ,* Here's how you can create a hook that posts payloads in JSON format:
     */
    createHook(
      params: Github.ReposCreateHookParams,
      callback?: Github.Callback<
        Github.Response<Github.ReposCreateHookResponse>
      >
    ): Promise<Github.Response<Github.ReposCreateHookResponse>>;
    /**
     * **Note**: There are two endpoints for creating a repository: one to create a repository on a user account, and one to create a repository in an organization. The organization endpoint is fully enabled for [GitHub Apps](https://developer.github.com/v3/apps/available-endpoints/), whereas the user endpoint is enabled only for [user-to-server requests](https://developer.github.com/apps/building-github-apps/identifying-and-authorizing-users-for-github-apps/#user-to-server-requests).,* ,* **OAuth scope requirements**,* ,* When using [OAuth](https://developer.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/), authorizations must include:,* ,* *   `public_repo` scope or `repo` scope to create a public repository,* *   `repo` scope to create a private repository
     */
    createInOrg(
      params: Github.ReposCreateInOrgParams,
      callback?: Github.Callback<
        Github.Response<Github.ReposCreateInOrgResponse>
      >
    ): Promise<Github.Response<Github.ReposCreateInOrgResponse>>;
    /**
     * Users with push access to the repository can create a release.
     */
    createRelease(
      params: Github.ReposCreateReleaseParams,
      callback?: Github.Callback<
        Github.Response<Github.ReposCreateReleaseResponse>
      >
    ): Promise<Github.Response<Github.ReposCreateReleaseResponse>>;
    /**
     * Users with push access in a repository can create commit statuses for a given SHA.,* ,* Note: there is a limit of 1000 statuses per `sha` and `context` within a repository. Attempts to create more than 1000 statuses will result in a validation error.
     */
    createStatus(
      params: Github.ReposCreateStatusParams,
      callback?: Github.Callback<
        Github.Response<Github.ReposCreateStatusResponse>
      >
    ): Promise<Github.Response<Github.ReposCreateStatusResponse>>;

    declineInvitation(
      params: Github.ReposDeclineInvitationParams,
      callback?: Github.Callback<
        Github.Response<Github.ReposDeclineInvitationResponse>
      >
    ): Promise<Github.Response<Github.ReposDeclineInvitationResponse>>;
    /**
     * Deleting a repository requires admin access. If OAuth is used, the `delete_repo` scope is required.,* ,* If an organization owner has configured the organization to prevent members from deleting organization-owned repositories, a member will get this response:
     */
    delete(
      params: Github.ReposDeleteParams,
      callback?: Github.Callback<Github.Response<Github.ReposDeleteResponse>>
    ): Promise<Github.Response<Github.ReposDeleteResponse>>;

    deleteCommitComment(
      params: Github.ReposDeleteCommitCommentParams,
      callback?: Github.Callback<
        Github.Response<Github.ReposDeleteCommitCommentResponse>
      >
    ): Promise<Github.Response<Github.ReposDeleteCommitCommentResponse>>;

    deleteDownload(
      params: Github.ReposDeleteDownloadParams,
      callback?: Github.Callback<
        Github.Response<Github.ReposDeleteDownloadResponse>
      >
    ): Promise<Github.Response<Github.ReposDeleteDownloadResponse>>;
    /**
     * Deletes a file in a repository.,* ,* The `author` section is optional and is filled in with the `committer` information if omitted. If the `committer` information is omitted, the authenticated user's information is used.,* ,* You must provide values for both `name` and `email`, whether you choose to use `author` or `committer`. Otherwise, you'll receive a `422` status code.,* ,* Both the `author` and `committer` parameters have the same keys:,* ,* | name  | type   | description                                          |,* | ----- | ------ | ---------------------------------------------------- |,* | name  | string | The name of the author (or committer) of the commit  |,* | email | string | The email of the author (or committer) of the commit |
     */
    deleteFile(
      params: Github.ReposDeleteFileParams,
      callback?: Github.Callback<
        Github.Response<Github.ReposDeleteFileResponse>
      >
    ): Promise<Github.Response<Github.ReposDeleteFileResponse>>;

    deleteHook(
      params: Github.ReposDeleteHookParams,
      callback?: Github.Callback<
        Github.Response<Github.ReposDeleteHookResponse>
      >
    ): Promise<Github.Response<Github.ReposDeleteHookResponse>>;

    deleteInvitation(
      params: Github.ReposDeleteInvitationParams,
      callback?: Github.Callback<
        Github.Response<Github.ReposDeleteInvitationResponse>
      >
    ): Promise<Github.Response<Github.ReposDeleteInvitationResponse>>;
    /**
     * Users with push access to the repository can delete a release.
     */
    deleteRelease(
      params: Github.ReposDeleteReleaseParams,
      callback?: Github.Callback<
        Github.Response<Github.ReposDeleteReleaseResponse>
      >
    ): Promise<Github.Response<Github.ReposDeleteReleaseResponse>>;

    deleteReleaseAsset(
      params: Github.ReposDeleteReleaseAssetParams,
      callback?: Github.Callback<
        Github.Response<Github.ReposDeleteReleaseAssetResponse>
      >
    ): Promise<Github.Response<Github.ReposDeleteReleaseAssetResponse>>;
    /**
     * The `parent` and `source` objects are present when the repository is a fork. `parent` is the repository this repository was forked from, `source` is the ultimate source for the network.
     */
    get(
      params: Github.ReposGetParams,
      callback?: Github.Callback<Github.Response<Github.ReposGetResponse>>
    ): Promise<Github.Response<Github.ReposGetResponse>>;
    /**
     * Gets a redirect URL to download an archive for a repository. The `:archive_format` can be either `tarball` or `zipball`. The `:ref` must be a valid Git reference. If you omit `:ref`, the repository’s default branch (usually `master`) will be used. Please make sure your HTTP framework is configured to follow redirects or you will need to use the `Location` header to make a second `GET` request.,* ,* _Note_: For private repositories, these links are temporary and expire after five minutes.,* ,* To follow redirects with curl, use the `-L` switch:,* ,*
     */
    getArchiveLink(
      params: Github.ReposGetArchiveLinkParams,
      callback?: Github.Callback<
        Github.Response<Github.ReposGetArchiveLinkResponse>
      >
    ): Promise<Github.Response<Github.ReposGetArchiveLinkResponse>>;

    getBranch(
      params: Github.ReposGetBranchParams,
      callback?: Github.Callback<Github.Response<Github.ReposGetBranchResponse>>
    ): Promise<Github.Response<Github.ReposGetBranchResponse>>;

    getBranchProtection(
      params: Github.ReposGetBranchProtectionParams,
      callback?: Github.Callback<
        Github.Response<Github.ReposGetBranchProtectionResponse>
      >
    ): Promise<Github.Response<Github.ReposGetBranchProtectionResponse>>;
    /**
     * Get the total number of clones and breakdown per day or week for the last 14 days. Timestamps are aligned to UTC midnight of the beginning of the day or week. Week begins on Monday.
     */
    getClones(
      params: Github.ReposGetClonesParams,
      callback?: Github.Callback<Github.Response<Github.ReposGetClonesResponse>>
    ): Promise<Github.Response<Github.ReposGetClonesResponse>>;
    /**
     * Returns a weekly aggregate of the number of additions and deletions pushed to a repository.,* ,*
     */
    getCodeFrequencyStats(
      params: Github.ReposGetCodeFrequencyStatsParams,
      callback?: Github.Callback<
        Github.Response<Github.ReposGetCodeFrequencyStatsResponse>
      >
    ): Promise<Github.Response<Github.ReposGetCodeFrequencyStatsResponse>>;
    /**
     * Possible values for the `permission` key: `admin`, `write`, `read`, `none`.
     */
    getCollaboratorPermissionLevel(
      params: Github.ReposGetCollaboratorPermissionLevelParams,
      callback?: Github.Callback<Github.AnyResponse>
    ): Promise<Github.AnyResponse>;
    /**
     * Users with pull access in a repository can access a combined view of commit statuses for a given ref. The ref can be a SHA, a branch name, or a tag name.,* ,* The most recent status for each context is returned, up to 100. This field [paginates](https://developer.github.com/v3/#pagination) if there are over 100 contexts.,* ,* Additionally, a combined `state` is returned. The `state` is one of:,* ,* *   **failure** if any of the contexts report as `error` or `failure`,* *   **pending** if there are no statuses or a context is `pending`,* *   **success** if the latest status for all contexts is `success`
     */
    getCombinedStatusForRef(
      params: Github.ReposGetCombinedStatusForRefParams,
      callback?: Github.Callback<
        Github.Response<Github.ReposGetCombinedStatusForRefResponse>
      >
    ): Promise<Github.Response<Github.ReposGetCombinedStatusForRefResponse>>;
    /**
     * Diffs with binary data will have no 'patch' property. Pass the appropriate [media type](https://developer.github.com/v3/media/#commits-commit-comparison-and-pull-requests) to fetch diff and patch formats.
     */
    getCommit(
      params: Github.ReposGetCommitParams,
      callback?: Github.Callback<Github.Response<Github.ReposGetCommitResponse>>
    ): Promise<Github.Response<Github.ReposGetCommitResponse>>;
    /**
     * Returns the last year of commit activity grouped by week. The `days` array is a group of commits per day, starting on `Sunday`.,* ,*
     */
    getCommitActivityStats(
      params: Github.ReposGetCommitActivityStatsParams,
      callback?: Github.Callback<
        Github.Response<Github.ReposGetCommitActivityStatsResponse>
      >
    ): Promise<Github.Response<Github.ReposGetCommitActivityStatsResponse>>;

    getCommitComment(
      params: Github.ReposGetCommitCommentParams,
      callback?: Github.Callback<
        Github.Response<Github.ReposGetCommitCommentResponse>
      >
    ): Promise<Github.Response<Github.ReposGetCommitCommentResponse>>;
    /**
     * Users with read access can get the SHA-1 of a commit reference:,* ,* To access the API you must provide a custom [media type](https://developer.github.com/v3/media) in the `Accept` header:,* ,* ,* ,* To check if a remote reference's SHA-1 is the same as your local reference's SHA-1, make a `GET` request and provide the current SHA-1 for the local reference as the ETag.,* ,* The SHA-1 of the commit reference.,* ,*
     */
    getCommitRefSha(
      params: Github.ReposGetCommitRefShaParams,
      callback?: Github.Callback<
        Github.Response<Github.ReposGetCommitRefShaResponse>
      >
    ): Promise<Github.Response<Github.ReposGetCommitRefShaResponse>>;
    /**
     * Gets the contents of a file or directory in a repository. Specify the file path or directory in `:path`. If you omit `:path`, you will receive the contents of all files in the repository.,* ,* Files and symlinks support [a custom media type](#custom-media-types) for retrieving the raw content or rendered HTML (when supported). All content types support [a custom media type](#custom-media-types) to ensure the content is returned in a consistent object format.,* ,* **Note**:,* ,* *   To get a repository's contents recursively, you can [recursively get the tree](https://developer.github.com/v3/git/trees/).,* *   This API has an upper limit of 1,000 files for a directory. If you need to retrieve more files, use the [Git Trees API](https://developer.github.com/v3/git/trees/#get-a-tree).,* *   This API supports files up to 1 megabyte in size.,* ,* The response will be an array of objects, one object for each item in the directory.,* ,* When listing the contents of a directory, submodules have their "type" specified as "file". Logically, the value _should_ be "submodule". This behavior exists in API v3 [for backwards compatibility purposes](https://git.io/v1YCW). In the next major version of the API, the type will be returned as "submodule".,* ,* If the requested `:path` points to a symlink, and the symlink's target is a normal file in the repository, then the API responds with the content of the file (in the [format shown above](#response-if-content-is-a-file)).,* ,* Otherwise, the API responds with an object describing the symlink itself:,* ,* The `submodule_git_url` identifies the location of the submodule repository, and the `sha` identifies a specific commit within the submodule repository. Git uses the given URL when cloning the submodule repository, and checks out the submodule at that specific commit.,* ,* If the submodule repository is not hosted on github.com, the Git URLs (`git_url` and `_links["git"]`) and the github.com URLs (`html_url` and `_links["html"]`) will have null values.
     */
    getContents(
      params: Github.ReposGetContentsParams,
      callback?: Github.Callback<Github.AnyResponse>
    ): Promise<Github.AnyResponse>;
    /**
     * *   `total` - The Total number of commits authored by the contributor.,* ,* Weekly Hash (`weeks` array):,* ,* *   `w` - Start of the week, given as a [Unix timestamp](http://en.wikipedia.org/wiki/Unix_time).,* *   `a` - Number of additions,* *   `d` - Number of deletions,* *   `c` - Number of commits,* ,*
     */
    getContributorsStats(
      params: Github.ReposGetContributorsStatsParams,
      callback?: Github.Callback<
        Github.Response<Github.ReposGetContributorsStatsResponse>
      >
    ): Promise<Github.Response<Github.ReposGetContributorsStatsResponse>>;

    getDeployKey(
      params: Github.ReposGetDeployKeyParams,
      callback?: Github.Callback<
        Github.Response<Github.ReposGetDeployKeyResponse>
      >
    ): Promise<Github.Response<Github.ReposGetDeployKeyResponse>>;

    getDeployment(
      params: Github.ReposGetDeploymentParams,
      callback?: Github.Callback<
        Github.Response<Github.ReposGetDeploymentResponse>
      >
    ): Promise<Github.Response<Github.ReposGetDeploymentResponse>>;
    /**
     * Users with pull access can view a deployment status for a deployment:
     */
    getDeploymentStatus(
      params: Github.ReposGetDeploymentStatusParams,
      callback?: Github.Callback<
        Github.Response<Github.ReposGetDeploymentStatusResponse>
      >
    ): Promise<Github.Response<Github.ReposGetDeploymentStatusResponse>>;

    getDownload(
      params: Github.ReposGetDownloadParams,
      callback?: Github.Callback<
        Github.Response<Github.ReposGetDownloadResponse>
      >
    ): Promise<Github.Response<Github.ReposGetDownloadResponse>>;

    getHook(
      params: Github.ReposGetHookParams,
      callback?: Github.Callback<Github.Response<Github.ReposGetHookResponse>>
    ): Promise<Github.Response<Github.ReposGetHookResponse>>;

    getLatestPagesBuild(
      params: Github.ReposGetLatestPagesBuildParams,
      callback?: Github.Callback<Github.AnyResponse>
    ): Promise<Github.AnyResponse>;
    /**
     * View the latest published full release for the repository. Draft releases and prereleases are not returned by this endpoint.
     */
    getLatestRelease(
      params: Github.ReposGetLatestReleaseParams,
      callback?: Github.Callback<
        Github.Response<Github.ReposGetLatestReleaseResponse>
      >
    ): Promise<Github.Response<Github.ReposGetLatestReleaseResponse>>;
    /**
     * Responses during the preview period contain two additional fields:,* ,* *   `html_url`: The absolute URL (with scheme) to the rendered site. For example, `https://username.github.io`.,* *   `source`: Information about the source branch and directory for the rendered site. The source field includes:,*     *   `branch`: The repo branch for [site source files](https://help.github.com/articles/configuring-a-publishing-source-for-github-pages/) For example, _master_ or _gh-pages_.,*     *   `path`: The repo directory from which the site publishes. Can be either `/` or `/docs`.
     */
    getPages(
      params: Github.ReposGetPagesParams,
      callback?: Github.Callback<Github.Response<Github.ReposGetPagesResponse>>
    ): Promise<Github.Response<Github.ReposGetPagesResponse>>;

    getPagesBuild(
      params: Github.ReposGetPagesBuildParams,
      callback?: Github.Callback<Github.AnyResponse>
    ): Promise<Github.AnyResponse>;
    /**
     * Returns the total commit counts for the `owner` and total commit counts in `all`. `all` is everyone combined, including the `owner` in the last 52 weeks. If you'd like to get the commit counts for non-owners, you can subtract `owner` from `all`.,* ,* The array order is oldest week (index 0) to most recent week.,* ,*
     */
    getParticipationStats(
      params: Github.ReposGetParticipationStatsParams,
      callback?: Github.Callback<
        Github.Response<Github.ReposGetParticipationStatsResponse>
      >
    ): Promise<Github.Response<Github.ReposGetParticipationStatsResponse>>;

    getProtectedBranchAdminEnforcement(
      params: Github.ReposGetProtectedBranchAdminEnforcementParams,
      callback?: Github.Callback<Github.AnyResponse>
    ): Promise<Github.AnyResponse>;

    getProtectedBranchPullRequestReviewEnforcement(
      params: Github.ReposGetProtectedBranchPullRequestReviewEnforcementParams,
      callback?: Github.Callback<Github.AnyResponse>
    ): Promise<Github.AnyResponse>;
    /**
     * When authenticated with admin or owner permissions to the repository, you can use this endpoint to check whether a branch requires signed commits. An enabled status of `true` indicates you must sign commits on this branch. For more information, see [Signing commits with GPG](https://help.github.com/articles/signing-commits-with-gpg) in GitHub Help.,* ,* **Note**: You must enable branch protection to require signed commits.
     */
    getProtectedBranchRequiredSignatures(
      params: Github.ReposGetProtectedBranchRequiredSignaturesParams,
      callback?: Github.Callback<
        Github.Response<
          Github.ReposGetProtectedBranchRequiredSignaturesResponse
        >
      >
    ): Promise<
      Github.Response<Github.ReposGetProtectedBranchRequiredSignaturesResponse>
    >;

    getProtectedBranchRequiredStatusChecks(
      params: Github.ReposGetProtectedBranchRequiredStatusChecksParams,
      callback?: Github.Callback<
        Github.Response<
          Github.ReposGetProtectedBranchRequiredStatusChecksResponse
        >
      >
    ): Promise<
      Github.Response<
        Github.ReposGetProtectedBranchRequiredStatusChecksResponse
      >
    >;
    /**
     * **Note**: Teams and users `restrictions` are only available for organization-owned repositories.
     */
    getProtectedBranchRestrictions(
      params: Github.ReposGetProtectedBranchRestrictionsParams,
      callback?: Github.Callback<Github.AnyResponse>
    ): Promise<Github.AnyResponse>;
    /**
     * Each array contains the day number, hour number, and number of commits:,* ,* *   `0-6`: Sunday - Saturday,* *   `0-23`: Hour of day,* *   Number of commits,* ,* For example, `[2, 14, 25]` indicates that there were 25 total commits, during the 2:00pm hour on Tuesdays. All times are based on the time zone of individual commits.
     */
    getPunchCardStats(
      params: Github.ReposGetPunchCardStatsParams,
      callback?: Github.Callback<
        Github.Response<Github.ReposGetPunchCardStatsResponse>
      >
    ): Promise<Github.Response<Github.ReposGetPunchCardStatsResponse>>;
    /**
     * Gets the preferred README for a repository.,* ,* READMEs support [custom media types](#custom-media-types) for retrieving the raw content or rendered HTML.
     */
    getReadme(
      params: Github.ReposGetReadmeParams,
      callback?: Github.Callback<Github.Response<Github.ReposGetReadmeResponse>>
    ): Promise<Github.Response<Github.ReposGetReadmeResponse>>;
    /**
     * **Note:** This returns an `upload_url` key corresponding to the endpoint for uploading release assets. This key is a [hypermedia resource](https://developer.github.com/v3/#hypermedia).
     */
    getRelease(
      params: Github.ReposGetReleaseParams,
      callback?: Github.Callback<
        Github.Response<Github.ReposGetReleaseResponse>
      >
    ): Promise<Github.Response<Github.ReposGetReleaseResponse>>;
    /**
     * To download the asset's binary content, set the `Accept` header of the request to [`application/octet-stream`](https://developer.github.com/v3/media/#media-types). The API will either redirect the client to the location, or stream it directly if possible. API clients should handle both a `200` or `302` response.
     */
    getReleaseAsset(
      params: Github.ReposGetReleaseAssetParams,
      callback?: Github.Callback<
        Github.Response<Github.ReposGetReleaseAssetResponse>
      >
    ): Promise<Github.Response<Github.ReposGetReleaseAssetResponse>>;
    /**
     * Get a published release with the specified tag.
     */
    getReleaseByTag(
      params: Github.ReposGetReleaseByTagParams,
      callback?: Github.Callback<
        Github.Response<Github.ReposGetReleaseByTagResponse>
      >
    ): Promise<Github.Response<Github.ReposGetReleaseByTagResponse>>;
    /**
     * Get the top 10 popular contents over the last 14 days.
     */
    getTopPaths(
      params: Github.ReposGetTopPathsParams,
      callback?: Github.Callback<
        Github.Response<Github.ReposGetTopPathsResponse>
      >
    ): Promise<Github.Response<Github.ReposGetTopPathsResponse>>;
    /**
     * Get the top 10 referrers over the last 14 days.
     */
    getTopReferrers(
      params: Github.ReposGetTopReferrersParams,
      callback?: Github.Callback<
        Github.Response<Github.ReposGetTopReferrersResponse>
      >
    ): Promise<Github.Response<Github.ReposGetTopReferrersResponse>>;
    /**
     * Get the total number of views and breakdown per day or week for the last 14 days. Timestamps are aligned to UTC midnight of the beginning of the day or week. Week begins on Monday.
     */
    getViews(
      params: Github.ReposGetViewsParams,
      callback?: Github.Callback<Github.Response<Github.ReposGetViewsResponse>>
    ): Promise<Github.Response<Github.ReposGetViewsResponse>>;
    /**
     * List repositories that the authenticated user has explicit permission (`:read`, `:write`, or `:admin`) to access.,* ,* The authenticated user has explicit permission to access repositories they own, repositories where they are a collaborator, and repositories that they can access through an organization membership.
     */
    list(
      params: Github.ReposListParams,
      callback?: Github.Callback<Github.AnyResponse>
    ): Promise<Github.AnyResponse>;

    listAssetsForRelease(
      params: Github.ReposListAssetsForReleaseParams,
      callback?: Github.Callback<
        Github.Response<Github.ReposListAssetsForReleaseResponse>
      >
    ): Promise<Github.Response<Github.ReposListAssetsForReleaseResponse>>;

    listBranches(
      params: Github.ReposListBranchesParams,
      callback?: Github.Callback<
        Github.Response<Github.ReposListBranchesResponse>
      >
    ): Promise<Github.Response<Github.ReposListBranchesResponse>>;
    /**
     * For organization-owned repositories, the list of collaborators includes outside collaborators, organization members that are direct collaborators, organization members with access through team memberships, organization members with access through default organization permissions, and organization owners.,* ,* If you pass the `hellcat-preview` media type, team members will include the members of child teams.
     */
    listCollaborators(
      params: Github.ReposListCollaboratorsParams,
      callback?: Github.Callback<
        Github.Response<Github.ReposListCollaboratorsResponse>
      >
    ): Promise<Github.Response<Github.ReposListCollaboratorsResponse>>;

    listCommentsForCommit(
      params: Github.ReposListCommentsForCommitParams,
      callback?: Github.Callback<
        Github.Response<Github.ReposListCommentsForCommitResponse>
      >
    ): Promise<Github.Response<Github.ReposListCommentsForCommitResponse>>;
    /**
     * Commit Comments use [these custom media types](#custom-media-types). You can read more about the use of media types in the API [here](https://developer.github.com/v3/media/).,* ,* Comments are ordered by ascending ID.,* ,*
     */
    listCommitComments(
      params: Github.ReposListCommitCommentsParams,
      callback?: Github.Callback<
        Github.Response<Github.ReposListCommitCommentsResponse>
      >
    ): Promise<Github.Response<Github.ReposListCommitCommentsResponse>>;

    listCommits(
      params: Github.ReposListCommitsParams,
      callback?: Github.Callback<
        Github.Response<Github.ReposListCommitsResponse>
      >
    ): Promise<Github.Response<Github.ReposListCommitsResponse>>;
    /**
     * Lists contributors to the specified repository and sorts them by the number of commits per contributor in descending order. This endpoint may return information that is a few hours old because the GitHub REST API v3 caches contributor data to improve performance.,* ,* GitHub identifies contributors by author email address. This endpoint groups contribution counts by GitHub user, which includes all associated email addresses. To improve performance, only the first 500 author email addresses in the repository link to GitHub users. The rest will appear as anonymous contributors without associated GitHub user information.
     */
    listContributors(
      params: Github.ReposListContributorsParams,
      callback?: Github.Callback<Github.AnyResponse>
    ): Promise<Github.AnyResponse>;

    listDeployKeys(
      params: Github.ReposListDeployKeysParams,
      callback?: Github.Callback<
        Github.Response<Github.ReposListDeployKeysResponse>
      >
    ): Promise<Github.Response<Github.ReposListDeployKeysResponse>>;
    /**
     * Users with pull access can view deployment statuses for a deployment:
     */
    listDeploymentStatuses(
      params: Github.ReposListDeploymentStatusesParams,
      callback?: Github.Callback<
        Github.Response<Github.ReposListDeploymentStatusesResponse>
      >
    ): Promise<Github.Response<Github.ReposListDeploymentStatusesResponse>>;
    /**
     * Simple filtering of deployments is available via query parameters:
     */
    listDeployments(
      params: Github.ReposListDeploymentsParams,
      callback?: Github.Callback<
        Github.Response<Github.ReposListDeploymentsResponse>
      >
    ): Promise<Github.Response<Github.ReposListDeploymentsResponse>>;

    listDownloads(
      params: Github.ReposListDownloadsParams,
      callback?: Github.Callback<
        Github.Response<Github.ReposListDownloadsResponse>
      >
    ): Promise<Github.Response<Github.ReposListDownloadsResponse>>;
    /**
     * List repositories for the specified org.
     */
    listForOrg(
      params: Github.ReposListForOrgParams,
      callback?: Github.Callback<
        Github.Response<Github.ReposListForOrgResponse>
      >
    ): Promise<Github.Response<Github.ReposListForOrgResponse>>;
    /**
     * List public repositories for the specified user.
     */
    listForUser(
      params: Github.ReposListForUserParams,
      callback?: Github.Callback<Github.AnyResponse>
    ): Promise<Github.AnyResponse>;

    listForks(
      params: Github.ReposListForksParams,
      callback?: Github.Callback<Github.Response<Github.ReposListForksResponse>>
    ): Promise<Github.Response<Github.ReposListForksResponse>>;

    listHooks(
      params: Github.ReposListHooksParams,
      callback?: Github.Callback<Github.Response<Github.ReposListHooksResponse>>
    ): Promise<Github.Response<Github.ReposListHooksResponse>>;
    /**
     * When authenticating as a user with admin rights to a repository, this endpoint will list all currently open repository invitations.,* ,*
     */
    listInvitations(
      params: Github.ReposListInvitationsParams,
      callback?: Github.Callback<
        Github.Response<Github.ReposListInvitationsResponse>
      >
    ): Promise<Github.Response<Github.ReposListInvitationsResponse>>;
    /**
     * When authenticating as a user, this endpoint will list all currently open repository invitations for that user.,* ,*
     */
    listInvitationsForAuthenticatedUser(
      params: Github.ReposListInvitationsForAuthenticatedUserParams,
      callback?: Github.Callback<
        Github.Response<Github.ReposListInvitationsForAuthenticatedUserResponse>
      >
    ): Promise<
      Github.Response<Github.ReposListInvitationsForAuthenticatedUserResponse>
    >;
    /**
     * Lists languages for the specified repository. The value shown for each language is the number of bytes of code written in that language.
     */
    listLanguages(
      params: Github.ReposListLanguagesParams,
      callback?: Github.Callback<
        Github.Response<Github.ReposListLanguagesResponse>
      >
    ): Promise<Github.Response<Github.ReposListLanguagesResponse>>;

    listPagesBuilds(
      params: Github.ReposListPagesBuildsParams,
      callback?: Github.Callback<Github.AnyResponse>
    ): Promise<Github.AnyResponse>;

    listProtectedBranchRequiredStatusChecksContexts(
      params: Github.ReposListProtectedBranchRequiredStatusChecksContextsParams,
      callback?: Github.Callback<Github.AnyResponse>
    ): Promise<Github.AnyResponse>;
    /**
     * Lists the teams who have push access to this branch. If you pass the `hellcat-preview` media type, the list includes child teams.
     */
    listProtectedBranchTeamRestrictions(
      params: Github.ReposListProtectedBranchTeamRestrictionsParams,
      callback?: Github.Callback<
        Github.Response<Github.ReposListProtectedBranchTeamRestrictionsResponse>
      >
    ): Promise<
      Github.Response<Github.ReposListProtectedBranchTeamRestrictionsResponse>
    >;
    /**
     * Lists the people who have push access to this branch.
     */
    listProtectedBranchUserRestrictions(
      params: Github.ReposListProtectedBranchUserRestrictionsParams,
      callback?: Github.Callback<Github.AnyResponse>
    ): Promise<Github.AnyResponse>;
    /**
     * This provides a dump of every public repository, in the order that they were created.,* ,* Note: Pagination is powered exclusively by the `since` parameter. Use the [Link header](https://developer.github.com/v3/#link-header) to get the URL for the next page of repositories.
     */
    listPublic(
      params: Github.ReposListPublicParams,
      callback?: Github.Callback<
        Github.Response<Github.ReposListPublicResponse>
      >
    ): Promise<Github.Response<Github.ReposListPublicResponse>>;
    /**
     * This returns a list of releases, which does not include regular Git tags that have not been associated with a release. To get a list of Git tags, use the [Repository Tags API](https://developer.github.com/v3/repos/#list-tags).,* ,* Information about published releases are available to everyone. Only users with push access will receive listings for draft releases.
     */
    listReleases(
      params: Github.ReposListReleasesParams,
      callback?: Github.Callback<
        Github.Response<Github.ReposListReleasesResponse>
      >
    ): Promise<Github.Response<Github.ReposListReleasesResponse>>;
    /**
     * Users with pull access in a repository can view commit statuses for a given ref. The ref can be a SHA, a branch name, or a tag name. Statuses are returned in reverse chronological order. The first status in the list will be the latest one.,* ,* This resource is also available via a legacy route: `GET /repos/:owner/:repo/statuses/:ref`.
     */
    listStatusesForRef(
      params: Github.ReposListStatusesForRefParams,
      callback?: Github.Callback<
        Github.Response<Github.ReposListStatusesForRefResponse>
      >
    ): Promise<Github.Response<Github.ReposListStatusesForRefResponse>>;

    listTags(
      params: Github.ReposListTagsParams,
      callback?: Github.Callback<Github.Response<Github.ReposListTagsResponse>>
    ): Promise<Github.Response<Github.ReposListTagsResponse>>;

    listTeams(
      params: Github.ReposListTeamsParams,
      callback?: Github.Callback<Github.Response<Github.ReposListTeamsResponse>>
    ): Promise<Github.Response<Github.ReposListTeamsResponse>>;

    listTopics(
      params: Github.ReposListTopicsParams,
      callback?: Github.Callback<
        Github.Response<Github.ReposListTopicsResponse>
      >
    ): Promise<Github.Response<Github.ReposListTopicsResponse>>;

    merge(
      params: Github.ReposMergeParams,
      callback?: Github.Callback<Github.AnyResponse>
    ): Promise<Github.AnyResponse>;
    /**
     * This will trigger a [ping event](https://developer.github.com/webhooks/#ping-event) to be sent to the hook.
     */
    pingHook(
      params: Github.ReposPingHookParams,
      callback?: Github.Callback<Github.Response<Github.ReposPingHookResponse>>
    ): Promise<Github.Response<Github.ReposPingHookResponse>>;

    removeBranchProtection(
      params: Github.ReposRemoveBranchProtectionParams,
      callback?: Github.Callback<
        Github.Response<Github.ReposRemoveBranchProtectionResponse>
      >
    ): Promise<Github.Response<Github.ReposRemoveBranchProtectionResponse>>;

    removeCollaborator(
      params: Github.ReposRemoveCollaboratorParams,
      callback?: Github.Callback<
        Github.Response<Github.ReposRemoveCollaboratorResponse>
      >
    ): Promise<Github.Response<Github.ReposRemoveCollaboratorResponse>>;

    removeDeployKey(
      params: Github.ReposRemoveDeployKeyParams,
      callback?: Github.Callback<
        Github.Response<Github.ReposRemoveDeployKeyResponse>
      >
    ): Promise<Github.Response<Github.ReposRemoveDeployKeyResponse>>;
    /**
     * Removing admin enforcement requires admin or owner permissions to the repository and branch protection to be enabled.
     */
    removeProtectedBranchAdminEnforcement(
      params: Github.ReposRemoveProtectedBranchAdminEnforcementParams,
      callback?: Github.Callback<Github.AnyResponse>
    ): Promise<Github.AnyResponse>;

    removeProtectedBranchPullRequestReviewEnforcement(
      params: Github.ReposRemoveProtectedBranchPullRequestReviewEnforcementParams,
      callback?: Github.Callback<Github.AnyResponse>
    ): Promise<Github.AnyResponse>;
    /**
     * When authenticated with admin or owner permissions to the repository, you can use this endpoint to disable required signed commits on a branch. You must enable branch protection to require signed commits.
     */
    removeProtectedBranchRequiredSignatures(
      params: Github.ReposRemoveProtectedBranchRequiredSignaturesParams,
      callback?: Github.Callback<Github.AnyResponse>
    ): Promise<Github.AnyResponse>;

    removeProtectedBranchRequiredStatusChecks(
      params: Github.ReposRemoveProtectedBranchRequiredStatusChecksParams,
      callback?: Github.Callback<Github.AnyResponse>
    ): Promise<Github.AnyResponse>;

    removeProtectedBranchRequiredStatusChecksContexts(
      params: Github.ReposRemoveProtectedBranchRequiredStatusChecksContextsParams,
      callback?: Github.Callback<
        Github.Response<
          Github.ReposRemoveProtectedBranchRequiredStatusChecksContextsResponse
        >
      >
    ): Promise<
      Github.Response<
        Github.ReposRemoveProtectedBranchRequiredStatusChecksContextsResponse
      >
    >;
    /**
     * Disables the ability to restrict who can push to this branch.
     */
    removeProtectedBranchRestrictions(
      params: Github.ReposRemoveProtectedBranchRestrictionsParams,
      callback?: Github.Callback<Github.AnyResponse>
    ): Promise<Github.AnyResponse>;
    /**
     * Removes the ability of a team to push to this branch. If you pass the `hellcat-preview` media type, you can include child teams.,* ,* | Type    | Description                                                                                                                                  |,* | ------- | -------------------------------------------------------------------------------------------------------------------------------------------- |,* | `array` | Teams that should no longer have push access. Use the team's `slug`. **Note**: The list of users and teams in total is limited to 100 items. |
     */
    removeProtectedBranchTeamRestrictions(
      params: Github.ReposRemoveProtectedBranchTeamRestrictionsParams,
      callback?: Github.Callback<
        Github.Response<
          Github.ReposRemoveProtectedBranchTeamRestrictionsResponse
        >
      >
    ): Promise<
      Github.Response<Github.ReposRemoveProtectedBranchTeamRestrictionsResponse>
    >;
    /**
     * Removes the ability of a team to push to this branch.,* ,* | Type    | Description                                                                                                                            |,* | ------- | -------------------------------------------------------------------------------------------------------------------------------------- |,* | `array` | Usernames of the people who should no longer have push access. **Note**: The list of users and teams in total is limited to 100 items. |
     */
    removeProtectedBranchUserRestrictions(
      params: Github.ReposRemoveProtectedBranchUserRestrictionsParams,
      callback?: Github.Callback<
        Github.Response<
          Github.ReposRemoveProtectedBranchUserRestrictionsResponse
        >
      >
    ): Promise<
      Github.Response<Github.ReposRemoveProtectedBranchUserRestrictionsResponse>
    >;

    replaceProtectedBranchRequiredStatusChecksContexts(
      params: Github.ReposReplaceProtectedBranchRequiredStatusChecksContextsParams,
      callback?: Github.Callback<
        Github.Response<
          Github.ReposReplaceProtectedBranchRequiredStatusChecksContextsResponse
        >
      >
    ): Promise<
      Github.Response<
        Github.ReposReplaceProtectedBranchRequiredStatusChecksContextsResponse
      >
    >;
    /**
     * Replaces the list of teams that have push access to this branch. This removes all teams that previously had push access and grants push access to the new list of teams. If you pass the `hellcat-preview` media type, you can include child teams.,* ,* | Type    | Description                                                                                                                         |,* | ------- | ----------------------------------------------------------------------------------------------------------------------------------- |,* | `array` | The teams that can have push access. Use the team's `slug`. **Note**: The list of users and teams in total is limited to 100 items. |
     */
    replaceProtectedBranchTeamRestrictions(
      params: Github.ReposReplaceProtectedBranchTeamRestrictionsParams,
      callback?: Github.Callback<
        Github.Response<
          Github.ReposReplaceProtectedBranchTeamRestrictionsResponse
        >
      >
    ): Promise<
      Github.Response<
        Github.ReposReplaceProtectedBranchTeamRestrictionsResponse
      >
    >;
    /**
     * Replaces the list of people that have push access to this branch. This removes all people that previously had push access and grants push access to the new list of people.,* ,* | Type    | Description                                                                                                            |,* | ------- | ---------------------------------------------------------------------------------------------------------------------- |,* | `array` | Usernames for people who can have push access. **Note**: The list of users and teams in total is limited to 100 items. |
     */
    replaceProtectedBranchUserRestrictions(
      params: Github.ReposReplaceProtectedBranchUserRestrictionsParams,
      callback?: Github.Callback<
        Github.Response<
          Github.ReposReplaceProtectedBranchUserRestrictionsResponse
        >
      >
    ): Promise<
      Github.Response<
        Github.ReposReplaceProtectedBranchUserRestrictionsResponse
      >
    >;

    replaceTopics(
      params: Github.ReposReplaceTopicsParams,
      callback?: Github.Callback<
        Github.Response<Github.ReposReplaceTopicsResponse>
      >
    ): Promise<Github.Response<Github.ReposReplaceTopicsResponse>>;
    /**
     * You can request that your site be built from the latest revision on the default branch. This has the same effect as pushing a commit to your default branch, but does not require an additional commit. Manually triggering page builds can be helpful when diagnosing build warnings and failures.,* ,* Build requests are limited to one concurrent build per repository and one concurrent build per requester. If you request a build while another is still in progress, the second request will be queued until the first completes.
     */
    requestPageBuild(
      params: Github.ReposRequestPageBuildParams,
      callback?: Github.Callback<
        Github.Response<Github.ReposRequestPageBuildResponse>
      >
    ): Promise<Github.Response<Github.ReposRequestPageBuildResponse>>;
    /**
     * This endpoint will return all community profile metrics, including an overall health score, repository description, the presence of documentation, detected code of conduct, detected license, and the presence of ISSUE\_TEMPLATE, PULL\_REQUEST\_TEMPLATE, README, and CONTRIBUTING files.
     */
    retrieveCommunityProfileMetrics(
      params: Github.ReposRetrieveCommunityProfileMetricsParams,
      callback?: Github.Callback<
        Github.Response<Github.ReposRetrieveCommunityProfileMetricsResponse>
      >
    ): Promise<
      Github.Response<Github.ReposRetrieveCommunityProfileMetricsResponse>
    >;
    /**
     * This will trigger the hook with the latest push to the current repository if the hook is subscribed to `push` events. If the hook is not subscribed to `push` events, the server will respond with 204 but no test POST will be generated.,* ,* **Note**: Previously `/repos/:owner/:repo/hooks/:hook_id/test`
     */
    testPushHook(
      params: Github.ReposTestPushHookParams,
      callback?: Github.Callback<
        Github.Response<Github.ReposTestPushHookResponse>
      >
    ): Promise<Github.Response<Github.ReposTestPushHookResponse>>;
    /**
     * A transfer request will need to be accepted by the new owner when transferring a personal repository to another user. The response will contain the original `owner`, and the transfer will continue asynchronously. For more details on the requirements to transfer personal and organization-owned repositories, see [about repository transfers](https://help.github.com/articles/about-repository-transfers/).
     */
    transfer(
      params: Github.ReposTransferParams,
      callback?: Github.Callback<Github.Response<Github.ReposTransferResponse>>
    ): Promise<Github.Response<Github.ReposTransferResponse>>;
    /**
     * **Note**: To edit a repository's topics, use the [`topics` endpoint](#replace-all-topics-for-a-repository).
     */
    update(
      params: Github.ReposUpdateParams,
      callback?: Github.Callback<Github.Response<Github.ReposUpdateResponse>>
    ): Promise<Github.Response<Github.ReposUpdateResponse>>;
    /**
     * Protecting a branch requires admin or owner permissions to the repository.,* ,* **Note**: Passing new arrays of `users` and `teams` replaces their previous values.,* ,* **Note**: The list of users and teams in total is limited to 100 items.
     */
    updateBranchProtection(
      params: Github.ReposUpdateBranchProtectionParams,
      callback?: Github.Callback<
        Github.Response<Github.ReposUpdateBranchProtectionResponse>
      >
    ): Promise<Github.Response<Github.ReposUpdateBranchProtectionResponse>>;

    updateCommitComment(
      params: Github.ReposUpdateCommitCommentParams,
      callback?: Github.Callback<
        Github.Response<Github.ReposUpdateCommitCommentResponse>
      >
    ): Promise<Github.Response<Github.ReposUpdateCommitCommentResponse>>;
    /**
     * Updates a file in a repository.
     */
    updateFile(
      params: Github.ReposUpdateFileParams,
      callback?: Github.Callback<
        Github.Response<Github.ReposUpdateFileResponse>
      >
    ): Promise<Github.Response<Github.ReposUpdateFileResponse>>;

    updateHook(
      params: Github.ReposUpdateHookParams,
      callback?: Github.Callback<
        Github.Response<Github.ReposUpdateHookResponse>
      >
    ): Promise<Github.Response<Github.ReposUpdateHookResponse>>;

    updateInformationAboutPagesSite(
      params: Github.ReposUpdateInformationAboutPagesSiteParams,
      callback?: Github.Callback<
        Github.Response<Github.ReposUpdateInformationAboutPagesSiteResponse>
      >
    ): Promise<
      Github.Response<Github.ReposUpdateInformationAboutPagesSiteResponse>
    >;

    updateInvitation(
      params: Github.ReposUpdateInvitationParams,
      callback?: Github.Callback<
        Github.Response<Github.ReposUpdateInvitationResponse>
      >
    ): Promise<Github.Response<Github.ReposUpdateInvitationResponse>>;
    /**
     * Updating pull request review enforcement requires admin or owner permissions to the repository and branch protection to be enabled.,* ,* **Note**: Passing new arrays of `users` and `teams` replaces their previous values.
     */
    updateProtectedBranchPullRequestReviewEnforcement(
      params: Github.ReposUpdateProtectedBranchPullRequestReviewEnforcementParams,
      callback?: Github.Callback<
        Github.Response<
          Github.ReposUpdateProtectedBranchPullRequestReviewEnforcementResponse
        >
      >
    ): Promise<
      Github.Response<
        Github.ReposUpdateProtectedBranchPullRequestReviewEnforcementResponse
      >
    >;
    /**
     * Updating required status checks requires admin or owner permissions to the repository and branch protection to be enabled.
     */
    updateProtectedBranchRequiredStatusChecks(
      params: Github.ReposUpdateProtectedBranchRequiredStatusChecksParams,
      callback?: Github.Callback<
        Github.Response<
          Github.ReposUpdateProtectedBranchRequiredStatusChecksResponse
        >
      >
    ): Promise<
      Github.Response<
        Github.ReposUpdateProtectedBranchRequiredStatusChecksResponse
      >
    >;
    /**
     * Users with push access to the repository can edit a release.
     */
    updateRelease(
      params: Github.ReposUpdateReleaseParams,
      callback?: Github.Callback<
        Github.Response<Github.ReposUpdateReleaseResponse>
      >
    ): Promise<Github.Response<Github.ReposUpdateReleaseResponse>>;
    /**
     * Users with push access to the repository can edit a release asset.
     */
    updateReleaseAsset(
      params: Github.ReposUpdateReleaseAssetParams,
      callback?: Github.Callback<
        Github.Response<Github.ReposUpdateReleaseAssetResponse>
      >
    ): Promise<Github.Response<Github.ReposUpdateReleaseAssetResponse>>;
    /**
     * This endpoint makes use of [a Hypermedia relation](https://developer.github.com/v3/#hypermedia) to determine which URL to access. This endpoint is provided by a URI template in [the release's API response](#get-a-single-release). You need to use an HTTP client which supports [SNI](http://en.wikipedia.org/wiki/Server_Name_Indication) to make calls to this endpoint.,* ,* The asset data is expected in its raw binary form, rather than JSON. Everything else about the endpoint is the same as the rest of the API. For example, you'll still need to pass your authentication to be able to upload an asset.,* ,* Send the raw binary content of the asset as the request body.,* ,* This may leave an empty asset with a state of `"new"`. It can be safely deleted.
     */
    uploadReleaseAsset(
      params: Github.ReposUploadReleaseAssetParams,
      callback?: Github.Callback<Github.AnyResponse>
    ): Promise<Github.AnyResponse>;
  };
  search: {
    /**
     * Find file contents via various criteria. This method returns up to 100 results [per page](https://developer.github.com/v3/#pagination).,* ,* **Note:** You must [authenticate](https://developer.github.com/v3/#authentication) to search for code across all public repositories.,* ,* **Considerations for code search**,* ,* Due to the complexity of searching code, there are a few restrictions on how searches are performed:,* ,* *   Only the _default branch_ is considered. In most cases, this will be the `master` branch.,* *   Only files smaller than 384 KB are searchable.,* *   You must always include at least one search term when searching source code. For example, searching for [`language:go`](https://github.com/search?utf8=%E2%9C%93&q=language%3Ago&type=Code) is not valid, while [`amazing language:go`](https://github.com/search?utf8=%E2%9C%93&q=amazing+language%3Ago&type=Code) is.,* ,* The `q` search term can also contain any combination of the supported code search qualifiers as described by the in-browser [code search documentation](https://help.github.com/articles/searching-code/) and [search syntax documentation](https://help.github.com/articles/search-syntax/):,* ,* *   [`in`](https://help.github.com/articles/searching-code#scope-the-search-fields) Qualifies which fields are searched. With this qualifier you can restrict the search to the file contents (`file`), the file path (`path`), or both.,* *   [`language`](https://help.github.com/articles/searching-code#search-by-language) Searches code based on the language it's written in.,* *   [`fork`](https://help.github.com/articles/searching-code#search-by-the-number-of-forks-the-parent-repository-has) Specifies that code from forked repositories should be searched (`true`). Repository forks will not be searchable unless the fork has more stars than the parent repository.,* *   [`size`](https://help.github.com/articles/searching-code#search-by-the-size-of-the-parent-repository) Finds files that match a certain size (in bytes).,* *   [`path`](https://help.github.com/articles/searching-code#search-by-the-location-of-a-file-within-the-repository) Specifies the path prefix that the resulting file must be under.,* *   [`filename`](https://help.github.com/articles/searching-code#search-by-filename) Matches files by a substring of the filename.,* *   [`extension`](https://help.github.com/articles/searching-code#search-by-the-file-extension) Matches files with a certain extension after a dot.,* *   [`user` or `repo`](https://help.github.com/articles/searching-code#search-within-a-users-or-organizations-repositories) Limits searches to a specific user or repository.,* ,* Suppose you want to find the definition of the `addClass` function inside [jQuery](https://github.com/jquery/jquery). Your query would look something like this:,* ,* Here, we're searching for the keyword `addClass` within a file's contents. We're making sure that we're only looking in files where the language is JavaScript. And we're scoping the search to the `repo:jquery/jquery` repository.,* ,* **Highlighting code search results**,* ,* You might want to highlight the matching search terms when displaying search results. The API offers additional metadata to support this use case. To get this metadata in your search results, specify the `text-match` media type in your `Accept` header. For example, via cURL, the above query would look like this:,* ,* This produces the same JSON payload as above, with an extra key called `text_matches`, an array of objects. These objects provide information such as the position of your search terms within the text, as well as the `property` that included the search term.,* ,* When searching for code, you can get text match metadata for the file **content** and file **path** fields. For details on the attributes present in the `text_matches` array, see [text match metadata](#text-match-metadata).,* ,* Here's an example response:
     */
    code(
      params: Github.SearchCodeParams,
      callback?: Github.Callback<Github.AnyResponse>
    ): Promise<Github.AnyResponse>;
    /**
     * Find commits via various criteria. This method returns up to 100 results [per page](https://developer.github.com/v3/#pagination).,* ,* **Considerations for commit search**,* ,* Only the _default branch_ is considered. In most cases, this will be the `master` branch.,* ,* The `q` search term can also contain any combination of the supported commit search qualifiers as described by the in-browser [commit search documentation](https://help.github.com/articles/searching-commits/) and [search syntax documentation](https://help.github.com/articles/search-syntax/):,* ,* *   [`author`](https://help.github.com/articles/searching-commits#search-by-author-or-committer) Matches commits authored by a user (based on email settings).,* *   [`committer`](https://help.github.com/articles/searching-commits#search-by-author-or-committer) Matches commits committed by a user (based on email settings).,* *   [`author-name`](https://help.github.com/articles/searching-commits#search-by-author-or-committer) Matches commits by author name.,* *   [`committer-name`](https://help.github.com/articles/searching-commits#search-by-author-or-committer) Matches commits by committer name.,* *   [`author-email`](https://help.github.com/articles/searching-commits#search-by-author-or-committer) Matches commits by author email.,* *   [`committer-email`](https://help.github.com/articles/searching-commits#search-by-author-or-committer) Matches commits by committer email.,* *   [`author-date`](https://help.github.com/articles/searching-commits#search-by-authored-or-committed-date) Matches commits by author date range.,* *   [`committer-date`](https://help.github.com/articles/searching-commits/#search-by-authored-or-committed-date) Matches commits by committer date range.,* *   [`merge`](https://help.github.com/articles/searching-commits#filter-merge-commits) `true` filters to merge commits, `false` filters out merge commits.,* *   [`hash`](https://help.github.com/articles/searching-commits#search-by-hash) Matches commits by hash.,* *   [`parent`](https://help.github.com/articles/searching-commits#search-by-parent) Matches commits that have a particular parent.,* *   [`tree`](https://help.github.com/articles/searching-commits#search-by-tree) Matches commits by tree hash.,* *   [`is`](https://help.github.com/articles/searching-commits#filter-to-public-or-private-repositories) Matches `public` or `private` repositories.,* *   [`user`, `org`, or `repo`](https://help.github.com/articles/searching-commits#search-within-a-users-or-organizations-repositories) Limits searches to a specific user, organization, or repository.,* ,* Suppose you want to find commits related to CSS in the [octocat/Spoon-Knife](https://github.com/octocat/Spoon-Knife) repository. Your query would look something like this:,* ,* **Highlighting code search results**,* ,* When searching for commits, you can get text match metadata for the **message** field. See the section on [text match metadata](#text-match-metadata) for full details.
     */
    commits(
      params: Github.SearchCommitsParams,
      callback?: Github.Callback<Github.AnyResponse>
    ): Promise<Github.AnyResponse>;
    /**
     * Find issues by state and keyword. This method returns up to 100 results [per page](https://developer.github.com/v3/#pagination).,* ,* The `q` search term can also contain any combination of the supported issue search qualifiers as described by the in-browser [issue search documentation](https://help.github.com/articles/searching-issues/) and [search syntax documentation](https://help.github.com/articles/search-syntax/):,* ,* *   [`type`](https://help.github.com/articles/searching-issues#search-issues-or-pull-requests) With this qualifier you can restrict the search to issues (`issue`) or pull request (`pr`) only.,* *   [`in`](https://help.github.com/articles/searching-issues#scope-the-search-fields) Qualifies which fields are searched. With this qualifier you can restrict the search to just the title (`title`), body (`body`), comments (`comments`), or any combination of these.,* *   [`author`](https://help.github.com/articles/searching-issues#search-by-the-author-of-an-issue-or-pull-request) Finds issues or pull requests created by a certain user.,* *   [`assignee`](https://help.github.com/articles/searching-issues#search-by-the-assignee-of-an-issue-or-pull-request) Finds issues or pull requests that are assigned to a certain user.,* *   [`mentions`](https://help.github.com/articles/searching-issues#search-by-a-mentioned-user-within-an-issue-or-pull-request) Finds issues or pull requests that mention a certain user.,* *   [`commenter`](https://help.github.com/articles/searching-issues#search-by-a-commenter-within-an-issue-or-pull-request) Finds issues or pull requests that a certain user commented on.,* *   [`involves`](https://help.github.com/articles/searching-issues#search-by-a-user-thats-involved-within-an-issue-or-pull-request) Finds issues or pull requests that were either created by a certain user, assigned to that user, mention that user, or were commented on by that user.,* *   [`team`](https://help.github.com/articles/searching-issues/#search-by-a-team-thats-mentioned-within-an-issue-or-pull-request) For organizations you're a member of, finds issues or pull requests that @mention a team within the organization.,* *   [`state`](https://help.github.com/articles/searching-issues#search-based-on-whether-an-issue-or-pull-request-is-open) Filter issues or pull requests based on whether they're open or closed.,* *   [`labels`](https://help.github.com/articles/searching-issues#search-by-the-labels-on-an-issue) Filters issues or pull requests based on their labels.,* *   [`no`](https://help.github.com/articles/searching-issues#search-by-missing-metadata-on-an-issue-or-pull-request) Filters items missing certain metadata, such as `label`, `milestone`, or `assignee`,* *   [`language`](https://help.github.com/articles/searching-issues#search-by-the-main-language-of-a-repository) Searches for issues or pull requests within repositories that match a certain language.,* *   [`is`](https://help.github.com/articles/searching-issues#search-based-on-the-state-of-an-issue-or-pull-request) Searches for items within repositories that match a certain state, such as `open`, `closed`, or `merged`,* *   [`created` or `updated`](https://help.github.com/articles/searching-issues#search-based-on-when-an-issue-or-pull-request-was-created-or-last-updated) Filters issues or pull requests based on date of creation, or when they were last updated.,* *   [`merged`](https://help.github.com/articles/searching-issues#search-based-on-when-a-pull-request-was-merged) Filters pull requests based on the date when they were merged.,* *   [`status`](https://help.github.com/articles/searching-issues#search-based-on-commit-status) Filters pull requests based on the commit status.,* *   [`head` or `base`](https://help.github.com/articles/searching-issues#search-based-on-branch-names) Filters pull requests based on the branch that they came from or that they are modifying.,* *   [`closed`](https://help.github.com/articles/searching-issues#search-based-on-when-an-issue-or-pull-request-was-closed) Filters issues or pull requests based on the date when they were closed.,* *   [`comments`](https://help.github.com/articles/searching-issues#search-by-the-number-of-comments-an-issue-or-pull-request-has) Filters issues or pull requests based on the quantity of comments.,* *   [`user` or `repo`](https://help.github.com/articles/searching-issues#search-within-a-users-or-organizations-repositories) Limits searches to a specific user or repository.,* *   [`project`](https://help.github.com/articles/searching-issues/#search-by-project-board) Limits searches to a specific project board in a repository or organization.,* *   [`archived`](https://help.github.com/articles/searching-issues/#search-within-archived-repositories) Filters issues or pull requests based on whether they are in an archived repository.,* ,* If you know the specific SHA hash of a commit, you can use also [use it to search for pull requests](https://help.github.com/articles/searching-issues#search-by-the-commit-shas-within-a-pull-request) that contain that SHA. Note that the SHA syntax must be at least seven characters.,* ,* Let's say you want to find the oldest unresolved Python bugs on Windows. Your query might look something like this.,* ,* In this query, we're searching for the keyword `windows`, within any open issue that's labeled as `bug`. The search runs across repositories whose primary language is Python. We’re sorting by creation date in ascending order, so that the oldest issues appear first in the search results.,* ,* **Highlighting issue search results**,* ,* You might want to highlight the matching search terms when displaying search results. The API offers additional metadata to support this use case. To get this metadata in your search results, specify the `text-match` media type in your `Accept` header. For example, via cURL, the above query would look like this:,* ,* This produces the same JSON payload as above, with an extra key called `text_matches`, an array of objects. These objects provide information such as the position of your search terms within the text, as well as the `property` that included the search term.,* ,* When searching for issues, you can get text match metadata for the issue **title**, issue **body**, and issue **comment body** fields. For details on the attributes present in the `text_matches` array, see [text match metadata](#text-match-metadata).,* ,* Here's an example response:
     */
    issues(
      params: Github.SearchIssuesParams,
      callback?: Github.Callback<Github.AnyResponse>
    ): Promise<Github.AnyResponse>;
    /**
     * Find labels in a repository with names or descriptions that match search keywords. Returns up to 100 results [per page](https://developer.github.com/v3/#pagination).,* ,* Suppose you want to find labels in the `linguist` repository that match `bug`, `defect`, or `enhancement`. Your query might look like this:,* ,* The labels that best match for the query appear first in the search results.,* ,* **Highlighting label search results**,* ,* You might want to highlight the matching search terms when displaying search results. The API offers additional metadata to support this use case. To get this metadata in your search results, specify the `text-match` media type in your `Accept` header. For example, via cURL, the above query would look like this:,* ,* This produces the same JSON payload as above, with an extra key called `text_matches`, an array of objects. These objects provide information such as the position of your search terms within the text, as well as the `property` that included the search term.,* ,* When searching for labels, you can get text match metadata for the label **name** and **description** fields. For details on the attributes present in the `text_matches` array, see [text match metadata](#text-match-metadata).
     */
    labels(
      params: Github.SearchLabelsParams,
      callback?: Github.Callback<Github.AnyResponse>
    ): Promise<Github.AnyResponse>;
    /**
     * Find repositories via various criteria. This method returns up to 100 results [per page](https://developer.github.com/v3/#pagination).,* ,* The `q` search term can also contain any combination of the supported repository search qualifiers as described by the in-browser [repository search documentation](https://help.github.com/articles/searching-for-repositories/) and [search syntax documentation](https://help.github.com/articles/search-syntax/):,* ,* *   [`created` or `pushed`](https://help.github.com/articles/searching-for-repositories/#search-by-when-a-repository-was-created-or-last-updated) Filters repositories based on date of creation, or when they were last updated.,* *   [`fork`](https://help.github.com/articles/searching-for-repositories/#search-by-number-of-forks) Filters whether forked repositories should be included (`true`) or only forked repositories should be returned (`only`).,* *   [`forks`](https://help.github.com/articles/searching-for-repositories/#search-by-number-of-forks) Filters repositories based on the number of forks.,* *   [`in`](https://help.github.com/articles/searching-for-repositories) Qualifies which fields are searched. With this qualifier you can restrict the search to just the repository name, description, readme, or any combination of these.,* *   [`language`](https://help.github.com/articles/searching-for-repositories/#search-by-language) Searches repositories based on the language they're written in.,* *   [`license`](https://help.github.com/articles/searching-for-repositories/#search-by-license) Filters repositories by license or license family, using the [license keyword](https://help.github.com/articles/licensing-a-repository/#searching-github-by-license-type).,* *   [`repo` or `user`](https://help.github.com/articles/searching-for-repositories/#search-within-a-users-or-organizations-repositories) Limits searches to a specific repository or user.,* *   [`size`](https://help.github.com/articles/searching-for-repositories/#search-by-repository-size) Finds repositories that match a certain size (in kilobytes).,* *   [`stars`](https://help.github.com/articles/searching-for-repositories/#search-by-number-of-stars) Searches repositories based on the number of stars.,* *   [`topic`](https://help.github.com/articles/classifying-your-repository-with-topics/) Filters repositories based on the specified topic.,* *   [`archived`](https://help.github.com/articles/searching-for-repositories/#search-based-on-whether-a-repository-is-archived) Filters whether archived repositories should be included (`true`) or not (`false`).,* ,* Suppose you want to search for popular Tetris repositories written in Assembly. Your query might look like this.,* ,* You can search for multiple topics by adding more `topic:` instances, and including the `mercy-preview` header. For example:,* ,* In this request, we're searching for repositories with the word `tetris` in the name, the description, or the README. We're limiting the results to only find repositories where the primary language is Assembly. We're sorting by stars in descending order, so that the most popular repositories appear first in the search results.,* ,* **Highlighting repository search results**,* ,* You might want to highlight the matching search terms when displaying search results. The API offers additional metadata to support this use case. To get this metadata in your search results, specify the `text-match` media type in your `Accept` header. For example, via cURL, the above query would look like this:,* ,* This produces the same JSON payload as above, with an extra key called `text_matches`, an array of objects. These objects provide information such as the position of your search terms within the text, as well as the `property` that included the search term.,* ,* When searching for repositories, you can get text match metadata for the **name** and **description** fields. For details on the attributes present in the `text_matches` array, see [text match metadata](#text-match-metadata).,* ,* Here's an example response:
     */
    repos(
      params: Github.SearchReposParams,
      callback?: Github.Callback<Github.AnyResponse>
    ): Promise<Github.AnyResponse>;
    /**
     * Find topics via various criteria. This method returns up to 100 results [per page](https://developer.github.com/v3/#pagination).,* ,* Results are sorted by best match by default.,* ,* The `q` search term can also contain any combination of the supported topic search qualifiers as described by the in-browser [topic search documentation](https://help.github.com/articles/searching-topics/) and [search syntax documentation](https://help.github.com/articles/search-syntax/):,* ,* *   `is:curated` Finds topics that have extra information, e.g., a description, display name, or logo, because they have an entry in the [`github/explore` repository](https://github.com/github/explore).,* *   `is:featured` Finds topics listed on [https://github.com/topics](https://github.com/topics). Any featured topic will also be curated.,* *   `is:not-featured` Finds topics not listed on [https://github.com/topics](https://github.com/topics).,* *   `is:not-curated` Finds topics that have no extra information because they haven't been added to the [`github/explore` repository](https://github.com/github/explore).,* *   `repositories:` Finds topics with some number of repositories using them, e.g., `repositories:>1000`.,* ,* Suppose you want to search for topics related to Ruby that are featured on [https://github.com/topics](https://github.com/topics). Your query might look like this:,* ,* In this request, we're searching for topics with the keyword `ruby`, and we're limiting the results to find only topics that are featured. The topics that are the best match for the query appear first in the search results.,* ,* **Note:** A search for featured Ruby topics only has 6 total results, so a [Link header](https://developer.github.com/v3/#link-header) indicating pagination is not included in the response.,* ,* **Highlighting topic search results**,* ,* You might want to highlight the matching search terms when displaying search results. The API offers additional metadata to support this use case. To get this metadata in your search results, specify the `text-match` media type in your Accept header. For example, via cURL, the above query would look like this:,* ,* This produces the same JSON payload as above, with an extra key called `text_matches`, which is an array of objects. These objects provide information such as the position of your search terms within the text, as well as the `property` that included the search term.,* ,* When searching for topics, you can get text match metadata for the topic's **short\_description**, **description**, **name**, or **display\_name** field. For details on the attributes present in the `text_matches` array, see [text match metadata](#text-match-metadata).
     */
    topics(
      params: Github.SearchTopicsParams,
      callback?: Github.Callback<Github.AnyResponse>
    ): Promise<Github.AnyResponse>;
    /**
     * Find users via various criteria. This method returns up to 100 results [per page](https://developer.github.com/v3/#pagination).,* ,* The `q` search term can also contain any combination of the supported user search qualifiers as described by the in-browser [user search documentation](https://help.github.com/articles/searching-users/) and [search syntax documentation](https://help.github.com/articles/search-syntax/):,* ,* *   [`type`](https://help.github.com/articles/searching-users#search-for-users-or-organizations) With this qualifier you can restrict the search to just personal accounts (`user`) or just organization accounts (`org`).,* *   [`in`](https://help.github.com/articles/searching-users#scope-the-search-fields) Qualifies which fields are searched. With this qualifier you can restrict the search to just the username (`login`), public email (`email`), full name (`fullname`), or any combination of these.,* *   [`repos`](https://help.github.com/articles/searching-users#search-based-on-the-number-of-repositories-a-user-has) Filters users based on the number of repositories they have.,* *   [`location`](https://help.github.com/articles/searching-users#search-based-on-the-location-where-a-user-resides) Filter users by the location indicated in their profile.,* *   [`language`](https://help.github.com/articles/searching-users#search-based-on-the-languages-of-a-users-repositories) Search for users that have repositories that match a certain language.,* *   [`created`](https://help.github.com/articles/searching-users#search-based-on-when-a-user-joined-github) Filter users based on when they joined.,* *   [`followers`](https://help.github.com/articles/searching-users#search-based-on-the-number-of-followers-a-user-has) Filter users based on the number of followers they have.,* ,* Imagine you're looking for a list of popular users. You might try out this query:,* ,* Here, we're looking at users with the name Tom. We're only interested in those with more than 42 repositories, and only if they have over 1,000 followers.,* ,* **Highlighting user search results**,* ,* You might want to highlight the matching search terms when displaying search results. The API offers additional metadata to support this use case. To get this metadata in your search results, specify the `text-match` media type in your `Accept` header. For example, via cURL, the above query would look like this:,* ,* This produces the same JSON payload as above, with an extra key called `text_matches`, an array of objects. These objects provide information such as the position of your search terms within the text, as well as the `property` that included the search term.,* ,* When searching for users, you can get text match metadata for the issue **login**, **email**, and **name** fields. For details on the attributes present in the `text_matches` array, see [text match metadata](#text-match-metadata).
     */
    users(
      params: Github.SearchUsersParams,
      callback?: Github.Callback<Github.AnyResponse>
    ): Promise<Github.AnyResponse>;
  };
  teams: {
    /**
     * The "Add team member" API (described below) is deprecated.,* ,* We recommend using the [Add team membership API](https://developer.github.com/v3/teams/members/#add-or-update-team-membership) instead. It allows you to invite new organization members to your teams.,* ,* To add a user to a team, the authenticated user must have 'admin' permissions to the team or be an owner of the organization that the team is associated with, and the user being added must already be a member of at least one other team on the same organization.,* ,* Note that you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP verbs](https://developer.github.com/v3/#http-verbs).",* ,* If you attempt to add an organization to a team, you will get this:,* ,* If you attempt to add a user to a team and that user is not a member of at least one other team on the same organization, you will get this:
     */
    addMember(
      params: Github.TeamsAddMemberParams,
      callback?: Github.Callback<Github.Response<Github.TeamsAddMemberResponse>>
    ): Promise<Github.Response<Github.TeamsAddMemberResponse>>;
    /**
     * If the user is already a member of the team's organization, this endpoint will add the user to the team. To add a membership between an organization member and a team, the authenticated user must be an organization owner or a maintainer of the team.,* ,* If the user is unaffiliated with the team's organization, this endpoint will send an invitation to the user via email. This newly-created membership will be in the "pending" state until the user accepts the invitation, at which point the membership will transition to the "active" state and the user will be added as a member of the team. To add a membership between an unaffiliated user and a team, the authenticated user must be an organization owner.,* ,* If the user is already a member of the team, this endpoint will update the role of the team member's role. To update the membership of a team member, the authenticated user must be an organization owner or a maintainer of the team.,* ,* If you attempt to add an organization to a team, you will get this:
     */
    addOrUpdateMembership(
      params: Github.TeamsAddOrUpdateMembershipParams,
      callback?: Github.Callback<Github.AnyResponse>
    ): Promise<Github.AnyResponse>;
    /**
     * Adds an organization project to a team. To add a project to a team or update the team's permission on a project, the authenticated user must have `admin` permissions for the project. The project and team must be part of the same organization.
     */
    addOrUpdateProject(
      params: Github.TeamsAddOrUpdateProjectParams,
      callback?: Github.Callback<
        Github.Response<Github.TeamsAddOrUpdateProjectResponse>
      >
    ): Promise<Github.Response<Github.TeamsAddOrUpdateProjectResponse>>;
    /**
     * To add a repository to a team or update the team's permission on a repository, the authenticated user must have admin access to the repository, and must be able to see the team. The repository must be owned by the organization, or a direct fork of a repository owned by the organization.,* ,* If you pass the `hellcat-preview` media type, you can modify repository permissions of child teams.,* ,* Note that, if you choose not to pass any parameters, you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP verbs](https://developer.github.com/v3/#http-verbs).",* ,*
     */
    addOrUpdateRepo(
      params: Github.TeamsAddOrUpdateRepoParams,
      callback?: Github.Callback<
        Github.Response<Github.TeamsAddOrUpdateRepoResponse>
      >
    ): Promise<Github.Response<Github.TeamsAddOrUpdateRepoResponse>>;
    /**
     * **Note**: If you pass the `hellcat-preview` media type, repositories inherited through a parent team will be checked.,* ,* You can also get information about the specified repository, including what permissions the team grants on it, by passing the following custom [media type](https://developer.github.com/v3/media/) via the `Accept` header:
     */
    checkManagesRepo(
      params: Github.TeamsCheckManagesRepoParams,
      callback?: Github.Callback<Github.AnyResponse>
    ): Promise<Github.AnyResponse>;
    /**
     * To create a team, the authenticated user must be a member of `:org`.
     */
    create(
      params: Github.TeamsCreateParams,
      callback?: Github.Callback<Github.Response<Github.TeamsCreateResponse>>
    ): Promise<Github.Response<Github.TeamsCreateResponse>>;
    /**
     * Creates a new discussion post on a team's page. OAuth access tokens require the `write:discussion` [scope](https://developer.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
     */
    createDiscussion(
      params: Github.TeamsCreateDiscussionParams,
      callback?: Github.Callback<
        Github.Response<Github.TeamsCreateDiscussionResponse>
      >
    ): Promise<Github.Response<Github.TeamsCreateDiscussionResponse>>;
    /**
     * Creates a new comment on a team discussion. OAuth access tokens require the `write:discussion` [scope](https://developer.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
     */
    createDiscussionComment(
      params: Github.TeamsCreateDiscussionCommentParams,
      callback?: Github.Callback<
        Github.Response<Github.TeamsCreateDiscussionCommentResponse>
      >
    ): Promise<Github.Response<Github.TeamsCreateDiscussionCommentResponse>>;
    /**
     * To delete a team, the authenticated user must be a team maintainer or an owner of the org associated with the team.,* ,* If you are an organization owner and you pass the `hellcat-preview` media type, deleting a parent team will delete all of its child teams as well.
     */
    delete(
      params: Github.TeamsDeleteParams,
      callback?: Github.Callback<Github.Response<Github.TeamsDeleteResponse>>
    ): Promise<Github.Response<Github.TeamsDeleteResponse>>;
    /**
     * Delete a discussion from a team's page. OAuth access tokens require the `write:discussion` [scope](https://developer.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
     */
    deleteDiscussion(
      params: Github.TeamsDeleteDiscussionParams,
      callback?: Github.Callback<
        Github.Response<Github.TeamsDeleteDiscussionResponse>
      >
    ): Promise<Github.Response<Github.TeamsDeleteDiscussionResponse>>;
    /**
     * Deletes a comment on a team discussion. OAuth access tokens require the `write:discussion` [scope](https://developer.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
     */
    deleteDiscussionComment(
      params: Github.TeamsDeleteDiscussionCommentParams,
      callback?: Github.Callback<
        Github.Response<Github.TeamsDeleteDiscussionCommentResponse>
      >
    ): Promise<Github.Response<Github.TeamsDeleteDiscussionCommentResponse>>;

    get(
      params: Github.TeamsGetParams,
      callback?: Github.Callback<Github.Response<Github.TeamsGetResponse>>
    ): Promise<Github.Response<Github.TeamsGetResponse>>;
    /**
     * Get a specific discussion on a team's page. OAuth access tokens require the `read:discussion` [scope](https://developer.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
     */
    getDiscussion(
      params: Github.TeamsGetDiscussionParams,
      callback?: Github.Callback<
        Github.Response<Github.TeamsGetDiscussionResponse>
      >
    ): Promise<Github.Response<Github.TeamsGetDiscussionResponse>>;
    /**
     * Get a specific comment on a team discussion. OAuth access tokens require the `read:discussion` [scope](https://developer.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
     */
    getDiscussionComment(
      params: Github.TeamsGetDiscussionCommentParams,
      callback?: Github.Callback<
        Github.Response<Github.TeamsGetDiscussionCommentResponse>
      >
    ): Promise<Github.Response<Github.TeamsGetDiscussionCommentResponse>>;
    /**
     * The "Get team member" API (described below) is deprecated.,* ,* We recommend using the [Get team membership API](https://developer.github.com/v3/teams/members/#get-team-membership) instead. It allows you to get both active and pending memberships.,* ,* To list members in a team, the team must be visible to the authenticated user.
     */
    getMember(
      params: Github.TeamsGetMemberParams,
      callback?: Github.Callback<Github.AnyResponse>
    ): Promise<Github.AnyResponse>;
    /**
     * If you pass the `hellcat-preview` media type, team members will include the members of child teams.,* ,* To get a user's membership with a team, the team must be visible to the authenticated user.,* ,* **Note:** The `role` for organization owners returns as `maintainer`. For more information about `maintainer` roles, see [Create team](https://developer.github.com/v3/teams#create-team).
     */
    getMembership(
      params: Github.TeamsGetMembershipParams,
      callback?: Github.Callback<Github.AnyResponse>
    ): Promise<Github.AnyResponse>;

    list(
      params: Github.TeamsListParams,
      callback?: Github.Callback<Github.Response<Github.TeamsListResponse>>
    ): Promise<Github.Response<Github.TeamsListResponse>>;
    /**
     * At this time, the `hellcat-preview` media type is required to use this endpoint.,* ,*
     */
    listChild(
      params: Github.TeamsListChildParams,
      callback?: Github.Callback<Github.AnyResponse>
    ): Promise<Github.AnyResponse>;
    /**
     * List all comments on a team discussion. OAuth access tokens require the `read:discussion` [scope](https://developer.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
     */
    listDiscussionComments(
      params: Github.TeamsListDiscussionCommentsParams,
      callback?: Github.Callback<
        Github.Response<Github.TeamsListDiscussionCommentsResponse>
      >
    ): Promise<Github.Response<Github.TeamsListDiscussionCommentsResponse>>;
    /**
     * List all discussions on a team's page. OAuth access tokens require the `read:discussion` [scope](https://developer.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
     */
    listDiscussions(
      params: Github.TeamsListDiscussionsParams,
      callback?: Github.Callback<
        Github.Response<Github.TeamsListDiscussionsResponse>
      >
    ): Promise<Github.Response<Github.TeamsListDiscussionsResponse>>;
    /**
     * List all of the teams across all of the organizations to which the authenticated user belongs. This method requires `user`, `repo`, or `read:org` [scope](https://developer.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/) when authenticating via [OAuth](https://developer.github.com/apps/building-oauth-apps/).
     */
    listForAuthenticatedUser(
      params: Github.TeamsListForAuthenticatedUserParams,
      callback?: Github.Callback<
        Github.Response<Github.TeamsListForAuthenticatedUserResponse>
      >
    ): Promise<Github.Response<Github.TeamsListForAuthenticatedUserResponse>>;
    /**
     * If you pass the `hellcat-preview` media type, team members will include the members of child teams.
     */
    listMembers(
      params: Github.TeamsListMembersParams,
      callback?: Github.Callback<
        Github.Response<Github.TeamsListMembersResponse>
      >
    ): Promise<Github.Response<Github.TeamsListMembersResponse>>;
    /**
     * The return hash contains a `role` field which refers to the Organization Invitation role and will be one of the following values: `direct_member`, `admin`, `billing_manager`, `hiring_manager`, or `reinstate`. If the invitee is not a GitHub member, the `login` field in the return hash will be `null`.
     */
    listPendingInvitations(
      params: Github.TeamsListPendingInvitationsParams,
      callback?: Github.Callback<
        Github.Response<Github.TeamsListPendingInvitationsResponse>
      >
    ): Promise<Github.Response<Github.TeamsListPendingInvitationsResponse>>;
    /**
     * Lists the organization projects for a team. If you pass the `hellcat-preview` media type, the response will include projects inherited from a parent team.
     */
    listProjects(
      params: Github.TeamsListProjectsParams,
      callback?: Github.Callback<
        Github.Response<Github.TeamsListProjectsResponse>
      >
    ): Promise<Github.Response<Github.TeamsListProjectsResponse>>;
    /**
     * **Note**: If you pass the `hellcat-preview` media type, the response will include any repositories inherited through a parent team.
     */
    listRepos(
      params: Github.TeamsListReposParams,
      callback?: Github.Callback<Github.Response<Github.TeamsListReposResponse>>
    ): Promise<Github.Response<Github.TeamsListReposResponse>>;
    /**
     * The "Remove team member" API (described below) is deprecated.,* ,* We recommend using the [Remove team membership API](https://developer.github.com/v3/teams/members/#remove-team-membership) instead. It allows you to remove both active and pending memberships.,* ,* To remove a user from a team, the authenticated user must have 'admin' permissions to the team or be an owner of the org that the team is associated with. NOTE: This does not delete the user, it just removes them from the team.
     */
    removeMember(
      params: Github.TeamsRemoveMemberParams,
      callback?: Github.Callback<
        Github.Response<Github.TeamsRemoveMemberResponse>
      >
    ): Promise<Github.Response<Github.TeamsRemoveMemberResponse>>;
    /**
     * To remove a membership between a user and a team, the authenticated user must have 'admin' permissions to the team or be an owner of the organization that the team is associated with. NOTE: This does not delete the user, it just removes their membership from the team.
     */
    removeMembership(
      params: Github.TeamsRemoveMembershipParams,
      callback?: Github.Callback<
        Github.Response<Github.TeamsRemoveMembershipResponse>
      >
    ): Promise<Github.Response<Github.TeamsRemoveMembershipResponse>>;
    /**
     * Removes an organization project from a team. An organization owner or a team maintainer can remove any project from the team. To remove a project from a team as an organization member, the authenticated user must have `read` access to both the team and project, or `admin` access to the team or project. **Note:** This endpoint removes the project from the team, but does not delete it.
     */
    removeProject(
      params: Github.TeamsRemoveProjectParams,
      callback?: Github.Callback<
        Github.Response<Github.TeamsRemoveProjectResponse>
      >
    ): Promise<Github.Response<Github.TeamsRemoveProjectResponse>>;
    /**
     * If the authenticated user is an organization owner or a team maintainer, they can remove any repositories from the team. To remove a repository from a team as an organization member, the authenticated user must have admin access to the repository and must be able to see the team. NOTE: This does not delete the repository, it just removes it from the team.
     */
    removeRepo(
      params: Github.TeamsRemoveRepoParams,
      callback?: Github.Callback<
        Github.Response<Github.TeamsRemoveRepoResponse>
      >
    ): Promise<Github.Response<Github.TeamsRemoveRepoResponse>>;
    /**
     * Checks whether a team has `read`, `write`, or `admin` permissions for an organization project. If you pass the `hellcat-preview` media type, the response will include projects inherited from a parent team.
     */
    reviewProject(
      params: Github.TeamsReviewProjectParams,
      callback?: Github.Callback<
        Github.Response<Github.TeamsReviewProjectResponse>
      >
    ): Promise<Github.Response<Github.TeamsReviewProjectResponse>>;
    /**
     * To edit a team, the authenticated user must either be an owner of the org that the team is associated with, or a maintainer of the team.,* ,* **Note:** With nested teams, the `privacy` for parent teams cannot be `secret`.
     */
    update(
      params: Github.TeamsUpdateParams,
      callback?: Github.Callback<Github.Response<Github.TeamsUpdateResponse>>
    ): Promise<Github.Response<Github.TeamsUpdateResponse>>;
    /**
     * Edits the title and body text of a discussion post. Only the parameters you provide are updated. OAuth access tokens require the `write:discussion` [scope](https://developer.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
     */
    updateDiscussion(
      params: Github.TeamsUpdateDiscussionParams,
      callback?: Github.Callback<
        Github.Response<Github.TeamsUpdateDiscussionResponse>
      >
    ): Promise<Github.Response<Github.TeamsUpdateDiscussionResponse>>;
    /**
     * Edits the body text of a discussion comment. OAuth access tokens require the `write:discussion` [scope](https://developer.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
     */
    updateDiscussionComment(
      params: Github.TeamsUpdateDiscussionCommentParams,
      callback?: Github.Callback<
        Github.Response<Github.TeamsUpdateDiscussionCommentResponse>
      >
    ): Promise<Github.Response<Github.TeamsUpdateDiscussionCommentResponse>>;
  };
  users: {
    addEmails(
      params: Github.UsersAddEmailsParams,
      callback?: Github.Callback<Github.Response<Github.UsersAddEmailsResponse>>
    ): Promise<Github.Response<Github.UsersAddEmailsResponse>>;

    block(
      params: Github.UsersBlockParams,
      callback?: Github.Callback<Github.Response<Github.UsersBlockResponse>>
    ): Promise<Github.Response<Github.UsersBlockResponse>>;
    /**
     * If the user is blocked:,* ,* If the user is not blocked:
     */
    checkBlocked(
      params: Github.UsersCheckBlockedParams,
      callback?: Github.Callback<
        Github.Response<Github.UsersCheckBlockedResponse>
      >
    ): Promise<Github.Response<Github.UsersCheckBlockedResponse>>;

    checkFollowing(
      params: Github.UsersCheckFollowingParams,
      callback?: Github.Callback<Github.AnyResponse>
    ): Promise<Github.AnyResponse>;

    checkFollowingForUser(
      params: Github.UsersCheckFollowingForUserParams,
      callback?: Github.Callback<Github.AnyResponse>
    ): Promise<Github.AnyResponse>;
    /**
     * Adds a GPG key to the authenticated user's GitHub account. Requires that you are authenticated via Basic Auth, or OAuth with at least `write:gpg_key` [scope](https://developer.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
     */
    createGpgKey(
      params: Github.UsersCreateGpgKeyParams,
      callback?: Github.Callback<
        Github.Response<Github.UsersCreateGpgKeyResponse>
      >
    ): Promise<Github.Response<Github.UsersCreateGpgKeyResponse>>;
    /**
     * Adds a public SSH key to the authenticated user's GitHub account. Requires that you are authenticated via Basic Auth, or OAuth with at least `write:public_key` [scope](https://developer.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
     */
    createPublicKey(
      params: Github.UsersCreatePublicKeyParams,
      callback?: Github.Callback<
        Github.Response<Github.UsersCreatePublicKeyResponse>
      >
    ): Promise<Github.Response<Github.UsersCreatePublicKeyResponse>>;

    deleteEmails(
      params: Github.UsersDeleteEmailsParams,
      callback?: Github.Callback<
        Github.Response<Github.UsersDeleteEmailsResponse>
      >
    ): Promise<Github.Response<Github.UsersDeleteEmailsResponse>>;
    /**
     * Removes a GPG key from the authenticated user's GitHub account. Requires that you are authenticated via Basic Auth or via OAuth with at least `admin:gpg_key` [scope](https://developer.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
     */
    deleteGpgKey(
      params: Github.UsersDeleteGpgKeyParams,
      callback?: Github.Callback<
        Github.Response<Github.UsersDeleteGpgKeyResponse>
      >
    ): Promise<Github.Response<Github.UsersDeleteGpgKeyResponse>>;
    /**
     * Removes a public SSH key from the authenticated user's GitHub account. Requires that you are authenticated via Basic Auth or via OAuth with at least `admin:public_key` [scope](https://developer.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
     */
    deletePublicKey(
      params: Github.UsersDeletePublicKeyParams,
      callback?: Github.Callback<
        Github.Response<Github.UsersDeletePublicKeyResponse>
      >
    ): Promise<Github.Response<Github.UsersDeletePublicKeyResponse>>;
    /**
     * Note that you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP verbs](https://developer.github.com/v3/#http-verbs).",* ,* Following a user requires the user to be logged in and authenticated with basic auth or OAuth with the `user:follow` scope.
     */
    follow(
      params: Github.UsersFollowParams,
      callback?: Github.Callback<Github.Response<Github.UsersFollowResponse>>
    ): Promise<Github.Response<Github.UsersFollowResponse>>;
    /**
     * Lists public and private profile information when authenticated through basic auth or OAuth with the `user` scope.,* ,* Lists public profile information when authenticated through OAuth without the `user` scope.
     */
    getAuthenticated(
      params: Github.EmptyParams,
      callback?: Github.Callback<Github.AnyResponse>
    ): Promise<Github.AnyResponse>;
    /**
     * Provides publicly available information about someone with a GitHub account.,* ,* The `email` key in the following response is the publicly visible email address from your GitHub [profile page](https://github.com/settings/profile). When setting up your profile, you can select a primary email address to be “public” which provides an email entry for this endpoint. If you do not set a public email address for `email`, then it will have a value of `null`. You only see publicly visible email addresses when authenticated with GitHub. For more information, see [Authentication](https://developer.github.com/v3/#authentication).,* ,* The Emails API enables you to list all of your email addresses, and toggle a primary email to be visible publicly. For more information, see "[Emails API](https://developer.github.com/v3/users/emails/)".
     */
    getByUsername(
      params: Github.UsersGetByUsernameParams,
      callback?: Github.Callback<
        Github.Response<Github.UsersGetByUsernameResponse>
      >
    ): Promise<Github.Response<Github.UsersGetByUsernameResponse>>;
    /**
     * Provides hovercard information when authenticated through basic auth or OAuth with the `repo` scope. You can find out more about someone in relation to their pull requests, issues, repositories, and organizations.,* ,* The `subject_type` and `subject_id` parameters provide context for the person's hovercard, which returns more information than without the parameters. For example, if you wanted to find out more about `octocat` who owns the `Spoon-Knife` repository via cURL, it would look like this:
     */
    getContextForUser(
      params: Github.UsersGetContextForUserParams,
      callback?: Github.Callback<
        Github.Response<Github.UsersGetContextForUserResponse>
      >
    ): Promise<Github.Response<Github.UsersGetContextForUserResponse>>;
    /**
     * View extended details for a single GPG key. Requires that you are authenticated via Basic Auth or via OAuth with at least `read:gpg_key` [scope](https://developer.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
     */
    getGpgKey(
      params: Github.UsersGetGpgKeyParams,
      callback?: Github.Callback<Github.Response<Github.UsersGetGpgKeyResponse>>
    ): Promise<Github.Response<Github.UsersGetGpgKeyResponse>>;
    /**
     * View extended details for a single public SSH key. Requires that you are authenticated via Basic Auth or via OAuth with at least `read:public_key` [scope](https://developer.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
     */
    getPublicKey(
      params: Github.UsersGetPublicKeyParams,
      callback?: Github.Callback<
        Github.Response<Github.UsersGetPublicKeyResponse>
      >
    ): Promise<Github.Response<Github.UsersGetPublicKeyResponse>>;
    /**
     * Lists all users, in the order that they signed up on GitHub. This list includes personal user accounts and organization accounts.,* ,* Note: Pagination is powered exclusively by the `since` parameter. Use the [Link header](https://developer.github.com/v3/#link-header) to get the URL for the next page of users.
     */
    list(
      params: Github.UsersListParams,
      callback?: Github.Callback<Github.Response<Github.UsersListResponse>>
    ): Promise<Github.Response<Github.UsersListResponse>>;
    /**
     * List the users you've blocked on your personal account.
     */
    listBlocked(
      params: Github.EmptyParams,
      callback?: Github.Callback<
        Github.Response<Github.UsersListBlockedResponse>
      >
    ): Promise<Github.Response<Github.UsersListBlockedResponse>>;
    /**
     * Lists all of your email addresses, and specifies which one is visible to the public. This endpoint is accessible with the `user:email` scope.
     */
    listEmails(
      params: Github.UsersListEmailsParams,
      callback?: Github.Callback<
        Github.Response<Github.UsersListEmailsResponse>
      >
    ): Promise<Github.Response<Github.UsersListEmailsResponse>>;

    listFollowersForAuthenticatedUser(
      params: Github.UsersListFollowersForAuthenticatedUserParams,
      callback?: Github.Callback<
        Github.Response<Github.UsersListFollowersForAuthenticatedUserResponse>
      >
    ): Promise<
      Github.Response<Github.UsersListFollowersForAuthenticatedUserResponse>
    >;

    listFollowersForUser(
      params: Github.UsersListFollowersForUserParams,
      callback?: Github.Callback<
        Github.Response<Github.UsersListFollowersForUserResponse>
      >
    ): Promise<Github.Response<Github.UsersListFollowersForUserResponse>>;

    listFollowingForAuthenticatedUser(
      params: Github.UsersListFollowingForAuthenticatedUserParams,
      callback?: Github.Callback<
        Github.Response<Github.UsersListFollowingForAuthenticatedUserResponse>
      >
    ): Promise<
      Github.Response<Github.UsersListFollowingForAuthenticatedUserResponse>
    >;

    listFollowingForUser(
      params: Github.UsersListFollowingForUserParams,
      callback?: Github.Callback<
        Github.Response<Github.UsersListFollowingForUserResponse>
      >
    ): Promise<Github.Response<Github.UsersListFollowingForUserResponse>>;
    /**
     * Lists the current user's GPG keys. Requires that you are authenticated via Basic Auth or via OAuth with at least `read:gpg_key` [scope](https://developer.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
     */
    listGpgKeys(
      params: Github.UsersListGpgKeysParams,
      callback?: Github.Callback<
        Github.Response<Github.UsersListGpgKeysResponse>
      >
    ): Promise<Github.Response<Github.UsersListGpgKeysResponse>>;
    /**
     * Lists the GPG keys for a user. This information is accessible by anyone.
     */
    listGpgKeysForUser(
      params: Github.UsersListGpgKeysForUserParams,
      callback?: Github.Callback<
        Github.Response<Github.UsersListGpgKeysForUserResponse>
      >
    ): Promise<Github.Response<Github.UsersListGpgKeysForUserResponse>>;
    /**
     * Lists your publicly visible email address, which you can set with the [Toggle primary email visibility](#toggle-primary-email-visibility) endpoint. This endpoint is accessible with the `user:email` scope.
     */
    listPublicEmails(
      params: Github.UsersListPublicEmailsParams,
      callback?: Github.Callback<
        Github.Response<Github.UsersListPublicEmailsResponse>
      >
    ): Promise<Github.Response<Github.UsersListPublicEmailsResponse>>;
    /**
     * Lists the public SSH keys for the authenticated user's GitHub account. Requires that you are authenticated via Basic Auth or via OAuth with at least `read:public_key` [scope](https://developer.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
     */
    listPublicKeys(
      params: Github.UsersListPublicKeysParams,
      callback?: Github.Callback<
        Github.Response<Github.UsersListPublicKeysResponse>
      >
    ): Promise<Github.Response<Github.UsersListPublicKeysResponse>>;
    /**
     * Lists the _verified_ public SSH keys for a user. This is accessible by anyone.
     */
    listPublicKeysForUser(
      params: Github.UsersListPublicKeysForUserParams,
      callback?: Github.Callback<
        Github.Response<Github.UsersListPublicKeysForUserResponse>
      >
    ): Promise<Github.Response<Github.UsersListPublicKeysForUserResponse>>;
    /**
     * Sets the visibility for your primary email addresses.
     */
    togglePrimaryEmailVisibility(
      params: Github.UsersTogglePrimaryEmailVisibilityParams,
      callback?: Github.Callback<
        Github.Response<Github.UsersTogglePrimaryEmailVisibilityResponse>
      >
    ): Promise<
      Github.Response<Github.UsersTogglePrimaryEmailVisibilityResponse>
    >;

    unblock(
      params: Github.UsersUnblockParams,
      callback?: Github.Callback<Github.Response<Github.UsersUnblockResponse>>
    ): Promise<Github.Response<Github.UsersUnblockResponse>>;
    /**
     * Unfollowing a user requires the user to be logged in and authenticated with basic auth or OAuth with the `user:follow` scope.
     */
    unfollow(
      params: Github.UsersUnfollowParams,
      callback?: Github.Callback<Github.Response<Github.UsersUnfollowResponse>>
    ): Promise<Github.Response<Github.UsersUnfollowResponse>>;
    /**
     * **Note:** If your email is set to private and you send an `email` parameter as part of this request to update your profile, your privacy settings are still enforced: the email address will not be displayed on your public profile or via the API.
     */
    updateAuthenticated(
      params: Github.UsersUpdateAuthenticatedParams,
      callback?: Github.Callback<
        Github.Response<Github.UsersUpdateAuthenticatedResponse>
      >
    ): Promise<Github.Response<Github.UsersUpdateAuthenticatedResponse>>;
  };
}

export = Github;
